/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.Gui;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiParticle;
import net.minecraft.src.Tessellator;
import net.minecraft.src.helper.Color;
import net.minecraft.src.input.InputType;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiScreen
extends Gui {
    final GuiScreen parentScreen;
    protected Minecraft mc;
    public int width;
    public int height;
    protected List<GuiButton> controlList = new ArrayList<GuiButton>();
    public boolean field_948_f = false;
    protected FontRenderer fontRenderer;
    public GuiParticle field_25091_h;
    private GuiButton selectedButton = null;

    public GuiScreen(GuiScreen parent) {
        this.parentScreen = parent;
    }

    public GuiScreen() {
        this(null);
    }

    public void drawScreen(int x2, int y2, float renderPartialTicks) {
        for (int i2 = 0; i2 < this.controlList.size(); ++i2) {
            GuiButton guibutton = this.controlList.get(i2);
            guibutton.drawButton(this.mc, x2, y2);
        }
    }

    public void keyTyped(char c2, int i2) {
        if (i2 == 14) {
            this.mc.displayGuiScreen(this.parentScreen);
        }
        if (i2 == 1) {
            this.mc.displayGuiScreen(null);
        }
    }

    public void mouseClicked(int x2, int y2, int button) {
        if (button == 0) {
            for (int l2 = 0; l2 < this.controlList.size(); ++l2) {
                GuiButton guibutton = this.controlList.get(l2);
                if (!guibutton.mousePressed(this.mc, x2, y2)) continue;
                this.selectedButton = guibutton;
                this.mc.sndManager.playSoundFX("random.click", 1.0f, 1.0f);
                if (guibutton.listener != null) {
                    guibutton.listener.listen(guibutton);
                    continue;
                }
                this.actionPerformed(guibutton);
            }
        }
    }

    public void mouseMovedOrUp(int i2, int j2, int k2) {
        if (this.selectedButton != null && k2 == 0) {
            this.selectedButton.mouseReleased(i2, j2);
            this.selectedButton = null;
        }
    }

    protected void actionPerformed(GuiButton guibutton) {
    }

    public void setWorldAndResolution(Minecraft minecraft, int i2, int j2) {
        this.field_25091_h = new GuiParticle(minecraft);
        this.mc = minecraft;
        this.fontRenderer = minecraft.fontRenderer;
        this.width = i2;
        this.height = j2;
        this.controlList.clear();
        this.initGui();
    }

    public void initGui() {
    }

    public void handleInput() {
        while (Mouse.next()) {
            this.handleMouseInput();
        }
        while (Keyboard.next()) {
            this.handleKeyboardInput();
        }
    }

    public void handleMouseInput() {
        if (this.mc.inputType == InputType.CONTROLLER) {
            return;
        }
        if (Mouse.getEventButtonState()) {
            int i2 = Mouse.getEventX() * this.width / this.mc.resolution.width;
            int k2 = this.height - Mouse.getEventY() * this.height / this.mc.resolution.height - 1;
            this.mouseClicked(i2, k2, Mouse.getEventButton());
        } else {
            int j2 = Mouse.getEventX() * this.width / this.mc.resolution.width;
            int l2 = this.height - Mouse.getEventY() * this.height / this.mc.resolution.height - 1;
            this.mouseMovedOrUp(j2, l2, Mouse.getEventButton());
        }
    }

    public void handleKeyboardInput() {
        if (Keyboard.getEventKeyState()) {
            if (Keyboard.getEventKey() == 87) {
                this.mc.toggleFullscreen();
                return;
            }
            this.keyTyped(Keyboard.getEventCharacter(), Keyboard.getEventKey());
        }
    }

    public void updateScreen() {
    }

    public void onGuiClosed() {
    }

    public void drawDefaultBackground() {
        this.drawWorldBackground(0);
    }

    public void drawWorldBackground(int i2) {
        if (this.mc.theWorld != null) {
            int color = ((Color)this.mc.gameSettings.guiBackgroundColor.value).getARGB();
            this.drawGradientRect(0, 0, this.width, this.height, color, color);
        } else {
            this.drawBackground(i2);
        }
    }

    public void drawBackground(int i2) {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        Tessellator tessellator = Tessellator.instance;
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/background.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f2 = 32.0f;
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0x404040);
        tessellator.addVertexWithUV(0.0, this.height, 0.0, 0.0, (float)this.height / f2 + (float)i2);
        tessellator.addVertexWithUV(this.width, this.height, 0.0, (float)this.width / f2, (float)this.height / f2 + (float)i2);
        tessellator.addVertexWithUV(this.width, 0.0, 0.0, (float)this.width / f2, 0 + i2);
        tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0 + i2);
        tessellator.draw();
    }

    public void drawCursor() {
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/gui.png"));
        this.drawTexturedModalRect(this.mc.controllerInput.cursorX - 8.0, this.mc.controllerInput.cursorY - 8.0, 224, 0, 16, 16, 32, 32);
        GL11.glDisable((int)3042);
    }

    public boolean doesGuiPauseGame() {
        return true;
    }

    public void deleteWorld(boolean flag, int i2) {
    }

    public void selectNextField() {
    }

    public void selectButtonUp() {
        double cursorX = this.mc.controllerInput.cursorX;
        double cursorY = this.mc.controllerInput.cursorY;
        GuiButton hoveredButton = null;
        GuiButton closestButton = null;
        float closestButtonDistance = Float.POSITIVE_INFINITY;
        for (GuiButton button : this.controlList) {
            if (!button.isHovered((int)cursorX, (int)cursorY)) continue;
            hoveredButton = button;
            break;
        }
        if (hoveredButton != null) {
            for (GuiButton button : this.controlList) {
                if (button == hoveredButton || hoveredButton.yPosition <= button.yPosition || hoveredButton.xPosition != button.xPosition || !((float)(hoveredButton.yPosition - button.yPosition) < closestButtonDistance)) continue;
                closestButtonDistance = hoveredButton.yPosition - button.yPosition;
                closestButton = button;
            }
        }
        if (closestButton == null) {
            for (GuiButton button : this.controlList) {
                float buttonDistance;
                if (!((double)button.yPosition + (double)button.height / 2.0 < cursorY) || !((buttonDistance = this.getButtonDistance(button, (int)cursorX, (int)cursorY)) < closestButtonDistance)) continue;
                closestButton = button;
                closestButtonDistance = this.getButtonDistance(button, (int)cursorX, (int)cursorY);
            }
        }
        if (closestButton == null) {
            return;
        }
        this.mc.controllerInput.cursorX = (double)closestButton.xPosition + (double)closestButton.width / 2.0;
        this.mc.controllerInput.cursorY = (double)closestButton.yPosition + (double)closestButton.height / 2.0;
    }

    public void selectButtonDown() {
        double cursorX = this.mc.controllerInput.cursorX;
        double cursorY = this.mc.controllerInput.cursorY;
        GuiButton hoveredButton = null;
        GuiButton closestButton = null;
        float closestButtonDistance = Float.POSITIVE_INFINITY;
        for (GuiButton button : this.controlList) {
            if (!button.isHovered((int)cursorX, (int)cursorY)) continue;
            hoveredButton = button;
            break;
        }
        if (hoveredButton != null) {
            for (GuiButton button : this.controlList) {
                if (button == hoveredButton || hoveredButton.yPosition >= button.yPosition || hoveredButton.xPosition != button.xPosition || !((float)(button.yPosition - hoveredButton.yPosition) < closestButtonDistance)) continue;
                closestButtonDistance = button.yPosition - hoveredButton.yPosition;
                closestButton = button;
            }
        }
        if (closestButton == null) {
            for (GuiButton button : this.controlList) {
                float buttonDistance;
                if (!((double)button.yPosition + (double)button.height / 2.0 > cursorY) || !((buttonDistance = this.getButtonDistance(button, (int)cursorX, (int)cursorY)) < closestButtonDistance)) continue;
                closestButton = button;
                closestButtonDistance = this.getButtonDistance(button, (int)cursorX, (int)cursorY);
            }
        }
        if (closestButton == null) {
            return;
        }
        this.mc.controllerInput.cursorX = (double)closestButton.xPosition + (double)closestButton.width / 2.0;
        this.mc.controllerInput.cursorY = (double)closestButton.yPosition + (double)closestButton.height / 2.0;
    }

    public void selectButtonLeft() {
        double cursorX = this.mc.controllerInput.cursorX;
        double cursorY = this.mc.controllerInput.cursorY;
        GuiButton hoveredButton = null;
        GuiButton closestButton = null;
        float closestButtonDistance = Float.POSITIVE_INFINITY;
        for (GuiButton button : this.controlList) {
            if (!button.isHovered((int)cursorX, (int)cursorY)) continue;
            hoveredButton = button;
            break;
        }
        if (hoveredButton != null) {
            for (GuiButton button : this.controlList) {
                if (button == hoveredButton || hoveredButton.xPosition <= button.xPosition || hoveredButton.yPosition != button.yPosition || !((float)(hoveredButton.xPosition - button.xPosition) < closestButtonDistance)) continue;
                closestButtonDistance = hoveredButton.xPosition - button.xPosition;
                closestButton = button;
            }
        }
        if (closestButton == null) {
            for (GuiButton button : this.controlList) {
                float buttonDistance;
                if (!((double)button.xPosition + (double)button.width / 2.0 < cursorX) || !((buttonDistance = this.getButtonDistance(button, (int)cursorX, (int)cursorY)) < closestButtonDistance)) continue;
                closestButton = button;
                closestButtonDistance = this.getButtonDistance(button, (int)cursorX, (int)cursorY);
            }
        }
        if (closestButton == null) {
            return;
        }
        this.mc.controllerInput.cursorX = (double)closestButton.xPosition + (double)closestButton.width / 2.0;
        this.mc.controllerInput.cursorY = (double)closestButton.yPosition + (double)closestButton.height / 2.0;
    }

    public void selectButtonRight() {
        double cursorX = this.mc.controllerInput.cursorX;
        double cursorY = this.mc.controllerInput.cursorY;
        GuiButton hoveredButton = null;
        GuiButton closestButton = null;
        float closestButtonDistance = Float.POSITIVE_INFINITY;
        for (GuiButton button : this.controlList) {
            if (!button.isHovered((int)cursorX, (int)cursorY)) continue;
            hoveredButton = button;
            break;
        }
        if (hoveredButton != null) {
            for (GuiButton button : this.controlList) {
                if (button == hoveredButton || hoveredButton.xPosition >= button.xPosition || hoveredButton.yPosition != button.yPosition || !((float)(button.xPosition - hoveredButton.xPosition) < closestButtonDistance)) continue;
                closestButtonDistance = button.xPosition - hoveredButton.xPosition;
                closestButton = button;
            }
        }
        if (closestButton == null) {
            for (GuiButton button : this.controlList) {
                float buttonDistance;
                if (!((double)button.xPosition + (double)button.width / 2.0 > cursorX) || !((buttonDistance = this.getButtonDistance(button, (int)cursorX, (int)cursorY)) < closestButtonDistance)) continue;
                closestButton = button;
                closestButtonDistance = this.getButtonDistance(button, (int)cursorX, (int)cursorY);
            }
        }
        if (closestButton == null) {
            return;
        }
        this.mc.controllerInput.cursorX = (double)closestButton.xPosition + (double)closestButton.width / 2.0;
        this.mc.controllerInput.cursorY = (double)closestButton.yPosition + (double)closestButton.height / 2.0;
    }

    public float getButtonDistance(GuiButton button1, int cursorX, int cursorY) {
        return (float)Math.sqrt(Math.pow(button1.xPosition - cursorX, 2.0) + Math.pow(button1.yPosition - cursorY, 2.0));
    }

    public float getButtonDistanceBiasX(GuiButton button1, int cursorX, int cursorY) {
        return (float)Math.sqrt(Math.pow((double)(button1.xPosition - cursorX) / 16.0, 2.0) + Math.pow(button1.yPosition - cursorY, 2.0));
    }

    public float getButtonDistanceBiasY(GuiButton button1, int cursorX, int cursorY) {
        return (float)Math.sqrt(Math.pow(button1.xPosition - cursorX, 2.0) + Math.pow((double)(button1.yPosition - cursorY) / 16.0, 2.0));
    }
}

