/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import net.minecraft.client.Minecraft;
import net.minecraft.src.GuiAddServer;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiConnecting;
import net.minecraft.src.GuiMultiplayer;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.GuiServerSlot;
import net.minecraft.src.GuiYesNo;
import net.minecraft.src.SavedServer;
import net.minecraft.src.SavedServerList;
import net.minecraft.src.StringTranslate;

public class GuiSelectServer
extends GuiScreen {
    private final DateFormat dateFormatter = new SimpleDateFormat();
    protected String screenTitle = "Select server";
    private boolean selected = false;
    private int selectedServer;
    private SavedServerList savedServerList;
    private GuiServerSlot worldSlotContainer;
    private String field_22098_o;
    private String field_22097_p;
    private boolean deleting;
    private GuiButton buttonAdd;
    private GuiButton buttonConnect;
    private GuiButton buttonDelete;

    public GuiSelectServer(GuiScreen guiscreen) {
        super(guiscreen);
    }

    @Override
    public void initGui() {
        StringTranslate stringtranslate = StringTranslate.getInstance();
        this.screenTitle = stringtranslate.translateKey("selectServer.title");
        this.loadSavedServers();
        this.worldSlotContainer = new GuiServerSlot(this);
        this.worldSlotContainer.registerScrollButtons(this.controlList, 4, 5);
        this.initButtons();
    }

    private void loadSavedServers() {
        this.savedServerList = SavedServerList.readFromFile(new File(Minecraft.getMinecraftDir() + "/servers.dat"));
        this.selectedServer = -1;
    }

    public void initButtons() {
        StringTranslate stringtranslate = StringTranslate.getInstance();
        this.buttonConnect = new GuiButton(1, this.width / 2 - 154, this.height - 52, 150, 20, stringtranslate.translateKey("selectServer.connect"));
        this.controlList.add(this.buttonConnect);
        this.buttonAdd = new GuiButton(6, this.width / 2 - 154, this.height - 28, 70, 20, stringtranslate.translateKey("selectServer.add"));
        this.controlList.add(this.buttonAdd);
        this.buttonDelete = new GuiButton(2, this.width / 2 - 74, this.height - 28, 70, 20, stringtranslate.translateKey("selectServer.delete"));
        this.controlList.add(this.buttonDelete);
        this.controlList.add(new GuiButton(3, this.width / 2 + 4, this.height - 52, 150, 20, stringtranslate.translateKey("selectServer.ip")));
        this.controlList.add(new GuiButton(0, this.width / 2 + 4, this.height - 28, 150, 20, stringtranslate.translateKey("gui.cancel")));
        this.buttonConnect.enabled = false;
        this.buttonDelete.enabled = false;
    }

    @Override
    protected void actionPerformed(GuiButton guibutton) {
        if (!guibutton.enabled) {
            return;
        }
        if (guibutton.id == 2) {
            String s2 = this.savedServerList.servers.get((int)this.selectedServer).nickname;
            if (s2 != null) {
                this.deleting = true;
                StringTranslate stringtranslate = StringTranslate.getInstance();
                String s1 = stringtranslate.translateKey("selectWorld.deleteQuestion");
                String s22 = "'" + s2 + "' " + stringtranslate.translateKey("selectWorld.deleteWarning");
                String s3 = stringtranslate.translateKey("selectWorld.deleteButton");
                String s4 = stringtranslate.translateKey("gui.cancel");
                GuiYesNo guiyesno = new GuiYesNo(this, s1, s22, s3, s4, this.selectedServer);
                this.mc.displayGuiScreen(guiyesno);
            }
        } else if (guibutton.id == 1) {
            this.selectServer(this.selectedServer);
        } else if (guibutton.id == 3) {
            this.mc.displayGuiScreen(new GuiMultiplayer(this));
        } else if (guibutton.id == 6) {
            this.mc.displayGuiScreen(new GuiAddServer(this, this.savedServerList));
            this.savedServerList.writeToFile();
        } else if (guibutton.id == 0) {
            this.mc.displayGuiScreen(this.parentScreen);
        } else {
            this.worldSlotContainer.actionPerformed(guibutton);
        }
    }

    public void selectServer(int i2) {
        this.mc.displayGuiScreen(null);
        if (this.selected) {
            return;
        }
        this.selected = true;
        SavedServer server = this.savedServerList.servers.get(this.selectedServer);
        server.lastPlayed = LocalDateTime.now();
        this.savedServerList.writeToFile();
        String[] as2 = server.address.split(":");
        this.mc.displayGuiScreen(new GuiConnecting(this.mc, as2[0], as2.length <= 1 ? 25565 : this.parseIntWithDefault(as2[1], 25565)));
    }

    @Override
    public void deleteWorld(boolean flag, int i2) {
        if (this.deleting) {
            this.deleting = false;
            if (flag) {
                this.savedServerList.servers.remove(i2);
                this.savedServerList.writeToFile();
            }
            this.mc.displayGuiScreen(this);
        }
    }

    private int parseIntWithDefault(String s2, int i2) {
        try {
            return Integer.parseInt(s2.trim());
        }
        catch (Exception exception) {
            return i2;
        }
    }

    @Override
    public void drawScreen(int x2, int y2, float renderPartialTicks) {
        this.worldSlotContainer.drawScreen(x2, y2, renderPartialTicks);
        this.drawCenteredString(this.fontRenderer, this.screenTitle, this.width / 2, 20, 0xFFFFFF);
        super.drawScreen(x2, y2, renderPartialTicks);
    }

    static SavedServerList getSize(GuiSelectServer guiselectworld) {
        return guiselectworld.savedServerList;
    }

    static int onElementSelected(GuiSelectServer guiselectworld, int i2) {
        guiselectworld.selectedServer = i2;
        return guiselectworld.selectedServer;
    }

    static int getSelectedServer(GuiSelectServer guiselectworld) {
        return guiselectworld.selectedServer;
    }

    static GuiButton getConnectButton(GuiSelectServer guiselectworld) {
        return guiselectworld.buttonConnect;
    }

    static GuiButton getDeleteButton(GuiSelectServer guiselectworld) {
        return guiselectworld.buttonDelete;
    }
}

