/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.GameSettings;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiOptionsButton;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.GuiSlider;
import net.minecraft.src.StringTranslate;
import net.minecraft.src.option.FloatOption;
import net.minecraft.src.option.Option;
import net.minecraft.src.render.Shaders;

public abstract class GuiSettingsBase
extends GuiScreen {
    String languageKey;
    final GameSettings gameSettings;
    Option<?>[] options;

    public GuiSettingsBase(GuiScreen parent, GameSettings settings) {
        super(parent);
        this.gameSettings = settings;
    }

    protected void setOptions(Option<?> ... options) {
        this.options = options;
    }

    @Override
    public void initGui() {
        this.controlList.clear();
        StringTranslate stringtranslate = StringTranslate.getInstance();
        for (int i2 = 0; i2 < this.options.length; ++i2) {
            Option<?> option = this.options[i2];
            if (option == null) continue;
            if (option instanceof FloatOption) {
                GuiSlider slider = new GuiSlider(option.getId(), this.width / 2 - 155 + i2 % 2 * 160, this.height / 6 + 24 * (i2 >> 1), option, option.getDisplayString(), this.gameSettings.getOptionFloatValue(option));
                this.controlList.add(slider);
                if (option != this.mc.gameSettings.gamma || Shaders.shadersCompatible) continue;
                slider.enabled = false;
                continue;
            }
            GuiOptionsButton button = new GuiOptionsButton(option.getId(), this.width / 2 - 155 + i2 % 2 * 160, this.height / 6 + 24 * (i2 >> 1), option, option.getDisplayString());
            this.controlList.add(button);
        }
        this.controlList.add(new GuiButton(200, this.width / 2 - 100, this.height / 6 + 168, stringtranslate.translateKey("gui.done")));
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        if (!button.enabled) {
            return;
        }
        if (button.id < 100 && button instanceof GuiOptionsButton) {
            GuiOptionsButton optionsButton = (GuiOptionsButton)button;
            Option<?> option = optionsButton.returnEnumOptions();
            this.gameSettings.setOptionValue(option, 1);
            option.update();
            if (optionsButton.returnEnumOptions() == this.mc.gameSettings.guiScale) {
                this.mc.resolution.update();
            }
            button.displayString = option.getDisplayString();
        }
        if (button.id == 200) {
            this.mc.gameSettings.saveOptions();
            this.mc.displayGuiScreen(this.parentScreen);
        }
        if (!(button instanceof GuiSlider)) {
            this.setWorldAndResolution(this.mc, this.mc.resolution.scaledWidth, this.mc.resolution.scaledHeight);
        }
    }

    @Override
    public void drawScreen(int x2, int y2, float renderPartialTicks) {
        StringTranslate stringtranslate = StringTranslate.getInstance();
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRenderer, stringtranslate.translateKey(this.languageKey), this.width / 2, 20, 0xFFFFFF);
        super.drawScreen(x2, y2, renderPartialTicks);
    }

    public void autoAlignButtons() {
        int i2 = 0;
        for (GuiButton button : this.controlList) {
            if (button.id == 200) continue;
            button.xPosition = this.width / 2 - 155 + i2 % 2 * 160;
            button.yPosition = this.height / 6 + 21 * (i2 / 2);
            button.width = 150;
            button.height = 20;
            ++i2;
        }
    }
}

