/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.client.Minecraft;
import net.minecraft.src.GuiButton;
import net.minecraft.src.option.Option;
import org.lwjgl.opengl.GL11;

public class GuiSlider
extends GuiButton {
    public float sliderValue;
    public boolean dragging;
    private Option<?> idFloat;

    public GuiSlider(int id2, int xPosition, int yPosition, Option<?> enumoptions, String text, float defaultValue) {
        super(id2, xPosition, yPosition, 150, 20, text);
        this.sliderValue = 1.0f;
        this.dragging = false;
        this.idFloat = null;
        this.idFloat = enumoptions;
        this.sliderValue = defaultValue;
    }

    public GuiSlider(int id2, int xPosition, int yPosition, int width, int height, String text, float defaultValue) {
        super(id2, xPosition, yPosition, width, height, text);
        this.dragging = false;
        this.idFloat = null;
        this.sliderValue = defaultValue;
    }

    @Override
    protected int getButtonState(boolean hovered) {
        return 0;
    }

    @Override
    protected void mouseDragged(Minecraft minecraft, int i2, int j2) {
        if (!this.visible) {
            return;
        }
        if (this.dragging) {
            this.sliderValue = (float)(i2 - (this.xPosition + 4)) / (float)(this.width - 8);
            if (this.sliderValue < 0.0f) {
                this.sliderValue = 0.0f;
            }
            if (this.sliderValue > 1.0f) {
                this.sliderValue = 1.0f;
            }
            if (this.idFloat != null) {
                minecraft.gameSettings.setOptionFloatValue(this.idFloat, this.sliderValue);
                this.displayString = this.idFloat.getDisplayString();
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(this.xPosition + (int)(this.sliderValue * (float)(this.width - 8)), this.yPosition, 0, 66, 4, 20);
        this.drawTexturedModalRect(this.xPosition + (int)(this.sliderValue * (float)(this.width - 8)) + 4, this.yPosition, 196, 66, 4, 20);
    }

    @Override
    public boolean mousePressed(Minecraft minecraft, int i2, int j2) {
        if (super.mousePressed(minecraft, i2, j2)) {
            this.sliderValue = (float)(i2 - (this.xPosition + 4)) / (float)(this.width - 8);
            if (this.sliderValue < 0.0f) {
                this.sliderValue = 0.0f;
            }
            if (this.sliderValue > 1.0f) {
                this.sliderValue = 1.0f;
            }
            if (this.idFloat != null) {
                minecraft.gameSettings.setOptionFloatValue(this.idFloat, this.sliderValue);
                this.displayString = this.idFloat.getDisplayString();
            }
            this.dragging = true;
            return true;
        }
        return false;
    }

    @Override
    public void mouseReleased(int i2, int j2) {
        this.dragging = false;
    }
}

