/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.src.GuiButton;
import net.minecraft.src.Tessellator;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class GuiSlot {
    private final Minecraft mc;
    private final int width;
    private final int height;
    protected final int top;
    protected final int bottom;
    private final int right;
    private final int left = 0;
    protected final int posZ;
    private int scrollUpButtonID;
    private int scrollDownButtonID;
    private float initialClickY = -2.0f;
    private float scrollMultiplier;
    private float amountScrolled;
    private int selectedElement = -1;
    private long lastClicked = 0L;
    private boolean field_25123_p = true;
    private boolean field_27262_q;
    private int field_27261_r;

    public GuiSlot(Minecraft minecraft, int i2, int j2, int k2, int l2, int i1) {
        this.mc = minecraft;
        this.width = i2;
        this.height = j2;
        this.top = k2;
        this.bottom = l2;
        this.posZ = i1;
        this.right = i2;
    }

    public void func_27258_a(boolean flag) {
        this.field_25123_p = flag;
    }

    protected void func_27259_a(boolean flag, int i2) {
        this.field_27262_q = flag;
        this.field_27261_r = i2;
        if (!flag) {
            this.field_27261_r = 0;
        }
    }

    protected abstract int getSize();

    protected abstract void elementClicked(int var1, boolean var2);

    protected abstract boolean isSelected(int var1);

    protected int getContentHeight() {
        return this.getSize() * this.posZ + this.field_27261_r;
    }

    protected abstract void drawBackground();

    protected abstract void drawSlot(int var1, int var2, int var3, int var4, Tessellator var5);

    protected void func_27260_a(int i2, int j2, Tessellator tessellator) {
    }

    protected void func_27255_a(int i2, int j2) {
    }

    protected void func_27257_b(int i2, int j2) {
    }

    public int func_27256_c(int i2, int j2) {
        int k2 = this.width / 2 - 110;
        int l2 = this.width / 2 + 110;
        int i1 = j2 - this.top - this.field_27261_r + (int)this.amountScrolled - 4;
        int j1 = i1 / this.posZ;
        if (i2 >= k2 && i2 <= l2 && j1 >= 0 && i1 >= 0 && j1 < this.getSize()) {
            return j1;
        }
        return -1;
    }

    public void registerScrollButtons(List list, int i2, int j2) {
        this.scrollUpButtonID = i2;
        this.scrollDownButtonID = j2;
    }

    private void bindAmountScrolled() {
        int i2 = this.getContentHeight() - (this.bottom - this.top - 4);
        if (i2 < 0) {
            i2 /= 2;
        }
        if (this.amountScrolled < 0.0f) {
            this.amountScrolled = 0.0f;
        }
        if (this.amountScrolled > (float)i2) {
            this.amountScrolled = i2;
        }
    }

    public void actionPerformed(GuiButton guibutton) {
        if (!guibutton.enabled) {
            return;
        }
        if (guibutton.id == this.scrollUpButtonID) {
            this.amountScrolled -= (float)(this.posZ * 2 / 3);
            this.initialClickY = -2.0f;
            this.bindAmountScrolled();
        } else if (guibutton.id == this.scrollDownButtonID) {
            this.amountScrolled += (float)(this.posZ * 2 / 3);
            this.initialClickY = -2.0f;
            this.bindAmountScrolled();
        }
    }

    public void drawScreen(int i2, int j2, float f2) {
        this.drawBackground();
        int k2 = this.getSize();
        int l2 = this.width / 2 + 124;
        int i1 = l2 + 6;
        if (Mouse.isButtonDown((int)0) || this.mc.controllerInput != null && this.mc.controllerInput.buttonA.isPressed()) {
            if (this.initialClickY == -1.0f) {
                boolean flag = true;
                if (j2 >= this.top && j2 <= this.bottom) {
                    int j1 = this.width / 2 - 110;
                    int k1 = this.width / 2 + 110;
                    int i22 = j2 - this.top - this.field_27261_r + (int)this.amountScrolled - 4;
                    int k22 = i22 / this.posZ;
                    if (i2 >= j1 && i2 <= k1 && k22 >= 0 && i22 >= 0 && k22 < k2) {
                        boolean flag1 = k22 == this.selectedElement && System.currentTimeMillis() - this.lastClicked < 250L;
                        this.elementClicked(k22, flag1);
                        this.selectedElement = k22;
                        this.lastClicked = System.currentTimeMillis();
                    } else if (i2 >= j1 && i2 <= k1 && i22 < 0) {
                        this.func_27255_a(i2 - j1, j2 - this.top + (int)this.amountScrolled - 4);
                        flag = false;
                    }
                    if (i2 >= l2 && i2 <= i1) {
                        int l3;
                        this.scrollMultiplier = -1.0f;
                        int i3 = this.getContentHeight() - (this.bottom - this.top - 4);
                        if (i3 < 1) {
                            i3 = 1;
                        }
                        if ((l3 = (int)((float)((this.bottom - this.top) * (this.bottom - this.top)) / (float)this.getContentHeight())) < 32) {
                            l3 = 32;
                        }
                        if (l3 > this.bottom - this.top - 8) {
                            l3 = this.bottom - this.top - 8;
                        }
                        this.scrollMultiplier /= (float)(this.bottom - this.top - l3) / (float)i3;
                    } else {
                        this.scrollMultiplier = 1.0f;
                    }
                    this.initialClickY = flag ? (float)j2 : -2.0f;
                } else {
                    this.initialClickY = -2.0f;
                }
            } else if (this.initialClickY >= 0.0f) {
                this.amountScrolled -= ((float)j2 - this.initialClickY) * this.scrollMultiplier;
                this.initialClickY = j2;
            }
        } else {
            this.initialClickY = -1.0f;
        }
        this.bindAmountScrolled();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        Tessellator tessellator = Tessellator.instance;
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/background.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f1 = 32.0f;
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0x202020);
        tessellator.addVertexWithUV(0.0, this.bottom, 0.0, 0.0f / f1, (float)(this.bottom + (int)this.amountScrolled) / f1);
        tessellator.addVertexWithUV(this.right, this.bottom, 0.0, (float)this.right / f1, (float)(this.bottom + (int)this.amountScrolled) / f1);
        tessellator.addVertexWithUV(this.right, this.top, 0.0, (float)this.right / f1, (float)(this.top + (int)this.amountScrolled) / f1);
        tessellator.addVertexWithUV(0.0, this.top, 0.0, 0.0f / f1, (float)(this.top + (int)this.amountScrolled) / f1);
        tessellator.draw();
        int l1 = this.width / 2 - 92 - 16;
        int j22 = this.top + 4 - (int)this.amountScrolled;
        if (this.field_27262_q) {
            this.func_27260_a(l1, j22, tessellator);
        }
        for (int l22 = 0; l22 < k2; ++l22) {
            int j3 = j22 + l22 * this.posZ + this.field_27261_r;
            int i4 = this.posZ - 4;
            if (j3 > this.bottom || j3 + i4 < this.top) continue;
            if (this.field_25123_p && this.isSelected(l22)) {
                int k4 = this.width / 2 - 110;
                int i5 = this.width / 2 + 110;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)3553);
                tessellator.startDrawingQuads();
                tessellator.setColorOpaque_I(0x808080);
                tessellator.addVertexWithUV(k4, j3 + i4 + 2, 0.0, 0.0, 1.0);
                tessellator.addVertexWithUV(i5, j3 + i4 + 2, 0.0, 1.0, 1.0);
                tessellator.addVertexWithUV(i5, j3 - 2, 0.0, 1.0, 0.0);
                tessellator.addVertexWithUV(k4, j3 - 2, 0.0, 0.0, 0.0);
                tessellator.setColorOpaque_I(0);
                tessellator.addVertexWithUV(k4 + 1, j3 + i4 + 1, 0.0, 0.0, 1.0);
                tessellator.addVertexWithUV(i5 - 1, j3 + i4 + 1, 0.0, 1.0, 1.0);
                tessellator.addVertexWithUV(i5 - 1, j3 - 1, 0.0, 1.0, 0.0);
                tessellator.addVertexWithUV(k4 + 1, j3 - 1, 0.0, 0.0, 0.0);
                tessellator.draw();
                GL11.glEnable((int)3553);
            }
            this.drawSlot(l22, l1, j3, i4, tessellator);
        }
        GL11.glDisable((int)2929);
        int byte0 = 4;
        this.overlayBackground(0, this.top, 255, 255);
        this.overlayBackground(this.bottom, this.height, 255, 255);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)3553);
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_I(0, 0);
        tessellator.addVertexWithUV(0.0, this.top + byte0, 0.0, 0.0, 1.0);
        tessellator.addVertexWithUV(this.right, this.top + byte0, 0.0, 1.0, 1.0);
        tessellator.setColorRGBA_I(0, 255);
        tessellator.addVertexWithUV(this.right, this.top, 0.0, 1.0, 0.0);
        tessellator.addVertexWithUV(0.0, this.top, 0.0, 0.0, 0.0);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_I(0, 255);
        tessellator.addVertexWithUV(0.0, this.bottom, 0.0, 0.0, 1.0);
        tessellator.addVertexWithUV(this.right, this.bottom, 0.0, 1.0, 1.0);
        tessellator.setColorRGBA_I(0, 0);
        tessellator.addVertexWithUV(this.right, this.bottom - byte0, 0.0, 1.0, 0.0);
        tessellator.addVertexWithUV(0.0, this.bottom - byte0, 0.0, 0.0, 0.0);
        tessellator.draw();
        int k3 = this.getContentHeight() - (this.bottom - this.top - 4);
        if (k3 > 0) {
            int l4;
            int j4 = (this.bottom - this.top) * (this.bottom - this.top) / this.getContentHeight();
            if (j4 < 32) {
                j4 = 32;
            }
            if (j4 > this.bottom - this.top - 8) {
                j4 = this.bottom - this.top - 8;
            }
            if ((l4 = (int)this.amountScrolled * (this.bottom - this.top - j4) / k3 + this.top) < this.top) {
                l4 = this.top;
            }
            tessellator.startDrawingQuads();
            tessellator.setColorRGBA_I(0, 255);
            tessellator.addVertexWithUV(l2, this.bottom, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(i1, this.bottom, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV(i1, this.top, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(l2, this.top, 0.0, 0.0, 0.0);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setColorRGBA_I(0x808080, 255);
            tessellator.addVertexWithUV(l2, l4 + j4, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(i1, l4 + j4, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV(i1, l4, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(l2, l4, 0.0, 0.0, 0.0);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setColorRGBA_I(0xC0C0C0, 255);
            tessellator.addVertexWithUV(l2, l4 + j4 - 1, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(i1 - 1, l4 + j4 - 1, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV(i1 - 1, l4, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(l2, l4, 0.0, 0.0, 0.0);
            tessellator.draw();
        }
        this.func_27257_b(i2, j2);
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
    }

    private void overlayBackground(int i2, int j2, int k2, int l2) {
        Tessellator tessellator = Tessellator.instance;
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/background.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f2 = 32.0f;
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_I(0x404040, l2);
        tessellator.addVertexWithUV(0.0, j2, 0.0, 0.0, (float)j2 / f2);
        tessellator.addVertexWithUV(this.width, j2, 0.0, (float)this.width / f2, (float)j2 / f2);
        tessellator.setColorRGBA_I(0x404040, k2);
        tessellator.addVertexWithUV(this.width, i2, 0.0, (float)this.width / f2, (float)i2 / f2);
        tessellator.addVertexWithUV(0.0, i2, 0.0, 0.0, (float)i2 / f2);
        tessellator.draw();
    }
}

