/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.Timer;
import net.minecraft.src.GuiStatsListener;
import net.minecraft.src.NetworkManager;

public class GuiStatsComponent
extends JComponent {
    private int[] memoryUse = new int[256];
    private int updateCounter = 0;
    private String[] displayStrings = new String[10];

    public GuiStatsComponent() {
        this.setPreferredSize(new Dimension(256, 196));
        this.setMinimumSize(new Dimension(256, 196));
        this.setMaximumSize(new Dimension(256, 196));
        new Timer(500, new GuiStatsListener(this)).start();
        this.setBackground(Color.BLACK);
    }

    private void updateStats() {
        long l2 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        System.gc();
        this.displayStrings[0] = "Memory use: " + l2 / 1024L / 1024L + " mb (" + Runtime.getRuntime().freeMemory() * 100L / Runtime.getRuntime().maxMemory() + "% free)";
        this.displayStrings[1] = "Threads: " + NetworkManager.numReadThreads + " + " + NetworkManager.numWriteThreads;
        this.memoryUse[this.updateCounter++ & 0xFF] = (int)(l2 * 100L / Runtime.getRuntime().maxMemory());
        this.repaint();
    }

    @Override
    public void paint(Graphics g2) {
        g2.setColor(new Color(0xFFFFFF));
        g2.fillRect(0, 0, 256, 192);
        for (int i2 = 0; i2 < 256; ++i2) {
            int k2 = this.memoryUse[i2 + this.updateCounter & 0xFF];
            g2.setColor(new Color(k2 + 28 << 16));
            g2.fillRect(i2, 100 - k2, 1, k2);
        }
        g2.setColor(Color.BLACK);
        for (int j2 = 0; j2 < this.displayStrings.length; ++j2) {
            String s2 = this.displayStrings[j2];
            if (s2 == null) continue;
            g2.drawString(s2, 32, 116 + j2 * 16);
        }
    }

    static void update(GuiStatsComponent guistatscomponent) {
        guistatscomponent.updateStats();
    }
}

