/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Date;
import net.minecraft.src.Gamemode;
import net.minecraft.src.GuiSelectWorld;
import net.minecraft.src.GuiSlot;
import net.minecraft.src.MathHelper;
import net.minecraft.src.SaveFormatComparator;
import net.minecraft.src.StringTranslate;
import net.minecraft.src.Tessellator;
import net.minecraft.src.WorldInfo;
import net.minecraft.src.WorldType;

class GuiWorldSlot
extends GuiSlot {
    final GuiSelectWorld parentWorldGui;

    public GuiWorldSlot(GuiSelectWorld guiselectworld) {
        super(guiselectworld.mc, guiselectworld.width, guiselectworld.height, 32, guiselectworld.height - 64, 36);
        this.parentWorldGui = guiselectworld;
    }

    @Override
    protected int getSize() {
        return GuiSelectWorld.getSize(this.parentWorldGui).size();
    }

    @Override
    protected void elementClicked(int i2, boolean flag) {
        boolean flag1;
        GuiSelectWorld.onElementSelected(this.parentWorldGui, i2);
        GuiSelectWorld.getSelectButton((GuiSelectWorld)this.parentWorldGui).enabled = flag1 = GuiSelectWorld.getSelectedWorld(this.parentWorldGui) >= 0 && GuiSelectWorld.getSelectedWorld(this.parentWorldGui) < this.getSize();
        GuiSelectWorld.getRenameButton((GuiSelectWorld)this.parentWorldGui).enabled = flag1;
        GuiSelectWorld.getDeleteButton((GuiSelectWorld)this.parentWorldGui).enabled = flag1;
        if (flag && flag1) {
            this.parentWorldGui.selectWorld(i2);
        }
    }

    @Override
    protected boolean isSelected(int i2) {
        return i2 == GuiSelectWorld.getSelectedWorld(this.parentWorldGui);
    }

    @Override
    protected int getContentHeight() {
        return GuiSelectWorld.getSize(this.parentWorldGui).size() * 36;
    }

    @Override
    protected void drawBackground() {
        this.parentWorldGui.drawDefaultBackground();
    }

    @Override
    protected void drawSlot(int i2, int j2, int k2, int l2, Tessellator tessellator) {
        SaveFormatComparator saveformatcomparator = (SaveFormatComparator)GuiSelectWorld.getSize(this.parentWorldGui).get(i2);
        String s2 = saveformatcomparator.getDisplayName();
        if (s2 == null || MathHelper.stringNullOrLengthZero(s2)) {
            s2 = GuiSelectWorld.func_22087_f(this.parentWorldGui) + " " + (i2 + 1);
        }
        String s1 = saveformatcomparator.getFileName();
        s1 = s1 + " (" + GuiSelectWorld.getDateFormatter(this.parentWorldGui).format(new Date(saveformatcomparator.func_22163_e()));
        long l1 = saveformatcomparator.func_22159_c();
        s1 = s1 + ", " + (float)(l1 / 1024L * 100L / 1024L) / 100.0f + " MB)";
        String s22 = "";
        if (saveformatcomparator.func_22161_d()) {
            s22 = GuiSelectWorld.func_22088_h(this.parentWorldGui) + " " + s22;
        } else {
            WorldInfo wi2 = saveformatcomparator.getWorldInfo();
            StringTranslate st2 = StringTranslate.getInstance();
            s22 = s22 + st2.translateNamedKey(Gamemode.gamemodesList[wi2.getGamemode()].languageKey);
            if (wi2.getCheatsEnabled()) {
                s22 = s22 + " | Cheats";
            }
            s22 = s22 + " | " + st2.translateNamedKey(WorldType.worldTypes[wi2.getWorldType((int)0)].languageKey);
        }
        this.parentWorldGui.drawString(this.parentWorldGui.fontRenderer, s2, j2 + 2, k2 + 1, 0xFFFFFF);
        this.parentWorldGui.drawString(this.parentWorldGui.fontRenderer, s1, j2 + 2, k2 + 12, 0x808080);
        this.parentWorldGui.drawString(this.parentWorldGui.fontRenderer, s22, j2 + 2, k2 + 12 + 10, 0x808080);
    }
}

