/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Container;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.ItemStack;

public class InventoryCrafting
implements IInventory {
    private ItemStack[] stackList;
    private int field_21104_b;
    private Container eventHandler;

    public InventoryCrafting(Container container, int i2, int j2) {
        int k2 = i2 * j2;
        this.stackList = new ItemStack[k2];
        this.eventHandler = container;
        this.field_21104_b = i2;
    }

    @Override
    public int getSizeInventory() {
        return this.stackList.length;
    }

    @Override
    public ItemStack getStackInSlot(int i2) {
        if (i2 >= this.getSizeInventory()) {
            return null;
        }
        return this.stackList[i2];
    }

    public ItemStack getItemStackAt(int i2, int j2) {
        if (i2 < 0 || i2 >= this.field_21104_b) {
            return null;
        }
        int k2 = i2 + j2 * this.field_21104_b;
        return this.getStackInSlot(k2);
    }

    public void setSlotContentsAt(int i2, int j2, ItemStack itemStack) {
        if (i2 < 0 || i2 >= this.field_21104_b) {
            return;
        }
        int k2 = i2 + j2 * this.field_21104_b;
        this.setInventorySlotContents(k2, itemStack);
    }

    @Override
    public String getInvName() {
        return "Crafting";
    }

    @Override
    public ItemStack decrStackSize(int i2, int j2) {
        if (this.stackList[i2] != null) {
            if (this.stackList[i2].stackSize <= j2) {
                ItemStack itemstack = this.stackList[i2];
                this.stackList[i2] = null;
                this.eventHandler.onCraftMatrixChanged(this);
                return itemstack;
            }
            ItemStack itemstack1 = this.stackList[i2].splitStack(j2);
            if (this.stackList[i2].stackSize == 0) {
                this.stackList[i2] = null;
            }
            this.eventHandler.onCraftMatrixChanged(this);
            return itemstack1;
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(int i2, ItemStack itemstack) {
        this.stackList[i2] = itemstack;
        this.eventHandler.onCraftMatrixChanged(this);
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public void onInventoryChanged() {
        this.eventHandler.onCraftMatrixChanged(this);
    }

    @Override
    public boolean canInteractWith(EntityPlayer entityplayer) {
        return true;
    }
}

