/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.Item;
import net.minecraft.src.ItemArmor;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.helper.DamageType;

public class InventoryPlayer
implements IInventory {
    public int hotbarOffset = 0;
    public ItemStack[] mainInventory = new ItemStack[36];
    public ItemStack[] armorInventory = new ItemStack[4];
    public int currentItem = 0;
    public EntityPlayer player;
    private ItemStack heldItem;
    public boolean inventoryChanged = false;

    public InventoryPlayer(EntityPlayer entityplayer) {
        this.player = entityplayer;
    }

    public ItemStack getCurrentItem() {
        if (this.currentItem < 9 + this.hotbarOffset && this.currentItem >= this.hotbarOffset) {
            return this.mainInventory[this.currentItem];
        }
        return null;
    }

    public static int func_25054_e() {
        return 36;
    }

    private int getInventorySlotContainItem(int i2) {
        for (int j2 = 0; j2 < this.mainInventory.length; ++j2) {
            if (this.mainInventory[j2] == null || this.mainInventory[j2].itemID != i2) continue;
            return j2;
        }
        return -1;
    }

    private int storeItemStack(ItemStack itemstack) {
        for (int i2 = 0; i2 < this.mainInventory.length; ++i2) {
            if (this.mainInventory[i2] == null || this.mainInventory[i2].itemID != itemstack.itemID || !this.mainInventory[i2].isStackable() || this.mainInventory[i2].stackSize >= this.mainInventory[i2].getMaxStackSize() || this.mainInventory[i2].stackSize >= this.getInventoryStackLimit() || this.mainInventory[i2].getHasSubtypes() && this.mainInventory[i2].getMetadata() != itemstack.getMetadata()) continue;
            return i2;
        }
        return -1;
    }

    private int storeItemStackWithHotbarOffset(ItemStack itemstack) {
        for (int i2 = 0; i2 < this.mainInventory.length; ++i2) {
            int index = (i2 + this.hotbarOffset) % this.mainInventory.length;
            if (this.mainInventory[index] == null || this.mainInventory[index].itemID != itemstack.itemID || !this.mainInventory[index].isStackable() || this.mainInventory[index].stackSize >= this.mainInventory[index].getMaxStackSize() || this.mainInventory[index].stackSize >= this.getInventoryStackLimit() || this.mainInventory[index].getHasSubtypes() && this.mainInventory[index].getMetadata() != itemstack.getMetadata()) continue;
            return index;
        }
        return -1;
    }

    private int getFirstEmptyStack() {
        for (int i2 = 0; i2 < this.mainInventory.length; ++i2) {
            if (this.mainInventory[i2] != null) continue;
            return i2;
        }
        return -1;
    }

    private int getFirstEmptyStackWithHotbarOffset() {
        for (int i2 = 0; i2 < this.mainInventory.length; ++i2) {
            if (this.mainInventory[(i2 + this.hotbarOffset) % this.mainInventory.length] != null) continue;
            return (i2 + this.hotbarOffset) % this.mainInventory.length;
        }
        return -1;
    }

    public int setCurrentItem(ItemStack itemstack, boolean flag) {
        if (!flag) {
            return this.currentItem;
        }
        if (itemstack.itemID < Block.blocksList.length ? Block.blocksList[itemstack.itemID].notInCreativeMenu : Item.itemsList[itemstack.itemID].notInCreativeMenu) {
            return this.currentItem;
        }
        for (int j2 = this.hotbarOffset; j2 < 9 + this.hotbarOffset; ++j2) {
            if (this.mainInventory[j2] == null || this.mainInventory[j2].itemID != itemstack.itemID) continue;
            this.currentItem = j2;
            return this.currentItem;
        }
        this.mainInventory[this.currentItem] = itemstack;
        return this.currentItem;
    }

    public void changeCurrentItem(int i2) {
        if (i2 > 0) {
            i2 = 1;
        }
        if (i2 < 0) {
            i2 = -1;
        }
        this.currentItem -= i2;
        while (this.currentItem < this.hotbarOffset) {
            this.currentItem += 9;
        }
        while (this.currentItem >= 9 + this.hotbarOffset) {
            this.currentItem -= 9;
        }
    }

    private int storePartialItemStack(ItemStack itemstack) {
        int l2;
        int i2 = itemstack.itemID;
        int j2 = itemstack.stackSize;
        int k2 = this.storeItemStack(itemstack);
        if (k2 < 0) {
            k2 = this.getFirstEmptyStack();
        }
        if (k2 < 0) {
            return j2;
        }
        if (this.mainInventory[k2] == null) {
            this.mainInventory[k2] = new ItemStack(i2, 0, itemstack.getMetadata(), itemstack.tag);
        }
        if ((l2 = j2) > this.mainInventory[k2].getMaxStackSize() - this.mainInventory[k2].stackSize) {
            l2 = this.mainInventory[k2].getMaxStackSize() - this.mainInventory[k2].stackSize;
        }
        if (l2 > this.getInventoryStackLimit() - this.mainInventory[k2].stackSize) {
            l2 = this.getInventoryStackLimit() - this.mainInventory[k2].stackSize;
        }
        if (l2 == 0) {
            return j2;
        }
        this.mainInventory[k2].stackSize += l2;
        this.mainInventory[k2].animationsToGo = 5;
        return j2 -= l2;
    }

    private int storePartialItemStackWithHotbarOffset(ItemStack itemstack) {
        int l2;
        int i2 = itemstack.itemID;
        int j2 = itemstack.stackSize;
        int k2 = this.storeItemStackWithHotbarOffset(itemstack);
        if (k2 < 0) {
            k2 = this.getFirstEmptyStackWithHotbarOffset();
        }
        if (k2 < 0) {
            return j2;
        }
        if (this.mainInventory[k2] == null) {
            this.mainInventory[k2] = new ItemStack(i2, 0, itemstack.getMetadata(), itemstack.tag);
        }
        if ((l2 = j2) > this.mainInventory[k2].getMaxStackSize() - this.mainInventory[k2].stackSize) {
            l2 = this.mainInventory[k2].getMaxStackSize() - this.mainInventory[k2].stackSize;
        }
        if (l2 > this.getInventoryStackLimit() - this.mainInventory[k2].stackSize) {
            l2 = this.getInventoryStackLimit() - this.mainInventory[k2].stackSize;
        }
        if (l2 == 0) {
            return j2;
        }
        this.mainInventory[k2].stackSize += l2;
        this.mainInventory[k2].animationsToGo = 5;
        return j2 -= l2;
    }

    public void decrementAnimations() {
        for (int i2 = 0; i2 < this.mainInventory.length; ++i2) {
            if (this.mainInventory[i2] == null) continue;
            this.mainInventory[i2].updateAnimation(this.player.worldObj, this.player, i2, this.currentItem == i2);
        }
    }

    public boolean consumeInventoryItem(int i2) {
        int j2 = this.getInventorySlotContainItem(i2);
        if (j2 < 0) {
            return false;
        }
        if (this.player.getGamemode().consumeBlocks && --this.mainInventory[j2].stackSize <= 0) {
            this.mainInventory[j2] = null;
        }
        return true;
    }

    public boolean addItemStackToInventory(ItemStack itemstack) {
        if (!itemstack.isItemDamaged()) {
            int i2;
            do {
                i2 = itemstack.stackSize;
                itemstack.stackSize = this.storePartialItemStack(itemstack);
            } while (itemstack.stackSize > 0 && itemstack.stackSize < i2);
            return itemstack.stackSize < i2;
        }
        int j2 = this.getFirstEmptyStack();
        if (j2 >= 0) {
            this.mainInventory[j2] = ItemStack.copyItemStack(itemstack);
            this.mainInventory[j2].animationsToGo = 5;
            itemstack.stackSize = 0;
            return true;
        }
        return false;
    }

    public boolean addItemStackToInventoryWithHotbarOffset(ItemStack itemstack) {
        if (!itemstack.isItemDamaged()) {
            int i2;
            do {
                i2 = itemstack.stackSize;
                itemstack.stackSize = this.storePartialItemStackWithHotbarOffset(itemstack);
            } while (itemstack.stackSize > 0 && itemstack.stackSize < i2);
            return itemstack.stackSize < i2;
        }
        int j2 = this.getFirstEmptyStackWithHotbarOffset();
        if (j2 >= 0) {
            this.mainInventory[j2] = ItemStack.copyItemStack(itemstack);
            this.mainInventory[j2].animationsToGo = 5;
            itemstack.stackSize = 0;
            return true;
        }
        return false;
    }

    @Override
    public ItemStack decrStackSize(int i2, int j2) {
        ItemStack[] aitemstack = this.mainInventory;
        if (i2 >= this.mainInventory.length) {
            aitemstack = this.armorInventory;
            i2 -= this.mainInventory.length;
        }
        if (aitemstack[i2] != null) {
            if (aitemstack[i2].stackSize <= j2) {
                ItemStack itemstack = aitemstack[i2];
                aitemstack[i2] = null;
                return itemstack;
            }
            ItemStack itemstack1 = aitemstack[i2].splitStack(j2);
            if (aitemstack[i2].stackSize == 0) {
                aitemstack[i2] = null;
            }
            return itemstack1;
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(int i2, ItemStack itemstack) {
        ItemStack[] aitemstack = this.mainInventory;
        if (i2 >= aitemstack.length) {
            i2 -= aitemstack.length;
            aitemstack = this.armorInventory;
        }
        aitemstack[i2] = itemstack;
    }

    public float getStrVsBlock(Block block) {
        float f2 = 1.0f;
        if (this.mainInventory[this.currentItem] != null) {
            f2 *= this.mainInventory[this.currentItem].getStrVsBlock(block);
        }
        return f2;
    }

    public NBTTagList writeToNBT(NBTTagList nbttaglist) {
        for (int i2 = 0; i2 < this.mainInventory.length; ++i2) {
            if (this.mainInventory[i2] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.setByte("Slot", (byte)i2);
            this.mainInventory[i2].writeToNBT(nbttagcompound);
            nbttaglist.setTag(nbttagcompound);
        }
        for (int j2 = 0; j2 < this.armorInventory.length; ++j2) {
            if (this.armorInventory[j2] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.setByte("Slot", (byte)(j2 + 100));
            this.armorInventory[j2].writeToNBT(nbttagcompound1);
            nbttaglist.setTag(nbttagcompound1);
        }
        return nbttaglist;
    }

    public void readFromNBT(NBTTagList nbttaglist) {
        this.mainInventory = new ItemStack[36];
        this.armorInventory = new ItemStack[4];
        for (int i2 = 0; i2 < nbttaglist.tagCount(); ++i2) {
            NBTTagCompound nbttagcompound = (NBTTagCompound)nbttaglist.tagAt(i2);
            int j2 = nbttagcompound.getByte("Slot") & 0xFF;
            ItemStack itemstack = new ItemStack(nbttagcompound);
            if (itemstack.getItem() == null) continue;
            if (j2 >= 0 && j2 < this.mainInventory.length) {
                this.mainInventory[j2] = itemstack;
            }
            if (j2 < 100 || j2 >= this.armorInventory.length + 100) continue;
            this.armorInventory[j2 - 100] = itemstack;
        }
    }

    @Override
    public int getSizeInventory() {
        return this.mainInventory.length + 4;
    }

    @Override
    public ItemStack getStackInSlot(int i2) {
        ItemStack[] aitemstack = this.mainInventory;
        if (i2 >= aitemstack.length) {
            i2 -= aitemstack.length;
            aitemstack = this.armorInventory;
        }
        return aitemstack[i2];
    }

    @Override
    public String getInvName() {
        return "Inventory";
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    public int getDamageVsEntity(Entity entity) {
        ItemStack itemstack = this.getStackInSlot(this.currentItem);
        if (itemstack != null) {
            return itemstack.getDamageVsEntity(entity);
        }
        return 1;
    }

    public boolean canHarvestBlock(Block block) {
        if (block.blockMaterial.getIsHarvestable()) {
            return true;
        }
        ItemStack itemstack = this.getStackInSlot(this.currentItem);
        if (itemstack != null) {
            return itemstack.canHarvestBlock(block);
        }
        return false;
    }

    public ItemStack armorItemInSlot(int i2) {
        return this.armorInventory[i2];
    }

    public int getTotalArmourPoints() {
        float armorDurability = 0.0f;
        float maxDurability = 0.0f;
        for (int armorPiece = 0; armorPiece < this.armorInventory.length; ++armorPiece) {
            ItemStack itemStack = this.armorInventory[armorPiece];
            if (itemStack == null || !(itemStack.getItem() instanceof ItemArmor)) continue;
            ItemArmor armor = (ItemArmor)itemStack.getItem();
            maxDurability += (float)armor.getMaxDamage();
            armorDurability += (float)(armor.getMaxDamage() - itemStack.getMetadata());
        }
        return (int)(20.0f * (armorDurability / maxDurability));
    }

    public float getTotalProtectionAmount(DamageType damageType) {
        float protectionPercentage = 0.0f;
        for (int i2 = 0; i2 < this.armorInventory.length; ++i2) {
            if (this.armorInventory[i2] == null || !(this.armorInventory[i2].getItem() instanceof ItemArmor)) continue;
            ItemArmor armor = (ItemArmor)this.armorInventory[i2].getItem();
            protectionPercentage += armor.material.getProtection(damageType) * armor.getArmorPieceProtectionPercentage();
        }
        return protectionPercentage;
    }

    public void damageArmor(int damage) {
        for (int j2 = 0; j2 < this.armorInventory.length; ++j2) {
            if (this.armorInventory[j2] == null || !(this.armorInventory[j2].getItem() instanceof ItemArmor)) continue;
            this.armorInventory[j2].damageItem(damage, this.player);
            if (this.armorInventory[j2].stackSize != 0) continue;
            this.armorInventory[j2].func_1097_a(this.player);
            this.armorInventory[j2] = null;
        }
    }

    public void damageArmor(int damage, int armorSlot) {
        if (this.armorInventory[armorSlot] == null) {
            return;
        }
        this.armorInventory[armorSlot].damageItem(damage, this.player);
        if (this.armorInventory[armorSlot].stackSize == 0) {
            this.armorInventory[armorSlot].func_1097_a(this.player);
            this.armorInventory[armorSlot] = null;
        }
    }

    public void dropAllItems() {
        for (int i2 = 0; i2 < this.mainInventory.length; ++i2) {
            if (this.mainInventory[i2] == null) continue;
            this.player.dropPlayerItemWithRandomChoice(this.mainInventory[i2], true);
            this.mainInventory[i2] = null;
        }
        for (int j2 = 0; j2 < this.armorInventory.length; ++j2) {
            if (this.armorInventory[j2] == null) continue;
            this.player.dropPlayerItemWithRandomChoice(this.armorInventory[j2], true);
            this.armorInventory[j2] = null;
        }
    }

    @Override
    public void onInventoryChanged() {
        this.inventoryChanged = true;
    }

    public void setHeldItemStack(ItemStack itemstack) {
        this.heldItem = itemstack;
        if (itemstack != null && itemstack.stackSize == 0) {
            this.heldItem = null;
        }
        this.player.onItemStackChanged(itemstack);
    }

    public ItemStack getHeldItemStack() {
        return this.heldItem;
    }

    @Override
    public boolean canInteractWith(EntityPlayer entityplayer) {
        if (this.player.isDead) {
            return false;
        }
        return entityplayer.getDistanceSqToEntity(this.player) <= 64.0;
    }

    public boolean func_28018_c(ItemStack itemstack) {
        for (int i2 = 0; i2 < this.armorInventory.length; ++i2) {
            if (this.armorInventory[i2] == null || !this.armorInventory[i2].isStackEqual(itemstack)) continue;
            return true;
        }
        for (int j2 = 0; j2 < this.mainInventory.length; ++j2) {
            if (this.mainInventory[j2] == null || !this.mainInventory[j2].isStackEqual(itemstack)) continue;
            return true;
        }
        return false;
    }
}

