/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Item;
import net.minecraft.src.material.ArmorMaterial;

public class ItemArmor
extends Item {
    public static final int[] armorPieceProtectionValues = new int[]{3, 8, 6, 3};
    private static final float[] armorPieceDurabilityModifiers = new float[]{0.91f, 1.0f, 0.97f, 0.94f};
    public final ArmorMaterial material;
    public final int armorPiece;

    public ItemArmor(int id2, ArmorMaterial material, int armorPiece) {
        super(id2);
        this.material = material;
        this.armorPiece = armorPiece;
        this.setMaxDamage((int)(armorPieceDurabilityModifiers[armorPiece] * (float)material.durability));
        this.maxStackSize = 1;
    }

    public int armorPieceProtection() {
        return armorPieceProtectionValues[this.armorPiece];
    }

    public float getArmorPieceProtectionPercentage() {
        return (float)this.armorPieceProtection() / 20.0f;
    }
}

