/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.shared.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.World;
import net.minecraft.src.helper.Direction;

public class ItemBlock
extends Item {
    protected int blockID;

    public ItemBlock(int i2) {
        super(i2);
        this.blockID = i2 + Block.blocksList.length;
        this.setIconIndex(Block.blocksList[i2 + Block.blocksList.length].getBlockTextureFromSide(2));
    }

    @Override
    public int getColorFromDamage(int i2) {
        Block block = Block.blocksList[this.blockID];
        int colour = block.getRenderColor(i2);
        return colour;
    }

    @Override
    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int x2, int y2, int z2, int side, double heightPlaced) {
        Direction dir = Direction.UP;
        if (Block.blocksList[world.getBlockId(x2, y2, z2)] != null && Block.blocksList[world.getBlockId((int)x2, (int)y2, (int)z2)].placeOverwrites) {
            side = 1;
        } else {
            if (side == 0) {
                --y2;
                dir = Direction.UP;
            }
            if (side == 1) {
                ++y2;
                dir = Direction.DOWN;
            }
            if (side == 2) {
                --z2;
                dir = Direction.NORTH;
            }
            if (side == 3) {
                ++z2;
                dir = Direction.SOUTH;
            }
            if (side == 4) {
                --x2;
                dir = Direction.WEST;
            }
            if (side == 5) {
                ++x2;
                dir = Direction.EAST;
            }
        }
        if (itemstack.stackSize == 0) {
            return false;
        }
        if (y2 == Minecraft.WORLD_HEIGHT_BLOCKS - 1 && Block.blocksList[this.blockID].blockMaterial.isSolid()) {
            return false;
        }
        if (world.canBlockBePlacedAt(this.blockID, x2, y2, z2, false, side) && itemstack.consumeItem(entityplayer)) {
            Block block = Block.blocksList[this.blockID];
            if (world.setBlockAndMetadataWithNotify(x2, y2, z2, this.blockID, this.getPlacedBlockMetadata(itemstack.getMetadata()))) {
                Block.blocksList[this.blockID].onBlockPlaced(world, x2, y2, z2, dir, entityplayer, heightPlaced);
                world.playSoundEffect((float)x2 + 0.5f, (float)y2 + 0.5f, (float)z2 + 0.5f, block.stepSound.func_1145_d(), (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getItemNameIS(ItemStack itemstack) {
        return Block.blocksList[this.blockID].getBlockName(itemstack.getMetadata());
    }

    @Override
    public String getItemName() {
        return Block.blocksList[this.blockID].getBlockName(0);
    }
}

