/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.shared.Minecraft;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockLayerBase;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemStack;
import net.minecraft.src.World;

public class ItemBlockLayer
extends ItemBlock {
    public ItemBlockLayer(int i2) {
        super(i2);
    }

    @Override
    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int i2, int j2, int k2, int l2, double heightPlaced) {
        int id2 = world.getBlockId(i2, j2, k2);
        int meta = world.getBlockMetadata(i2, j2, k2);
        if (id2 != this.blockID && Block.blocksList[id2] != null && Block.blocksList[id2].placeOverwrites) {
            id2 = 0;
            meta = 0;
        }
        if (itemstack.stackSize == 0) {
            return false;
        }
        if (j2 == Minecraft.WORLD_HEIGHT_BLOCKS - 1 && Block.blocksList[this.blockID].blockMaterial.isSolid()) {
            return false;
        }
        if (id2 == this.blockID && l2 == 1) {
            BlockLayerBase blockLayer = (BlockLayerBase)Block.blocksList[this.blockID];
            int newMeta = meta + 1;
            AxisAlignedBB bbBox = AxisAlignedBB.getBoundingBoxFromPool(i2, j2, k2, (float)i2 + 1.0f, (float)j2 + (float)(2 * (newMeta + 1)) / 16.0f, (float)k2 + 1.0f);
            if (!world.checkIfAABBIsClear(bbBox)) {
                return false;
            }
            if (newMeta < 7) {
                world.setBlockAndMetadataWithNotify(i2, j2, k2, this.blockID, newMeta);
            } else if (blockLayer.fullBlockID != -1) {
                world.setBlockAndMetadataWithNotify(i2, j2, k2, blockLayer.fullBlockID, 0);
            } else {
                world.setBlockAndMetadataWithNotify(i2, j2 + 1, k2, this.blockID, 0);
            }
            world.playSoundEffect((float)i2 + 0.5f, (float)j2 + 0.5f, (float)k2 + 0.5f, blockLayer.stepSound.func_1145_d(), (blockLayer.stepSound.getVolume() + 1.0f) / 2.0f, blockLayer.stepSound.getPitch() * 0.8f);
            itemstack.consumeItem(entityplayer);
            return true;
        }
        if (id2 != 0) {
            if (l2 == 0) {
                --j2;
            }
            if (l2 == 1) {
                ++j2;
            }
            if (l2 == 2) {
                --k2;
            }
            if (l2 == 3) {
                ++k2;
            }
            if (l2 == 4) {
                --i2;
            }
            if (l2 == 5) {
                ++i2;
            }
            id2 = world.getBlockId(i2, j2, k2);
            meta = world.getBlockMetadata(i2, j2, k2);
        }
        if (id2 == this.blockID) {
            BlockLayerBase blockLayer = (BlockLayerBase)Block.blocksList[this.blockID];
            int newMeta = meta + 1;
            AxisAlignedBB bbBox = AxisAlignedBB.getBoundingBoxFromPool(i2, j2, k2, (float)i2 + 1.0f, (float)j2 + (float)(2 * (newMeta + 1)) / 16.0f, (float)k2 + 1.0f);
            if (!world.checkIfAABBIsClear(bbBox)) {
                return false;
            }
            if (newMeta < 7) {
                world.setBlockAndMetadataWithNotify(i2, j2, k2, this.blockID, newMeta);
            } else if (blockLayer.fullBlockID != -1) {
                world.setBlockAndMetadataWithNotify(i2, j2, k2, blockLayer.fullBlockID, 0);
            } else {
                world.setBlockAndMetadataWithNotify(i2, j2 + 1, k2, this.blockID, 0);
            }
            world.playSoundEffect((float)i2 + 0.5f, (float)j2 + 0.5f, (float)k2 + 0.5f, blockLayer.stepSound.func_1145_d(), (blockLayer.stepSound.getVolume() + 1.0f) / 2.0f, blockLayer.stepSound.getPitch() * 0.8f);
            itemstack.consumeItem(entityplayer);
            return true;
        }
        if (world.canBlockBePlacedAt(this.blockID, i2, j2, k2, false, l2)) {
            Block block = Block.blocksList[this.blockID];
            if (world.setBlockAndMetadataWithNotify(i2, j2, k2, this.blockID, this.getPlacedBlockMetadata(itemstack.getMetadata()))) {
                Block.blocksList[this.blockID].onBlockPlaced(world, i2, j2, k2, null, entityplayer, heightPlaced);
                world.playSoundEffect((float)i2 + 0.5f, (float)j2 + 0.5f, (float)k2 + 0.5f, block.stepSound.func_1145_d(), (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
                itemstack.consumeItem(entityplayer);
            }
            return true;
        }
        return false;
    }
}

