/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class ItemDoor
extends Item {
    private Material doorMaterial;

    public ItemDoor(int i2, Material material) {
        super(i2);
        this.doorMaterial = material;
        this.maxStackSize = 64;
    }

    @Override
    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int x2, int y2, int z2, int l2, double heightPlaced) {
        Block doorBlockTop;
        Block doorBlockBottom;
        if (l2 != 1) {
            return false;
        }
        ++y2;
        if (this.doorMaterial == Material.wood) {
            doorBlockBottom = Block.doorPlanksOakBottom;
            doorBlockTop = Block.doorPlanksOakTop;
        } else {
            doorBlockBottom = Block.doorIronBottom;
            doorBlockTop = Block.doorIronTop;
        }
        if (!doorBlockBottom.canPlaceBlockAt(world, x2, y2, z2)) {
            return false;
        }
        int direction = entityplayer.getHorizontalPlacementDirection(null).rotate(1).getIndex();
        int xOffset = 0;
        int zOffset = 0;
        if (direction == 0) {
            zOffset = 1;
        }
        if (direction == 1) {
            xOffset = -1;
        }
        if (direction == 2) {
            zOffset = -1;
        }
        if (direction == 3) {
            xOffset = 1;
        }
        int isSolidBlockLeft = (world.isBlockNormalCube(x2 - xOffset, y2, z2 - zOffset) ? 1 : 0) + (world.isBlockNormalCube(x2 - xOffset, y2 + 1, z2 - zOffset) ? 1 : 0);
        int isSolidBlockRight = (world.isBlockNormalCube(x2 + xOffset, y2, z2 + zOffset) ? 1 : 0) + (world.isBlockNormalCube(x2 + xOffset, y2 + 1, z2 + zOffset) ? 1 : 0);
        boolean isDoorLeft = world.getBlockId(x2 - xOffset, y2, z2 - zOffset) == doorBlockBottom.blockID || world.getBlockId(x2 - xOffset, y2 + 1, z2 - zOffset) == doorBlockTop.blockID;
        boolean isDoorRight = world.getBlockId(x2 + xOffset, y2, z2 + zOffset) == doorBlockBottom.blockID || world.getBlockId(x2 + xOffset, y2 + 1, z2 + zOffset) == doorBlockTop.blockID;
        boolean isMirrored = false;
        if (isDoorLeft && !isDoorRight) {
            isMirrored = true;
        } else if (isSolidBlockRight > isSolidBlockLeft) {
            isMirrored = true;
        }
        if (isMirrored) {
            direction = direction - 1 & 3;
            direction += 4;
            direction |= 8;
        }
        world.editingBlocks = true;
        world.setBlockAndMetadataWithNotify(x2, y2, z2, doorBlockBottom.blockID, direction);
        world.setBlockAndMetadataWithNotify(x2, y2 + 1, z2, doorBlockTop.blockID, direction);
        world.editingBlocks = false;
        world.notifyBlocksOfNeighborChange(x2, y2, z2, doorBlockBottom.blockID);
        world.notifyBlocksOfNeighborChange(x2, y2 + 1, z2, doorBlockTop.blockID);
        world.playSoundEffect((float)x2 + 0.5f, (float)y2 + 0.5f, (float)z2 + 0.5f, doorBlockBottom.stepSound.func_1145_d(), (doorBlockBottom.stepSound.getVolume() + 1.0f) / 2.0f, doorBlockBottom.stepSound.getPitch() * 0.8f);
        itemstack.consumeItem(entityplayer);
        return true;
    }
}

