/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityPlayerMP;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Packet53BlockChange;
import net.minecraft.src.World;
import net.minecraft.src.WorldServer;

public class ItemInWorldManager {
    private WorldServer thisWorld;
    public EntityPlayer thisPlayer;
    private float field_672_d = 0.0f;
    private int field_22055_d;
    private int field_22054_g;
    private int field_22053_h;
    private int field_22052_i;
    private int field_22051_j;
    private boolean field_22050_k;
    private int field_22049_l;
    private int field_22048_m;
    private int field_22047_n;
    private int field_22046_o;

    public ItemInWorldManager(WorldServer worldserver) {
        this.thisWorld = worldserver;
    }

    public void func_328_a() {
        ++this.field_22051_j;
        if (this.field_22050_k) {
            int i2 = this.field_22051_j - this.field_22046_o;
            int j2 = this.thisWorld.getBlockId(this.field_22049_l, this.field_22048_m, this.field_22047_n);
            if (j2 != 0) {
                Block block = Block.blocksList[j2];
                float f2 = block.blockStrength(this.thisPlayer) * (float)(i2 + 1);
                if (f2 >= 1.0f) {
                    this.field_22050_k = false;
                    this.func_325_c(this.field_22049_l, this.field_22048_m, this.field_22047_n);
                }
            } else {
                this.field_22050_k = false;
            }
        }
    }

    public void func_324_a(int i2, int j2, int k2, int l2) {
        this.thisWorld.onBlockHit(null, i2, j2, k2, l2);
        if (!this.thisPlayer.getGamemode().doBlockBreakingAnim) {
            this.func_325_c(i2, j2, k2);
            return;
        }
        this.field_22055_d = this.field_22051_j;
        int i1 = this.thisWorld.getBlockId(i2, j2, k2);
        if (i1 > 0) {
            Block.blocksList[i1].onBlockClicked(this.thisWorld, i2, j2, k2, this.thisPlayer);
        }
        if (i1 > 0 && Block.blocksList[i1].blockStrength(this.thisPlayer) >= 1.0f) {
            this.func_325_c(i2, j2, k2);
        } else {
            this.field_22054_g = i2;
            this.field_22053_h = j2;
            this.field_22052_i = k2;
        }
    }

    public void func_22045_b(int i2, int j2, int k2) {
        if (i2 == this.field_22054_g && j2 == this.field_22053_h && k2 == this.field_22052_i) {
            int l2 = this.field_22051_j - this.field_22055_d;
            int i1 = this.thisWorld.getBlockId(i2, j2, k2);
            if (i1 != 0) {
                Block block = Block.blocksList[i1];
                float f2 = block.blockStrength(this.thisPlayer) * (float)(l2 + 1);
                if (f2 >= 0.7f) {
                    this.func_325_c(i2, j2, k2);
                } else if (!this.field_22050_k) {
                    this.field_22050_k = true;
                    this.field_22049_l = i2;
                    this.field_22048_m = j2;
                    this.field_22047_n = k2;
                    this.field_22046_o = this.field_22055_d;
                }
            }
        }
        this.field_672_d = 0.0f;
    }

    public boolean removeBlock(int i2, int j2, int k2) {
        Block block = Block.blocksList[this.thisWorld.getBlockId(i2, j2, k2)];
        int l2 = this.thisWorld.getBlockMetadata(i2, j2, k2);
        boolean flag = this.thisWorld.setBlockWithNotify(i2, j2, k2, 0);
        if (block != null && flag) {
            block.onBlockDestroyedByPlayer(this.thisWorld, i2, j2, k2, l2);
        }
        return flag;
    }

    public boolean func_325_c(int x2, int y2, int z2) {
        ItemStack itemstack;
        int id2 = this.thisWorld.getBlockId(x2, y2, z2);
        int meta = this.thisWorld.getBlockMetadata(x2, y2, z2);
        this.thisWorld.playSoundEffectForPlayer(this.thisPlayer, 2001, x2, y2, z2, id2);
        boolean flag = this.removeBlock(x2, y2, z2);
        if (flag && this.thisPlayer.canHarvestBlock(Block.blocksList[id2]) && this.thisPlayer.getGamemode().dropBlockOnBreak) {
            Block.blocksList[id2].harvestBlock(this.thisWorld, this.thisPlayer, x2, y2, z2, meta);
            ((EntityPlayerMP)this.thisPlayer).playerNetServerHandler.sendPacket(new Packet53BlockChange(x2, y2, z2, this.thisWorld));
        }
        if ((itemstack = this.thisPlayer.getCurrentEquippedItem()) != null) {
            itemstack.onDestroyBlock(id2, x2, y2, z2, this.thisPlayer);
            if (itemstack.stackSize == 0) {
                itemstack.func_1097_a(this.thisPlayer);
                this.thisPlayer.destroyCurrentEquippedItem();
            }
        }
        return flag;
    }

    public boolean func_6154_a(EntityPlayer entityplayer, World world, ItemStack itemstack) {
        int i2 = itemstack.stackSize;
        ItemStack itemstack1 = itemstack.useItemRightClick(world, entityplayer);
        if (itemstack1 != itemstack || itemstack1 != null && itemstack1.stackSize != i2) {
            entityplayer.inventory.mainInventory[entityplayer.inventory.currentItem] = itemstack1;
            if (itemstack1.stackSize == 0) {
                entityplayer.inventory.mainInventory[entityplayer.inventory.currentItem] = null;
            }
            return true;
        }
        return false;
    }

    public boolean activeBlockOrUseItem(EntityPlayer entityplayer, World world, ItemStack itemstack, int i2, int j2, int k2, int l2, double heightPlaced) {
        int i1 = world.getBlockId(i2, j2, k2);
        if ((entityplayer.isSneaking() && entityplayer.getCurrentEquippedItem() == null || !entityplayer.isSneaking()) && i1 > 0 && Block.blocksList[i1].blockActivated(world, i2, j2, k2, entityplayer)) {
            return true;
        }
        if (itemstack == null) {
            return false;
        }
        return itemstack.useItem(entityplayer, world, i2, j2, k2, l2, heightPlaced);
    }
}

