/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.ChunkConverter;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.StatList;
import net.minecraft.src.World;

public final class ItemStack {
    public int stackSize;
    public int animationsToGo;
    public int itemID;
    private int metadata;
    public NBTTagCompound tag;

    public ItemStack(Block block) {
        this(block, 1);
    }

    public ItemStack(Block block, int stackSize) {
        this(block.blockID, stackSize, 0);
    }

    public ItemStack(Block block, int stackSize, int metadata) {
        this(block.blockID, stackSize, metadata);
    }

    public ItemStack(Block block, int stackSize, int metadata, NBTTagCompound tag) {
        this(block.blockID, stackSize, metadata, tag);
    }

    public ItemStack(Item item) {
        this(item.itemID, 1, 0);
    }

    public ItemStack(Item item, int stackSize) {
        this(item.itemID, stackSize, 0);
    }

    public ItemStack(Item item, int stackSize, int metadata) {
        this(item.itemID, stackSize, metadata);
    }

    public ItemStack(Item item, int stackSize, int metadata, NBTTagCompound tag) {
        this(item.itemID, stackSize, metadata, tag);
    }

    public ItemStack(int itemID, int stackSize, int metadata) {
        this(itemID, stackSize, metadata, Item.itemsList[itemID].getDefaultTag());
    }

    public ItemStack(ItemStack itemStack) {
        this.itemID = itemStack.itemID;
        this.metadata = itemStack.metadata;
        this.stackSize = itemStack.stackSize;
        this.tag = new NBTTagCompound(itemStack.tag);
    }

    public ItemStack(int itemID, int stackSize, int metadata, NBTTagCompound tag) {
        this.itemID = itemID;
        this.stackSize = stackSize;
        this.metadata = metadata;
        this.tag = tag;
    }

    public ItemStack(NBTTagCompound nbttagcompound) {
        this.stackSize = 0;
        this.readFromNBT(nbttagcompound);
    }

    public ItemStack splitStack(int i2) {
        ItemStack itemStack = new ItemStack(this);
        itemStack.stackSize = i2;
        this.stackSize -= i2;
        return itemStack;
    }

    public Item getItem() {
        return Item.itemsList[this.itemID];
    }

    public int getIconIndex() {
        return this.getItem().getIconIndex(this);
    }

    public boolean useItem(EntityPlayer entityplayer, World world, int i2, int j2, int k2, int l2, double heightPlaced) {
        boolean flag = this.getItem().onItemUse(this, entityplayer, world, i2, j2, k2, l2, heightPlaced);
        if (flag) {
            entityplayer.addStat(StatList.usedItemStats[this.itemID], 1);
        }
        return flag;
    }

    public float getStrVsBlock(Block block) {
        return this.getItem().getStrVsBlock(this, block);
    }

    public ItemStack useItemRightClick(World world, EntityPlayer entityplayer) {
        return this.getItem().onItemRightClick(this, world, entityplayer);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setShort("id", (short)this.itemID);
        nbttagcompound.setByte("Count", (byte)this.stackSize);
        nbttagcompound.setShort("Damage", (short)this.metadata);
        nbttagcompound.setByte("Expanded", (byte)1);
        nbttagcompound.setInteger("Version", 19133);
        nbttagcompound.setCompoundTag("Data", this.tag);
        return nbttagcompound;
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.itemID = nbttagcompound.getShort("id");
        this.stackSize = nbttagcompound.getByte("Count");
        this.metadata = nbttagcompound.getShort("Damage");
        byte expanded = nbttagcompound.getByte("Expanded");
        int version = nbttagcompound.getInteger("Version");
        if (expanded == 0 && this.itemID >= 256) {
            this.itemID += Block.blocksList.length - 256;
        }
        if (version != 19133 && this.itemID < Block.blocksList.length) {
            short[] id2 = new short[]{(short)this.itemID};
            byte[] meta = new byte[]{(byte)this.metadata};
            ChunkConverter.converters[0].convertBlocksAndMetadata(id2, meta);
            this.itemID = id2[0];
            this.metadata = meta[0];
        }
        this.tag = nbttagcompound.getCompoundTag("Data");
        if (this.tag == null) {
            this.tag = Item.itemsList[this.itemID].getDefaultTag();
        }
        if (!this.tag.hasKey("color")) {
            this.tag.setByte("color", (byte)15);
        }
        if (!this.tag.hasKey("name")) {
            this.tag.setString("name", "");
        }
    }

    public int getMaxStackSize() {
        return this.getItem().getItemStackLimit();
    }

    public boolean isStackable() {
        return this.getMaxStackSize() > 1 && (!this.isItemStackDamageable() || !this.isItemDamaged());
    }

    public boolean isItemStackDamageable() {
        return Item.itemsList[this.itemID].getMaxDamage() > 0;
    }

    @Deprecated
    public boolean getHasSubtypes() {
        return Item.itemsList[this.itemID].getHasSubtypes();
    }

    public boolean isItemDamaged() {
        return this.isItemStackDamageable() && this.metadata > 0;
    }

    public int getItemDamageForDisplay() {
        return this.metadata;
    }

    public int getMetadata() {
        return this.metadata;
    }

    public void setMetadata(int i2) {
        this.metadata = i2;
    }

    public int getMaxDamage() {
        return Item.itemsList[this.itemID].getMaxDamage();
    }

    public void damageItem(int i2, Entity entity) {
        if (entity instanceof EntityPlayer && !((EntityPlayer)entity).getGamemode().toolDurability) {
            return;
        }
        if (!this.isItemStackDamageable()) {
            return;
        }
        this.metadata += i2;
        if (this.metadata > this.getMaxDamage()) {
            if (entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).addStat(StatList.breakItemStats[this.itemID], 1);
            }
            --this.stackSize;
            if (this.stackSize < 0) {
                this.stackSize = 0;
            }
            this.metadata = 0;
        }
    }

    public void repairItem(int i2) {
        if (!this.isItemStackDamageable()) {
            return;
        }
        if (this.metadata > this.getMaxDamage()) {
            return;
        }
        this.metadata += i2;
    }

    public void hitEntity(EntityLiving entityliving, EntityPlayer entityplayer) {
        boolean flag = Item.itemsList[this.itemID].hitEntity(this, entityliving, entityplayer);
        if (flag) {
            entityplayer.addStat(StatList.usedItemStats[this.itemID], 1);
        }
    }

    public void onDestroyBlock(int id2, int x2, int y2, int z2, EntityPlayer entityplayer) {
        boolean flag = Item.itemsList[this.itemID].onBlockDestroyed(this, id2, x2, y2, z2, entityplayer);
        if (flag) {
            entityplayer.addStat(StatList.usedItemStats[this.itemID], 1);
        }
    }

    public boolean consumeItem(EntityPlayer entityplayer) {
        if (this.stackSize <= 0) {
            return false;
        }
        if (entityplayer.getGamemode().consumeBlocks) {
            --this.stackSize;
        }
        return true;
    }

    public int getDamageVsEntity(Entity entity) {
        return Item.itemsList[this.itemID].getDamageVsEntity(entity);
    }

    public boolean canHarvestBlock(Block block) {
        return Item.itemsList[this.itemID].canHarvestBlock(block);
    }

    public void func_1097_a(EntityPlayer entityplayer) {
    }

    public boolean useItemOnEntity(EntityLiving entityliving, EntityPlayer entityPlayer) {
        return Item.itemsList[this.itemID].useItemOnEntity(this, entityliving, entityPlayer);
    }

    public ItemStack copy() {
        return new ItemStack(this.itemID, this.stackSize, this.metadata, new NBTTagCompound(this.tag));
    }

    public static boolean areItemStacksEqual(ItemStack itemstack, ItemStack itemstack1) {
        if (itemstack == null && itemstack1 == null) {
            return true;
        }
        if (itemstack == null || itemstack1 == null) {
            return false;
        }
        return itemstack.isItemStackEqual(itemstack1);
    }

    private boolean isItemStackEqual(ItemStack itemstack) {
        if (this.stackSize != itemstack.stackSize) {
            return false;
        }
        if (this.itemID != itemstack.itemID) {
            return false;
        }
        return this.metadata == itemstack.metadata;
    }

    public boolean isItemEqual(ItemStack itemstack) {
        return this.itemID == itemstack.itemID && this.metadata == itemstack.metadata;
    }

    public String getItemName() {
        return Item.itemsList[this.itemID].getItemNameIS(this);
    }

    public static ItemStack copyItemStack(ItemStack itemstack) {
        return itemstack != null ? itemstack.copy() : null;
    }

    public String toString() {
        return this.stackSize + " * " + Item.itemsList[this.itemID].getItemName() + ":" + this.metadata;
    }

    public void updateAnimation(World world, Entity entity, int i2, boolean flag) {
        if (this.animationsToGo > 0) {
            --this.animationsToGo;
        }
        Item.itemsList[this.itemID].onUpdate(this, world, entity, i2, flag);
    }

    public void onCrafting(World world, EntityPlayer entityplayer) {
        entityplayer.addStat(StatList.craftedItemStats[this.itemID], this.stackSize);
        Item.itemsList[this.itemID].onCreated(this, world, entityplayer);
    }

    public boolean isStackEqual(ItemStack itemstack) {
        return this.itemID == itemstack.itemID && this.stackSize == itemstack.stackSize && this.metadata == itemstack.metadata;
    }

    public boolean canStackWith(ItemStack itemStack) {
        if (itemStack == null) {
            return true;
        }
        return this.itemID == itemStack.itemID && this.metadata == itemStack.metadata;
    }

    public boolean canItemBeRenamed() {
        return this.getMaxStackSize() == 1 && this.isItemStackDamageable();
    }
}

