/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.material.ToolMaterial;

public class ItemTool
extends Item {
    private Material[] materialsEffectiveAgainst;
    private int damageVsEntity;
    protected ToolMaterial material;

    protected ItemTool(int i2, int j2, ToolMaterial toolMaterial, Material[] materialsEffectiveAgainst) {
        super(i2);
        this.material = toolMaterial;
        this.materialsEffectiveAgainst = materialsEffectiveAgainst;
        this.maxStackSize = 1;
        this.setMaxDamage(toolMaterial.getDurability());
        this.damageVsEntity = j2 + toolMaterial.getDamage();
    }

    @Override
    public float getStrVsBlock(ItemStack itemstack, Block block) {
        for (int i2 = 0; i2 < this.materialsEffectiveAgainst.length; ++i2) {
            if (block.blockMaterial != this.materialsEffectiveAgainst[i2]) continue;
            return this.material.getEfficiency(false);
        }
        return 1.0f;
    }

    @Override
    public boolean hitEntity(ItemStack itemstack, EntityLiving entityliving, EntityLiving entityliving1) {
        itemstack.damageItem(2, entityliving1);
        return true;
    }

    @Override
    public boolean onBlockDestroyed(ItemStack itemstack, int i2, int j2, int k2, int l2, EntityLiving entityliving) {
        Block block = Block.blocksList[i2];
        if (block != null && block.blockHardness > 0.0f) {
            itemstack.damageItem(1, entityliving);
        }
        return true;
    }

    @Override
    public int getDamageVsEntity(Entity entity) {
        return this.damageVsEntity;
    }

    @Override
    public boolean isFull3D() {
        return true;
    }

    @Override
    public boolean isSilkTouch() {
        return this.material.isSilkTouch();
    }

    @Override
    public int getBlockHitDelay() {
        return this.material.getBlockHitDelay();
    }
}

