/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.World;
import net.minecraft.src.material.ToolMaterial;

public class ItemToolHoe
extends Item {
    private ToolMaterial toolMaterial;

    public ItemToolHoe(int i2, ToolMaterial enumtoolmaterial) {
        super(i2);
        this.maxStackSize = 1;
        this.toolMaterial = enumtoolmaterial;
        this.setMaxDamage(enumtoolmaterial.getDurability());
    }

    @Override
    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int i2, int j2, int k2, int l2, double heightPlaced) {
        int i1 = world.getBlockId(i2, j2, k2);
        int j1 = world.getBlockId(i2, j2 + 1, k2);
        if (l2 != 0 && j1 == 0 && (i1 == Block.grass.blockID || i1 == Block.dirt.blockID || i1 == Block.pathDirt.blockID || i1 == Block.grassRetro.blockID)) {
            Block block = Block.farmlandDirt;
            world.playSoundEffect((float)i2 + 0.5f, (float)j2 + 0.5f, (float)k2 + 0.5f, block.stepSound.func_1145_d(), (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
            if (world.isMultiplayerAndNotHost) {
                return true;
            }
            world.setBlockWithNotify(i2, j2, k2, block.blockID);
            itemstack.damageItem(1, entityplayer);
            return true;
        }
        return false;
    }

    @Override
    public boolean onBlockDestroyed(ItemStack itemstack, int id2, int x2, int y2, int z2, EntityLiving entityliving) {
        if (entityliving != null && !entityliving.worldObj.isMultiplayerAndNotHost && id2 == Block.tallgrass.blockID) {
            if (this.toolMaterial.isSilkTouch()) {
                entityliving.worldObj.dropItem(x2, y2, z2, new ItemStack(Item.itemsList[id2]));
            } else if (entityliving.worldObj.rand.nextInt(5) == 0) {
                entityliving.worldObj.dropItem(x2, y2, z2, new ItemStack(Item.seedsWheat));
            }
            itemstack.damageItem(1, entityliving);
        }
        return super.onBlockDestroyed(itemstack, id2, x2, y2, z2, entityliving);
    }

    @Override
    public boolean isFull3D() {
        return true;
    }
}

