/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.src.Block;
import net.minecraft.src.ItemTool;
import net.minecraft.src.Material;
import net.minecraft.src.material.ToolMaterial;

public class ItemToolPickaxe
extends ItemTool {
    public static Map<Block, Integer> miningLevels = new HashMap<Block, Integer>();
    private static Material[] materialsEffectiveAgainst;

    public ItemToolPickaxe(int i2, ToolMaterial enumtoolmaterial) {
        super(i2, 2, enumtoolmaterial, materialsEffectiveAgainst);
    }

    @Override
    public boolean canHarvestBlock(Block block) {
        if (this.material.isSilkTouch()) {
            return true;
        }
        Integer miningLevel = miningLevels.get(block);
        if (miningLevel != null) {
            return this.material.getMiningLevel() >= miningLevel;
        }
        return block.blockMaterial == Material.rock || block.blockMaterial == Material.moss || block.blockMaterial == Material.iron;
    }

    static {
        miningLevels.put(Block.obsidian, 3);
        miningLevels.put(Block.blockDiamond, 2);
        miningLevels.put(Block.oreDiamondStone, 2);
        miningLevels.put(Block.oreDiamondBasalt, 2);
        miningLevels.put(Block.oreDiamondGranite, 2);
        miningLevels.put(Block.oreDiamondLimestone, 2);
        miningLevels.put(Block.blockGold, 2);
        miningLevels.put(Block.oreGoldStone, 2);
        miningLevels.put(Block.oreGoldBasalt, 2);
        miningLevels.put(Block.oreGoldGranite, 2);
        miningLevels.put(Block.oreGoldLimestone, 2);
        miningLevels.put(Block.blockIron, 1);
        miningLevels.put(Block.oreIronStone, 1);
        miningLevels.put(Block.oreIronBasalt, 1);
        miningLevels.put(Block.oreIronGranite, 1);
        miningLevels.put(Block.oreIronLimestone, 1);
        miningLevels.put(Block.blockSteel, 2);
        miningLevels.put(Block.oreNethercoalNetherrack, 2);
        miningLevels.put(Block.blockLapis, 1);
        miningLevels.put(Block.oreLapisStone, 1);
        miningLevels.put(Block.oreLapisBasalt, 1);
        miningLevels.put(Block.oreLapisGranite, 1);
        miningLevels.put(Block.oreLapisLimestone, 1);
        miningLevels.put(Block.blockRedstone, 2);
        miningLevels.put(Block.oreRedstoneStone, 2);
        miningLevels.put(Block.oreRedstoneBasalt, 2);
        miningLevels.put(Block.oreRedstoneGranite, 2);
        miningLevels.put(Block.oreRedstoneLimestone, 2);
        miningLevels.put(Block.oreRedstoneGlowingStone, 2);
        miningLevels.put(Block.oreRedstoneGlowingBasalt, 2);
        miningLevels.put(Block.oreRedstoneGlowingGranite, 2);
        miningLevels.put(Block.oreRedstoneGlowingLimestone, 2);
        materialsEffectiveAgainst = new Material[]{Material.rock, Material.iron, Material.piston, Material.moss, Material.ice, Material.glass, Material.circuits};
    }
}

