/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.ItemTool;
import net.minecraft.src.Material;
import net.minecraft.src.World;
import net.minecraft.src.material.ToolMaterial;

public class ItemToolShovel
extends ItemTool {
    private static Material[] materialsEffectiveAgainst = new Material[]{Material.grass, Material.ground, Material.sand, Material.snow, Material.builtSnow, Material.clay};

    public ItemToolShovel(int i2, ToolMaterial enumtoolmaterial) {
        super(i2, 1, enumtoolmaterial, materialsEffectiveAgainst);
    }

    @Override
    public boolean canHarvestBlock(Block block) {
        if (block == Block.layerSnow) {
            return true;
        }
        return block == Block.blockSnow;
    }

    @Override
    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int i2, int j2, int k2, int l2, double heightPlaced) {
        int i1 = world.getBlockId(i2, j2, k2);
        int j1 = world.getBlockId(i2, j2 + 1, k2);
        if (l2 != 0 && j1 == 0 && (i1 == Block.grass.blockID || i1 == Block.dirt.blockID || i1 == Block.grassRetro.blockID || i1 == Block.farmlandDirt.blockID)) {
            Block block = Block.pathDirt;
            world.playSoundEffect((float)i2 + 0.5f, (float)j2 + 0.5f, (float)k2 + 0.5f, block.stepSound.func_1145_d(), (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
            if (!world.isMultiplayerAndNotHost) {
                world.setBlockWithNotify(i2, j2, k2, block.blockID);
                itemstack.damageItem(1, entityplayer);
            }
            return true;
        }
        return false;
    }
}

