/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.MCHashEntry;

public class MCHash {
    private transient MCHashEntry[] slots = new MCHashEntry[16];
    private transient int count;
    private int threshold = 12;
    private final float growFactor = 0.75f;
    private volatile transient int versionStamp;

    private static int computeHash(int i2) {
        i2 ^= i2 >>> 20 ^ i2 >>> 12;
        return i2 ^ i2 >>> 7 ^ i2 >>> 4;
    }

    private static int getSlotIndex(int i2, int j2) {
        return i2 & j2 - 1;
    }

    public Object lookup(int i2) {
        int j2 = MCHash.computeHash(i2);
        MCHashEntry mchashentry = this.slots[MCHash.getSlotIndex(j2, this.slots.length)];
        while (mchashentry != null) {
            if (mchashentry.hashEntry == i2) {
                return mchashentry.valueEntry;
            }
            mchashentry = mchashentry.nextEntry;
        }
        return null;
    }

    public boolean containsItem(int i2) {
        return this.lookupEntry(i2) != null;
    }

    final MCHashEntry lookupEntry(int i2) {
        int j2 = MCHash.computeHash(i2);
        MCHashEntry mchashentry = this.slots[MCHash.getSlotIndex(j2, this.slots.length)];
        while (mchashentry != null) {
            if (mchashentry.hashEntry == i2) {
                return mchashentry;
            }
            mchashentry = mchashentry.nextEntry;
        }
        return null;
    }

    public void addKey(int i2, Object obj) {
        int j2 = MCHash.computeHash(i2);
        int k2 = MCHash.getSlotIndex(j2, this.slots.length);
        MCHashEntry mchashentry = this.slots[k2];
        while (mchashentry != null) {
            if (mchashentry.hashEntry == i2) {
                mchashentry.valueEntry = obj;
            }
            mchashentry = mchashentry.nextEntry;
        }
        ++this.versionStamp;
        this.insert(j2, i2, obj, k2);
    }

    private void grow(int i2) {
        MCHashEntry[] amchashentry = this.slots;
        int j2 = amchashentry.length;
        if (j2 == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        MCHashEntry[] amchashentry1 = new MCHashEntry[i2];
        this.copyTo(amchashentry1);
        this.slots = amchashentry1;
        this.threshold = (int)((float)i2 * 0.75f);
    }

    private void copyTo(MCHashEntry[] amchashentry) {
        MCHashEntry[] amchashentry1 = this.slots;
        int i2 = amchashentry.length;
        for (int j2 = 0; j2 < amchashentry1.length; ++j2) {
            MCHashEntry mchashentry1;
            MCHashEntry mchashentry = amchashentry1[j2];
            if (mchashentry == null) continue;
            amchashentry1[j2] = null;
            do {
                mchashentry1 = mchashentry.nextEntry;
                int k2 = MCHash.getSlotIndex(mchashentry.slotHash, i2);
                mchashentry.nextEntry = amchashentry[k2];
                amchashentry[k2] = mchashentry;
            } while ((mchashentry = mchashentry1) != null);
        }
    }

    public Object removeObject(int i2) {
        MCHashEntry mchashentry = this.removeEntry(i2);
        return mchashentry != null ? mchashentry.valueEntry : null;
    }

    final MCHashEntry removeEntry(int i2) {
        MCHashEntry mchashentry;
        int j2 = MCHash.computeHash(i2);
        int k2 = MCHash.getSlotIndex(j2, this.slots.length);
        MCHashEntry mchashentry1 = mchashentry = this.slots[k2];
        while (mchashentry1 != null) {
            MCHashEntry mchashentry2 = mchashentry1.nextEntry;
            if (mchashentry1.hashEntry == i2) {
                ++this.versionStamp;
                --this.count;
                if (mchashentry == mchashentry1) {
                    this.slots[k2] = mchashentry2;
                } else {
                    mchashentry.nextEntry = mchashentry2;
                }
                return mchashentry1;
            }
            mchashentry = mchashentry1;
            mchashentry1 = mchashentry2;
        }
        return mchashentry1;
    }

    public void clearMap() {
        ++this.versionStamp;
        MCHashEntry[] amchashentry = this.slots;
        for (int i2 = 0; i2 < amchashentry.length; ++i2) {
            amchashentry[i2] = null;
        }
        this.count = 0;
    }

    private void insert(int i2, int j2, Object obj, int k2) {
        MCHashEntry mchashentry = this.slots[k2];
        this.slots[k2] = new MCHashEntry(i2, j2, obj, mchashentry);
        if (this.count++ >= this.threshold) {
            this.grow(2 * this.slots.length);
        }
    }

    static int getHash(int i2) {
        return MCHash.computeHash(i2);
    }
}

