/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MapCoord;
import net.minecraft.src.MapDataBase;
import net.minecraft.src.MapInfo;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.World;

public class MapData
extends MapDataBase {
    public int xCenter;
    public int zCenter;
    public byte dimenson;
    public byte scale;
    public byte[] field_28176_f = new byte[16384];
    public int field_28175_g;
    public List field_28174_h = new ArrayList();
    private Map field_28172_j = new HashMap();
    public List field_28173_i = new ArrayList();

    public MapData(String s2) {
        super(s2);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.dimenson = nbttagcompound.getByte("dimension");
        this.xCenter = nbttagcompound.getInteger("xCenter");
        this.zCenter = nbttagcompound.getInteger("zCenter");
        this.scale = nbttagcompound.getByte("scale");
        if (this.scale < 0) {
            this.scale = 0;
        }
        if (this.scale > 4) {
            this.scale = (byte)4;
        }
        int word0 = nbttagcompound.getShort("width");
        int word1 = nbttagcompound.getShort("height");
        if (word0 == 128 && word1 == 128) {
            this.field_28176_f = nbttagcompound.getByteArray("colors");
        } else {
            byte[] abyte0 = nbttagcompound.getByteArray("colors");
            this.field_28176_f = new byte[16384];
            int i2 = (128 - word0) / 2;
            int j2 = (128 - word1) / 2;
            for (int k2 = 0; k2 < word1; ++k2) {
                int l2 = k2 + j2;
                if (l2 < 0 && l2 >= 128) continue;
                for (int i1 = 0; i1 < word0; ++i1) {
                    int j1 = i1 + i2;
                    if (j1 < 0 && j1 >= 128) continue;
                    this.field_28176_f[j1 + l2 * 128] = abyte0[i1 + k2 * word0];
                }
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setByte("dimension", this.dimenson);
        nbttagcompound.setInteger("xCenter", this.xCenter);
        nbttagcompound.setInteger("zCenter", this.zCenter);
        nbttagcompound.setByte("scale", this.scale);
        nbttagcompound.setShort("width", (short)128);
        nbttagcompound.setShort("height", (short)128);
        nbttagcompound.setByteArray("colors", this.field_28176_f);
    }

    public void func_28169_a(EntityPlayer entityplayer, ItemStack itemstack) {
        if (!this.field_28172_j.containsKey(entityplayer)) {
            MapInfo mapinfo = new MapInfo(this, entityplayer);
            this.field_28172_j.put(entityplayer, mapinfo);
            this.field_28174_h.add(mapinfo);
        }
        this.field_28173_i.clear();
        for (int i2 = 0; i2 < this.field_28174_h.size(); ++i2) {
            MapInfo mapinfo1 = (MapInfo)this.field_28174_h.get(i2);
            if (mapinfo1.entityplayerObj.isDead || !mapinfo1.entityplayerObj.inventory.func_28018_c(itemstack)) {
                this.field_28172_j.remove(mapinfo1.entityplayerObj);
                this.field_28174_h.remove(mapinfo1);
                continue;
            }
            float f2 = (float)(mapinfo1.entityplayerObj.posX - (double)this.xCenter) / (float)(1 << this.scale);
            float f1 = (float)(mapinfo1.entityplayerObj.posZ - (double)this.zCenter) / (float)(1 << this.scale);
            int j2 = 64;
            int k2 = 64;
            if (f2 < (float)(-j2) || f1 < (float)(-k2) || f2 > (float)j2 || f1 > (float)k2) continue;
            byte byte0 = 0;
            byte byte1 = (byte)((double)(f2 * 2.0f) + 0.5);
            byte byte2 = (byte)((double)(f1 * 2.0f) + 0.5);
            byte byte3 = (byte)((double)(entityplayer.rotationYaw * 16.0f / 360.0f) + 0.5);
            if (this.dimenson == 1) {
                int l2 = this.field_28175_g / 10;
                byte3 = (byte)(l2 * l2 * 34187121 + l2 * 121 >> 15 & 0xF);
            }
            if (mapinfo1.entityplayerObj.dimension != this.dimenson) continue;
            this.field_28173_i.add(new MapCoord(this, byte0, byte1, byte2, byte3));
        }
    }

    public byte[] func_28171_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        MapInfo mapinfo = (MapInfo)this.field_28172_j.get(entityplayer);
        if (mapinfo == null) {
            return null;
        }
        byte[] abyte0 = mapinfo.func_28118_a(itemstack);
        return abyte0;
    }

    public void func_28170_a(int i2, int j2, int k2) {
        super.markDirty();
        for (int l2 = 0; l2 < this.field_28174_h.size(); ++l2) {
            MapInfo mapinfo = (MapInfo)this.field_28174_h.get(l2);
            if (mapinfo.field_28119_b[i2] < 0 || mapinfo.field_28119_b[i2] > j2) {
                mapinfo.field_28119_b[i2] = j2;
            }
            if (mapinfo.field_28124_c[i2] >= 0 && mapinfo.field_28124_c[i2] >= k2) continue;
            mapinfo.field_28124_c[i2] = k2;
        }
    }

    public void func_28173_a(byte[] abyte0) {
        if (abyte0[0] == 0) {
            int i2 = abyte0[1] & 0xFF;
            int k2 = abyte0[2] & 0xFF;
            for (int l2 = 0; l2 < abyte0.length - 3; ++l2) {
                this.field_28176_f[(l2 + k2) * 128 + i2] = abyte0[l2 + 3];
            }
            this.markDirty();
        } else if (abyte0[0] == 1) {
            this.field_28173_i.clear();
            for (int j2 = 0; j2 < (abyte0.length - 1) / 3; ++j2) {
                byte byte0 = (byte)(abyte0[j2 * 3 + 1] % 16);
                byte byte1 = abyte0[j2 * 3 + 2];
                byte byte2 = abyte0[j2 * 3 + 3];
                byte byte3 = (byte)(abyte0[j2 * 3 + 1] / 16);
                this.field_28173_i.add(new MapCoord(this, byte0, byte1, byte2, byte3));
            }
        }
    }
}

