/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.MapGenBase;
import net.minecraft.src.MathHelper;
import net.minecraft.src.World;

public class MapGenCaves
extends MapGenBase {
    private boolean isAlpha;

    public MapGenCaves(boolean isAlpha) {
        this.isAlpha = isAlpha;
    }

    protected void generateHubRoom(long seed, int baseChunkX, int baseChunkZ, short[] data, double blockX, double blockY, double blockZ) {
        this.generateCave(seed, baseChunkX, baseChunkZ, data, blockX, blockY, blockZ, 1.0f + rand.nextFloat() * 6.0f, 0.0f, 0.0f, -1, -1, 0.5);
    }

    protected void generateCave(long seed, int baseChunkX, int baseChunkZ, short[] data, double blockX, double blockY, double blockZ, float initialRadius, float f1, float f2, int k2, int l2, double heightMod) {
        boolean flag1;
        double chunkMiddleX = baseChunkX * 16 + 8;
        double chunkMiddleZ = baseChunkZ * 16 + 8;
        float f3 = 0.0f;
        float f4 = 0.0f;
        Random random = new Random(seed);
        if (l2 <= 0) {
            int i1 = this.field_1306_a * 16 - 16;
            l2 = i1 - random.nextInt(i1 / 4);
        }
        boolean flag = false;
        if (k2 == -1) {
            k2 = l2 / 2;
            flag = true;
        }
        int j1 = random.nextInt(l2 / 2) + l2 / 4;
        boolean bl2 = flag1 = random.nextInt(6) == 0;
        while (k2 < l2) {
            double d6 = 1.5 + (double)(MathHelper.sin((float)k2 * 3.141593f / (float)l2) * initialRadius * 1.0f);
            double d7 = d6 * heightMod;
            float f5 = MathHelper.cos(f2);
            float f6 = MathHelper.sin(f2);
            blockX += (double)(MathHelper.cos(f1) * f5);
            blockY += (double)f6;
            blockZ += (double)(MathHelper.sin(f1) * f5);
            f2 = flag1 ? (f2 *= 0.92f) : (f2 *= 0.7f);
            f2 += f4 * 0.1f;
            f1 += f3 * 0.1f;
            f4 *= 0.9f;
            f3 *= 0.75f;
            f4 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            f3 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (!flag && k2 == j1 && initialRadius > 1.0f) {
                this.generateCave(random.nextLong(), baseChunkX, baseChunkZ, data, blockX, blockY, blockZ, random.nextFloat() * 0.5f + 0.5f, f1 - 1.570796f, f2 / 3.0f, k2, l2, 1.0);
                this.generateCave(random.nextLong(), baseChunkX, baseChunkZ, data, blockX, blockY, blockZ, random.nextFloat() * 0.5f + 0.5f, f1 + 1.570796f, f2 / 3.0f, k2, l2, 1.0);
                return;
            }
            if (flag || random.nextInt(4) != 0) {
                double d8a = blockX - chunkMiddleX;
                double d9a = blockZ - chunkMiddleZ;
                double d10a = l2 - k2;
                double d11 = initialRadius + 2.0f + 16.0f;
                if (d8a * d8a + d9a * d9a - d10a * d10a > d11 * d11) {
                    return;
                }
                if (!(blockX < chunkMiddleX - 16.0 - d6 * 2.0 || blockZ < chunkMiddleZ - 16.0 - d6 * 2.0 || blockX > chunkMiddleX + 16.0 + d6 * 2.0 || blockZ > chunkMiddleZ + 16.0 + d6 * 2.0)) {
                    int d8 = MathHelper.floor_double(blockX - d6) - baseChunkX * 16 - 1;
                    int k1 = MathHelper.floor_double(blockX + d6) - baseChunkX * 16 + 1;
                    int d9 = MathHelper.floor_double(blockY - d7) - 1;
                    int l1 = MathHelper.floor_double(blockY + d7) + 1;
                    int d10 = MathHelper.floor_double(blockZ - d6) - baseChunkZ * 16 - 1;
                    int i2 = MathHelper.floor_double(blockZ + d6) - baseChunkZ * 16 + 1;
                    if (d8 < 0) {
                        d8 = 0;
                    }
                    if (k1 > 16) {
                        k1 = 16;
                    }
                    if (d9 < 1) {
                        d9 = 1;
                    }
                    if (l1 > Minecraft.WORLD_HEIGHT_BLOCKS - 8) {
                        l1 = Minecraft.WORLD_HEIGHT_BLOCKS - 8;
                    }
                    if (d10 < 0) {
                        d10 = 0;
                    }
                    if (i2 > 16) {
                        i2 = 16;
                    }
                    boolean flag2 = false;
                    for (int j2 = d8; !flag2 && j2 < k1; ++j2) {
                        for (int l22 = d10; !flag2 && l22 < i2; ++l22) {
                            for (int i3 = l1 + 1; !flag2 && i3 >= d9 - 1; --i3) {
                                int j3 = (j2 * 16 + l22) * Minecraft.WORLD_HEIGHT_BLOCKS + i3;
                                if (i3 < 0 || i3 >= Minecraft.WORLD_HEIGHT_BLOCKS) continue;
                                if (data[j3] == Block.fluidWaterFlowing.blockID || data[j3] == Block.fluidWaterStill.blockID) {
                                    flag2 = true;
                                }
                                if (i3 == d9 - 1 || j2 == d8 || j2 == k1 - 1 || l22 == d10 || l22 == i2 - 1) continue;
                                i3 = d9;
                            }
                        }
                    }
                    if (!flag2) {
                        for (int k22 = d8; k22 < k1; ++k22) {
                            double d12 = ((double)(k22 + baseChunkX * 16) + 0.5 - blockX) / d6;
                            for (int k3 = d10; k3 < i2; ++k3) {
                                double d13 = ((double)(k3 + baseChunkZ * 16) + 0.5 - blockZ) / d6;
                                int l3 = (k22 * 16 + k3) * Minecraft.WORLD_HEIGHT_BLOCKS + l1;
                                boolean flag3 = false;
                                if (d12 * d12 + d13 * d13 >= 1.0) continue;
                                for (int i4 = l1 - 1; i4 >= d9; --i4) {
                                    double d14 = ((double)i4 + 0.5 - blockY) / d7;
                                    if (d14 > -0.7 && d12 * d12 + d14 * d14 + d13 * d13 < 1.0) {
                                        short short0 = data[l3];
                                        if (short0 == Block.grass.blockID || short0 == Block.sand.blockID || short0 == Block.dirtScorched.blockID || short0 == Block.grassRetro.blockID) {
                                            flag3 = true;
                                        }
                                        if (short0 == Block.sandstone.blockID || short0 == Block.dirtScorched.blockID || short0 == Block.stone.blockID || short0 == Block.dirt.blockID || short0 == Block.grass.blockID || short0 == Block.granite.blockID || short0 == Block.basalt.blockID || short0 == Block.limestone.blockID || short0 == Block.grassRetro.blockID) {
                                            if (i4 < 10) {
                                                data[l3] = (short)Block.fluidLavaStill.blockID;
                                            } else {
                                                data[l3] = 0;
                                                if (flag3 && data[l3 - 1] == Block.dirt.blockID) {
                                                    data[l3 - 1] = this.isAlpha ? (short)Block.grassRetro.blockID : (short)Block.grass.blockID;
                                                }
                                            }
                                        }
                                    }
                                    --l3;
                                }
                            }
                        }
                        if (flag) break;
                    }
                }
            }
            ++k2;
        }
    }

    @Override
    protected void doGeneration(World world, int chunkX, int chunkZ, int baseChunkX, int baseChunkZ, short[] data) {
        int cavesToGenerate = rand.nextInt(rand.nextInt(rand.nextInt(40) + 1) + 1);
        if (rand.nextInt(15) != 0) {
            cavesToGenerate = 0;
        }
        for (int i2 = 0; i2 < cavesToGenerate; ++i2) {
            double blockX = chunkX * 16 + rand.nextInt(16);
            double blockY = rand.nextInt(rand.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS - 8) + 8);
            double blockZ = chunkZ * 16 + rand.nextInt(16);
            float heightScaler = 1.0f;
            if (blockY <= 128.0) {
                heightScaler = (float)(128.0 - blockY) / 128.0f;
                heightScaler *= (float)(rand.nextInt(16) + 1);
            }
            int numBranches = 1;
            if (rand.nextInt(4) == 0) {
                this.generateHubRoom(rand.nextLong(), baseChunkX, baseChunkZ, data, blockX, blockY, blockZ);
                numBranches += rand.nextInt(4);
            }
            for (int l1 = 0; l1 < numBranches; ++l1) {
                float f2 = rand.nextFloat() * 3.141593f * 2.0f;
                float f1 = (rand.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float initialRadius = rand.nextFloat() * 2.0f + rand.nextFloat();
                this.generateCave(rand.nextLong(), baseChunkX, baseChunkZ, data, blockX, blockY, blockZ, initialRadius, f2, f1, 0, 0, 1.0);
            }
        }
    }
}

