/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.src.CompressedStreamTools;
import net.minecraft.src.ISaveHandler;
import net.minecraft.src.MapDataBase;
import net.minecraft.src.NBTBase;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagShort;

public class MapStorage {
    private ISaveHandler field_28191_a;
    private Map loadedDataMap = new HashMap();
    private List loadedDataList = new ArrayList();
    private Map idCounts = new HashMap();

    public MapStorage(ISaveHandler isavehandler) {
        this.field_28191_a = isavehandler;
        this.loadIdCounts();
    }

    public MapDataBase loadData(Class class1, String s2) {
        MapDataBase mapdatabase;
        block7: {
            mapdatabase = (MapDataBase)this.loadedDataMap.get(s2);
            if (mapdatabase != null) {
                return mapdatabase;
            }
            if (this.field_28191_a != null) {
                try {
                    File file = this.field_28191_a.func_28113_a(s2);
                    if (file == null || !file.exists()) break block7;
                    try {
                        mapdatabase = (MapDataBase)class1.getConstructor(String.class).newInstance(s2);
                    }
                    catch (Exception exception1) {
                        throw new RuntimeException("Failed to instantiate " + class1.toString(), exception1);
                    }
                    FileInputStream fileinputstream = new FileInputStream(file);
                    NBTTagCompound nbttagcompound = CompressedStreamTools.func_1138_a(fileinputstream);
                    fileinputstream.close();
                    mapdatabase.readFromNBT(nbttagcompound.getCompoundTag("data"));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        if (mapdatabase != null) {
            this.loadedDataMap.put(s2, mapdatabase);
            this.loadedDataList.add(mapdatabase);
        }
        return mapdatabase;
    }

    public void setData(String s2, MapDataBase mapdatabase) {
        if (mapdatabase == null) {
            throw new RuntimeException("Can't set null data");
        }
        if (this.loadedDataMap.containsKey(s2)) {
            this.loadedDataList.remove(this.loadedDataMap.remove(s2));
        }
        this.loadedDataMap.put(s2, mapdatabase);
        this.loadedDataList.add(mapdatabase);
    }

    public void saveAllData() {
        for (int i2 = 0; i2 < this.loadedDataList.size(); ++i2) {
            MapDataBase mapdatabase = (MapDataBase)this.loadedDataList.get(i2);
            if (!mapdatabase.isDirty()) continue;
            this.saveData(mapdatabase);
            mapdatabase.setDirty(false);
        }
    }

    private void saveData(MapDataBase mapdatabase) {
        if (this.field_28191_a == null) {
            return;
        }
        try {
            File file = this.field_28191_a.func_28113_a(mapdatabase.field_28168_a);
            if (file != null) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                mapdatabase.writeToNBT(nbttagcompound);
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.setCompoundTag("data", nbttagcompound);
                FileOutputStream fileoutputstream = new FileOutputStream(file);
                CompressedStreamTools.writeGzippedCompoundToOutputStream(nbttagcompound1, fileoutputstream);
                fileoutputstream.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void loadIdCounts() {
        try {
            this.idCounts.clear();
            if (this.field_28191_a == null) {
                return;
            }
            File file = this.field_28191_a.func_28113_a("idcounts");
            if (file != null && file.exists()) {
                DataInputStream datainputstream = new DataInputStream(new FileInputStream(file));
                NBTTagCompound nbttagcompound = CompressedStreamTools.func_1141_a(datainputstream);
                datainputstream.close();
                for (NBTBase nbtbase : nbttagcompound.func_28110_c()) {
                    if (!(nbtbase instanceof NBTTagShort)) continue;
                    NBTTagShort nbttagshort = (NBTTagShort)nbtbase;
                    String s2 = nbttagshort.getKey();
                    short word0 = nbttagshort.shortValue;
                    this.idCounts.put(s2, word0);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getUniqueDataId(String s2) {
        Short short1 = (Short)this.idCounts.get(s2);
        if (short1 == null) {
            short1 = 0;
        } else {
            Short short2 = short1;
            Short short3 = short1 = Short.valueOf((short)(short1 + 1));
            Short s3 = short2;
        }
        this.idCounts.put(s2, short1);
        if (this.field_28191_a == null) {
            return short1.shortValue();
        }
        try {
            File file = this.field_28191_a.func_28113_a("idcounts");
            if (file != null) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                for (String s1 : this.idCounts.keySet()) {
                    short word0 = (Short)this.idCounts.get(s1);
                    nbttagcompound.setShort(s1, word0);
                }
                DataOutputStream dataoutputstream = new DataOutputStream(new FileOutputStream(file));
                CompressedStreamTools.func_1139_a(nbttagcompound, dataoutputstream);
                dataoutputstream.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return short1.shortValue();
    }
}

