/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.EntityPlayer;
import net.minecraft.src.GameSettings;
import net.minecraft.src.MovementInput;
import net.minecraft.src.input.InputType;

public class MovementInputFromOptions
extends MovementInput {
    private boolean[] movementKeyStates = new boolean[10];
    private GameSettings gameSettings;

    public MovementInputFromOptions(GameSettings gamesettings) {
        this.gameSettings = gamesettings;
    }

    @Override
    public void checkKeyForMovementInput(int i2, boolean flag) {
        int byte0 = -1;
        if (this.gameSettings.keyForward.isKey(i2)) {
            byte0 = 0;
        }
        if (this.gameSettings.keyBack.isKey(i2)) {
            byte0 = 1;
        }
        if (this.gameSettings.keyLeft.isKey(i2)) {
            byte0 = 2;
        }
        if (this.gameSettings.keyRight.isKey(i2)) {
            byte0 = 3;
        }
        if (this.gameSettings.keyJump.isKey(i2)) {
            byte0 = 4;
        }
        if (this.gameSettings.keySneak.isKey(i2)) {
            byte0 = 5;
        }
        if (this.gameSettings.keyLookLeft.isKey(i2)) {
            byte0 = 6;
        }
        if (this.gameSettings.keyLookRight.isKey(i2)) {
            byte0 = 7;
        }
        if (this.gameSettings.keyLookUp.isKey(i2)) {
            byte0 = 8;
        }
        if (this.gameSettings.keyLookDown.isKey(i2)) {
            byte0 = 9;
        }
        if (byte0 >= 0) {
            this.movementKeyStates[byte0] = flag;
        }
    }

    @Override
    public void resetKeyState() {
        for (int i2 = 0; i2 < 10; ++i2) {
            this.movementKeyStates[i2] = false;
        }
    }

    @Override
    public void updatePlayerMoveState(EntityPlayer entityplayer) {
        if (this.gameSettings.mc.inputType == InputType.CONTROLLER) {
            if (this.gameSettings.mc.currentScreen == null) {
                this.moveForward = -this.gameSettings.mc.controllerInput.joyLeft.getY();
                this.moveStrafe = -this.gameSettings.mc.controllerInput.joyLeft.getX();
                this.jump = this.gameSettings.mc.controllerInput.buttonA.isPressed();
                if (this.gameSettings.mc.controllerInput.joyRight.getButton().pressedThisFrame()) {
                    this.sneak = !this.sneak;
                }
            } else {
                this.moveForward = 0.0f;
                this.moveStrafe = 0.0f;
                this.jump = false;
            }
        } else {
            this.moveStrafe = 0.0f;
            this.moveForward = 0.0f;
            this.lookPitch = 0.0f;
            this.lookYaw = 0.0f;
            if (this.movementKeyStates[0]) {
                this.moveForward += 1.0f;
            }
            if (this.movementKeyStates[1]) {
                this.moveForward -= 1.0f;
            }
            if (this.movementKeyStates[2]) {
                this.moveStrafe += 1.0f;
            }
            if (this.movementKeyStates[3]) {
                this.moveStrafe -= 1.0f;
            }
            this.jump = this.movementKeyStates[4];
            this.sneak = this.movementKeyStates[5];
            if (this.movementKeyStates[6]) {
                this.lookYaw -= 1.0f;
            }
            if (this.movementKeyStates[7]) {
                this.lookYaw += 1.0f;
            }
            if (this.movementKeyStates[8]) {
                this.lookPitch -= 1.0f;
            }
            if (this.movementKeyStates[9]) {
                this.lookPitch += 1.0f;
            }
            this.lookYaw *= ((Float)this.gameSettings.mouseSensitivity.value).floatValue() * 20.0f;
            this.lookPitch *= ((Float)this.gameSettings.mouseSensitivity.value).floatValue() * 20.0f;
            if (this.sneak) {
                this.lookPitch /= 2.0f;
                this.lookYaw /= 2.0f;
            }
        }
        if (this.sneak) {
            this.moveStrafe = (float)((double)this.moveStrafe * 0.3);
            this.moveForward = (float)((double)this.moveForward * 0.3);
        }
    }
}

