/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.Chunk;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.Container;
import net.minecraft.src.Dimension;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityArrow;
import net.minecraft.src.EntityArrowGolden;
import net.minecraft.src.EntityArrowPurple;
import net.minecraft.src.EntityBoat;
import net.minecraft.src.EntityCannonball;
import net.minecraft.src.EntityClientPlayerMP;
import net.minecraft.src.EntityEgg;
import net.minecraft.src.EntityFallingSand;
import net.minecraft.src.EntityFireball;
import net.minecraft.src.EntityFish;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityLightningBolt;
import net.minecraft.src.EntityList;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityMinecart;
import net.minecraft.src.EntityOtherPlayerMP;
import net.minecraft.src.EntityPainting;
import net.minecraft.src.EntityPebble;
import net.minecraft.src.EntityPickupFX;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityPlayerSP;
import net.minecraft.src.EntitySnowball;
import net.minecraft.src.EntityTNTPrimed;
import net.minecraft.src.Explosion;
import net.minecraft.src.ExplosionCannonball;
import net.minecraft.src.Gamemode;
import net.minecraft.src.GuiConnectFailed;
import net.minecraft.src.GuiDownloadTerrain;
import net.minecraft.src.InventoryBasic;
import net.minecraft.src.Item;
import net.minecraft.src.ItemMap;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MapStorage;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NetHandler;
import net.minecraft.src.NetworkManager;
import net.minecraft.src.Packet;
import net.minecraft.src.Packet100OpenWindow;
import net.minecraft.src.Packet101CloseWindow;
import net.minecraft.src.Packet103SetSlot;
import net.minecraft.src.Packet104WindowItems;
import net.minecraft.src.Packet105UpdateProgressbar;
import net.minecraft.src.Packet106Transaction;
import net.minecraft.src.Packet10Flying;
import net.minecraft.src.Packet130UpdateSign;
import net.minecraft.src.Packet131MapData;
import net.minecraft.src.Packet132SetMobSpawner;
import net.minecraft.src.Packet17Sleep;
import net.minecraft.src.Packet18Animation;
import net.minecraft.src.Packet1Login;
import net.minecraft.src.Packet200Statistic;
import net.minecraft.src.Packet20NamedEntitySpawn;
import net.minecraft.src.Packet21PickupSpawn;
import net.minecraft.src.Packet22Collect;
import net.minecraft.src.Packet23VehicleSpawn;
import net.minecraft.src.Packet24MobSpawn;
import net.minecraft.src.Packet255KickDisconnect;
import net.minecraft.src.Packet25EntityPainting;
import net.minecraft.src.Packet28EntityVelocity;
import net.minecraft.src.Packet29DestroyEntity;
import net.minecraft.src.Packet2Handshake;
import net.minecraft.src.Packet30Entity;
import net.minecraft.src.Packet34EntityTeleport;
import net.minecraft.src.Packet35EntityNickname;
import net.minecraft.src.Packet38EntityStatus;
import net.minecraft.src.Packet39AttachEntity;
import net.minecraft.src.Packet3Chat;
import net.minecraft.src.Packet40EntityMetadata;
import net.minecraft.src.Packet41EntityPlayerGamemode;
import net.minecraft.src.Packet4UpdateTime;
import net.minecraft.src.Packet50PreChunk;
import net.minecraft.src.Packet51MapChunk;
import net.minecraft.src.Packet52MultiBlockChange;
import net.minecraft.src.Packet53BlockChange;
import net.minecraft.src.Packet54PlayNoteBlock;
import net.minecraft.src.Packet55WorldTypes;
import net.minecraft.src.Packet5PlayerInventory;
import net.minecraft.src.Packet60Explosion;
import net.minecraft.src.Packet61PlaySoundEffect;
import net.minecraft.src.Packet6SpawnPosition;
import net.minecraft.src.Packet70Bed;
import net.minecraft.src.Packet71Weather;
import net.minecraft.src.Packet72UpdatePlayerProfile;
import net.minecraft.src.Packet73WeatherStatus;
import net.minecraft.src.Packet8UpdateHealth;
import net.minecraft.src.Packet9Respawn;
import net.minecraft.src.PlayerControllerMP;
import net.minecraft.src.PlayerProfile;
import net.minecraft.src.StatList;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityBlastFurnace;
import net.minecraft.src.TileEntityDispenser;
import net.minecraft.src.TileEntityFurnace;
import net.minecraft.src.TileEntityMobSpawner;
import net.minecraft.src.TileEntitySign;
import net.minecraft.src.TileEntityTrommel;
import net.minecraft.src.Weather;
import net.minecraft.src.World;
import net.minecraft.src.WorldClient;
import net.minecraft.src.WorldType;

public class NetClientHandler
extends NetHandler {
    private boolean disconnected = false;
    private NetworkManager netManager;
    public String field_1209_a;
    private Minecraft mc;
    private WorldClient worldClient;
    private boolean field_1210_g = false;
    public MapStorage field_28118_b = new MapStorage(null);
    public List<PlayerProfile> players;
    Random rand = new Random();

    public NetClientHandler(Minecraft minecraft, String s2, int i2) throws UnknownHostException, IOException {
        this.mc = minecraft;
        Socket socket = new Socket(InetAddress.getByName(s2), i2);
        this.netManager = new NetworkManager(socket, "Client", this);
        this.players = new ArrayList<PlayerProfile>();
    }

    public void processReadPackets() {
        if (!this.disconnected) {
            this.netManager.processReadPackets();
        }
        this.netManager.wakeThreads();
    }

    public int findPlayerInList(PlayerProfile playerProfile) {
        for (int i2 = 0; i2 < this.players.size(); ++i2) {
            if (!this.players.get((int)i2).playerName.equals(playerProfile.playerName)) continue;
            return i2;
        }
        return -1;
    }

    public void addPlayer(PlayerProfile playerProfile) {
        this.players.add(playerProfile);
    }

    public PlayerProfile getPlayer(String username) {
        for (PlayerProfile player : this.players) {
            if (!player.playerName.equals(username)) continue;
            return player;
        }
        return null;
    }

    public void removePlayer(int index) {
        this.players.remove(index);
    }

    @Override
    public void handleLogin(Packet1Login packet1login) {
        this.mc.playerController = new PlayerControllerMP(this.mc, this);
        this.mc.statFileWriter.writeStat(StatList.joinMultiplayerStat, 1);
        this.worldClient = new WorldClient(this.mc, this, packet1login.mapSeed, packet1login.dimension);
        this.worldClient.isMultiplayerAndNotHost = true;
        this.mc.changeWorld1(this.worldClient);
        this.mc.thePlayer.dimension = packet1login.dimension;
        this.mc.displayGuiScreen(new GuiDownloadTerrain(this));
        this.mc.thePlayer.entityId = packet1login.protocolVersion;
        this.mc.thePlayer.syncPlacementMode();
    }

    @Override
    public void handlePickupSpawn(Packet21PickupSpawn packet21pickupspawn) {
        double d2 = (double)packet21pickupspawn.xPosition / 32.0;
        double d1 = (double)packet21pickupspawn.yPosition / 32.0;
        double d22 = (double)packet21pickupspawn.zPosition / 32.0;
        EntityItem entityitem = new EntityItem(this.worldClient, d2, d1, d22, new ItemStack(packet21pickupspawn.itemID, packet21pickupspawn.count, packet21pickupspawn.itemDamage, packet21pickupspawn.tag));
        entityitem.motionX = (double)packet21pickupspawn.rotation / 128.0;
        entityitem.motionY = (double)packet21pickupspawn.pitch / 128.0;
        entityitem.motionZ = (double)packet21pickupspawn.roll / 128.0;
        entityitem.serverPosX = packet21pickupspawn.xPosition;
        entityitem.serverPosY = packet21pickupspawn.yPosition;
        entityitem.serverPosZ = packet21pickupspawn.zPosition;
        this.worldClient.func_712_a(packet21pickupspawn.entityId, entityitem);
    }

    @Override
    public void handleVehicleSpawn(Packet23VehicleSpawn packet23vehiclespawn) {
        double d2 = (double)packet23vehiclespawn.xPosition / 32.0;
        double d1 = (double)packet23vehiclespawn.yPosition / 32.0;
        double d22 = (double)packet23vehiclespawn.zPosition / 32.0;
        Entity obj = null;
        if (packet23vehiclespawn.type == 10) {
            obj = new EntityMinecart(this.worldClient, d2, d1, d22, 0);
        }
        if (packet23vehiclespawn.type == 11) {
            obj = new EntityMinecart(this.worldClient, d2, d1, d22, 1);
        }
        if (packet23vehiclespawn.type == 12) {
            obj = new EntityMinecart(this.worldClient, d2, d1, d22, 2);
        }
        if (packet23vehiclespawn.type == 90) {
            obj = new EntityFish(this.worldClient, d2, d1, d22);
        }
        if (packet23vehiclespawn.type == 60) {
            obj = packet23vehiclespawn.arrowType == 2 ? new EntityArrowGolden((World)this.worldClient, d2, d1, d22) : (packet23vehiclespawn.arrowType == 1 ? new EntityArrowPurple((World)this.worldClient, d2, d1, d22) : new EntityArrow(this.worldClient, d2, d1, d22, packet23vehiclespawn.arrowType));
        }
        if (packet23vehiclespawn.type == 61) {
            obj = new EntitySnowball(this.worldClient, d2, d1, d22);
        }
        if (packet23vehiclespawn.type == 62) {
            obj = new EntityEgg(this.worldClient, d2, d1, d22);
        }
        if (packet23vehiclespawn.type == 63) {
            obj = new EntityFireball(this.worldClient, d2, d1, d22, (double)packet23vehiclespawn.field_28047_e / 8000.0, (double)packet23vehiclespawn.field_28046_f / 8000.0, (double)packet23vehiclespawn.field_28045_g / 8000.0);
            packet23vehiclespawn.field_28044_i = 0;
        }
        if (packet23vehiclespawn.type == 64) {
            obj = new EntityPebble(this.worldClient, d2, d1, d22);
        }
        if (packet23vehiclespawn.type == 1) {
            obj = new EntityBoat(this.worldClient, d2, d1, d22);
        }
        if (packet23vehiclespawn.type == 50) {
            obj = new EntityTNTPrimed(this.worldClient, d2, d1, d22);
        }
        if (packet23vehiclespawn.type == 70) {
            obj = new EntityFallingSand(this.worldClient, d2, d1, d22, Block.sand.blockID);
        }
        if (packet23vehiclespawn.type == 71) {
            obj = new EntityFallingSand(this.worldClient, d2, d1, d22, Block.gravel.blockID);
        }
        if (packet23vehiclespawn.type == 72) {
            obj = new EntityCannonball(this.worldClient, d2, d1, d22);
        }
        if (obj != null) {
            obj.serverPosX = packet23vehiclespawn.xPosition;
            obj.serverPosY = packet23vehiclespawn.yPosition;
            obj.serverPosZ = packet23vehiclespawn.zPosition;
            obj.rotationYaw = packet23vehiclespawn.yaw;
            obj.rotationPitch = packet23vehiclespawn.pitch;
            obj.entityId = packet23vehiclespawn.entityId;
            this.worldClient.func_712_a(packet23vehiclespawn.entityId, obj);
            if (packet23vehiclespawn.field_28044_i > 0) {
                Entity entity;
                if (packet23vehiclespawn.type == 60 && (entity = this.getEntityByID(packet23vehiclespawn.field_28044_i)) instanceof EntityLiving) {
                    ((EntityArrow)obj).owner = (EntityLiving)entity;
                }
                if (packet23vehiclespawn.type == 72 && (entity = this.getEntityByID(packet23vehiclespawn.field_28044_i)) instanceof EntityLiving) {
                    ((EntityCannonball)obj).owner = (EntityLiving)entity;
                }
                if (packet23vehiclespawn.type == 73 && (entity = this.getEntityByID(packet23vehiclespawn.field_28044_i)) instanceof EntityLiving) {
                    ((EntityArrowGolden)obj).owner = (EntityLiving)entity;
                }
                obj.setVelocity((double)packet23vehiclespawn.field_28047_e / 8000.0, (double)packet23vehiclespawn.field_28046_f / 8000.0, (double)packet23vehiclespawn.field_28045_g / 8000.0);
            }
        }
    }

    @Override
    public void handleWeather(Packet71Weather packet71weather) {
        double d2 = (double)packet71weather.field_27053_b / 32.0;
        double d1 = (double)packet71weather.field_27057_c / 32.0;
        double d22 = (double)packet71weather.field_27056_d / 32.0;
        EntityLightningBolt entitylightningbolt = null;
        if (packet71weather.field_27055_e == 1) {
            entitylightningbolt = new EntityLightningBolt(this.worldClient, d2, d1, d22);
        }
        if (entitylightningbolt != null) {
            entitylightningbolt.serverPosX = packet71weather.field_27053_b;
            entitylightningbolt.serverPosY = packet71weather.field_27057_c;
            entitylightningbolt.serverPosZ = packet71weather.field_27056_d;
            entitylightningbolt.rotationYaw = 0.0f;
            entitylightningbolt.rotationPitch = 0.0f;
            entitylightningbolt.entityId = packet71weather.field_27054_a;
            this.worldClient.addWeatherEffect(entitylightningbolt);
        }
    }

    @Override
    public void handleWeatherStatus(Packet73WeatherStatus packet) {
        if (this.worldClient.dimension.dimId != packet.dimId) {
            return;
        }
        if (packet.id != -1) {
            this.worldClient.currentWeather = Weather.weatherList[packet.id];
        }
        if (packet.newId != -1) {
            this.worldClient.newWeather = Weather.weatherList[packet.newId];
        }
        this.worldClient.weatherDuration = packet.duration;
        this.worldClient.weatherIntensity = packet.intensity;
        this.worldClient.weatherPower = packet.power;
    }

    @Override
    public void handleEntityPainting(Packet25EntityPainting packet25entitypainting) {
        EntityPainting entitypainting = new EntityPainting(this.worldClient, packet25entitypainting.xPosition, packet25entitypainting.yPosition, packet25entitypainting.zPosition, packet25entitypainting.direction, packet25entitypainting.title);
        this.worldClient.func_712_a(packet25entitypainting.entityId, entitypainting);
    }

    @Override
    public void handleEntityVelocity(Packet28EntityVelocity packet28entityvelocity) {
        Entity entity = this.getEntityByID(packet28entityvelocity.entityId);
        if (entity == null) {
            return;
        }
        entity.setVelocity((double)packet28entityvelocity.motionX / 8000.0, (double)packet28entityvelocity.motionY / 8000.0, (double)packet28entityvelocity.motionZ / 8000.0);
    }

    @Override
    public void handleEntityMetadata(Packet40EntityMetadata packet40entitymetadata) {
        Entity entity = this.getEntityByID(packet40entitymetadata.entityId);
        if (entity != null && packet40entitymetadata.func_21047_b() != null) {
            entity.getDataWatcher().updateWatchedObjectsFromList(packet40entitymetadata.func_21047_b());
        }
    }

    @Override
    public void handleNamedEntitySpawn(Packet20NamedEntitySpawn packet20namedentityspawn) {
        double d2 = (double)packet20namedentityspawn.xPosition / 32.0;
        double d1 = (double)packet20namedentityspawn.yPosition / 32.0;
        double d22 = (double)packet20namedentityspawn.zPosition / 32.0;
        float f2 = (float)(packet20namedentityspawn.rotation * 360) / 256.0f;
        float f1 = (float)(packet20namedentityspawn.pitch * 360) / 256.0f;
        EntityOtherPlayerMP entityotherplayermp = new EntityOtherPlayerMP(this.mc.theWorld, packet20namedentityspawn.name);
        entityotherplayermp.serverPosX = packet20namedentityspawn.xPosition;
        entityotherplayermp.prevPosX = entityotherplayermp.lastTickPosX = (double)entityotherplayermp.serverPosX;
        entityotherplayermp.serverPosY = packet20namedentityspawn.yPosition;
        entityotherplayermp.prevPosY = entityotherplayermp.lastTickPosY = (double)entityotherplayermp.serverPosY;
        entityotherplayermp.serverPosZ = packet20namedentityspawn.zPosition;
        entityotherplayermp.prevPosZ = entityotherplayermp.lastTickPosZ = (double)entityotherplayermp.serverPosZ;
        int i2 = packet20namedentityspawn.currentItem;
        entityotherplayermp.inventory.mainInventory[entityotherplayermp.inventory.currentItem] = i2 == 0 ? null : new ItemStack(i2, 1, 0);
        entityotherplayermp.setPositionAndRotation(d2, d1, d22, f2, f1);
        this.worldClient.func_712_a(packet20namedentityspawn.entityId, entityotherplayermp);
        entityotherplayermp.nickname = packet20namedentityspawn.nickname;
        entityotherplayermp.chatColor = packet20namedentityspawn.chatColor;
    }

    @Override
    public void handleEntityTeleport(Packet34EntityTeleport packet34entityteleport) {
        Entity entity = this.getEntityByID(packet34entityteleport.entityId);
        if (entity == null) {
            return;
        }
        entity.serverPosX = packet34entityteleport.xPosition;
        entity.serverPosY = packet34entityteleport.yPosition;
        entity.serverPosZ = packet34entityteleport.zPosition;
        double d2 = (double)entity.serverPosX / 32.0;
        double d1 = (double)entity.serverPosY / 32.0 + 0.015625;
        double d22 = (double)entity.serverPosZ / 32.0;
        float f2 = (float)(packet34entityteleport.yaw * 360) / 256.0f;
        float f1 = (float)(packet34entityteleport.pitch * 360) / 256.0f;
        entity.setPositionAndRotation2(d2, d1, d22, f2, f1, 3);
    }

    @Override
    public void handleEntity(Packet30Entity packet30entity) {
        Entity entity = this.getEntityByID(packet30entity.entityId);
        if (entity == null) {
            return;
        }
        entity.serverPosX += packet30entity.xPosition;
        entity.serverPosY += packet30entity.yPosition;
        entity.serverPosZ += packet30entity.zPosition;
        double d2 = (double)entity.serverPosX / 32.0;
        double d1 = (double)entity.serverPosY / 32.0;
        double d22 = (double)entity.serverPosZ / 32.0;
        float f2 = packet30entity.rotating ? (float)(packet30entity.yaw * 360) / 256.0f : entity.rotationYaw;
        float f1 = packet30entity.rotating ? (float)(packet30entity.pitch * 360) / 256.0f : entity.rotationPitch;
        entity.setPositionAndRotation2(d2, d1, d22, f2, f1, 3);
    }

    @Override
    public void handleSetMobSpawner(Packet132SetMobSpawner packet132SetMobSpawner) {
        TileEntity tileentity;
        if (this.mc.theWorld.blockExists(packet132SetMobSpawner.xPosition, packet132SetMobSpawner.yPosition, packet132SetMobSpawner.zPosition) && (tileentity = this.mc.theWorld.getBlockTileEntity(packet132SetMobSpawner.xPosition, packet132SetMobSpawner.yPosition, packet132SetMobSpawner.zPosition)) instanceof TileEntityMobSpawner) {
            TileEntityMobSpawner tileEntityMobSpawner = (TileEntityMobSpawner)tileentity;
            tileEntityMobSpawner.setMobID(packet132SetMobSpawner.spawnType);
            tileEntityMobSpawner.onInventoryChanged();
        }
    }

    @Override
    public void handleDestroyEntity(Packet29DestroyEntity packet29destroyentity) {
        this.worldClient.removeEntityFromWorld(packet29destroyentity.entityId);
    }

    @Override
    public void handleFlying(Packet10Flying packet10flying) {
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        double d2 = entityplayersp.posX;
        double d1 = entityplayersp.posY;
        double d22 = entityplayersp.posZ;
        float f2 = entityplayersp.rotationYaw;
        float f1 = entityplayersp.rotationPitch;
        if (packet10flying.moving) {
            d2 = packet10flying.xPosition;
            d1 = packet10flying.yPosition;
            d22 = packet10flying.zPosition;
        }
        if (packet10flying.rotating) {
            f2 = packet10flying.yaw;
            f1 = packet10flying.pitch;
        }
        entityplayersp.ySize = 0.0f;
        entityplayersp.motionZ = 0.0;
        entityplayersp.motionY = 0.0;
        entityplayersp.motionX = 0.0;
        entityplayersp.setPositionAndRotation(d2, d1, d22, f2, f1);
        packet10flying.xPosition = entityplayersp.posX;
        packet10flying.yPosition = entityplayersp.boundingBox.minY;
        packet10flying.zPosition = entityplayersp.posZ;
        packet10flying.stance = entityplayersp.posY;
        this.netManager.addToSendQueue(packet10flying);
        if (!this.field_1210_g) {
            this.mc.thePlayer.prevPosX = this.mc.thePlayer.posX;
            this.mc.thePlayer.prevPosY = this.mc.thePlayer.posY;
            this.mc.thePlayer.prevPosZ = this.mc.thePlayer.posZ;
            this.field_1210_g = true;
            this.mc.displayGuiScreen(null);
        }
    }

    @Override
    public void handlePreChunk(Packet50PreChunk packet50prechunk) {
        this.worldClient.doPreChunk(packet50prechunk.xPosition, packet50prechunk.yPosition, packet50prechunk.mode);
    }

    @Override
    public void handleMultiBlockChange(Packet52MultiBlockChange packet52multiblockchange) {
        Chunk chunk = this.worldClient.getChunkFromChunkCoords(packet52multiblockchange.xPosition, packet52multiblockchange.zPosition);
        int i2 = packet52multiblockchange.xPosition * 16;
        int j2 = packet52multiblockchange.zPosition * 16;
        for (int k2 = 0; k2 < packet52multiblockchange.size; ++k2) {
            short word0 = packet52multiblockchange.coordinateArray[k2];
            int l2 = packet52multiblockchange.typeArray[k2] & 0x3FFF;
            byte byte0 = packet52multiblockchange.metadataArray[k2];
            int i1 = word0 >> 12 & 0xF;
            int j1 = word0 >> 8 & 0xF;
            int k1 = word0 & 0xFF;
            chunk.setBlockIDWithMetadata(i1, k1, j1, l2, byte0);
            this.worldClient.func_711_c(i1 + i2, k1, j1 + j2, i1 + i2, k1, j1 + j2);
            this.worldClient.markBlocksDirty(i1 + i2, k1, j1 + j2, i1 + i2, k1, j1 + j2);
        }
    }

    @Override
    public void handleMapChunk(Packet51MapChunk packet51mapchunk) {
        this.worldClient.func_711_c(packet51mapchunk.xPosition, packet51mapchunk.yPosition, packet51mapchunk.zPosition, packet51mapchunk.xPosition + packet51mapchunk.xSize - 1, packet51mapchunk.yPosition + packet51mapchunk.ySize - 1, packet51mapchunk.zPosition + packet51mapchunk.zSize - 1);
        this.worldClient.setChunkData(packet51mapchunk.xPosition, packet51mapchunk.yPosition, packet51mapchunk.zPosition, packet51mapchunk.xSize, packet51mapchunk.ySize, packet51mapchunk.zSize, packet51mapchunk.chunk);
    }

    @Override
    public void handleBlockChange(Packet53BlockChange packet53blockchange) {
        this.worldClient.func_714_c(packet53blockchange.xPosition, packet53blockchange.yPosition, packet53blockchange.zPosition, packet53blockchange.type, packet53blockchange.metadata);
    }

    @Override
    public void handleKickDisconnect(Packet255KickDisconnect packet255kickdisconnect) {
        this.netManager.networkShutdown("disconnect.kicked", new Object[0]);
        this.disconnected = true;
        this.mc.changeWorld1(null);
        this.mc.displayGuiScreen(new GuiConnectFailed("disconnect.disconnected", "disconnect.genericReason", new Object[]{packet255kickdisconnect.reason}));
    }

    @Override
    public void handleErrorMessage(String s2, Object[] aobj) {
        if (this.disconnected) {
            return;
        }
        this.disconnected = true;
        this.mc.changeWorld1(null);
        this.mc.displayGuiScreen(new GuiConnectFailed("disconnect.lost", s2, aobj));
    }

    public void func_28117_a(Packet packet) {
        if (this.disconnected) {
            return;
        }
        this.netManager.addToSendQueue(packet);
        this.netManager.serverShutdown();
    }

    public void addToSendQueue(Packet packet) {
        if (this.disconnected) {
            return;
        }
        this.netManager.addToSendQueue(packet);
    }

    @Override
    public void handleCollect(Packet22Collect packet22collect) {
        Entity entity = this.getEntityByID(packet22collect.collectedEntityId);
        EntityLiving obj = (EntityLiving)this.getEntityByID(packet22collect.collectorEntityId);
        if (obj == null) {
            obj = this.mc.thePlayer;
        }
        if (entity != null) {
            this.worldClient.playSoundAtEntity(entity, "random.pop", 0.2f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            this.mc.effectRenderer.addEffect(new EntityPickupFX(this.mc.theWorld, entity, obj, -0.5f));
            this.worldClient.removeEntityFromWorld(packet22collect.collectedEntityId);
        }
    }

    @Override
    public void handleChat(Packet3Chat packet3chat) {
        this.mc.ingameGUI.addChatMessage(packet3chat.message);
    }

    public void handlePlayerJoin(Packet3Chat packet3chat) {
        this.mc.ingameGUI.addChatMessage(packet3chat.message);
    }

    public void handlePlayerLeave(Packet3Chat packet3chat) {
        this.mc.ingameGUI.addChatMessage(packet3chat.message);
    }

    @Override
    public void handleAnimation(Packet18Animation packet18animation) {
        Entity entity = this.getEntityByID(packet18animation.entityId);
        if (entity == null) {
            return;
        }
        if (packet18animation.animate == 1) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            entityplayer.swingItem();
        } else if (packet18animation.animate == 2) {
            entity.performHurtAnimation();
        } else if (packet18animation.animate == 3) {
            EntityPlayer entityplayer1 = (EntityPlayer)entity;
            entityplayer1.wakeUpPlayer(false, false);
        } else if (packet18animation.animate == 4) {
            EntityPlayer entityplayer2 = (EntityPlayer)entity;
            entityplayer2.func_6420_o();
        }
    }

    @Override
    public void handleSleep(Packet17Sleep packet17sleep) {
        Entity entity = this.getEntityByID(packet17sleep.entityID);
        if (entity == null) {
            return;
        }
        if (packet17sleep.field_22046_e == 0) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            entityplayer.sleepInBedAt(packet17sleep.x, packet17sleep.y, packet17sleep.z);
        }
    }

    @Override
    public void handleHandshake(Packet2Handshake packet2handshake) {
        if (packet2handshake.username.equals("-")) {
            this.addToSendQueue(new Packet1Login(this.mc.session.username, net.minecraft.shared.Minecraft.MP_PROTOCOL_VERSION));
        } else {
            try {
                URL url = new URL("http://session.minecraft.net/game/joinserver.jsp?user=" + this.mc.session.username + "&sessionId=" + this.mc.session.sessionId + "&serverId=" + packet2handshake.username);
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(url.openStream()));
                String s2 = bufferedreader.readLine();
                bufferedreader.close();
                if (s2.equalsIgnoreCase("ok")) {
                    this.addToSendQueue(new Packet1Login(this.mc.session.username, net.minecraft.shared.Minecraft.MP_PROTOCOL_VERSION));
                } else {
                    this.netManager.networkShutdown("disconnect.loginFailedInfo", new Object[]{s2});
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.netManager.networkShutdown("disconnect.genericReason", new Object[]{"Internal client error: " + exception.toString()});
            }
        }
    }

    public void disconnect() {
        this.disconnected = true;
        this.netManager.wakeThreads();
        this.netManager.networkShutdown("disconnect.closed", new Object[0]);
    }

    @Override
    public void handleMobSpawn(Packet24MobSpawn packet24mobspawn) {
        double d2 = (double)packet24mobspawn.xPosition / 32.0;
        double d1 = (double)packet24mobspawn.yPosition / 32.0;
        double d22 = (double)packet24mobspawn.zPosition / 32.0;
        float f2 = (float)(packet24mobspawn.yaw * 360) / 256.0f;
        float f1 = (float)(packet24mobspawn.pitch * 360) / 256.0f;
        EntityLiving entityliving = (EntityLiving)EntityList.createEntity(packet24mobspawn.type, this.mc.theWorld);
        entityliving.serverPosX = packet24mobspawn.xPosition;
        entityliving.serverPosY = packet24mobspawn.yPosition;
        entityliving.serverPosZ = packet24mobspawn.zPosition;
        entityliving.entityId = packet24mobspawn.entityId;
        entityliving.setPositionAndRotation(d2, d1, d22, f2, f1);
        entityliving.isMultiplayerEntity = true;
        this.worldClient.func_712_a(packet24mobspawn.entityId, entityliving);
        List list = packet24mobspawn.getMetadata();
        if (list != null) {
            entityliving.getDataWatcher().updateWatchedObjectsFromList(list);
        }
        entityliving.nickname = packet24mobspawn.nickname;
        entityliving.chatColor = packet24mobspawn.chatColor;
    }

    @Override
    public void handleUpdateTime(Packet4UpdateTime packet4updatetime) {
        this.mc.theWorld.setWorldTime(packet4updatetime.time);
    }

    @Override
    public void handleSpawnPosition(Packet6SpawnPosition packet6spawnposition) {
        this.mc.thePlayer.setPlayerSpawnCoordinate(new ChunkCoordinates(packet6spawnposition.xPosition, packet6spawnposition.yPosition, packet6spawnposition.zPosition));
        this.mc.theWorld.getWorldInfo().setSpawn(packet6spawnposition.xPosition, packet6spawnposition.yPosition, packet6spawnposition.zPosition);
    }

    @Override
    public void handleAttachEntity(Packet39AttachEntity packet39attachentity) {
        Entity obj = this.getEntityByID(packet39attachentity.entityId);
        Entity entity = this.getEntityByID(packet39attachentity.vehicleEntityId);
        if (packet39attachentity.entityId == this.mc.thePlayer.entityId) {
            obj = this.mc.thePlayer;
        }
        if (obj == null) {
            return;
        }
        obj.mountEntity(entity);
    }

    @Override
    public void handleEntityStatus(Packet38EntityStatus packet38entitystatus) {
        Entity entity = this.getEntityByID(packet38entitystatus.entityId);
        if (entity != null) {
            entity.handleEntityStatus(packet38entitystatus.entityStatus, packet38entitystatus.attackedAtYaw);
        }
    }

    protected Entity getEntityByID(int i2) {
        if (i2 == this.mc.thePlayer.entityId) {
            return this.mc.thePlayer;
        }
        return this.worldClient.func_709_b(i2);
    }

    @Override
    public void handleUpdateHealth(Packet8UpdateHealth packet8updatehealth) {
        this.mc.thePlayer.setHealth(packet8updatehealth.healthMP);
    }

    @Override
    public void handleUpdatePlayerProfile(Packet72UpdatePlayerProfile packet72playerprofile) {
        int index;
        PlayerProfile playerProfile = new PlayerProfile(packet72playerprofile.username, packet72playerprofile.nickname, packet72playerprofile.score, packet72playerprofile.chatColor, packet72playerprofile.isOperator);
        if (playerProfile.playerName.equals(this.mc.thePlayer.username)) {
            this.mc.thePlayer.score = playerProfile.scoreTotal;
        }
        if ((index = this.findPlayerInList(playerProfile)) != -1) {
            if (!packet72playerprofile.isOnline) {
                this.removePlayer(index);
            } else {
                this.players.set(index, playerProfile);
            }
        } else {
            this.addPlayer(playerProfile);
        }
    }

    @Override
    public void handleRespawn(Packet9Respawn packet9respawn) {
        if (packet9respawn.respawnDimension != this.mc.thePlayer.dimension) {
            this.field_1210_g = false;
            this.worldClient = new WorldClient(this.mc, this, this.worldClient.getWorldInfo().getRandomSeed(), packet9respawn.respawnDimension);
            this.worldClient.isMultiplayerAndNotHost = true;
            this.mc.changeWorld1(this.worldClient);
            this.mc.thePlayer.dimension = packet9respawn.respawnDimension;
            this.mc.displayGuiScreen(new GuiDownloadTerrain(this));
        }
        this.mc.respawn(true, packet9respawn.respawnDimension);
    }

    @Override
    public void handleExplosion(Packet60Explosion packet60explosion) {
        Explosion explosion = packet60explosion.isCannonball ? new ExplosionCannonball(this.mc.theWorld, null, packet60explosion.explosionX, packet60explosion.explosionY, packet60explosion.explosionZ, packet60explosion.explosionSize) : new Explosion(this.mc.theWorld, null, packet60explosion.explosionX, packet60explosion.explosionY, packet60explosion.explosionZ, packet60explosion.explosionSize);
        explosion.destroyedBlockPositions = packet60explosion.destroyedBlockPositions;
        explosion.doExplosionB(true);
    }

    @Override
    public void handleOpenWindow(Packet100OpenWindow packet100openwindow) {
        if (packet100openwindow.inventoryType == 0) {
            InventoryBasic inventorybasic = new InventoryBasic(packet100openwindow.windowTitle, packet100openwindow.slotsCount);
            this.mc.thePlayer.displayGUIChest(inventorybasic);
            this.mc.thePlayer.craftingInventory.windowId = packet100openwindow.windowId;
        } else if (packet100openwindow.inventoryType == 2) {
            TileEntityFurnace tileentityfurnace = new TileEntityFurnace();
            this.mc.thePlayer.displayGUIFurnace(tileentityfurnace);
            this.mc.thePlayer.craftingInventory.windowId = packet100openwindow.windowId;
        } else if (packet100openwindow.inventoryType == 3) {
            TileEntityDispenser tileentitydispenser = new TileEntityDispenser();
            this.mc.thePlayer.displayGUIDispenser(tileentitydispenser);
            this.mc.thePlayer.craftingInventory.windowId = packet100openwindow.windowId;
        } else if (packet100openwindow.inventoryType == 4) {
            TileEntityBlastFurnace tileentityblastfurnace = new TileEntityBlastFurnace();
            this.mc.thePlayer.displayGUIFurnace(tileentityblastfurnace);
            this.mc.thePlayer.craftingInventory.windowId = packet100openwindow.windowId;
        } else if (packet100openwindow.inventoryType == 5) {
            TileEntityTrommel tileentitytrommel = new TileEntityTrommel();
            this.mc.thePlayer.displayGUITrommel(tileentitytrommel);
            this.mc.thePlayer.craftingInventory.windowId = packet100openwindow.windowId;
        } else if (packet100openwindow.inventoryType == 6) {
            this.mc.thePlayer.displayGUIGuidebook();
            this.mc.thePlayer.craftingInventory.windowId = packet100openwindow.windowId;
        } else if (packet100openwindow.inventoryType == 1) {
            EntityPlayerSP entityplayersp = this.mc.thePlayer;
            this.mc.thePlayer.displayGUIWorkbench(MathHelper.floor_double(entityplayersp.posX), MathHelper.floor_double(entityplayersp.posY), MathHelper.floor_double(entityplayersp.posZ));
            this.mc.thePlayer.craftingInventory.windowId = packet100openwindow.windowId;
        }
    }

    @Override
    public void handleSetSlot(Packet103SetSlot packet103setslot) {
        if (packet103setslot.windowId == -1) {
            this.mc.thePlayer.inventory.setHeldItemStack(packet103setslot.myItemStack);
        } else if (packet103setslot.windowId == 0 && packet103setslot.itemSlot >= 36 && packet103setslot.itemSlot < 45) {
            ItemStack itemstack = this.mc.thePlayer.inventorySlots.getSlot(packet103setslot.itemSlot).getStack();
            if (packet103setslot.myItemStack != null && (itemstack == null || itemstack.stackSize < packet103setslot.myItemStack.stackSize)) {
                packet103setslot.myItemStack.animationsToGo = 5;
            }
            this.mc.thePlayer.inventorySlots.putStackInSlot(packet103setslot.itemSlot, packet103setslot.myItemStack);
        } else if (packet103setslot.windowId == this.mc.thePlayer.craftingInventory.windowId) {
            this.mc.thePlayer.craftingInventory.putStackInSlot(packet103setslot.itemSlot, packet103setslot.myItemStack);
        }
    }

    @Override
    public void handleTransaction(Packet106Transaction packet106transaction) {
        Container container = null;
        if (packet106transaction.windowId == 0) {
            container = this.mc.thePlayer.inventorySlots;
        } else if (packet106transaction.windowId == this.mc.thePlayer.craftingInventory.windowId) {
            container = this.mc.thePlayer.craftingInventory;
        }
        if (container != null) {
            if (packet106transaction.field_20030_c) {
                container.func_20113_a(packet106transaction.shortWindowId);
            } else {
                container.func_20110_b(packet106transaction.shortWindowId);
                this.addToSendQueue(new Packet106Transaction(packet106transaction.windowId, packet106transaction.shortWindowId, true));
            }
        }
    }

    @Override
    public void handleWindowItems(Packet104WindowItems packet104windowitems) {
        if (packet104windowitems.windowId == 0) {
            this.mc.thePlayer.inventorySlots.putStacksInSlots(packet104windowitems.itemStack);
        } else if (packet104windowitems.windowId == this.mc.thePlayer.craftingInventory.windowId) {
            this.mc.thePlayer.craftingInventory.putStacksInSlots(packet104windowitems.itemStack);
        }
    }

    @Override
    public void handleUpdateSign(Packet130UpdateSign packet130updatesign) {
        TileEntity tileentity;
        if (this.mc.theWorld.blockExists(packet130updatesign.xPosition, packet130updatesign.yPosition, packet130updatesign.zPosition) && (tileentity = this.mc.theWorld.getBlockTileEntity(packet130updatesign.xPosition, packet130updatesign.yPosition, packet130updatesign.zPosition)) instanceof TileEntitySign) {
            TileEntitySign tileentitysign = (TileEntitySign)tileentity;
            for (int i2 = 0; i2 < 4; ++i2) {
                tileentitysign.signText[i2] = packet130updatesign.signLines[i2];
            }
            tileentitysign.onInventoryChanged();
        }
    }

    @Override
    public void handleUpdateProgressbar(Packet105UpdateProgressbar packet105updateprogressbar) {
        this.handleInvalidPacket(packet105updateprogressbar);
        if (this.mc.thePlayer.craftingInventory != null && this.mc.thePlayer.craftingInventory.windowId == packet105updateprogressbar.windowId) {
            this.mc.thePlayer.craftingInventory.updateClientProgressBar(packet105updateprogressbar.progressBar, packet105updateprogressbar.progressBarValue);
        }
    }

    @Override
    public void handlePlayerInventory(Packet5PlayerInventory packet5playerinventory) {
        Entity entity = this.getEntityByID(packet5playerinventory.entityID);
        if (entity != null) {
            entity.outfitWithItem(packet5playerinventory.slot, packet5playerinventory.itemID, packet5playerinventory.itemDamage, packet5playerinventory.itemData);
        }
    }

    @Override
    public void handleCloseWindow(Packet101CloseWindow packet101closewindow) {
        this.mc.thePlayer.closeScreen();
    }

    @Override
    public void handlePlayNoteBlock(Packet54PlayNoteBlock packet54playnoteblock) {
        this.mc.theWorld.playNoteAt(packet54playnoteblock.xLocation, packet54playnoteblock.yLocation, packet54playnoteblock.zLocation, packet54playnoteblock.instrumentType, packet54playnoteblock.pitch);
    }

    @Override
    public void handleBed(Packet70Bed packet70bed) {
        int i2 = packet70bed.field_25019_b;
        if (i2 >= 0 && i2 < Packet70Bed.field_25020_a.length && Packet70Bed.field_25020_a[i2] != null) {
            this.mc.thePlayer.addChatMessage(Packet70Bed.field_25020_a[i2]);
        }
    }

    @Override
    public void handleMapData(Packet131MapData packet131mapdata) {
        if (packet131mapdata.field_28055_a == Item.map.itemID) {
            ItemMap.func_28013_a(packet131mapdata.field_28054_b, this.mc.theWorld).func_28173_a(packet131mapdata.field_28056_c);
        } else {
            System.out.println("Unknown itemid: " + packet131mapdata.field_28054_b);
        }
    }

    @Override
    public void handlePlaySoundEffect(Packet61PlaySoundEffect packet61playsoundeffect) {
        this.mc.theWorld.playSoundEffect(packet61playsoundeffect.soundID, packet61playsoundeffect.x, packet61playsoundeffect.y, packet61playsoundeffect.z, packet61playsoundeffect.data);
    }

    @Override
    public void handleStatistic(Packet200Statistic packet200statistic) {
        ((EntityClientPlayerMP)this.mc.thePlayer).func_27027_b(StatList.getStat(packet200statistic.field_27052_a), packet200statistic.field_27051_b);
    }

    @Override
    public void handleEntityPlayerGamemode(Packet41EntityPlayerGamemode packet) {
        this.mc.thePlayer.setGamemode(Gamemode.gamemodesList[packet.gamemodeId]);
    }

    @Override
    public void handleWorldTypes(Packet55WorldTypes packet55WorldTypes) {
        for (int i2 = 0; i2 < packet55WorldTypes.worldTypes.length; ++i2) {
            Dimension.dimensionList[i2].worldType = WorldType.worldTypes[packet55WorldTypes.worldTypes[i2]];
        }
    }

    @Override
    public void handleEntityNickname(Packet35EntityNickname packet35EntityNickname) {
        Entity entity = this.getEntityByID(packet35EntityNickname.entityId);
        if (entity instanceof EntityLiving) {
            ((EntityLiving)entity).nickname = packet35EntityNickname.nickname;
            ((EntityLiving)entity).chatColor = packet35EntityNickname.chatColor;
        }
    }

    @Override
    public boolean isServerHandler() {
        return false;
    }
}

