/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.minecraft.server.MinecraftServer;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.ChatAllowedCharacters;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.ContainerPlayerCreative;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityPlayerMP;
import net.minecraft.src.ICommandListener;
import net.minecraft.src.InventoryPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.NetHandler;
import net.minecraft.src.NetworkManager;
import net.minecraft.src.Packet;
import net.minecraft.src.Packet0KeepAlive;
import net.minecraft.src.Packet101CloseWindow;
import net.minecraft.src.Packet102WindowClick;
import net.minecraft.src.Packet103SetSlot;
import net.minecraft.src.Packet106Transaction;
import net.minecraft.src.Packet107UpdateCreativeInventory;
import net.minecraft.src.Packet108SetHotbarOffset;
import net.minecraft.src.Packet10Flying;
import net.minecraft.src.Packet130UpdateSign;
import net.minecraft.src.Packet133OpenGuidebook;
import net.minecraft.src.Packet134ItemData;
import net.minecraft.src.Packet135PlacementMode;
import net.minecraft.src.Packet13PlayerLookMove;
import net.minecraft.src.Packet14BlockDig;
import net.minecraft.src.Packet15Place;
import net.minecraft.src.Packet16BlockItemSwitch;
import net.minecraft.src.Packet18Animation;
import net.minecraft.src.Packet19EntityAction;
import net.minecraft.src.Packet255KickDisconnect;
import net.minecraft.src.Packet27Position;
import net.minecraft.src.Packet3Chat;
import net.minecraft.src.Packet51MapChunk;
import net.minecraft.src.Packet53BlockChange;
import net.minecraft.src.Packet56RequestChunk;
import net.minecraft.src.Packet72UpdatePlayerProfile;
import net.minecraft.src.Packet7UseEntity;
import net.minecraft.src.Packet9Respawn;
import net.minecraft.src.Slot;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntitySign;
import net.minecraft.src.Vec3D;
import net.minecraft.src.WorldServer;
import net.minecraft.src.command.ChatColor;
import net.minecraft.src.command.Command;
import net.minecraft.src.command.CommandError;
import net.minecraft.src.command.Commands;
import net.minecraft.src.command.PlayerCommandSender;
import net.minecraft.src.command.ServerCommandHandler;
import net.minecraft.src.command.ServerPlayerCommandSender;

public class NetServerHandler
extends NetHandler
implements ICommandListener {
    public static Logger logger = Logger.getLogger("Minecraft");
    public NetworkManager netManager;
    public boolean connectionClosed = false;
    private MinecraftServer mcServer;
    private EntityPlayerMP playerEntity;
    private int field_15_f;
    private int field_22004_g;
    private int playerInAirTime;
    private boolean field_22003_h;
    private double lastPosX;
    private double lastPosY;
    private double lastPosZ;
    private boolean hasMoved = true;
    private Map field_10_k = new HashMap();

    public NetServerHandler(MinecraftServer minecraftserver, NetworkManager networkmanager, EntityPlayerMP entityplayermp) {
        this.mcServer = minecraftserver;
        this.netManager = networkmanager;
        networkmanager.setNetHandler(this);
        this.playerEntity = entityplayermp;
        entityplayermp.playerNetServerHandler = this;
    }

    public void handlePackets() {
        this.field_22003_h = false;
        this.netManager.processReadPackets();
        if (this.field_15_f - this.field_22004_g > 20) {
            this.sendPacket(new Packet0KeepAlive());
        }
    }

    public void kickPlayer(String s2) {
        this.playerEntity.func_30002_A();
        this.sendPacket(new Packet255KickDisconnect(s2));
        this.netManager.serverShutdown();
        this.mcServer.configManager.sendPacketToAllPlayers(new Packet3Chat(this.playerEntity.getDisplayName() + ChatColor.yellow + " was kicked from the game."));
        this.mcServer.configManager.sendPacketToAllPlayers(new Packet72UpdatePlayerProfile(this.playerEntity.username, this.playerEntity.nickname, this.playerEntity.score, this.playerEntity.chatColor, false, this.playerEntity.isOperator()));
        this.mcServer.configManager.playerLoggedOut(this.playerEntity);
        this.connectionClosed = true;
    }

    public void handleMovementTypePacket(Packet27Position packet27position) {
        this.playerEntity.setMovementType(packet27position.func_22031_c(), packet27position.func_22028_e(), packet27position.func_22032_g(), packet27position.func_22030_h(), packet27position.func_22029_d(), packet27position.func_22033_f());
    }

    @Override
    public void handleFlying(Packet10Flying packet10flying) {
        WorldServer worldserver = this.mcServer.getWorldManager(this.playerEntity.dimension);
        this.field_22003_h = true;
        if (!this.hasMoved) {
            double d2 = packet10flying.yPosition - this.lastPosY;
            if (packet10flying.xPosition == this.lastPosX && d2 * d2 < 0.01 && packet10flying.zPosition == this.lastPosZ) {
                this.hasMoved = true;
            }
        }
        if (this.hasMoved) {
            boolean flag2;
            if (this.playerEntity.ridingEntity != null) {
                float f2 = this.playerEntity.rotationYaw;
                float f1 = this.playerEntity.rotationPitch;
                this.playerEntity.ridingEntity.updateRiderPosition();
                double d2 = this.playerEntity.posX;
                double d4 = this.playerEntity.posY;
                double d6 = this.playerEntity.posZ;
                double d8 = 0.0;
                double d9 = 0.0;
                if (packet10flying.rotating) {
                    f2 = packet10flying.yaw;
                    f1 = packet10flying.pitch;
                }
                if (packet10flying.moving && packet10flying.yPosition == -999.0 && packet10flying.stance == -999.0) {
                    d8 = packet10flying.xPosition;
                    d9 = packet10flying.zPosition;
                }
                this.playerEntity.onGround = packet10flying.onGround;
                this.playerEntity.onUpdateEntity(true);
                this.playerEntity.moveEntity(d8, 0.0, d9);
                this.playerEntity.setPositionAndRotation(d2, d4, d6, f2, f1);
                this.playerEntity.motionX = d8;
                this.playerEntity.motionZ = d9;
                if (this.playerEntity.ridingEntity != null) {
                    worldserver.func_12017_b(this.playerEntity.ridingEntity, true);
                }
                if (this.playerEntity.ridingEntity != null) {
                    this.playerEntity.ridingEntity.updateRiderPosition();
                }
                this.mcServer.configManager.func_613_b(this.playerEntity);
                this.lastPosX = this.playerEntity.posX;
                this.lastPosY = this.playerEntity.posY;
                this.lastPosZ = this.playerEntity.posZ;
                worldserver.updateEntity(this.playerEntity);
                return;
            }
            if (this.playerEntity.isPlayerSleeping()) {
                this.playerEntity.onUpdateEntity(true);
                this.playerEntity.setPositionAndRotation(this.lastPosX, this.lastPosY, this.lastPosZ, this.playerEntity.rotationYaw, this.playerEntity.rotationPitch);
                worldserver.updateEntity(this.playerEntity);
                return;
            }
            double d1 = this.playerEntity.posY;
            this.lastPosX = this.playerEntity.posX;
            this.lastPosY = this.playerEntity.posY;
            this.lastPosZ = this.playerEntity.posZ;
            double newPosX = this.playerEntity.posX;
            double newPosY = this.playerEntity.posY;
            double newPosZ = this.playerEntity.posZ;
            float f2 = this.playerEntity.rotationYaw;
            float f3 = this.playerEntity.rotationPitch;
            if (packet10flying.moving && packet10flying.yPosition == -999.0 && packet10flying.stance == -999.0) {
                packet10flying.moving = false;
            }
            if (packet10flying.moving && packet10flying.yPosition == -999.0 && packet10flying.stance == -999.0) {
                packet10flying.moving = false;
            }
            if (packet10flying.moving) {
                newPosX = packet10flying.xPosition;
                newPosY = packet10flying.yPosition;
                newPosZ = packet10flying.zPosition;
                double d10 = packet10flying.stance - packet10flying.yPosition;
                if (!this.playerEntity.isPlayerSleeping() && (d10 > 1.65 || d10 < 0.1)) {
                    this.kickPlayer("Illegal stance");
                    logger.warning(this.playerEntity.username + " had an illegal stance: " + d10);
                    return;
                }
                if (Math.abs(packet10flying.xPosition) > 3.2E7 || Math.abs(packet10flying.zPosition) > 3.2E7) {
                    this.kickPlayer("Illegal position");
                    return;
                }
            }
            if (packet10flying.rotating) {
                f2 = packet10flying.yaw;
                f3 = packet10flying.pitch;
            }
            this.playerEntity.onUpdateEntity(true);
            this.playerEntity.ySize = 0.0f;
            this.playerEntity.setPositionAndRotation(this.lastPosX, this.lastPosY, this.lastPosZ, f2, f3);
            if (!this.hasMoved) {
                return;
            }
            double dx2 = newPosX - this.playerEntity.posX;
            double dy2 = newPosY - this.playerEntity.posY;
            double dz2 = newPosZ - this.playerEntity.posZ;
            double d14 = dx2 * dx2 + dy2 * dy2 + dz2 * dz2;
            if (d14 > 100.0) {
                logger.warning(this.playerEntity.username + " moved too quickly!");
                this.kickPlayer("You moved too quickly :( (Hacking?)");
                return;
            }
            float f4 = 0.0625f;
            boolean flag = worldserver.getCollidingBoundingBoxes(this.playerEntity, this.playerEntity.boundingBox.copy().getInsetBoundingBox(f4, f4, f4)).size() == 0;
            this.playerEntity.moveEntity(dx2, dy2, dz2);
            dx2 = newPosX - this.playerEntity.posX;
            dy2 = newPosY - this.playerEntity.posY;
            if (dy2 > -0.5 || dy2 < 0.5) {
                dy2 = 0.0;
            }
            dz2 = newPosZ - this.playerEntity.posZ;
            d14 = dx2 * dx2 + dy2 * dy2 + dz2 * dz2;
            boolean flag1 = false;
            if (!this.playerEntity.getGamemode().canPlayerFly && d14 > 0.0625 && !this.playerEntity.isPlayerSleeping()) {
                flag1 = true;
                logger.warning(this.playerEntity.username + " moved wrongly!");
                System.out.println("Got position " + newPosX + ", " + newPosY + ", " + newPosZ);
                System.out.println("Expected " + this.playerEntity.posX + ", " + this.playerEntity.posY + ", " + this.playerEntity.posZ);
            }
            this.playerEntity.setPositionAndRotation(newPosX, newPosY, newPosZ, f2, f3);
            boolean bl2 = flag2 = worldserver.getCollidingBoundingBoxes(this.playerEntity, this.playerEntity.boundingBox.copy().getInsetBoundingBox(f4, f4, f4)).size() == 0;
            if (!(this.playerEntity.getGamemode().canPlayerFly || !flag || !flag1 && flag2 || this.playerEntity.isPlayerSleeping())) {
                this.teleportTo(this.lastPosX, this.lastPosY, this.lastPosZ, f2, f3);
                return;
            }
            AxisAlignedBB axisalignedbb = this.playerEntity.boundingBox.copy().expand(f4, f4, f4).addCoord(0.0, -0.55, 0.0);
            if (!(this.playerEntity.getGamemode().canPlayerFly || this.mcServer.allowFlight || worldserver.getIsAnyBlock(axisalignedbb))) {
                if (dy2 > -0.03125) {
                    ++this.playerInAirTime;
                    if (this.playerInAirTime > 80) {
                        logger.warning(this.playerEntity.username + " was kicked for floating too long!");
                        this.kickPlayer("Flying is not enabled on this server");
                        return;
                    }
                }
            } else {
                this.playerInAirTime = 0;
            }
            this.playerEntity.onGround = packet10flying.onGround;
            this.mcServer.configManager.func_613_b(this.playerEntity);
            this.playerEntity.handleFalling(this.playerEntity.posY - d1, packet10flying.onGround);
        }
    }

    public void teleportTo(double d2, double d1, double d22, float f2, float f1) {
        this.hasMoved = false;
        this.lastPosX = d2;
        this.lastPosY = d1;
        this.lastPosZ = d22;
        this.playerEntity.setPositionAndRotation(d2, d1, d22, f2, f1);
        this.playerEntity.playerNetServerHandler.sendPacket(new Packet13PlayerLookMove(d2, d1 + 1.625, d1, d22, f2, f1, false));
    }

    @Override
    public void handleBlockDig(Packet14BlockDig packet14blockdig) {
        int ChunkDistanceFromSpawn;
        double d3;
        double d1;
        double d2;
        double d5;
        WorldServer worldserver = this.mcServer.getWorldManager(this.playerEntity.dimension);
        if (packet14blockdig.status == 4) {
            this.playerEntity.dropCurrentItem();
            return;
        }
        worldserver.field_819_z = worldserver.dimension.dimId != 0 || this.mcServer.configManager.isOp(this.playerEntity.username);
        boolean opOrNotInOverworld = worldserver.field_819_z;
        boolean flag1 = false;
        if (packet14blockdig.status == 0) {
            flag1 = true;
        }
        if (packet14blockdig.status == 2) {
            flag1 = true;
        }
        int i2 = packet14blockdig.xPosition;
        int j2 = packet14blockdig.yPosition;
        int k2 = packet14blockdig.zPosition;
        if (flag1 && (d5 = (d2 = this.playerEntity.posX - ((double)i2 + 0.5)) * d2 + (d1 = this.playerEntity.posY - ((double)j2 + 0.5)) * d1 + (d3 = this.playerEntity.posZ - ((double)k2 + 0.5)) * d3) > 36.0) {
            return;
        }
        ChunkCoordinates chunkcoordinates = worldserver.getSpawnPoint();
        int l2 = (int)MathHelper.abs(i2 - chunkcoordinates.x);
        if (l2 > (ChunkDistanceFromSpawn = (int)MathHelper.abs(k2 - chunkcoordinates.z))) {
            ChunkDistanceFromSpawn = l2;
        }
        if (packet14blockdig.status == 0) {
            if (ChunkDistanceFromSpawn > this.mcServer.spawnProtectionRange || opOrNotInOverworld) {
                this.playerEntity.itemInWorldManager.func_324_a(i2, j2, k2, packet14blockdig.face);
            } else {
                this.playerEntity.playerNetServerHandler.sendPacket(new Packet53BlockChange(i2, j2, k2, worldserver));
            }
        } else if (packet14blockdig.status == 2) {
            this.playerEntity.itemInWorldManager.func_22045_b(i2, j2, k2);
            if (worldserver.getBlockId(i2, j2, k2) != 0) {
                this.playerEntity.playerNetServerHandler.sendPacket(new Packet53BlockChange(i2, j2, k2, worldserver));
            }
        } else if (packet14blockdig.status == 3) {
            double d22 = this.playerEntity.posX - ((double)i2 + 0.5);
            double d4 = this.playerEntity.posY - ((double)j2 + 0.5);
            double d6 = this.playerEntity.posZ - ((double)k2 + 0.5);
            double d7 = d22 * d22 + d4 * d4 + d6 * d6;
            if (d7 < 256.0) {
                this.playerEntity.playerNetServerHandler.sendPacket(new Packet53BlockChange(i2, j2, k2, worldserver));
            }
        } else if (packet14blockdig.status == 1) {
            this.playerEntity.middleClickBlock(packet14blockdig.xPosition, packet14blockdig.yPosition, packet14blockdig.zPosition);
        }
        worldserver.field_819_z = false;
    }

    public void handleSendInitialPlayerList() {
        for (EntityPlayerMP entityPlayerMP : this.mcServer.configManager.playerEntities) {
            this.sendPacket(new Packet72UpdatePlayerProfile(entityPlayerMP.username, entityPlayerMP.nickname, entityPlayerMP.score, entityPlayerMP.chatColor, true, entityPlayerMP.isOperator()));
        }
    }

    @Override
    public void handlePlace(Packet15Place packet15place) {
        WorldServer worldserver = this.mcServer.getWorldManager(this.playerEntity.dimension);
        ItemStack itemstack = this.playerEntity.inventory.getCurrentItem();
        worldserver.field_819_z = worldserver.dimension.dimId != 0 || this.mcServer.configManager.isOp(this.playerEntity.username);
        boolean flag = worldserver.field_819_z;
        if (packet15place.direction == 255) {
            if (itemstack == null) {
                return;
            }
            this.playerEntity.itemInWorldManager.func_6154_a(this.playerEntity, worldserver, itemstack);
        } else {
            int j1;
            int i2 = packet15place.xPosition;
            int j2 = packet15place.yPosition;
            int k2 = packet15place.zPosition;
            int l2 = packet15place.direction;
            double heightPlaced = packet15place.heightPlaced;
            ChunkCoordinates chunkcoordinates = worldserver.getSpawnPoint();
            int i1 = (int)MathHelper.abs(i2 - chunkcoordinates.x);
            if (i1 > (j1 = (int)MathHelper.abs(k2 - chunkcoordinates.z))) {
                j1 = i1;
            }
            if (this.hasMoved && this.playerEntity.getDistanceSq((double)i2 + 0.5, (double)j2 + 0.5, (double)k2 + 0.5) < 64.0 && (j1 > this.mcServer.spawnProtectionRange || flag)) {
                this.playerEntity.itemInWorldManager.activeBlockOrUseItem(this.playerEntity, worldserver, itemstack, i2, j2, k2, l2, heightPlaced);
            }
            this.playerEntity.playerNetServerHandler.sendPacket(new Packet53BlockChange(i2, j2, k2, worldserver));
            if (l2 == 0) {
                --j2;
            }
            if (l2 == 1) {
                ++j2;
            }
            if (l2 == 2) {
                --k2;
            }
            if (l2 == 3) {
                ++k2;
            }
            if (l2 == 4) {
                --i2;
            }
            if (l2 == 5) {
                ++i2;
            }
            this.playerEntity.playerNetServerHandler.sendPacket(new Packet53BlockChange(i2, j2, k2, worldserver));
        }
        itemstack = this.playerEntity.inventory.getCurrentItem();
        if (itemstack != null && itemstack.stackSize == 0) {
            this.playerEntity.inventory.mainInventory[this.playerEntity.inventory.currentItem] = null;
        }
        this.playerEntity.isChangingQuantityOnly = true;
        this.playerEntity.inventory.mainInventory[this.playerEntity.inventory.currentItem] = ItemStack.copyItemStack(this.playerEntity.inventory.mainInventory[this.playerEntity.inventory.currentItem]);
        Slot slot = this.playerEntity.craftingInventory.func_20127_a(this.playerEntity.inventory, this.playerEntity.inventory.currentItem);
        this.playerEntity.craftingInventory.updateInventory();
        this.playerEntity.isChangingQuantityOnly = false;
        if (!ItemStack.areItemStacksEqual(this.playerEntity.inventory.getCurrentItem(), packet15place.itemStack)) {
            this.sendPacket(new Packet103SetSlot(this.playerEntity.craftingInventory.windowId, slot.id, this.playerEntity.inventory.getCurrentItem()));
        }
        worldserver.field_819_z = false;
    }

    @Override
    public void handleErrorMessage(String s2, Object[] aobj) {
        logger.info(this.playerEntity.username + " lost connection: " + s2);
        this.mcServer.configManager.sendPacketToAllPlayers(new Packet3Chat(this.playerEntity.getDisplayName() + ChatColor.yellow + " left the game."));
        this.mcServer.configManager.sendPacketToAllPlayers(new Packet72UpdatePlayerProfile(this.playerEntity.username, this.playerEntity.nickname, this.playerEntity.score, this.playerEntity.chatColor, false, this.playerEntity.isOperator()));
        this.mcServer.configManager.playerLoggedOut(this.playerEntity);
        this.connectionClosed = true;
    }

    @Override
    public void handleInvalidPacket(Packet packet) {
        logger.warning(this.getClass() + " wasn't prepared to deal with a " + packet.getClass());
        this.kickPlayer("Protocol error, unexpected packet");
    }

    public void sendPacket(Packet packet) {
        this.netManager.addToSendQueue(packet);
        this.field_22004_g = this.field_15_f;
    }

    @Override
    public void handleBlockItemSwitch(Packet16BlockItemSwitch packet16blockitemswitch) {
        if (packet16blockitemswitch.id < 0 || packet16blockitemswitch.id > InventoryPlayer.func_25054_e()) {
            logger.warning(this.playerEntity.username + " tried to set an invalid carried item");
            return;
        }
        this.playerEntity.inventory.currentItem = packet16blockitemswitch.id;
    }

    @Override
    public void handleChat(Packet3Chat packet3chat) {
        String s2 = packet3chat.message;
        if (s2.length() > 100) {
            this.kickPlayer("Chat message too long");
            return;
        }
        s2 = s2.trim();
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            if (ChatAllowedCharacters.allowedCharacters.indexOf(s2.charAt(i2)) >= 0) continue;
            this.kickPlayer("Illegal characters in chat");
            return;
        }
        if (s2.startsWith("/")) {
            this.handleSlashCommand(s2);
        } else {
            s2 = "<" + this.playerEntity.getDisplayName() + ChatColor.white + "> " + s2;
            logger.info(s2);
            this.mcServer.configManager.sendPacketToAllPlayers(new Packet3Chat(s2));
        }
    }

    private void handleSlashCommand(String s2) {
        ServerPlayerCommandSender sender = new ServerPlayerCommandSender(this.mcServer, this.playerEntity);
        ServerCommandHandler handler = new ServerCommandHandler(this.mcServer);
        String[] args = s2.substring(1).split(" ");
        String[] args1 = new String[args.length - 1];
        System.arraycopy(args, 1, args1, 0, args.length - 1);
        for (Command command : Commands.commands) {
            if (!command.isName(args[0])) continue;
            if (!sender.isAdmin() && command.opRequired(args1)) {
                logger.info("Player " + ((PlayerCommandSender)sender).getPlayer().username + " tried command: " + s2);
                sender.sendMessage(ChatColor.red + "You don't have permission to use this command!");
                return;
            }
            logger.info("Player " + ((PlayerCommandSender)sender).getPlayer().username + " used command: " + s2);
            try {
                boolean success = command.execute(handler, sender, args1);
                if (!success) {
                    command.sendCommandSyntax(handler, sender);
                }
            }
            catch (CommandError e2) {
                sender.sendMessage(ChatColor.red + e2.getMessage());
            }
            catch (Throwable e3) {
                sender.sendMessage(ChatColor.red + "Error!");
            }
            return;
        }
        if (s2.toLowerCase().startsWith("/kill")) {
            this.playerEntity.attackEntityFrom(null, 1000, null);
        } else if (s2.equalsIgnoreCase("/online")) {
            String playerList = "";
            for (int i2 = 0; i2 < this.mcServer.configManager.playerEntities.size(); ++i2) {
                if (i2 > 0) {
                    playerList = playerList + ",";
                }
                EntityPlayerMP entityplayermp = this.mcServer.configManager.playerEntities.get(i2);
                playerList = playerList + (entityplayermp.getDisplayName() + ": " + ChatColor.yellow + (entityplayermp.score + "pts" + ChatColor.white));
            }
            logger.info(s2);
            this.sendPacket(new Packet3Chat(playerList));
        } else if (this.mcServer.configManager.isOp(this.playerEntity.username)) {
            String s1 = s2.substring(1);
            logger.info(this.playerEntity.username + " issued server command: " + s1);
            this.mcServer.addCommand(s1, this);
        } else {
            String s22 = s2.substring(1);
            logger.info(this.playerEntity.username + " tried command: " + s22);
        }
    }

    @Override
    public void handleAnimation(Packet18Animation packet18animation) {
        if (packet18animation.animate == 1) {
            this.playerEntity.swingItem();
        }
    }

    @Override
    public void handleEntityAction(Packet19EntityAction packet19entityaction) {
        if (packet19entityaction.state == 1) {
            this.playerEntity.setSneaking(true);
        } else if (packet19entityaction.state == 2) {
            this.playerEntity.setSneaking(false);
        } else if (packet19entityaction.state == 3) {
            this.playerEntity.wakeUpPlayer(false, true);
            this.hasMoved = false;
        }
    }

    @Override
    public void handleKickDisconnect(Packet255KickDisconnect packet255kickdisconnect) {
        this.netManager.networkShutdown("disconnect.quitting", new Object[0]);
    }

    public int getNumChunkDataPackets() {
        return this.netManager.getNumChunkDataPackets();
    }

    @Override
    public void log(String s2) {
        this.sendPacket(new Packet3Chat("\u00a77" + s2));
    }

    @Override
    public String getUsername() {
        return this.playerEntity.username;
    }

    @Override
    public void handleUseEntity(Packet7UseEntity packet7useentity) {
        WorldServer worldserver = this.mcServer.getWorldManager(this.playerEntity.dimension);
        Entity targetEntity = worldserver.func_6158_a(packet7useentity.targetEntity);
        if (targetEntity != null && this.playerEntity.getDistanceSqToEntity(targetEntity) < 36.0) {
            boolean canAttack = this.playerEntity.canEntityBeSeen(targetEntity);
            if (!canAttack) {
                float f1 = MathHelper.cos(-this.playerEntity.rotationYaw * 0.01745329f - 3.141593f);
                float f2 = MathHelper.sin(-this.playerEntity.rotationYaw * 0.01745329f - 3.141593f);
                float f3 = -MathHelper.cos(-this.playerEntity.rotationPitch * 0.01745329f);
                float f4 = MathHelper.sin(-this.playerEntity.rotationPitch * 0.01745329f);
                Vec3D viewVector = Vec3D.createVector(f2 * f3, f4, f1 * f3);
                viewVector.xCoord *= 8.0;
                viewVector.yCoord *= 8.0;
                viewVector.zCoord *= 8.0;
                viewVector.xCoord += this.playerEntity.posX;
                viewVector.yCoord += this.playerEntity.posY;
                viewVector.zCoord += this.playerEntity.posZ;
                Vec3D playerViewPos = Vec3D.createVector(this.playerEntity.posX, this.playerEntity.posY + (double)this.playerEntity.getEyeHeight(), this.playerEntity.posZ);
                MovingObjectPosition movingObjectPosition = targetEntity.boundingBox.func_1169_a(playerViewPos, viewVector);
                boolean bl2 = canAttack = movingObjectPosition != null && worldserver.rayTraceBlocks(playerViewPos, movingObjectPosition.hitVec) == null;
            }
            if (canAttack) {
                if (packet7useentity.isLeftClick == 0) {
                    this.playerEntity.useCurrentItemOnEntity(targetEntity);
                } else if (packet7useentity.isLeftClick == 1) {
                    this.playerEntity.attackTargetEntityWithCurrentItem(targetEntity);
                }
            }
        }
    }

    @Override
    public void handleOpenGuidebook(Packet133OpenGuidebook packet133OpenGuidebook) {
        this.playerEntity.displayGUIGuidebook();
    }

    @Override
    public void handleRespawn(Packet9Respawn packet9respawn) {
        if (this.playerEntity.health > 0) {
            return;
        }
        this.playerEntity = this.mcServer.configManager.recreatePlayerEntity(this.playerEntity, 0);
    }

    @Override
    public void handleCloseWindow(Packet101CloseWindow packet101closewindow) {
        this.playerEntity.closeCraftingGui();
    }

    @Override
    public void handleWindowClick(Packet102WindowClick p2) {
        if (this.playerEntity.craftingInventory.windowId == p2.window_Id && this.playerEntity.craftingInventory.getCanCraft(this.playerEntity)) {
            ItemStack itemstack = this.playerEntity.craftingInventory.clickInventorySlot(p2.inventorySlot, p2.mouseClick, p2.shift, p2.control, this.playerEntity);
            if (ItemStack.areItemStacksEqual(p2.itemStack, itemstack)) {
                this.playerEntity.playerNetServerHandler.sendPacket(new Packet106Transaction(p2.window_Id, p2.action, true));
                this.playerEntity.isChangingQuantityOnly = true;
                this.playerEntity.craftingInventory.updateInventory();
                this.playerEntity.updateHeldItem();
                this.playerEntity.isChangingQuantityOnly = false;
            } else {
                this.field_10_k.put(this.playerEntity.craftingInventory.windowId, p2.action);
                this.playerEntity.playerNetServerHandler.sendPacket(new Packet106Transaction(p2.window_Id, p2.action, false));
                this.playerEntity.craftingInventory.setCanCraft(this.playerEntity, false);
                ArrayList<ItemStack> arraylist = new ArrayList<ItemStack>();
                for (int i2 = 0; i2 < this.playerEntity.craftingInventory.inventorySlots.size(); ++i2) {
                    arraylist.add(this.playerEntity.craftingInventory.inventorySlots.get(i2).getStack());
                }
                this.playerEntity.updateCraftingInventory(this.playerEntity.craftingInventory, arraylist);
            }
        }
    }

    @Override
    public void handleTransaction(Packet106Transaction packet106transaction) {
        Short short1 = (Short)this.field_10_k.get(this.playerEntity.craftingInventory.windowId);
        if (short1 != null && packet106transaction.shortWindowId == short1 && this.playerEntity.craftingInventory.windowId == packet106transaction.windowId && !this.playerEntity.craftingInventory.getCanCraft(this.playerEntity)) {
            this.playerEntity.craftingInventory.setCanCraft(this.playerEntity, true);
        }
    }

    @Override
    public void handleUpdateSign(Packet130UpdateSign packet130updatesign) {
        WorldServer worldserver = this.mcServer.getWorldManager(this.playerEntity.dimension);
        if (worldserver.blockExists(packet130updatesign.xPosition, packet130updatesign.yPosition, packet130updatesign.zPosition)) {
            TileEntitySign tileentitysign;
            TileEntity tileentity = worldserver.getBlockTileEntity(packet130updatesign.xPosition, packet130updatesign.yPosition, packet130updatesign.zPosition);
            if (tileentity instanceof TileEntitySign && !(tileentitysign = (TileEntitySign)tileentity).getIsEditable()) {
                this.mcServer.logWarning("Player " + this.playerEntity.username + " just tried to change non-editable sign");
                return;
            }
            for (int i2 = 0; i2 < 4; ++i2) {
                boolean flag = true;
                if (packet130updatesign.signLines[i2].length() > 15) {
                    flag = false;
                } else {
                    for (int l2 = 0; l2 < packet130updatesign.signLines[i2].length(); ++l2) {
                        if (ChatAllowedCharacters.allowedCharacters.indexOf(packet130updatesign.signLines[i2].charAt(l2)) >= 0) continue;
                        flag = false;
                    }
                }
                if (flag) continue;
                packet130updatesign.signLines[i2] = "!?";
            }
            if (tileentity instanceof TileEntitySign) {
                int j2 = packet130updatesign.xPosition;
                int k2 = packet130updatesign.yPosition;
                int i1 = packet130updatesign.zPosition;
                TileEntitySign tileentitysign1 = (TileEntitySign)tileentity;
                for (int j1 = 0; j1 < 4; ++j1) {
                    tileentitysign1.signText[j1] = packet130updatesign.signLines[j1];
                }
                tileentitysign1.setIsEditable(false);
                tileentitysign1.onInventoryChanged();
                worldserver.markBlockNeedsUpdate(j2, k2, i1);
            }
        }
    }

    @Override
    public void handleUpdateCreativeInventory(Packet107UpdateCreativeInventory packet) {
        if (this.playerEntity.craftingInventory.windowId == packet.windowId && this.playerEntity.craftingInventory instanceof ContainerPlayerCreative) {
            ((ContainerPlayerCreative)this.playerEntity.craftingInventory).setInventoryStatus(packet.page, packet.searchText);
        }
    }

    @Override
    public void handleSetHotbarOffset(Packet108SetHotbarOffset packet108SetHotbarOffset) {
        this.playerEntity.inventory.hotbarOffset = packet108SetHotbarOffset.hotbarOffset;
    }

    @Override
    public void handleItemData(Packet134ItemData packet134itemdata) {
        this.playerEntity.inventory.getStackInSlot((int)packet134itemdata.slot).tag = packet134itemdata.tag;
    }

    @Override
    public void handleRequestChunk(Packet56RequestChunk packet56requestchunk) {
        Packet51MapChunk packet = new Packet51MapChunk(packet56requestchunk.chunkX * 16, 0, packet56requestchunk.chunkZ * 16, 16, Minecraft.WORLD_HEIGHT_BLOCKS, 16, this.mcServer.getWorldManager(this.playerEntity.dimension));
        this.sendPacket(packet);
    }

    @Override
    public void handlePlacementMode(Packet135PlacementMode packet) {
        this.playerEntity.rotationLock = packet.rotation;
        this.playerEntity.rotationLockHorizontal = packet.rotationHorizontal;
        this.playerEntity.rotationLockVertical = packet.rotationVertical;
        this.playerEntity.placementMode = packet.placementMode;
    }

    @Override
    public boolean isServerHandler() {
        return true;
    }
}

