/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NetHandler;
import net.minecraft.src.Packet0KeepAlive;
import net.minecraft.src.Packet100OpenWindow;
import net.minecraft.src.Packet101CloseWindow;
import net.minecraft.src.Packet102WindowClick;
import net.minecraft.src.Packet103SetSlot;
import net.minecraft.src.Packet104WindowItems;
import net.minecraft.src.Packet105UpdateProgressbar;
import net.minecraft.src.Packet106Transaction;
import net.minecraft.src.Packet107UpdateCreativeInventory;
import net.minecraft.src.Packet108SetHotbarOffset;
import net.minecraft.src.Packet10Flying;
import net.minecraft.src.Packet11PlayerPosition;
import net.minecraft.src.Packet12PlayerLook;
import net.minecraft.src.Packet130UpdateSign;
import net.minecraft.src.Packet131MapData;
import net.minecraft.src.Packet132SetMobSpawner;
import net.minecraft.src.Packet133OpenGuidebook;
import net.minecraft.src.Packet134ItemData;
import net.minecraft.src.Packet135PlacementMode;
import net.minecraft.src.Packet13PlayerLookMove;
import net.minecraft.src.Packet14BlockDig;
import net.minecraft.src.Packet15Place;
import net.minecraft.src.Packet16BlockItemSwitch;
import net.minecraft.src.Packet17Sleep;
import net.minecraft.src.Packet18Animation;
import net.minecraft.src.Packet19EntityAction;
import net.minecraft.src.Packet1Login;
import net.minecraft.src.Packet200Statistic;
import net.minecraft.src.Packet20NamedEntitySpawn;
import net.minecraft.src.Packet21PickupSpawn;
import net.minecraft.src.Packet22Collect;
import net.minecraft.src.Packet23VehicleSpawn;
import net.minecraft.src.Packet24MobSpawn;
import net.minecraft.src.Packet255KickDisconnect;
import net.minecraft.src.Packet25EntityPainting;
import net.minecraft.src.Packet27Position;
import net.minecraft.src.Packet28EntityVelocity;
import net.minecraft.src.Packet29DestroyEntity;
import net.minecraft.src.Packet2Handshake;
import net.minecraft.src.Packet30Entity;
import net.minecraft.src.Packet31RelEntityMove;
import net.minecraft.src.Packet32EntityLook;
import net.minecraft.src.Packet33RelEntityMoveLook;
import net.minecraft.src.Packet34EntityTeleport;
import net.minecraft.src.Packet35EntityNickname;
import net.minecraft.src.Packet38EntityStatus;
import net.minecraft.src.Packet39AttachEntity;
import net.minecraft.src.Packet3Chat;
import net.minecraft.src.Packet40EntityMetadata;
import net.minecraft.src.Packet41EntityPlayerGamemode;
import net.minecraft.src.Packet4UpdateTime;
import net.minecraft.src.Packet50PreChunk;
import net.minecraft.src.Packet51MapChunk;
import net.minecraft.src.Packet52MultiBlockChange;
import net.minecraft.src.Packet53BlockChange;
import net.minecraft.src.Packet54PlayNoteBlock;
import net.minecraft.src.Packet55WorldTypes;
import net.minecraft.src.Packet56RequestChunk;
import net.minecraft.src.Packet5PlayerInventory;
import net.minecraft.src.Packet60Explosion;
import net.minecraft.src.Packet61PlaySoundEffect;
import net.minecraft.src.Packet6SpawnPosition;
import net.minecraft.src.Packet70Bed;
import net.minecraft.src.Packet71Weather;
import net.minecraft.src.Packet72UpdatePlayerProfile;
import net.minecraft.src.Packet73WeatherStatus;
import net.minecraft.src.Packet7UseEntity;
import net.minecraft.src.Packet8UpdateHealth;
import net.minecraft.src.Packet9Respawn;
import net.minecraft.src.PacketCounter;

public abstract class Packet {
    private static Map packetIdToClassMap = new HashMap();
    private static Map packetClassToIdMap = new HashMap();
    private static Set clientPacketIdList = new HashSet();
    private static Set serverPacketIdList = new HashSet();
    public final long creationTimeMillis = System.currentTimeMillis();
    public boolean isChunkDataPacket = false;
    private static HashMap packetStats = new HashMap();
    private static int totalPacketsCount = 0;

    static void addIdClassMapping(int i2, boolean clientPacket, boolean serverPacket, Class class1) {
        if (packetIdToClassMap.containsKey(i2)) {
            throw new IllegalArgumentException("Duplicate packet id:" + i2);
        }
        if (packetClassToIdMap.containsKey(class1)) {
            throw new IllegalArgumentException("Duplicate packet class:" + class1);
        }
        packetIdToClassMap.put(i2, class1);
        packetClassToIdMap.put(class1, i2);
        if (clientPacket) {
            clientPacketIdList.add(i2);
        }
        if (serverPacket) {
            serverPacketIdList.add(i2);
        }
    }

    public static Packet getNewPacket(int i2) {
        try {
            Class class1 = (Class)packetIdToClassMap.get(i2);
            if (class1 == null) {
                return null;
            }
            return (Packet)class1.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Skipping packet with id " + i2);
            return null;
        }
    }

    public final int getPacketId() {
        return (Integer)packetClassToIdMap.get(this.getClass());
    }

    public static Packet readPacket(DataInputStream datainputstream, boolean flag) throws IOException {
        int i2 = 0;
        Packet packet = null;
        try {
            i2 = datainputstream.read();
            if (i2 == -1) {
                return null;
            }
            if (flag && !serverPacketIdList.contains(i2) || !flag && !clientPacketIdList.contains(i2)) {
                throw new IOException("Bad packet id " + i2);
            }
            packet = Packet.getNewPacket(i2);
            if (packet == null) {
                throw new IOException("Bad packet id " + i2);
            }
            packet.readPacketData(datainputstream);
        }
        catch (EOFException eofexception) {
            System.out.println("Reached end of stream");
            return null;
        }
        PacketCounter packetcounter = (PacketCounter)packetStats.get(i2);
        if (packetcounter == null) {
            packetcounter = new PacketCounter(null);
            packetStats.put(i2, packetcounter);
        }
        packetcounter.addPacket(packet.getPacketSize());
        if (++totalPacketsCount % 1000 != 0) {
            // empty if block
        }
        return packet;
    }

    public static void writePacket(Packet packet, DataOutputStream dataoutputstream) throws IOException {
        dataoutputstream.write(packet.getPacketId());
        packet.writePacketData(dataoutputstream);
    }

    public static void writeString(String s2, DataOutputStream dataoutputstream) throws IOException {
        if (s2.length() > Short.MAX_VALUE) {
            throw new IOException("String too big");
        }
        dataoutputstream.writeShort(s2.length());
        dataoutputstream.writeChars(s2);
    }

    public static String readString(DataInputStream datainputstream, int i2) throws IOException {
        int word0 = datainputstream.readShort();
        if (word0 > i2) {
            throw new IOException("Received string length longer than maximum allowed (" + word0 + " > " + i2 + ")");
        }
        if (word0 < 0) {
            throw new IOException("Received string length is less than zero! Weird string!");
        }
        StringBuilder stringbuilder = new StringBuilder();
        for (int j2 = 0; j2 < word0; ++j2) {
            stringbuilder.append(datainputstream.readChar());
        }
        return stringbuilder.toString();
    }

    public static void writeNBTTagCompound(NBTTagCompound tag, DataOutputStream dataoutputstream) throws IOException {
        tag.writeTagContents(dataoutputstream);
    }

    public static NBTTagCompound readNBTTagCompound(DataInputStream datainputstream) throws IOException {
        NBTTagCompound newTag = new NBTTagCompound();
        newTag.readTagContents(datainputstream);
        return newTag;
    }

    public abstract void readPacketData(DataInputStream var1) throws IOException;

    public abstract void writePacketData(DataOutputStream var1) throws IOException;

    public abstract void processPacket(NetHandler var1);

    public abstract int getPacketSize();

    static {
        Packet.addIdClassMapping(0, true, true, Packet0KeepAlive.class);
        Packet.addIdClassMapping(1, true, true, Packet1Login.class);
        Packet.addIdClassMapping(2, true, true, Packet2Handshake.class);
        Packet.addIdClassMapping(3, true, true, Packet3Chat.class);
        Packet.addIdClassMapping(4, true, false, Packet4UpdateTime.class);
        Packet.addIdClassMapping(5, true, false, Packet5PlayerInventory.class);
        Packet.addIdClassMapping(6, true, false, Packet6SpawnPosition.class);
        Packet.addIdClassMapping(7, false, true, Packet7UseEntity.class);
        Packet.addIdClassMapping(8, true, false, Packet8UpdateHealth.class);
        Packet.addIdClassMapping(9, true, true, Packet9Respawn.class);
        Packet.addIdClassMapping(10, true, true, Packet10Flying.class);
        Packet.addIdClassMapping(11, true, true, Packet11PlayerPosition.class);
        Packet.addIdClassMapping(12, true, true, Packet12PlayerLook.class);
        Packet.addIdClassMapping(13, true, true, Packet13PlayerLookMove.class);
        Packet.addIdClassMapping(14, false, true, Packet14BlockDig.class);
        Packet.addIdClassMapping(15, false, true, Packet15Place.class);
        Packet.addIdClassMapping(16, false, true, Packet16BlockItemSwitch.class);
        Packet.addIdClassMapping(17, true, false, Packet17Sleep.class);
        Packet.addIdClassMapping(18, true, true, Packet18Animation.class);
        Packet.addIdClassMapping(19, false, true, Packet19EntityAction.class);
        Packet.addIdClassMapping(20, true, false, Packet20NamedEntitySpawn.class);
        Packet.addIdClassMapping(21, true, false, Packet21PickupSpawn.class);
        Packet.addIdClassMapping(22, true, false, Packet22Collect.class);
        Packet.addIdClassMapping(23, true, false, Packet23VehicleSpawn.class);
        Packet.addIdClassMapping(24, true, false, Packet24MobSpawn.class);
        Packet.addIdClassMapping(25, true, false, Packet25EntityPainting.class);
        Packet.addIdClassMapping(27, false, true, Packet27Position.class);
        Packet.addIdClassMapping(28, true, false, Packet28EntityVelocity.class);
        Packet.addIdClassMapping(29, true, false, Packet29DestroyEntity.class);
        Packet.addIdClassMapping(30, true, false, Packet30Entity.class);
        Packet.addIdClassMapping(31, true, false, Packet31RelEntityMove.class);
        Packet.addIdClassMapping(32, true, false, Packet32EntityLook.class);
        Packet.addIdClassMapping(33, true, false, Packet33RelEntityMoveLook.class);
        Packet.addIdClassMapping(34, true, false, Packet34EntityTeleport.class);
        Packet.addIdClassMapping(35, true, true, Packet35EntityNickname.class);
        Packet.addIdClassMapping(38, true, false, Packet38EntityStatus.class);
        Packet.addIdClassMapping(39, true, false, Packet39AttachEntity.class);
        Packet.addIdClassMapping(40, true, false, Packet40EntityMetadata.class);
        Packet.addIdClassMapping(41, true, false, Packet41EntityPlayerGamemode.class);
        Packet.addIdClassMapping(50, true, false, Packet50PreChunk.class);
        Packet.addIdClassMapping(51, true, false, Packet51MapChunk.class);
        Packet.addIdClassMapping(52, true, false, Packet52MultiBlockChange.class);
        Packet.addIdClassMapping(53, true, false, Packet53BlockChange.class);
        Packet.addIdClassMapping(54, true, false, Packet54PlayNoteBlock.class);
        Packet.addIdClassMapping(55, true, false, Packet55WorldTypes.class);
        Packet.addIdClassMapping(56, false, true, Packet56RequestChunk.class);
        Packet.addIdClassMapping(60, true, false, Packet60Explosion.class);
        Packet.addIdClassMapping(61, true, false, Packet61PlaySoundEffect.class);
        Packet.addIdClassMapping(70, true, false, Packet70Bed.class);
        Packet.addIdClassMapping(71, true, false, Packet71Weather.class);
        Packet.addIdClassMapping(72, true, false, Packet72UpdatePlayerProfile.class);
        Packet.addIdClassMapping(73, true, false, Packet73WeatherStatus.class);
        Packet.addIdClassMapping(100, true, false, Packet100OpenWindow.class);
        Packet.addIdClassMapping(101, true, true, Packet101CloseWindow.class);
        Packet.addIdClassMapping(102, false, true, Packet102WindowClick.class);
        Packet.addIdClassMapping(103, true, false, Packet103SetSlot.class);
        Packet.addIdClassMapping(104, true, false, Packet104WindowItems.class);
        Packet.addIdClassMapping(105, true, false, Packet105UpdateProgressbar.class);
        Packet.addIdClassMapping(106, true, true, Packet106Transaction.class);
        Packet.addIdClassMapping(107, false, true, Packet107UpdateCreativeInventory.class);
        Packet.addIdClassMapping(108, false, true, Packet108SetHotbarOffset.class);
        Packet.addIdClassMapping(130, true, true, Packet130UpdateSign.class);
        Packet.addIdClassMapping(131, true, false, Packet131MapData.class);
        Packet.addIdClassMapping(132, true, false, Packet132SetMobSpawner.class);
        Packet.addIdClassMapping(133, false, true, Packet133OpenGuidebook.class);
        Packet.addIdClassMapping(134, false, true, Packet134ItemData.class);
        Packet.addIdClassMapping(135, false, true, Packet135PlacementMode.class);
        Packet.addIdClassMapping(200, true, false, Packet200Statistic.class);
        Packet.addIdClassMapping(255, true, true, Packet255KickDisconnect.class);
    }
}

