/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.src.NetHandler;
import net.minecraft.src.Packet;
import net.minecraft.src.helper.Direction;
import net.minecraft.src.helper.PlacementMode;

public class Packet135PlacementMode
extends Packet {
    public Direction rotation;
    public Direction rotationHorizontal;
    public Direction rotationVertical;
    public PlacementMode placementMode;

    public Packet135PlacementMode() {
    }

    public Packet135PlacementMode(Direction d2, Direction dx2, Direction dy2, PlacementMode placementMode) {
        this.rotation = d2;
        this.rotationHorizontal = dx2;
        this.rotationVertical = dy2;
        this.placementMode = placementMode;
    }

    @Override
    public void readPacketData(DataInputStream datainputstream) throws IOException {
        this.rotation = Packet135PlacementMode.readDirection(datainputstream);
        this.rotationHorizontal = Packet135PlacementMode.readDirection(datainputstream);
        this.rotationVertical = Packet135PlacementMode.readDirection(datainputstream);
        this.placementMode = Packet135PlacementMode.readPlacementMode(datainputstream);
    }

    @Override
    public void writePacketData(DataOutputStream dataoutputstream) throws IOException {
        Packet135PlacementMode.writeDirection(dataoutputstream, this.rotation);
        Packet135PlacementMode.writeDirection(dataoutputstream, this.rotationHorizontal);
        Packet135PlacementMode.writeDirection(dataoutputstream, this.rotationVertical);
        Packet135PlacementMode.writePlacementMode(dataoutputstream, this.placementMode);
    }

    @Override
    public void processPacket(NetHandler nethandler) {
        nethandler.handlePlacementMode(this);
    }

    @Override
    public int getPacketSize() {
        return 4;
    }

    public static Direction readDirection(DataInputStream dataInputStream) throws IOException {
        byte b2 = dataInputStream.readByte();
        if (b2 == -1) {
            return null;
        }
        return Direction.getDirection(b2);
    }

    public static void writeDirection(DataOutputStream dataOutputStream, Direction direction) throws IOException {
        if (direction == null) {
            dataOutputStream.writeByte(-1);
        } else {
            dataOutputStream.writeByte(direction.getIndex());
        }
    }

    public static void writePlacementMode(DataOutputStream dataOutputStream, PlacementMode placementMode) throws IOException {
        if (placementMode == PlacementMode.SIDE) {
            dataOutputStream.writeByte(1);
        } else {
            dataOutputStream.writeByte(0);
        }
    }

    public static PlacementMode readPlacementMode(DataInputStream dataInputStream) throws IOException {
        byte r2 = dataInputStream.readByte();
        if (r2 == 1) {
            return PlacementMode.SIDE;
        }
        return PlacementMode.FACING;
    }
}

