/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.src.EntityPainting;
import net.minecraft.src.EnumArt;
import net.minecraft.src.NetHandler;
import net.minecraft.src.Packet;

public class Packet25EntityPainting
extends Packet {
    public int entityId;
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public int direction;
    public String title;

    public Packet25EntityPainting() {
    }

    public Packet25EntityPainting(EntityPainting entitypainting) {
        this.entityId = entitypainting.entityId;
        this.xPosition = entitypainting.xPosition;
        this.yPosition = entitypainting.yPosition;
        this.zPosition = entitypainting.zPosition;
        this.direction = entitypainting.direction;
        this.title = entitypainting.art.title;
    }

    @Override
    public void readPacketData(DataInputStream datainputstream) throws IOException {
        this.entityId = datainputstream.readInt();
        this.title = Packet25EntityPainting.readString(datainputstream, EnumArt.maxArtTitleLength);
        this.xPosition = datainputstream.readInt();
        this.yPosition = datainputstream.readInt();
        this.zPosition = datainputstream.readInt();
        this.direction = datainputstream.readInt();
    }

    @Override
    public void writePacketData(DataOutputStream dataoutputstream) throws IOException {
        dataoutputstream.writeInt(this.entityId);
        Packet25EntityPainting.writeString(this.title, dataoutputstream);
        dataoutputstream.writeInt(this.xPosition);
        dataoutputstream.writeInt(this.yPosition);
        dataoutputstream.writeInt(this.zPosition);
        dataoutputstream.writeInt(this.direction);
    }

    @Override
    public void processPacket(NetHandler nethandler) {
        nethandler.handleEntityPainting(this);
    }

    @Override
    public int getPacketSize() {
        return 24;
    }
}

