/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.src.Chunk;
import net.minecraft.src.NetHandler;
import net.minecraft.src.Packet;
import net.minecraft.src.World;

public class Packet52MultiBlockChange
extends Packet {
    public int xPosition;
    public int zPosition;
    public short[] coordinateArray;
    public short[] typeArray;
    public byte[] metadataArray;
    public int size;

    public Packet52MultiBlockChange() {
        this.isChunkDataPacket = true;
    }

    public Packet52MultiBlockChange(int x2, int z2, short[] blocksToUpdate, int numBlocksToUpdate, World world) {
        this.isChunkDataPacket = true;
        this.xPosition = x2;
        this.zPosition = z2;
        this.size = numBlocksToUpdate;
        this.coordinateArray = new short[numBlocksToUpdate];
        this.typeArray = new short[numBlocksToUpdate];
        this.metadataArray = new byte[numBlocksToUpdate];
        Chunk chunk = world.getChunkFromChunkCoords(x2, z2);
        for (int i2 = 0; i2 < numBlocksToUpdate; ++i2) {
            int blockX = blocksToUpdate[i2] >> 12 & 0xF;
            int blockY = blocksToUpdate[i2] & 0xFF;
            int blockZ = blocksToUpdate[i2] >> 8 & 0xF;
            this.coordinateArray[i2] = blocksToUpdate[i2];
            this.typeArray[i2] = (short)chunk.getBlockID(blockX, blockY, blockZ);
            this.metadataArray[i2] = (byte)chunk.getBlockMetadata(blockX, blockY, blockZ);
        }
    }

    @Override
    public void readPacketData(DataInputStream datainputstream) throws IOException {
        int i2;
        this.xPosition = datainputstream.readInt();
        this.zPosition = datainputstream.readInt();
        this.size = datainputstream.readShort() & 0xFFFF;
        this.coordinateArray = new short[this.size];
        this.typeArray = new short[this.size];
        this.metadataArray = new byte[this.size];
        for (i2 = 0; i2 < this.size; ++i2) {
            this.coordinateArray[i2] = datainputstream.readShort();
        }
        for (i2 = 0; i2 < this.size; ++i2) {
            this.typeArray[i2] = datainputstream.readShort();
        }
        datainputstream.readFully(this.metadataArray);
    }

    @Override
    public void writePacketData(DataOutputStream dataoutputstream) throws IOException {
        int i2;
        dataoutputstream.writeInt(this.xPosition);
        dataoutputstream.writeInt(this.zPosition);
        dataoutputstream.writeShort((short)this.size);
        for (i2 = 0; i2 < this.size; ++i2) {
            dataoutputstream.writeShort(this.coordinateArray[i2]);
        }
        for (i2 = 0; i2 < this.size; ++i2) {
            dataoutputstream.writeShort(this.typeArray[i2]);
        }
        dataoutputstream.write(this.metadataArray);
    }

    @Override
    public void processPacket(NetHandler nethandler) {
        nethandler.handleMultiBlockChange(this);
    }

    @Override
    public int getPacketSize() {
        return 10 + this.size * 4;
    }
}

