/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.src.ChunkPosition;
import net.minecraft.src.NetHandler;
import net.minecraft.src.Packet;

public class Packet60Explosion
extends Packet {
    public double explosionX;
    public double explosionY;
    public double explosionZ;
    public float explosionSize;
    public Set<ChunkPosition> destroyedBlockPositions;
    public boolean isCannonball;

    public Packet60Explosion() {
    }

    public Packet60Explosion(double d2, double d1, double d22, float f2, Set<ChunkPosition> set, boolean isCannonball) {
        this.explosionX = d2;
        this.explosionY = d1;
        this.explosionZ = d22;
        this.explosionSize = f2;
        this.destroyedBlockPositions = new HashSet<ChunkPosition>(set);
        this.isCannonball = isCannonball;
    }

    @Override
    public void readPacketData(DataInputStream datainputstream) throws IOException {
        this.explosionX = datainputstream.readDouble();
        this.explosionY = datainputstream.readDouble();
        this.explosionZ = datainputstream.readDouble();
        this.explosionSize = datainputstream.readFloat();
        int i2 = datainputstream.readInt();
        this.destroyedBlockPositions = new HashSet<ChunkPosition>();
        int j2 = (int)this.explosionX;
        int k2 = (int)this.explosionY;
        int l2 = (int)this.explosionZ;
        for (int i1 = 0; i1 < i2; ++i1) {
            int j1 = datainputstream.readByte() + j2;
            int k1 = datainputstream.readByte() + k2;
            int l1 = datainputstream.readByte() + l2;
            this.destroyedBlockPositions.add(new ChunkPosition(j1, k1, l1));
        }
        this.isCannonball = datainputstream.readBoolean();
    }

    @Override
    public void writePacketData(DataOutputStream dataoutputstream) throws IOException {
        dataoutputstream.writeDouble(this.explosionX);
        dataoutputstream.writeDouble(this.explosionY);
        dataoutputstream.writeDouble(this.explosionZ);
        dataoutputstream.writeFloat(this.explosionSize);
        dataoutputstream.writeInt(this.destroyedBlockPositions.size());
        int i2 = (int)this.explosionX;
        int j2 = (int)this.explosionY;
        int k2 = (int)this.explosionZ;
        for (ChunkPosition chunkPosition : this.destroyedBlockPositions) {
            dataoutputstream.writeByte(chunkPosition.x - i2);
            dataoutputstream.writeByte(chunkPosition.y - j2);
            dataoutputstream.writeByte(chunkPosition.z - k2);
        }
        dataoutputstream.writeBoolean(this.isCannonball);
    }

    @Override
    public void processPacket(NetHandler nethandler) {
        nethandler.handleExplosion(this);
    }

    @Override
    public int getPacketSize() {
        return 32 + this.destroyedBlockPositions.size() * 3 + 1;
    }
}

