/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.MathHelper;

public class PathPoint {
    public final int xCoord;
    public final int yCoord;
    public final int zCoord;
    private final int hash;
    int index = -1;
    float totalPathDistance;
    float distanceToNext;
    float distanceToTarget;
    PathPoint previous;
    public boolean isFirst = false;

    public PathPoint(int i2, int j2, int k2) {
        this.xCoord = i2;
        this.yCoord = j2;
        this.zCoord = k2;
        this.hash = PathPoint.func_22329_a(i2, j2, k2);
    }

    public static int func_22329_a(int i2, int j2, int k2) {
        return j2 & 0xFF | (i2 & Short.MAX_VALUE) << 8 | (k2 & Short.MAX_VALUE) << 24 | (i2 >= 0 ? 0 : Integer.MIN_VALUE) | (k2 >= 0 ? 0 : 32768);
    }

    public float distanceTo(PathPoint pathpoint) {
        float f2 = pathpoint.xCoord - this.xCoord;
        float f1 = pathpoint.yCoord - this.yCoord;
        float f22 = pathpoint.zCoord - this.zCoord;
        return MathHelper.sqrt_float(f2 * f2 + f1 * f1 + f22 * f22);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PathPoint) {
            PathPoint pathpoint = (PathPoint)obj;
            return this.hash == pathpoint.hash && this.xCoord == pathpoint.xCoord && this.yCoord == pathpoint.yCoord && this.zCoord == pathpoint.zCoord;
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean isAssigned() {
        return this.index >= 0;
    }

    public String toString() {
        return this.xCoord + ", " + this.yCoord + ", " + this.zCoord;
    }
}

