/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.client.Minecraft;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityClientPlayerMP;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NetClientHandler;
import net.minecraft.src.Packet102WindowClick;
import net.minecraft.src.Packet14BlockDig;
import net.minecraft.src.Packet15Place;
import net.minecraft.src.Packet16BlockItemSwitch;
import net.minecraft.src.Packet7UseEntity;
import net.minecraft.src.PlayerController;
import net.minecraft.src.World;

public class PlayerControllerMP
extends PlayerController {
    protected NetClientHandler netHandler;
    protected int currentItem;

    public PlayerControllerMP(Minecraft minecraft, NetClientHandler netHandler) {
        super(minecraft);
        this.netHandler = netHandler;
    }

    @Override
    public boolean destroyBlock(int x2, int y2, int z2, int side) {
        int id2 = this.mc.theWorld.getBlockId(x2, y2, z2);
        boolean removed = super.destroyBlock(x2, y2, z2, side);
        ItemStack item = this.mc.thePlayer.getCurrentEquippedItem();
        if (item != null) {
            item.onDestroyBlock(id2, x2, y2, z2, this.mc.thePlayer);
            if (item.stackSize == 0) {
                item.func_1097_a(this.mc.thePlayer);
                this.mc.thePlayer.destroyCurrentEquippedItem();
            }
        }
        return removed;
    }

    @Override
    protected void hitBlock(int x2, int y2, int z2, int side) {
    }

    @Override
    public void sendStartDigPacket(int x2, int y2, int z2, int side) {
        this.netHandler.addToSendQueue(new Packet14BlockDig(0, x2, y2, z2, side));
    }

    @Override
    public void sendDestroyBlockPacket(int x2, int y2, int z2, int side) {
        this.netHandler.addToSendQueue(new Packet14BlockDig(2, x2, y2, z2, side));
    }

    @Override
    protected void syncCurrentPlayItem() {
        int i2 = this.mc.thePlayer.inventory.currentItem;
        if (i2 != this.currentItem) {
            this.currentItem = i2;
            this.netHandler.addToSendQueue(new Packet16BlockItemSwitch(this.currentItem));
        }
    }

    @Override
    public boolean activeBlockOrUseItem(EntityPlayer entityplayer, World world, ItemStack itemstack, int i2, int j2, int k2, int l2, double heightPlaced) {
        this.syncCurrentPlayItem();
        this.netHandler.addToSendQueue(new Packet15Place(i2, j2, k2, l2, entityplayer.inventory.getCurrentItem(), heightPlaced));
        boolean flag = super.activeBlockOrUseItem(entityplayer, world, itemstack, i2, j2, k2, l2, heightPlaced);
        return flag;
    }

    @Override
    public boolean sendUseItem(EntityPlayer entityplayer, World world, ItemStack itemstack) {
        this.syncCurrentPlayItem();
        this.netHandler.addToSendQueue(new Packet15Place(-1, -1, -1, 255, entityplayer.inventory.getCurrentItem(), 0.0));
        boolean flag = super.sendUseItem(entityplayer, world, itemstack);
        return flag;
    }

    @Override
    public EntityPlayer createPlayer(World world) {
        return new EntityClientPlayerMP(this.mc, world, this.mc.session, this.netHandler);
    }

    @Override
    public void attackEntity(EntityPlayer entityplayer, Entity entity) {
        this.syncCurrentPlayItem();
        this.netHandler.addToSendQueue(new Packet7UseEntity(entityplayer.entityId, entity.entityId, 1));
        entityplayer.attackTargetEntityWithCurrentItem(entity);
    }

    @Override
    public void interactWithEntity(EntityPlayer entityplayer, Entity entity) {
        this.syncCurrentPlayItem();
        this.netHandler.addToSendQueue(new Packet7UseEntity(entityplayer.entityId, entity.entityId, 0));
        entityplayer.useCurrentItemOnEntity(entity);
    }

    @Override
    public ItemStack itemPickUpFromInventory(int i2, int j2, int k2, boolean shift, boolean control, EntityPlayer entityplayer) {
        short word0 = entityplayer.craftingInventory.func_20111_a(entityplayer.inventory);
        ItemStack itemstack = super.itemPickUpFromInventory(i2, j2, k2, shift, control, entityplayer);
        this.netHandler.addToSendQueue(new Packet102WindowClick(i2, j2, k2, shift, control, itemstack, word0));
        return itemstack;
    }

    @Override
    public void func_20086_a(int i2, EntityPlayer entityplayer) {
        if (i2 == -9999) {
            return;
        }
    }
}

