/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.PlayerHashEntry;

public class PlayerHash {
    private transient PlayerHashEntry[] hashArray = new PlayerHashEntry[16];
    private transient int numHashElements;
    private int capacity = 12;
    private final float percentUsable = 0.75f;
    private volatile transient int field_950_e;

    private static int getHashedKey(long l2) {
        return PlayerHash.hash((int)(l2 ^ l2 >>> 32));
    }

    private static int hash(int i2) {
        i2 ^= i2 >>> 20 ^ i2 >>> 12;
        return i2 ^ i2 >>> 7 ^ i2 >>> 4;
    }

    private static int getHashIndex(int i2, int j2) {
        return i2 & j2 - 1;
    }

    public Object getValueByKey(long l2) {
        int i2 = PlayerHash.getHashedKey(l2);
        PlayerHashEntry playerhashentry = this.hashArray[PlayerHash.getHashIndex(i2, this.hashArray.length)];
        while (playerhashentry != null) {
            if (playerhashentry.key == l2) {
                return playerhashentry.value;
            }
            playerhashentry = playerhashentry.nextEntry;
        }
        return null;
    }

    public void add(long l2, Object obj) {
        int i2 = PlayerHash.getHashedKey(l2);
        int j2 = PlayerHash.getHashIndex(i2, this.hashArray.length);
        PlayerHashEntry playerhashentry = this.hashArray[j2];
        while (playerhashentry != null) {
            if (playerhashentry.key == l2) {
                playerhashentry.value = obj;
            }
            playerhashentry = playerhashentry.nextEntry;
        }
        ++this.field_950_e;
        this.createKey(i2, l2, obj, j2);
    }

    private void resizeTable(int i2) {
        PlayerHashEntry[] aplayerhashentry = this.hashArray;
        int j2 = aplayerhashentry.length;
        if (j2 == 0x40000000) {
            this.capacity = Integer.MAX_VALUE;
            return;
        }
        PlayerHashEntry[] aplayerhashentry1 = new PlayerHashEntry[i2];
        this.copyHashTableTo(aplayerhashentry1);
        this.hashArray = aplayerhashentry1;
        this.capacity = (int)((float)i2 * 0.75f);
    }

    private void copyHashTableTo(PlayerHashEntry[] aplayerhashentry) {
        PlayerHashEntry[] aplayerhashentry1 = this.hashArray;
        int i2 = aplayerhashentry.length;
        for (int j2 = 0; j2 < aplayerhashentry1.length; ++j2) {
            PlayerHashEntry playerhashentry1;
            PlayerHashEntry playerhashentry = aplayerhashentry1[j2];
            if (playerhashentry == null) continue;
            aplayerhashentry1[j2] = null;
            do {
                playerhashentry1 = playerhashentry.nextEntry;
                int k2 = PlayerHash.getHashIndex(playerhashentry.field_1026_d, i2);
                playerhashentry.nextEntry = aplayerhashentry[k2];
                aplayerhashentry[k2] = playerhashentry;
            } while ((playerhashentry = playerhashentry1) != null);
        }
    }

    public Object remove(long l2) {
        PlayerHashEntry playerhashentry = this.removeKey(l2);
        return playerhashentry != null ? playerhashentry.value : null;
    }

    final PlayerHashEntry removeKey(long l2) {
        PlayerHashEntry playerhashentry;
        int i2 = PlayerHash.getHashedKey(l2);
        int j2 = PlayerHash.getHashIndex(i2, this.hashArray.length);
        PlayerHashEntry playerhashentry1 = playerhashentry = this.hashArray[j2];
        while (playerhashentry1 != null) {
            PlayerHashEntry playerhashentry2 = playerhashentry1.nextEntry;
            if (playerhashentry1.key == l2) {
                ++this.field_950_e;
                --this.numHashElements;
                if (playerhashentry == playerhashentry1) {
                    this.hashArray[j2] = playerhashentry2;
                } else {
                    playerhashentry.nextEntry = playerhashentry2;
                }
                return playerhashentry1;
            }
            playerhashentry = playerhashentry1;
            playerhashentry1 = playerhashentry2;
        }
        return playerhashentry1;
    }

    private void createKey(int i2, long l2, Object obj, int j2) {
        PlayerHashEntry playerhashentry = this.hashArray[j2];
        this.hashArray[j2] = new PlayerHashEntry(i2, l2, obj, playerhashentry);
        if (this.numHashElements++ >= this.capacity) {
            this.resizeTable(2 * this.hashArray.length);
        }
    }

    static int getHashCode(long l2) {
        return PlayerHash.getHashedKey(l2);
    }
}

