/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.src.EntityPlayerMP;
import net.minecraft.src.PlayerHash;
import net.minecraft.src.PlayerInstance;
import net.minecraft.src.WorldServer;

public class PlayerManager {
    public List players;
    private PlayerHash playerInstances;
    private List playerInstancesToUpdate;
    private MinecraftServer mcServer;
    private int field_28110_e;
    private int playerViewRadius;
    private final int[][] field_22089_e = new int[][]{{1, 0}, {0, 1}, {-1, 0}, {0, -1}};

    public PlayerManager(MinecraftServer minecraftserver, int i2, int j2) {
        this.players = new ArrayList();
        this.playerInstances = new PlayerHash();
        this.playerInstancesToUpdate = new ArrayList();
        if (j2 > 15) {
            throw new IllegalArgumentException("Too big view radius!");
        }
        if (j2 < 3) {
            throw new IllegalArgumentException("Too small view radius!");
        }
        this.playerViewRadius = j2;
        this.mcServer = minecraftserver;
        this.field_28110_e = i2;
    }

    public WorldServer getMinecraftServer() {
        return this.mcServer.getWorldManager(this.field_28110_e);
    }

    public void updatePlayerInstances() {
        for (int i2 = 0; i2 < this.playerInstancesToUpdate.size(); ++i2) {
            ((PlayerInstance)this.playerInstancesToUpdate.get(i2)).onUpdate();
        }
        this.playerInstancesToUpdate.clear();
    }

    private PlayerInstance getPlayerInstance(int i2, int j2, boolean flag) {
        long l2 = (long)i2 + Integer.MAX_VALUE | (long)j2 + Integer.MAX_VALUE << 32;
        PlayerInstance playerinstance = (PlayerInstance)this.playerInstances.getValueByKey(l2);
        if (playerinstance == null && flag) {
            playerinstance = new PlayerInstance(this, i2, j2);
            this.playerInstances.add(l2, playerinstance);
        }
        return playerinstance;
    }

    public void markBlockNeedsUpdate(int i2, int j2, int k2) {
        int l2 = i2 >> 4;
        int i1 = k2 >> 4;
        PlayerInstance playerinstance = this.getPlayerInstance(l2, i1, false);
        if (playerinstance != null) {
            playerinstance.markBlockNeedsUpdate(i2 & 0xF, j2, k2 & 0xF);
        }
    }

    public void addPlayer(EntityPlayerMP entityplayermp) {
        int i2 = (int)entityplayermp.posX >> 4;
        int j2 = (int)entityplayermp.posZ >> 4;
        entityplayermp.field_9155_d = entityplayermp.posX;
        entityplayermp.field_9154_e = entityplayermp.posZ;
        int k2 = 0;
        int l2 = this.playerViewRadius;
        int i1 = 0;
        int j1 = 0;
        this.getPlayerInstance(i2, j2, true).addPlayer(entityplayermp);
        for (int k1 = 1; k1 <= l2 * 2; ++k1) {
            for (int i22 = 0; i22 < 2; ++i22) {
                int[] ai2 = this.field_22089_e[k2++ % 4];
                for (int j22 = 0; j22 < k1; ++j22) {
                    this.getPlayerInstance(i2 + (i1 += ai2[0]), j2 + (j1 += ai2[1]), true).addPlayer(entityplayermp);
                }
            }
        }
        k2 %= 4;
        for (int l1 = 0; l1 < l2 * 2; ++l1) {
            this.getPlayerInstance(i2 + (i1 += this.field_22089_e[k2][0]), j2 + (j1 += this.field_22089_e[k2][1]), true).addPlayer(entityplayermp);
        }
        this.players.add(entityplayermp);
    }

    public void removePlayer(EntityPlayerMP entityplayermp) {
        int i2 = (int)entityplayermp.field_9155_d >> 4;
        int j2 = (int)entityplayermp.field_9154_e >> 4;
        for (int k2 = i2 - this.playerViewRadius; k2 <= i2 + this.playerViewRadius; ++k2) {
            for (int l2 = j2 - this.playerViewRadius; l2 <= j2 + this.playerViewRadius; ++l2) {
                PlayerInstance playerinstance = this.getPlayerInstance(k2, l2, false);
                if (playerinstance == null) continue;
                playerinstance.removePlayer(entityplayermp);
            }
        }
        this.players.remove(entityplayermp);
    }

    private boolean func_544_a(int i2, int j2, int k2, int l2) {
        int i1 = i2 - k2;
        int j1 = j2 - l2;
        if (i1 < -this.playerViewRadius || i1 > this.playerViewRadius) {
            return false;
        }
        return j1 >= -this.playerViewRadius && j1 <= this.playerViewRadius;
    }

    public void func_543_c(EntityPlayerMP entityplayermp) {
        int i2 = (int)entityplayermp.posX >> 4;
        int j2 = (int)entityplayermp.posZ >> 4;
        double d2 = entityplayermp.field_9155_d - entityplayermp.posX;
        double d1 = entityplayermp.field_9154_e - entityplayermp.posZ;
        double d22 = d2 * d2 + d1 * d1;
        if (d22 < 64.0) {
            return;
        }
        int k2 = (int)entityplayermp.field_9155_d >> 4;
        int l2 = (int)entityplayermp.field_9154_e >> 4;
        int i1 = i2 - k2;
        int j1 = j2 - l2;
        if (i1 == 0 && j1 == 0) {
            return;
        }
        for (int k1 = i2 - this.playerViewRadius; k1 <= i2 + this.playerViewRadius; ++k1) {
            for (int l1 = j2 - this.playerViewRadius; l1 <= j2 + this.playerViewRadius; ++l1) {
                PlayerInstance playerinstance;
                if (!this.func_544_a(k1, l1, k2, l2)) {
                    this.getPlayerInstance(k1, l1, true).addPlayer(entityplayermp);
                }
                if (this.func_544_a(k1 - i1, l1 - j1, i2, j2) || (playerinstance = this.getPlayerInstance(k1 - i1, l1 - j1, false)) == null) continue;
                playerinstance.removePlayer(entityplayermp);
            }
        }
        entityplayermp.field_9155_d = entityplayermp.posX;
        entityplayermp.field_9154_e = entityplayermp.posZ;
    }

    public int getMaxTrackingDistance() {
        return this.playerViewRadius * 16 - 16;
    }

    static PlayerHash getPlayerInstances(PlayerManager playermanager) {
        return playermanager.playerInstances;
    }

    static List getPlayerInstancesToUpdate(PlayerManager playermanager) {
        return playermanager.playerInstancesToUpdate;
    }
}

