/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import net.minecraft.src.ChunkLoader;
import net.minecraft.src.CompressedStreamTools;
import net.minecraft.src.Dimension;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IChunkLoader;
import net.minecraft.src.IPlayerFileData;
import net.minecraft.src.ISaveHandler;
import net.minecraft.src.MinecraftException;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.WorldInfo;

public class PlayerNBTManager
implements IPlayerFileData,
ISaveHandler {
    private static final Logger logger = Logger.getLogger("Minecraft");
    private final File worldDir;
    private final File worldFile;
    private final File field_28112_d;
    private final long field_22100_d = System.currentTimeMillis();

    public PlayerNBTManager(File file, String s2, boolean flag) {
        this.worldDir = new File(file, s2);
        this.worldDir.mkdirs();
        this.worldFile = new File(this.worldDir, "players");
        this.field_28112_d = new File(this.worldDir, "data");
        this.field_28112_d.mkdirs();
        if (flag) {
            this.worldFile.mkdirs();
        }
        this.func_22154_d();
    }

    private void func_22154_d() {
        try {
            File file = new File(this.worldDir, "session.lock");
            try (DataOutputStream dataoutputstream = new DataOutputStream(new FileOutputStream(file));){
                dataoutputstream.writeLong(this.field_22100_d);
            }
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
            throw new RuntimeException("Failed to check session lock, aborting");
        }
    }

    protected File getSaveDirectory() {
        return this.worldDir;
    }

    @Override
    public void checkSessionLock() {
        try {
            File file = new File(this.worldDir, "session.lock");
            try (DataInputStream datainputstream = new DataInputStream(new FileInputStream(file));){
                if (datainputstream.readLong() != this.field_22100_d) {
                    throw new MinecraftException("The save is being accessed from another location, aborting");
                }
            }
        }
        catch (IOException ioexception) {
            throw new MinecraftException("Failed to check session lock, aborting");
        }
    }

    @Override
    public IChunkLoader getChunkLoader(Dimension dimension) {
        if (dimension == Dimension.overworld) {
            return new ChunkLoader(this.worldDir, true);
        }
        File file = new File(this.worldDir, "DIM-" + dimension.dimId);
        file.mkdirs();
        return new ChunkLoader(file, true);
    }

    @Override
    public WorldInfo loadWorldInfo() {
        File file = new File(this.worldDir, "level.dat");
        if (file.exists()) {
            try {
                NBTTagCompound nbttagcompound = CompressedStreamTools.func_1138_a(new FileInputStream(file));
                NBTTagCompound nbttagcompound2 = nbttagcompound.getCompoundTag("Data");
                return new WorldInfo(nbttagcompound2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if ((file = new File(this.worldDir, "level.dat_old")).exists()) {
            try {
                NBTTagCompound nbttagcompound1 = CompressedStreamTools.func_1138_a(new FileInputStream(file));
                NBTTagCompound nbttagcompound3 = nbttagcompound1.getCompoundTag("Data");
                return new WorldInfo(nbttagcompound3);
            }
            catch (Exception exception1) {
                exception1.printStackTrace();
            }
        }
        return null;
    }

    public void saveWorldInfoAndPlayer(WorldInfo worldinfo, List list) {
        NBTTagCompound nbttagcompound = worldinfo.getNBTTagCompoundWithPlayer(list);
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        nbttagcompound1.setTag("Data", nbttagcompound);
        try {
            File file = new File(this.worldDir, "level.dat_new");
            File file1 = new File(this.worldDir, "level.dat_old");
            File file2 = new File(this.worldDir, "level.dat");
            CompressedStreamTools.writeGzippedCompoundToOutputStream(nbttagcompound1, new FileOutputStream(file));
            if (file1.exists()) {
                file1.delete();
            }
            file2.renameTo(file1);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void saveWorldInfo(WorldInfo worldinfo) {
        NBTTagCompound nbttagcompound = worldinfo.getNBTTagCompound();
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        nbttagcompound1.setTag("Data", nbttagcompound);
        try {
            File file = new File(this.worldDir, "level.dat_new");
            File file1 = new File(this.worldDir, "level.dat_old");
            File file2 = new File(this.worldDir, "level.dat");
            CompressedStreamTools.writeGzippedCompoundToOutputStream(nbttagcompound1, new FileOutputStream(file));
            if (file1.exists()) {
                file1.delete();
            }
            file2.renameTo(file1);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void writePlayerData(EntityPlayer entityplayer) {
        try {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            entityplayer.writeToNBT(nbttagcompound);
            File file = new File(this.worldFile, "_tmp_.dat");
            File file1 = new File(this.worldFile, entityplayer.username + ".dat");
            CompressedStreamTools.writeGzippedCompoundToOutputStream(nbttagcompound, new FileOutputStream(file));
            if (file1.exists()) {
                file1.delete();
            }
            file.renameTo(file1);
        }
        catch (Exception exception) {
            logger.warning("Failed to save player data for " + entityplayer.username);
        }
    }

    @Override
    public void readPlayerData(EntityPlayer entityplayer) {
        NBTTagCompound nbttagcompound = this.getPlayerData(entityplayer.username);
        if (nbttagcompound != null) {
            entityplayer.readFromNBT(nbttagcompound);
        }
    }

    public NBTTagCompound getPlayerData(String s2) {
        try {
            File file = new File(this.worldFile, s2 + ".dat");
            if (file.exists()) {
                return CompressedStreamTools.func_1138_a(new FileInputStream(file));
            }
        }
        catch (Exception exception) {
            logger.warning("Failed to load player data for " + s2);
        }
        return null;
    }

    @Override
    public IPlayerFileData func_22090_d() {
        return this;
    }

    public void func_22093_e() {
    }

    @Override
    public File func_28113_a(String s2) {
        return new File(this.field_28112_d, s2 + ".dat");
    }
}

