/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import net.minecraft.src.ImageParser;

public class PlayerSkinParser
implements ImageParser {
    public static final PlayerSkinParser instance = new PlayerSkinParser();
    private int[] imageData;
    private int width = 64;
    private int height = 32;

    @Override
    public BufferedImage parseImage(BufferedImage image) {
        if (image == null) {
            return null;
        }
        BufferedImage newImage = new BufferedImage(this.width, this.height, 2);
        Graphics g2 = newImage.getGraphics();
        g2.drawImage(image, 0, 0, null);
        g2.dispose();
        this.imageData = ((DataBufferInt)newImage.getRaster().getDataBuffer()).getData();
        this.removeTransparency(0, 0, 32, 16);
        this.removeTransparency(0, 16, 64, 32);
        return newImage;
    }

    private void removeTransparency(int x1, int y1, int w2, int h2) {
        for (int x2 = x1; x2 < w2; ++x2) {
            for (int y2 = y1; y2 < h2; ++y2) {
                int n2 = x2 + y2 * this.width;
                this.imageData[n2] = this.imageData[n2] | 0xFF000000;
            }
        }
    }
}

