/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PropertyManager {
    public static Logger logger = Logger.getLogger("Minecraft");
    private Properties serverProperties = new Properties();
    private File serverPropertiesFile;

    public PropertyManager(File file) {
        this.serverPropertiesFile = file;
        if (file.exists()) {
            try {
                this.serverProperties.load(new FileInputStream(file));
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Failed to load " + file, exception);
                this.generateNewProperties();
            }
        } else {
            logger.log(Level.WARNING, file + " does not exist");
            this.generateNewProperties();
        }
    }

    public void generateNewProperties() {
        logger.log(Level.INFO, "Generating new properties file");
        this.saveProperties();
    }

    public void saveProperties() {
        try {
            this.serverProperties.store(new FileOutputStream(this.serverPropertiesFile), "Minecraft server properties");
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Failed to save " + this.serverPropertiesFile, exception);
            this.generateNewProperties();
        }
    }

    public String getStringProperty(String s2, String s1) {
        if (!this.serverProperties.containsKey(s2)) {
            this.serverProperties.setProperty(s2, s1);
            this.saveProperties();
        }
        return this.serverProperties.getProperty(s2, s1);
    }

    public int getIntProperty(String s2, int i2) {
        try {
            return Integer.parseInt(this.getStringProperty(s2, "" + i2));
        }
        catch (Exception exception) {
            this.serverProperties.setProperty(s2, "" + i2);
            return i2;
        }
    }

    public boolean getBooleanProperty(String s2, boolean flag) {
        try {
            return Boolean.parseBoolean(this.getStringProperty(s2, "" + flag));
        }
        catch (Exception exception) {
            this.serverProperties.setProperty(s2, "" + flag);
            return flag;
        }
    }

    public void setProperty(String s2, boolean flag) {
        this.serverProperties.setProperty(s2, "" + flag);
        this.saveProperties();
    }

    public void setProperty(String s2, int value) {
        this.serverProperties.setProperty(s2, "" + value);
    }
}

