/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.src.Block;
import net.minecraft.src.BlockRail;
import net.minecraft.src.ChunkPosition;
import net.minecraft.src.World;

class RailLogic {
    private World worldObj;
    private int trackX;
    private int trackY;
    private int trackZ;
    private final boolean isPoweredRail;
    private List connectedTracks;
    final BlockRail rail;

    public RailLogic(BlockRail blockrail, World world, int i2, int j2, int k2) {
        this.rail = blockrail;
        this.connectedTracks = new ArrayList();
        this.worldObj = world;
        this.trackX = i2;
        this.trackY = j2;
        this.trackZ = k2;
        int l2 = world.getBlockId(i2, j2, k2);
        int i1 = world.getBlockMetadata(i2, j2, k2);
        if (BlockRail.isPoweredBlockRail((BlockRail)Block.blocksList[l2])) {
            this.isPoweredRail = true;
            i1 &= 0xFFFFFFF7;
        } else {
            this.isPoweredRail = false;
        }
        this.setConnections(i1);
    }

    private void setConnections(int i2) {
        this.connectedTracks.clear();
        if (i2 == 0) {
            this.connectedTracks.add(new ChunkPosition(this.trackX, this.trackY, this.trackZ - 1));
            this.connectedTracks.add(new ChunkPosition(this.trackX, this.trackY, this.trackZ + 1));
        } else if (i2 == 1) {
            this.connectedTracks.add(new ChunkPosition(this.trackX - 1, this.trackY, this.trackZ));
            this.connectedTracks.add(new ChunkPosition(this.trackX + 1, this.trackY, this.trackZ));
        } else if (i2 == 2) {
            this.connectedTracks.add(new ChunkPosition(this.trackX - 1, this.trackY, this.trackZ));
            this.connectedTracks.add(new ChunkPosition(this.trackX + 1, this.trackY + 1, this.trackZ));
        } else if (i2 == 3) {
            this.connectedTracks.add(new ChunkPosition(this.trackX - 1, this.trackY + 1, this.trackZ));
            this.connectedTracks.add(new ChunkPosition(this.trackX + 1, this.trackY, this.trackZ));
        } else if (i2 == 4) {
            this.connectedTracks.add(new ChunkPosition(this.trackX, this.trackY + 1, this.trackZ - 1));
            this.connectedTracks.add(new ChunkPosition(this.trackX, this.trackY, this.trackZ + 1));
        } else if (i2 == 5) {
            this.connectedTracks.add(new ChunkPosition(this.trackX, this.trackY, this.trackZ - 1));
            this.connectedTracks.add(new ChunkPosition(this.trackX, this.trackY + 1, this.trackZ + 1));
        } else if (i2 == 6) {
            this.connectedTracks.add(new ChunkPosition(this.trackX + 1, this.trackY, this.trackZ));
            this.connectedTracks.add(new ChunkPosition(this.trackX, this.trackY, this.trackZ + 1));
        } else if (i2 == 7) {
            this.connectedTracks.add(new ChunkPosition(this.trackX - 1, this.trackY, this.trackZ));
            this.connectedTracks.add(new ChunkPosition(this.trackX, this.trackY, this.trackZ + 1));
        } else if (i2 == 8) {
            this.connectedTracks.add(new ChunkPosition(this.trackX - 1, this.trackY, this.trackZ));
            this.connectedTracks.add(new ChunkPosition(this.trackX, this.trackY, this.trackZ - 1));
        } else if (i2 == 9) {
            this.connectedTracks.add(new ChunkPosition(this.trackX + 1, this.trackY, this.trackZ));
            this.connectedTracks.add(new ChunkPosition(this.trackX, this.trackY, this.trackZ - 1));
        }
    }

    private void func_785_b() {
        for (int i2 = 0; i2 < this.connectedTracks.size(); ++i2) {
            RailLogic raillogic = this.getMinecartTrackLogic((ChunkPosition)this.connectedTracks.get(i2));
            if (raillogic == null || !raillogic.isConnectedTo(this)) {
                this.connectedTracks.remove(i2--);
                continue;
            }
            this.connectedTracks.set(i2, new ChunkPosition(raillogic.trackX, raillogic.trackY, raillogic.trackZ));
        }
    }

    private boolean isMinecartTrack(int i2, int j2, int k2) {
        if (BlockRail.isRailBlockAt(this.worldObj, i2, j2, k2)) {
            return true;
        }
        if (BlockRail.isRailBlockAt(this.worldObj, i2, j2 + 1, k2)) {
            return true;
        }
        return BlockRail.isRailBlockAt(this.worldObj, i2, j2 - 1, k2);
    }

    private RailLogic getMinecartTrackLogic(ChunkPosition chunkposition) {
        if (BlockRail.isRailBlockAt(this.worldObj, chunkposition.x, chunkposition.y, chunkposition.z)) {
            return new RailLogic(this.rail, this.worldObj, chunkposition.x, chunkposition.y, chunkposition.z);
        }
        if (BlockRail.isRailBlockAt(this.worldObj, chunkposition.x, chunkposition.y + 1, chunkposition.z)) {
            return new RailLogic(this.rail, this.worldObj, chunkposition.x, chunkposition.y + 1, chunkposition.z);
        }
        if (BlockRail.isRailBlockAt(this.worldObj, chunkposition.x, chunkposition.y - 1, chunkposition.z)) {
            return new RailLogic(this.rail, this.worldObj, chunkposition.x, chunkposition.y - 1, chunkposition.z);
        }
        return null;
    }

    private boolean isConnectedTo(RailLogic raillogic) {
        for (int i2 = 0; i2 < this.connectedTracks.size(); ++i2) {
            ChunkPosition chunkposition = (ChunkPosition)this.connectedTracks.get(i2);
            if (chunkposition.x != raillogic.trackX || chunkposition.z != raillogic.trackZ) continue;
            return true;
        }
        return false;
    }

    private boolean isInTrack(int i2, int j2, int k2) {
        for (int l2 = 0; l2 < this.connectedTracks.size(); ++l2) {
            ChunkPosition chunkposition = (ChunkPosition)this.connectedTracks.get(l2);
            if (chunkposition.x != i2 || chunkposition.z != k2) continue;
            return true;
        }
        return false;
    }

    private int getAdjacentTracks() {
        int i2 = 0;
        if (this.isMinecartTrack(this.trackX, this.trackY, this.trackZ - 1)) {
            ++i2;
        }
        if (this.isMinecartTrack(this.trackX, this.trackY, this.trackZ + 1)) {
            ++i2;
        }
        if (this.isMinecartTrack(this.trackX - 1, this.trackY, this.trackZ)) {
            ++i2;
        }
        if (this.isMinecartTrack(this.trackX + 1, this.trackY, this.trackZ)) {
            ++i2;
        }
        return i2;
    }

    private boolean handleKeyPress(RailLogic raillogic) {
        if (this.isConnectedTo(raillogic)) {
            return true;
        }
        if (this.connectedTracks.size() == 2) {
            return false;
        }
        if (this.connectedTracks.size() == 0) {
            return true;
        }
        ChunkPosition chunkposition = (ChunkPosition)this.connectedTracks.get(0);
        return raillogic.trackY != this.trackY || chunkposition.y != this.trackY ? true : true;
    }

    private void func_788_d(RailLogic raillogic) {
        this.connectedTracks.add(new ChunkPosition(raillogic.trackX, raillogic.trackY, raillogic.trackZ));
        boolean flag = this.isInTrack(this.trackX, this.trackY, this.trackZ - 1);
        boolean flag1 = this.isInTrack(this.trackX, this.trackY, this.trackZ + 1);
        boolean flag2 = this.isInTrack(this.trackX - 1, this.trackY, this.trackZ);
        boolean flag3 = this.isInTrack(this.trackX + 1, this.trackY, this.trackZ);
        int byte0 = -1;
        if (flag || flag1) {
            byte0 = 0;
        }
        if (flag2 || flag3) {
            byte0 = 1;
        }
        if (!this.isPoweredRail) {
            if (flag1 && flag3 && !flag && !flag2) {
                byte0 = 6;
            }
            if (flag1 && flag2 && !flag && !flag3) {
                byte0 = 7;
            }
            if (flag && flag2 && !flag1 && !flag3) {
                byte0 = 8;
            }
            if (flag && flag3 && !flag1 && !flag2) {
                byte0 = 9;
            }
        }
        if (byte0 == 0) {
            if (BlockRail.isRailBlockAt(this.worldObj, this.trackX, this.trackY + 1, this.trackZ - 1)) {
                byte0 = 4;
            }
            if (BlockRail.isRailBlockAt(this.worldObj, this.trackX, this.trackY + 1, this.trackZ + 1)) {
                byte0 = 5;
            }
        }
        if (byte0 == 1) {
            if (BlockRail.isRailBlockAt(this.worldObj, this.trackX + 1, this.trackY + 1, this.trackZ)) {
                byte0 = 2;
            }
            if (BlockRail.isRailBlockAt(this.worldObj, this.trackX - 1, this.trackY + 1, this.trackZ)) {
                byte0 = 3;
            }
        }
        if (byte0 < 0) {
            byte0 = 0;
        }
        int i2 = byte0;
        if (this.isPoweredRail) {
            i2 = this.worldObj.getBlockMetadata(this.trackX, this.trackY, this.trackZ) & 8 | byte0;
        }
        this.worldObj.setBlockMetadataWithNotify(this.trackX, this.trackY, this.trackZ, i2);
    }

    private boolean func_786_c(int i2, int j2, int k2) {
        RailLogic raillogic = this.getMinecartTrackLogic(new ChunkPosition(i2, j2, k2));
        if (raillogic == null) {
            return false;
        }
        raillogic.func_785_b();
        return raillogic.handleKeyPress(this);
    }

    public void func_792_a(boolean flag, boolean flag1) {
        boolean flag2 = this.func_786_c(this.trackX, this.trackY, this.trackZ - 1);
        boolean flag3 = this.func_786_c(this.trackX, this.trackY, this.trackZ + 1);
        boolean flag4 = this.func_786_c(this.trackX - 1, this.trackY, this.trackZ);
        boolean flag5 = this.func_786_c(this.trackX + 1, this.trackY, this.trackZ);
        int byte0 = -1;
        if ((flag2 || flag3) && !flag4 && !flag5) {
            byte0 = 0;
        }
        if ((flag4 || flag5) && !flag2 && !flag3) {
            byte0 = 1;
        }
        if (!this.isPoweredRail) {
            if (flag3 && flag5 && !flag2 && !flag4) {
                byte0 = 6;
            }
            if (flag3 && flag4 && !flag2 && !flag5) {
                byte0 = 7;
            }
            if (flag2 && flag4 && !flag3 && !flag5) {
                byte0 = 8;
            }
            if (flag2 && flag5 && !flag3 && !flag4) {
                byte0 = 9;
            }
        }
        if (byte0 == -1) {
            if (flag2 || flag3) {
                byte0 = 0;
            }
            if (flag4 || flag5) {
                byte0 = 1;
            }
            if (!this.isPoweredRail) {
                if (flag) {
                    if (flag3 && flag5) {
                        byte0 = 6;
                    }
                    if (flag4 && flag3) {
                        byte0 = 7;
                    }
                    if (flag5 && flag2) {
                        byte0 = 9;
                    }
                    if (flag2 && flag4) {
                        byte0 = 8;
                    }
                } else {
                    if (flag2 && flag4) {
                        byte0 = 8;
                    }
                    if (flag5 && flag2) {
                        byte0 = 9;
                    }
                    if (flag4 && flag3) {
                        byte0 = 7;
                    }
                    if (flag3 && flag5) {
                        byte0 = 6;
                    }
                }
            }
        }
        if (byte0 == 0) {
            if (BlockRail.isRailBlockAt(this.worldObj, this.trackX, this.trackY + 1, this.trackZ - 1)) {
                byte0 = 4;
            }
            if (BlockRail.isRailBlockAt(this.worldObj, this.trackX, this.trackY + 1, this.trackZ + 1)) {
                byte0 = 5;
            }
        }
        if (byte0 == 1) {
            if (BlockRail.isRailBlockAt(this.worldObj, this.trackX + 1, this.trackY + 1, this.trackZ)) {
                byte0 = 2;
            }
            if (BlockRail.isRailBlockAt(this.worldObj, this.trackX - 1, this.trackY + 1, this.trackZ)) {
                byte0 = 3;
            }
        }
        if (byte0 < 0) {
            byte0 = 0;
        }
        this.setConnections(byte0);
        int i2 = byte0;
        if (this.isPoweredRail) {
            i2 = this.worldObj.getBlockMetadata(this.trackX, this.trackY, this.trackZ) & 8 | byte0;
        }
        if (flag1 || this.worldObj.getBlockMetadata(this.trackX, this.trackY, this.trackZ) != i2) {
            this.worldObj.setBlockMetadataWithNotify(this.trackX, this.trackY, this.trackZ, i2);
            for (int j2 = 0; j2 < this.connectedTracks.size(); ++j2) {
                RailLogic raillogic = this.getMinecartTrackLogic((ChunkPosition)this.connectedTracks.get(j2));
                if (raillogic == null) continue;
                raillogic.func_785_b();
                if (!raillogic.handleKeyPress(this)) continue;
                raillogic.func_788_d(this);
            }
        }
    }

    static int getNAdjacentTracks(RailLogic raillogic) {
        return raillogic.getAdjacentTracks();
    }
}

