/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.IRecipe;
import net.minecraft.src.InventoryCrafting;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;

public class RecipeLabelDye
implements IRecipe {
    @Override
    public ItemStack getCraftingResult(InventoryCrafting inventorycrafting) {
        ItemStack labelStack = null;
        ItemStack dyeStack = null;
        block0: for (int x2 = 0; x2 < 3; ++x2) {
            for (int y2 = 0; y2 < 3; ++y2) {
                ItemStack stack = inventorycrafting.getItemStackAt(x2, y2);
                if (stack == null) continue;
                if (stack.itemID == Item.label.itemID && labelStack == null) {
                    labelStack = stack;
                } else if (stack.itemID == Item.dye.itemID && dyeStack == null) {
                    dyeStack = stack;
                }
                if (labelStack != null && dyeStack != null) break block0;
            }
        }
        if (labelStack != null && dyeStack != null) {
            ItemStack outStack = labelStack.copy();
            outStack.tag.setBoolean("overrideColor", true);
            outStack.tag.setByte("color", (byte)(15 - dyeStack.getMetadata()));
            return outStack;
        }
        return null;
    }

    @Override
    public ItemStack getRecipeOutput() {
        return new ItemStack(Item.label);
    }

    @Override
    public int getRecipeSize() {
        return 2;
    }

    @Override
    public boolean matches(InventoryCrafting inventorycrafting) {
        int labelCount = 0;
        int dyeCount = 0;
        for (int x2 = 0; x2 < 3; ++x2) {
            for (int y2 = 0; y2 < 3; ++y2) {
                ItemStack stack = inventorycrafting.getItemStackAt(x2, y2);
                if (stack == null) continue;
                if (stack.itemID == Item.label.itemID) {
                    ++labelCount;
                }
                if (stack.itemID != Item.dye.itemID) continue;
                ++dyeCount;
            }
        }
        return labelCount == 1 && dyeCount == 1;
    }

    @Override
    public ItemStack[] onCraftResult(InventoryCrafting inventorycrafting) {
        ItemStack[] returnStack = new ItemStack[9];
        for (int x2 = 0; x2 < 3; ++x2) {
            for (int y2 = 0; y2 < 3; ++y2) {
                ItemStack stack = inventorycrafting.getItemStackAt(x2, y2);
                if (stack == null) continue;
                --stack.stackSize;
                if (stack.stackSize != 0) continue;
                inventorycrafting.setSlotContentsAt(x2, y2, null);
            }
        }
        return returnStack;
    }
}

