/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.CraftingManager;
import net.minecraft.src.IRecipe;
import net.minecraft.src.InventoryCrafting;
import net.minecraft.src.ItemStack;

public class RecipeShaped
implements IRecipe {
    public int recipeWidth;
    public int recipeHeight;
    public ItemStack[] recipeItems;
    public ItemStack recipeOutput;
    public boolean useAlternatives;
    public boolean countForMetadata;
    public final int recipeOutputItemID;

    public RecipeShaped(int i2, int j2, ItemStack[] aitemstack, ItemStack itemstack) {
        this.recipeOutputItemID = itemstack.itemID;
        this.recipeWidth = i2;
        this.recipeHeight = j2;
        this.recipeItems = aitemstack;
        this.recipeOutput = itemstack;
        this.useAlternatives = false;
        this.countForMetadata = true;
    }

    public RecipeShaped(int i2, int j2, ItemStack[] aitemstack, ItemStack itemstack, boolean useAlternatives, boolean countForMetadata) {
        this(i2, j2, aitemstack, itemstack);
        this.useAlternatives = useAlternatives;
        this.countForMetadata = countForMetadata;
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    @Override
    public boolean matches(InventoryCrafting inventorycrafting) {
        for (int i2 = 0; i2 <= 3 - this.recipeWidth; ++i2) {
            for (int j2 = 0; j2 <= 3 - this.recipeHeight; ++j2) {
                if (this.isRecipeMatching(inventorycrafting, i2, j2, true)) {
                    return true;
                }
                if (!this.isRecipeMatching(inventorycrafting, i2, j2, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRecipeMatching(InventoryCrafting inventorycrafting, int i2, int j2, boolean flag) {
        for (int k2 = 0; k2 < 3; ++k2) {
            for (int l2 = 0; l2 < 3; ++l2) {
                ItemStack itemstack1;
                int i1 = k2 - i2;
                int j1 = l2 - j2;
                ItemStack itemstack = null;
                if (i1 >= 0 && j1 >= 0 && i1 < this.recipeWidth && j1 < this.recipeHeight) {
                    itemstack = flag ? this.recipeItems[this.recipeWidth - i1 - 1 + j1 * this.recipeWidth] : this.recipeItems[i1 + j1 * this.recipeWidth];
                }
                if ((itemstack1 = inventorycrafting.getItemStackAt(k2, l2)) == null && itemstack == null) continue;
                int alternativeIndex = -1;
                if (this.useAlternatives && itemstack != null) {
                    for (int q2 = 0; q2 < CraftingManager.blockAlternatives.length; ++q2) {
                        if (CraftingManager.blockAlternatives[q2][0].blockID != itemstack.itemID) continue;
                        alternativeIndex = q2;
                        break;
                    }
                }
                if (itemstack1 == null && itemstack != null || itemstack1 != null && itemstack == null) {
                    return false;
                }
                boolean idMatches = false;
                if (alternativeIndex != -1) {
                    for (int q3 = 0; q3 < CraftingManager.blockAlternatives[alternativeIndex].length; ++q3) {
                        if (itemstack1.itemID != CraftingManager.blockAlternatives[alternativeIndex][q3].blockID) continue;
                        idMatches = true;
                        break;
                    }
                } else if (itemstack.itemID == itemstack1.itemID) {
                    idMatches = true;
                }
                if (!idMatches) {
                    return false;
                }
                if (!this.countForMetadata || itemstack.getMetadata() == -1 || itemstack.getMetadata() == itemstack1.getMetadata()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public ItemStack getCraftingResult(InventoryCrafting inventorycrafting) {
        return new ItemStack(this.recipeOutput.itemID, this.recipeOutput.stackSize, this.recipeOutput.getMetadata());
    }

    @Override
    public ItemStack[] onCraftResult(InventoryCrafting inventorycrafting) {
        ItemStack[] returnStack = new ItemStack[9];
        for (int i2 = 0; i2 < inventorycrafting.getSizeInventory(); ++i2) {
            ItemStack itemstack1 = inventorycrafting.getStackInSlot(i2);
            if (itemstack1 == null) continue;
            inventorycrafting.decrStackSize(i2, 1);
            if (!itemstack1.getItem().hasContainerItem()) continue;
            inventorycrafting.setInventorySlotContents(i2, new ItemStack(itemstack1.getItem().getContainerItem()));
        }
        return returnStack;
    }

    @Override
    public int getRecipeSize() {
        return this.recipeWidth * this.recipeHeight;
    }
}

