/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import net.minecraft.src.RegionFileChunkBuffer;

public class RegionFile {
    private static final byte[] emptySector = new byte[4096];
    private final File fileName;
    private RandomAccessFile dataFile;
    private final int[] offsets = new int[1024];
    private final int[] field_22217_e = new int[1024];
    private ArrayList sectorFree;
    private int sizeDelta;
    private long field_22214_h = 0L;

    public RegionFile(File file) {
        this.fileName = file;
        this.debugln("REGION LOAD " + this.fileName);
        this.sizeDelta = 0;
        try {
            if (file.exists()) {
                this.field_22214_h = file.lastModified();
            }
            this.dataFile = new RandomAccessFile(file, "rw");
            if (this.dataFile.length() < 4096L) {
                for (int i2 = 0; i2 < 1024; ++i2) {
                    this.dataFile.writeInt(0);
                }
                for (int j2 = 0; j2 < 1024; ++j2) {
                    this.dataFile.writeInt(0);
                }
                this.sizeDelta += 8192;
            }
            if ((this.dataFile.length() & 0xFFFL) != 0L) {
                int k2 = 0;
                while ((long)k2 < (this.dataFile.length() & 0xFFFL)) {
                    this.dataFile.write(0);
                    ++k2;
                }
            }
            int l2 = (int)this.dataFile.length() / 4096;
            this.sectorFree = new ArrayList(l2);
            for (int i1 = 0; i1 < l2; ++i1) {
                this.sectorFree.add(true);
            }
            this.sectorFree.set(0, false);
            this.sectorFree.set(1, false);
            this.dataFile.seek(0L);
            for (int j1 = 0; j1 < 1024; ++j1) {
                int l1;
                this.offsets[j1] = l1 = this.dataFile.readInt();
                if (l1 == 0 || (l1 >> 8) + (l1 & 0xFF) > this.sectorFree.size()) continue;
                for (int j2 = 0; j2 < (l1 & 0xFF); ++j2) {
                    this.sectorFree.set((l1 >> 8) + j2, false);
                }
            }
            for (int k1 = 0; k1 < 1024; ++k1) {
                int i2;
                this.field_22217_e[k1] = i2 = this.dataFile.readInt();
            }
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    public synchronized int func_22209_a() {
        int i2 = this.sizeDelta;
        this.sizeDelta = 0;
        return i2;
    }

    private void func_22211_a(String s2) {
    }

    private void debugln(String s2) {
        this.func_22211_a(s2 + "\n");
    }

    private void func_22199_a(String s2, int i2, int j2, String s1) {
        this.func_22211_a("REGION " + s2 + " " + this.fileName.getName() + "[" + i2 + "," + j2 + "] = " + s1);
    }

    private void func_22197_a(String s2, int i2, int j2, int k2, String s1) {
        this.func_22211_a("REGION " + s2 + " " + this.fileName.getName() + "[" + i2 + "," + j2 + "] " + k2 + "B = " + s1);
    }

    private void debugln(String s2, int i2, int j2, String s1) {
        this.func_22199_a(s2, i2, j2, s1 + "\n");
    }

    public synchronized DataInputStream getChunkDataInputStream(int i2, int j2) {
        if (this.outOfBounds(i2, j2)) {
            this.debugln("READ", i2, j2, "out of bounds");
            return null;
        }
        try {
            int k2 = this.getOffset(i2, j2);
            if (k2 == 0) {
                return null;
            }
            int l2 = k2 >> 8;
            int i1 = k2 & 0xFF;
            if (l2 + i1 > this.sectorFree.size()) {
                this.debugln("READ", i2, j2, "invalid sector");
                return null;
            }
            this.dataFile.seek(l2 * 4096);
            int j1 = this.dataFile.readInt();
            if (j1 > 4096 * i1) {
                this.debugln("READ", i2, j2, "invalid length: " + j1 + " > 4096 * " + i1);
                return null;
            }
            byte byte0 = this.dataFile.readByte();
            if (byte0 == 1) {
                byte[] abyte0 = new byte[j1 - 1];
                this.dataFile.read(abyte0);
                DataInputStream datainputstream = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(abyte0)));
                return datainputstream;
            }
            if (byte0 == 2) {
                byte[] abyte1 = new byte[j1 - 1];
                this.dataFile.read(abyte1);
                DataInputStream datainputstream1 = new DataInputStream(new InflaterInputStream(new ByteArrayInputStream(abyte1)));
                return datainputstream1;
            }
            this.debugln("READ", i2, j2, "unknown version " + byte0);
            return null;
        }
        catch (IOException ioexception) {
            this.debugln("READ", i2, j2, "exception");
            return null;
        }
    }

    public DataOutputStream getChunkDataOutputStream(int i2, int j2) {
        if (this.outOfBounds(i2, j2)) {
            return null;
        }
        return new DataOutputStream(new DeflaterOutputStream(new RegionFileChunkBuffer(this, i2, j2)));
    }

    protected synchronized void write(int i2, int j2, byte[] abyte0, int k2) {
        try {
            int l2 = this.getOffset(i2, j2);
            int i1 = l2 >> 8;
            int l1 = l2 & 0xFF;
            int i22 = (k2 + 5) / 4096 + 1;
            if (i22 >= 256) {
                return;
            }
            if (i1 != 0 && l1 == i22) {
                this.func_22197_a("SAVE", i2, j2, k2, "rewrite");
                this.write(i1, abyte0, k2);
            } else {
                for (int j22 = 0; j22 < l1; ++j22) {
                    this.sectorFree.set(i1 + j22, true);
                }
                int k22 = this.sectorFree.indexOf(true);
                int l22 = 0;
                if (k22 != -1) {
                    for (int i3 = k22; i3 < this.sectorFree.size(); ++i3) {
                        if (l22 != 0) {
                            l22 = ((Boolean)this.sectorFree.get(i3)).booleanValue() ? ++l22 : 0;
                        } else if (((Boolean)this.sectorFree.get(i3)).booleanValue()) {
                            k22 = i3;
                            l22 = 1;
                        }
                        if (l22 >= i22) break;
                    }
                }
                if (l22 >= i22) {
                    this.func_22197_a("SAVE", i2, j2, k2, "reuse");
                    int j1 = k22;
                    this.setOffset(i2, j2, j1 << 8 | i22);
                    for (int j3 = 0; j3 < i22; ++j3) {
                        this.sectorFree.set(j1 + j3, false);
                    }
                    this.write(j1, abyte0, k2);
                } else {
                    this.func_22197_a("SAVE", i2, j2, k2, "grow");
                    this.dataFile.seek(this.dataFile.length());
                    int k1 = this.sectorFree.size();
                    for (int k3 = 0; k3 < i22; ++k3) {
                        this.dataFile.write(emptySector);
                        this.sectorFree.add(false);
                    }
                    this.sizeDelta += 4096 * i22;
                    this.write(k1, abyte0, k2);
                    this.setOffset(i2, j2, k1 << 8 | i22);
                }
            }
            this.func_22208_b(i2, j2, (int)(System.currentTimeMillis() / 1000L));
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    private void write(int i2, byte[] abyte0, int j2) throws IOException {
        this.debugln(" " + i2);
        this.dataFile.seek(i2 * 4096);
        this.dataFile.writeInt(j2 + 1);
        this.dataFile.writeByte(2);
        this.dataFile.write(abyte0, 0, j2);
    }

    private boolean outOfBounds(int i2, int j2) {
        return i2 < 0 || i2 >= 32 || j2 < 0 || j2 >= 32;
    }

    private int getOffset(int i2, int j2) {
        return this.offsets[i2 + j2 * 32];
    }

    public boolean func_22202_c(int i2, int j2) {
        return this.getOffset(i2, j2) != 0;
    }

    private void setOffset(int i2, int j2, int k2) throws IOException {
        this.offsets[i2 + j2 * 32] = k2;
        this.dataFile.seek((i2 + j2 * 32) * 4);
        this.dataFile.writeInt(k2);
    }

    private void func_22208_b(int i2, int j2, int k2) throws IOException {
        this.field_22217_e[i2 + j2 * 32] = k2;
        this.dataFile.seek(4096 + (i2 + j2 * 32) * 4);
        this.dataFile.writeInt(k2);
    }

    public void func_22196_b() throws IOException {
        this.dataFile.close();
    }
}

