/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.client.Minecraft;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.ImageParser;
import net.minecraft.src.MathHelper;
import net.minecraft.src.ModelBase;
import net.minecraft.src.ModelBiped;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.RenderEngine;
import net.minecraft.src.RenderManager;
import net.minecraft.src.Tessellator;
import net.minecraft.src.TextureFX;
import net.minecraft.src.World;
import org.lwjgl.opengl.GL11;

public abstract class Render {
    protected RenderManager renderManager;
    private ModelBase modelBase = new ModelBiped();
    private RenderBlocks renderBlocks = new RenderBlocks();
    protected float shadowSize = 0.0f;
    protected float field_194_c = 1.0f;

    public abstract void doRender(Entity var1, double var2, double var4, double var6, float var8, float var9);

    protected void loadTexture(String s2) {
        RenderEngine renderEngine = this.renderManager.renderEngine;
        renderEngine.bindTexture(renderEngine.getTexture(s2));
    }

    private void renderEntityOnFire(Entity entity, double d2, double d1, double d22, float f2) {
        GL11.glDisable((int)2896);
        int i2 = Block.texCoordToIndex(15, 1);
        int j2 = i2 % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int k2 = i2 / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        float f1 = (float)j2 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        float f3 = ((float)j2 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        float f5 = (float)k2 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        float f7 = ((float)k2 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)d2), (float)((float)d1), (float)((float)d22));
        float f9 = entity.width * 1.4f;
        GL11.glScalef((float)f9, (float)f9, (float)f9);
        this.loadTexture("/terrain.png");
        Tessellator tessellator = Tessellator.instance;
        float f10 = 0.5f;
        float f11 = 0.0f;
        float f12 = entity.height;
        float f13 = (float)(entity.posY - entity.boundingBox.minY);
        GL11.glRotatef((float)(-this.renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-0.3f + (float)((int)f12) * 0.02f));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f14 = 0.0f;
        int l2 = 0;
        tessellator.startDrawingQuads();
        while (f12 > 0.0f) {
            float f8;
            float f6;
            float f4;
            float f22;
            if (l2 % 2 == 0) {
                f22 = (float)j2 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                f4 = ((float)j2 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                f6 = (float)k2 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                f8 = ((float)k2 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            } else {
                f22 = (float)j2 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                f4 = ((float)j2 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                f6 = (float)(k2 + TextureFX.tileWidthTerrain) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                f8 = ((float)(k2 + TextureFX.tileWidthTerrain) + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            }
            if (l2 / 2 % 2 == 0) {
                float f15 = f4;
                f4 = f22;
                f22 = f15;
            }
            tessellator.addVertexWithUV(f10 - f11, 0.0f - f13, f14, f4, f8);
            tessellator.addVertexWithUV(-f10 - f11, 0.0f - f13, f14, f22, f8);
            tessellator.addVertexWithUV(-f10 - f11, 1.4f - f13, f14, f22, f6);
            tessellator.addVertexWithUV(f10 - f11, 1.4f - f13, f14, f4, f6);
            f12 -= 0.45f;
            f13 -= 0.45f;
            f10 *= 0.9f;
            f14 += 0.03f;
            ++l2;
        }
        tessellator.draw();
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
    }

    private void renderShadow(Entity entity, double d2, double d1, double d22, float f2, float f1) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderEngine renderengine = this.renderManager.renderEngine;
        renderengine.bindTexture(renderengine.getTexture("%clamp%/misc/shadow.png"));
        World world = this.getWorldFromRenderManager();
        GL11.glDepthMask((boolean)false);
        float f22 = this.shadowSize;
        double d3 = entity.lastTickPosX + (entity.posX - entity.lastTickPosX) * (double)f1;
        double d4 = entity.lastTickPosY + (entity.posY - entity.lastTickPosY) * (double)f1 + (double)entity.getShadowSize();
        double d5 = entity.lastTickPosZ + (entity.posZ - entity.lastTickPosZ) * (double)f1;
        int i2 = MathHelper.floor_double(d3 - (double)f22);
        int j2 = MathHelper.floor_double(d3 + (double)f22);
        int k2 = MathHelper.floor_double(d4 - (double)f22);
        int l2 = MathHelper.floor_double(d4);
        int i1 = MathHelper.floor_double(d5 - (double)f22);
        int j1 = MathHelper.floor_double(d5 + (double)f22);
        double d6 = d2 - d3;
        double d7 = d1 - d4;
        double d8 = d22 - d5;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        for (int k1 = i2; k1 <= j2; ++k1) {
            for (int l1 = k2; l1 <= l2; ++l1) {
                for (int i22 = i1; i22 <= j1; ++i22) {
                    int j22 = world.getBlockId(k1, l1 - 1, i22);
                    if (j22 <= 0 || world.getBlockLightValue(k1, l1, i22) <= 3) continue;
                    this.renderShadowOnBlock(Block.blocksList[j22], d2, d1 + (double)entity.getShadowSize(), d22, k1, l1, i22, f2, f22, d6, d7 + (double)entity.getShadowSize(), d8);
                }
            }
        }
        tessellator.draw();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
    }

    private World getWorldFromRenderManager() {
        return this.renderManager.worldObj;
    }

    private void renderShadowOnBlock(Block block, double d2, double d1, double d22, int i2, int j2, int k2, float f2, float f1, double d3, double d4, double d5) {
        double d6;
        Tessellator tessellator = Tessellator.instance;
        if (!block.renderAsNormalBlock()) {
            return;
        }
        double brightness = this.getWorldFromRenderManager().getLightBrightness(i2, j2, k2);
        if (Minecraft.getMinecraft().fullbright) {
            brightness = 1.0;
        }
        if ((d6 = ((double)f2 - (d1 - ((double)j2 + d4)) / 2.0) * 0.5 * brightness) < 0.0) {
            return;
        }
        if (d6 > 1.0) {
            d6 = 1.0;
        }
        tessellator.setColorRGBA_F(1.0f, 1.0f, 1.0f, (float)d6);
        double d7 = (double)i2 + block.minX + d3;
        double d8 = (double)i2 + block.maxX + d3;
        double d9 = (double)j2 + block.minY + d4 + 0.015625;
        double d10 = (double)k2 + block.minZ + d5;
        double d11 = (double)k2 + block.maxZ + d5;
        float f22 = (float)((d2 - d7) / 2.0 / (double)f1 + 0.5);
        float f3 = (float)((d2 - d8) / 2.0 / (double)f1 + 0.5);
        float f4 = (float)((d22 - d10) / 2.0 / (double)f1 + 0.5);
        float f5 = (float)((d22 - d11) / 2.0 / (double)f1 + 0.5);
        tessellator.addVertexWithUV(d7, d9, d10, f22, f4);
        tessellator.addVertexWithUV(d7, d9, d11, f22, f5);
        tessellator.addVertexWithUV(d8, d9, d11, f3, f5);
        tessellator.addVertexWithUV(d8, d9, d10, f3, f4);
    }

    public static void renderOffsetAABB(AxisAlignedBB axisalignedbb, double d2, double d1, double d22) {
        GL11.glDisable((int)3553);
        Tessellator tessellator = Tessellator.instance;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tessellator.startDrawingQuads();
        tessellator.setTranslationD(d2, d1, d22);
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.setTranslationD(0.0, 0.0, 0.0);
        tessellator.draw();
        GL11.glEnable((int)3553);
    }

    public static void renderAABB(AxisAlignedBB axisalignedbb) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.draw();
    }

    public void setRenderManager(RenderManager rendermanager) {
        this.renderManager = rendermanager;
    }

    public void doRenderShadowAndFire(Entity entity, double d2, double d1, double d22, float f2, float f1) {
        double d3;
        float f22;
        if (this.renderManager.options != null && ((Boolean)this.renderManager.options.fancyGraphics.value).booleanValue() && this.shadowSize > 0.0f && (f22 = (float)((1.0 - (d3 = this.renderManager.func_851_a(entity.posX, entity.posY, entity.posZ)) / 256.0) * (double)this.field_194_c)) > 0.0f) {
            this.renderShadow(entity, d2, d1, d22, f22, f1);
        }
        if (entity.isBurning()) {
            this.renderEntityOnFire(entity, d2, d1, d22, f1);
        }
    }

    public FontRenderer getFontRendererFromRenderManager() {
        return this.renderManager.getFontRenderer();
    }

    public boolean loadDownloadableTexture(String url, String localTexture, ImageParser imageParser) {
        return this.renderManager.renderEngine.loadDownloadableTexture(url, localTexture, imageParser);
    }
}

