/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.client.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.BlockBed;
import net.minecraft.src.BlockDoor;
import net.minecraft.src.BlockFence;
import net.minecraft.src.BlockFenceGate;
import net.minecraft.src.BlockFire;
import net.minecraft.src.BlockFluid;
import net.minecraft.src.BlockLeavesCherryFlowering;
import net.minecraft.src.BlockPistonBase;
import net.minecraft.src.BlockPistonHead;
import net.minecraft.src.BlockRail;
import net.minecraft.src.BlockRedstoneRepeater;
import net.minecraft.src.BlockRedstoneWire;
import net.minecraft.src.BlockSpikes;
import net.minecraft.src.EntityRenderer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.ModelBed;
import net.minecraft.src.Tessellator;
import net.minecraft.src.TextureFX;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;
import org.lwjgl.opengl.GL11;

public class RenderBlocks {
    private IBlockAccess blockAccess;
    private World world;
    private int overrideBlockTexture = -1;
    private boolean flipTexture = false;
    private boolean renderAllFaces = false;
    public static boolean fancyGrass = true;
    public boolean useInventoryTint = true;
    private int uvRotateEast = 0;
    private int uvRotateWest = 0;
    private int uvRotateSouth = 0;
    private int uvRotateNorth = 0;
    private int uvRotateTop = 0;
    private int uvRotateBottom = 0;
    private boolean enableAO;
    private float lightValueOwn;
    private float aoLightValueXNeg;
    private float aoLightValueYNeg;
    private float aoLightValueZNeg;
    private float aoLightValueXPos;
    private float aoLightValueYPos;
    private float aoLightValueZPos;
    private float field_22377_m;
    private float field_22376_n;
    private float field_22375_o;
    private float field_22374_p;
    private float field_22373_q;
    private float field_22372_r;
    private float field_22371_s;
    private float field_22370_t;
    private float field_22369_u;
    private float field_22368_v;
    private float field_22367_w;
    private float field_22366_x;
    private float field_22365_y;
    private float field_22364_z;
    private float field_22362_A;
    private float field_22360_B;
    private float field_22358_C;
    private float field_22356_D;
    private float field_22354_E;
    private float field_22353_F;
    private int field_22352_G = 1;
    private float colorRedTopLeft;
    private float colorRedBottomLeft;
    private float colorRedBottomRight;
    private float colorRedTopRight;
    private float colorGreenTopLeft;
    private float colorGreenBottomLeft;
    private float colorGreenBottomRight;
    private float colorGreenTopRight;
    private float colorBlueTopLeft;
    private float colorBlueBottomLeft;
    private float colorBlueBottomRight;
    private float colorBlueTopRight;
    private boolean ao9;
    private boolean ao0;
    private boolean ao4;
    private boolean ao8;
    private boolean ao6;
    private boolean ao2;
    private boolean ao7;
    private boolean ao3;
    private boolean ao11;
    private boolean ao1;
    private boolean ao5;
    private boolean ao10;
    public boolean overbright;

    public RenderBlocks(World world, IBlockAccess iblockaccess) {
        this.blockAccess = iblockaccess;
        this.world = world;
    }

    public RenderBlocks() {
    }

    public void renderBlockUsingTexture(Block block, int i2, int j2, int k2, int l2) {
        this.overrideBlockTexture = l2;
        this.renderBlockByRenderType(block, i2, j2, k2);
        this.overrideBlockTexture = -1;
    }

    public void func_31075_a(Block block, int i2, int j2, int k2) {
        this.renderAllFaces = true;
        this.renderBlockByRenderType(block, i2, j2, k2);
        this.renderAllFaces = false;
    }

    public boolean renderBlockByRenderType(Block block, int i2, int j2, int k2) {
        int renderType = block.getRenderType();
        block.setBlockBoundsBasedOnState(this.world, i2, j2, k2);
        if (renderType == 0 || renderType == 20) {
            return this.renderStandardBlock(block, i2, j2, k2);
        }
        if (renderType == 4) {
            return this.renderBlockFluids(block, i2, j2, k2);
        }
        if (renderType == 13) {
            return this.renderBlockCactus(block, i2, j2, k2);
        }
        if (renderType == 1) {
            return this.renderBlockReed(block, i2, j2, k2);
        }
        if (renderType == 6) {
            return this.renderBlockCrops(block, i2, j2, k2);
        }
        if (renderType == 2) {
            return this.renderBlockTorch(block, i2, j2, k2);
        }
        if (renderType == 3) {
            return this.renderBlockFire(block, i2, j2, k2);
        }
        if (renderType == 5) {
            return this.renderBlockRedstoneWire(block, i2, j2, k2);
        }
        if (renderType == 8) {
            return this.renderBlockLadder(block, i2, j2, k2);
        }
        if (renderType == 7) {
            return this.renderBlockDoor(block, i2, j2, k2);
        }
        if (renderType == 9) {
            return this.renderBlockMinecartTrack((BlockRail)block, i2, j2, k2);
        }
        if (renderType == 10) {
            return this.renderBlockStairs(block, i2, j2, k2);
        }
        if (renderType == 11) {
            return this.renderBlockFence((BlockFence)block, i2, j2, k2);
        }
        if (renderType == 12) {
            return this.renderBlockLever(block, i2, j2, k2);
        }
        if (renderType == 14) {
            return this.renderBlockBed(block, i2, j2, k2);
        }
        if (renderType == 15) {
            return this.renderBlockRepeater(block, i2, j2, k2);
        }
        if (renderType == 16) {
            return this.func_31074_b(block, i2, j2, k2, false);
        }
        if (renderType == 17) {
            return this.func_31080_c(block, i2, j2, k2, true);
        }
        if (renderType == 18) {
            return this.renderBlockFenceGate((BlockFenceGate)block, i2, j2, k2);
        }
        if (renderType == 19) {
            return this.renderBlockSpikes((BlockSpikes)block, i2, j2, k2);
        }
        if (renderType == 21) {
            return this.renderBlockMoss(block, i2, j2, k2);
        }
        if (renderType == 22) {
            return this.renderBlockPaintedChest(block, i2, j2, k2);
        }
        if (renderType == 23) {
            return this.renderBlockCherryLeavesBloom((BlockLeavesCherryFlowering)block, i2, j2, k2);
        }
        if (renderType == 24) {
            return this.renderBlockAlgae(block, i2, j2, k2);
        }
        return false;
    }

    private boolean renderBlockPaintedChest(Block block, int i2, int j2, int k2) {
        this.renderStandardBlock(Block.chestPlanksOak, i2, j2, k2);
        this.renderStandardBlock(block, i2, j2, k2);
        return true;
    }

    private boolean renderBlockMoss(Block block, int i2, int j2, int k2) {
        if (Minecraft.isAmbientOcclusionEnabled()) {
            this.renderStandardBlockWithAmbientOcclusion(block, i2, j2, k2, 1.0f, 1.0f, 1.0f);
        } else {
            this.renderStandardBlockWithColorMultiplier(block, i2, j2, k2, 1.0f, 1.0f, 1.0f);
        }
        this.overrideBlockTexture = Block.texCoordToIndex(0, 2);
        this.renderStandardBlock(block, i2, j2, k2);
        this.overrideBlockTexture = -1;
        return true;
    }

    private boolean renderBlockCherryLeavesBloom(BlockLeavesCherryFlowering block, int i2, int j2, int k2) {
        int l2 = this.blockAccess.getBlockMetadata(i2, j2, k2);
        this.renderStandardBlock(block, i2, j2, k2);
        if ((l2 & 3) == 1) {
            this.overrideBlockTexture = Block.texCoordToIndex(3, 17);
            if (Minecraft.isAmbientOcclusionEnabled()) {
                this.renderStandardBlockWithAmbientOcclusion(block, i2, j2, k2, 1.0f, 1.0f, 1.0f);
            } else {
                this.renderStandardBlockWithColorMultiplier(block, i2, j2, k2, 1.0f, 1.0f, 1.0f);
            }
            this.overrideBlockTexture = -1;
        }
        return true;
    }

    public boolean renderBlockAlgae(Block block, int x2, int y2, int z2) {
        float f1 = 1.0f;
        Tessellator tessellator = Tessellator.instance;
        float f4 = block.getBlockBrightness(this.world, x2, y2, z2);
        float f5 = block.getBlockBrightness(this.world, x2, y2 - 1, z2);
        if (f5 < f4) {
            f5 = f4;
        }
        tessellator.setColorOpaque_F(f1 * f5, f1 * f5, f1 * f5);
        int j2 = block.getBlockTextureFromSide(1);
        this.renderTopFace(block, x2, (double)y2 - 0.1125, z2, j2);
        this.renderBottomFace(block, x2, (double)y2 + 0.0125, z2, j2);
        return true;
    }

    private boolean renderBlockBed(Block block, int i2, int j2, int k2) {
        Tessellator tessellator = Tessellator.instance;
        int l2 = this.blockAccess.getBlockMetadata(i2, j2, k2);
        int i1 = BlockBed.getDirectionFromMetadata(l2);
        boolean flag = BlockBed.isBlockFootOfBed(l2);
        float f2 = 0.5f;
        float f1 = 1.0f;
        float f22 = 0.8f;
        float f3 = 0.6f;
        float f4 = f1;
        float f5 = f1;
        float f6 = f1;
        float f7 = f2;
        float f8 = f22;
        float f9 = f3;
        float f10 = f2;
        float f11 = f22;
        float f12 = f3;
        float f13 = f2;
        float f14 = f22;
        float f15 = f3;
        float f16 = block.getBlockBrightness(this.blockAccess, i2, j2, k2);
        tessellator.setColorOpaque_F(f7 * f16, f10 * f16, f13 * f16);
        int f17 = block.getBlockTexture(this.blockAccess, i2, j2, k2, 0);
        int j1 = f17 % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int k1 = f17 / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        double d2 = (double)j1 / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d22 = ((double)(j1 + TextureFX.tileWidthTerrain) - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d4 = (double)k1 / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d6 = ((double)(k1 + TextureFX.tileWidthTerrain) - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d8 = (double)i2 + block.minX;
        double d10 = (double)i2 + block.maxX;
        double d12 = (double)j2 + block.minY + 0.1875;
        double d14 = (double)k2 + block.minZ;
        double d16 = (double)k2 + block.maxZ;
        tessellator.addVertexWithUV(d8, d12, d16, d2, d6);
        tessellator.addVertexWithUV(d8, d12, d14, d2, d4);
        tessellator.addVertexWithUV(d10, d12, d14, d22, d4);
        tessellator.addVertexWithUV(d10, d12, d16, d22, d6);
        float f17a = block.getBlockBrightness(this.blockAccess, i2, j2 + 1, k2);
        tessellator.setColorOpaque_F(f4 * f17a, f5 * f17a, f6 * f17a);
        j1 = block.getBlockTexture(this.blockAccess, i2, j2, k2, 1);
        k1 = j1 % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        d2 = j1 / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        double d1 = (float)k1 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d3 = ((double)(k1 + TextureFX.tileWidthTerrain) - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d5 = (float)d2 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d7 = (d2 + (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d9 = d1;
        double d11 = d3;
        double d13 = d5;
        double d15 = d5;
        double d17 = d1;
        double d18 = d3;
        double d19 = d7;
        double d20 = d7;
        if (i1 == 0) {
            d11 = d1;
            d13 = d7;
            d17 = d3;
            d20 = d5;
        } else if (i1 == 2) {
            d9 = d3;
            d15 = d7;
            d18 = d1;
            d19 = d5;
        } else if (i1 == 3) {
            d9 = d3;
            d15 = d7;
            d18 = d1;
            d19 = d5;
            d11 = d1;
            d13 = d7;
            d17 = d3;
            d20 = d5;
        }
        double d21 = (double)i2 + block.minX;
        double d222 = (double)i2 + block.maxX;
        double d23 = (double)j2 + block.maxY;
        double d24 = (double)k2 + block.minZ;
        double d25 = (double)k2 + block.maxZ;
        tessellator.addVertexWithUV(d222, d23, d25, d17, d19);
        tessellator.addVertexWithUV(d222, d23, d24, d9, d13);
        tessellator.addVertexWithUV(d21, d23, d24, d11, d15);
        tessellator.addVertexWithUV(d21, d23, d25, d18, d20);
        f17 = ModelBed.field_22280_a[i1];
        if (flag) {
            f17 = ModelBed.field_22280_a[ModelBed.field_22279_b[i1]];
        }
        j1 = 4;
        switch (i1) {
            case 0: {
                j1 = 5;
                break;
            }
            case 3: {
                j1 = 2;
                break;
            }
            case 1: {
                j1 = 3;
            }
        }
        if (f17 != 2 && (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, i2, j2, k2 - 1, 2))) {
            float f18 = block.getBlockBrightness(this.blockAccess, i2, j2, k2 - 1);
            if (block.minZ > 0.0) {
                f18 = f16;
            }
            tessellator.setColorOpaque_F(f8 * f18, f11 * f18, f14 * f18);
            this.flipTexture = j1 == 2;
            this.renderEastFace(block, i2, j2, k2, block.getBlockTexture(this.blockAccess, i2, j2, k2, 2));
        }
        if (f17 != 3 && (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, i2, j2, k2 + 1, 3))) {
            float f19 = block.getBlockBrightness(this.blockAccess, i2, j2, k2 + 1);
            if (block.maxZ < 1.0) {
                f19 = f16;
            }
            tessellator.setColorOpaque_F(f8 * f19, f11 * f19, f14 * f19);
            this.flipTexture = j1 == 3;
            this.renderWestFace(block, i2, j2, k2, block.getBlockTexture(this.blockAccess, i2, j2, k2, 3));
        }
        if (f17 != 4 && (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, i2 - 1, j2, k2, 4))) {
            float f20 = block.getBlockBrightness(this.blockAccess, i2 - 1, j2, k2);
            if (block.minX > 0.0) {
                f20 = f16;
            }
            tessellator.setColorOpaque_F(f9 * f20, f12 * f20, f15 * f20);
            this.flipTexture = j1 == 4;
            this.renderNorthFace(block, i2, j2, k2, block.getBlockTexture(this.blockAccess, i2, j2, k2, 4));
        }
        if (f17 != 5 && (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, i2 + 1, j2, k2, 5))) {
            float f21 = block.getBlockBrightness(this.blockAccess, i2 + 1, j2, k2);
            if (block.maxX < 1.0) {
                f21 = f16;
            }
            tessellator.setColorOpaque_F(f9 * f21, f12 * f21, f15 * f21);
            this.flipTexture = j1 == 5;
            this.renderSouthFace(block, i2, j2, k2, block.getBlockTexture(this.blockAccess, i2, j2, k2, 5));
        }
        this.flipTexture = false;
        return true;
    }

    public boolean renderBlockTorch(Block block, int i2, int j2, int k2) {
        int l2 = this.blockAccess.getBlockMetadata(i2, j2, k2);
        Tessellator tessellator = Tessellator.instance;
        float f2 = block.getBlockBrightness(this.blockAccess, i2, j2, k2);
        if (Block.lightValue[block.blockID] > 0) {
            f2 = 1.0f;
        }
        tessellator.setColorOpaque_F(f2, f2, f2);
        double d2 = 0.4f;
        double d1 = 0.5 - d2;
        double d22 = 0.2f;
        if (l2 == 1) {
            this.renderTorchAtAngle(block, (double)i2 - d1, (double)j2 + d22, k2, -d2, 0.0);
        } else if (l2 == 2) {
            this.renderTorchAtAngle(block, (double)i2 + d1, (double)j2 + d22, k2, d2, 0.0);
        } else if (l2 == 3) {
            this.renderTorchAtAngle(block, i2, (double)j2 + d22, (double)k2 - d1, 0.0, -d2);
        } else if (l2 == 4) {
            this.renderTorchAtAngle(block, i2, (double)j2 + d22, (double)k2 + d1, 0.0, d2);
        } else {
            this.renderTorchAtAngle(block, i2, j2, k2, 0.0, 0.0);
        }
        return true;
    }

    private boolean renderBlockRepeater(Block block, int i2, int j2, int k2) {
        int l2 = this.blockAccess.getBlockMetadata(i2, j2, k2);
        int i1 = l2 & 3;
        int j1 = (l2 & 0xC) >> 2;
        this.renderStandardBlock(block, i2, j2, k2);
        Tessellator tessellator = Tessellator.instance;
        float f2 = block.getBlockBrightness(this.blockAccess, i2, j2, k2);
        if (Block.lightValue[block.blockID] > 0) {
            f2 = (f2 + 1.0f) * 0.5f;
        }
        tessellator.setColorOpaque_F(f2, f2, f2);
        double d2 = -0.1875;
        double d1 = 0.0;
        double d22 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        switch (i1) {
            case 0: {
                d4 = -0.3125;
                d22 = BlockRedstoneRepeater.field_22024_a[j1];
                break;
            }
            case 2: {
                d4 = 0.3125;
                d22 = -BlockRedstoneRepeater.field_22024_a[j1];
                break;
            }
            case 3: {
                d3 = -0.3125;
                d1 = BlockRedstoneRepeater.field_22024_a[j1];
                break;
            }
            case 1: {
                d3 = 0.3125;
                d1 = -BlockRedstoneRepeater.field_22024_a[j1];
            }
        }
        this.renderTorchAtAngle(block, (double)i2 + d1, (double)j2 + d2, (double)k2 + d22, 0.0, 0.0);
        this.renderTorchAtAngle(block, (double)i2 + d3, (double)j2 + d2, (double)k2 + d4, 0.0, 0.0);
        int k1 = block.getBlockTextureFromSide(1);
        int l1 = k1 % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int i22 = k1 / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        double d5 = (float)l1 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d6 = ((float)l1 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d7 = (float)i22 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d8 = ((float)i22 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        float f1 = 0.125f;
        float f22 = i2 + 1;
        float f3 = i2 + 1;
        float f4 = i2 + 0;
        float f5 = i2 + 0;
        float f6 = k2 + 0;
        float f7 = k2 + 1;
        float f8 = k2 + 1;
        float f9 = k2 + 0;
        float f10 = (float)j2 + f1;
        if (i1 == 2) {
            f22 = f3 = (float)(i2 + 0);
            f4 = f5 = (float)(i2 + 1);
            f6 = f9 = (float)(k2 + 1);
            f7 = f8 = (float)(k2 + 0);
        } else if (i1 == 3) {
            f22 = f5 = (float)(i2 + 0);
            f3 = f4 = (float)(i2 + 1);
            f6 = f7 = (float)(k2 + 0);
            f8 = f9 = (float)(k2 + 1);
        } else if (i1 == 1) {
            f22 = f5 = (float)(i2 + 1);
            f3 = f4 = (float)(i2 + 0);
            f6 = f7 = (float)(k2 + 1);
            f8 = f9 = (float)(k2 + 0);
        }
        tessellator.addVertexWithUV(f5, f10, f9, d5, d7);
        tessellator.addVertexWithUV(f4, f10, f8, d5, d8);
        tessellator.addVertexWithUV(f3, f10, f7, d6, d8);
        tessellator.addVertexWithUV(f22, f10, f6, d6, d7);
        return true;
    }

    public void func_31078_d(Block block, int i2, int j2, int k2) {
        this.renderAllFaces = true;
        this.func_31074_b(block, i2, j2, k2, true);
        this.renderAllFaces = false;
    }

    private boolean func_31074_b(Block block, int i2, int j2, int k2, boolean flag) {
        int l2 = this.blockAccess.getBlockMetadata(i2, j2, k2);
        boolean flag1 = flag || (l2 & 8) != 0;
        int i1 = BlockPistonBase.getOrientation(l2);
        if (flag1) {
            switch (i1) {
                case 0: {
                    this.uvRotateEast = 3;
                    this.uvRotateWest = 3;
                    this.uvRotateSouth = 3;
                    this.uvRotateNorth = 3;
                    block.setBlockBounds(0.0f, 0.25f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 1: {
                    block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
                    break;
                }
                case 2: {
                    this.uvRotateSouth = 1;
                    this.uvRotateNorth = 2;
                    block.setBlockBounds(0.0f, 0.0f, 0.25f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 3: {
                    this.uvRotateSouth = 2;
                    this.uvRotateNorth = 1;
                    this.uvRotateTop = 3;
                    this.uvRotateBottom = 3;
                    block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.75f);
                    break;
                }
                case 4: {
                    this.uvRotateEast = 1;
                    this.uvRotateWest = 2;
                    this.uvRotateTop = 2;
                    this.uvRotateBottom = 1;
                    block.setBlockBounds(0.25f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 5: {
                    this.uvRotateEast = 2;
                    this.uvRotateWest = 1;
                    this.uvRotateTop = 1;
                    this.uvRotateBottom = 2;
                    block.setBlockBounds(0.0f, 0.0f, 0.0f, 0.75f, 1.0f, 1.0f);
                }
            }
            this.renderStandardBlock(block, i2, j2, k2);
            this.uvRotateEast = 0;
            this.uvRotateWest = 0;
            this.uvRotateSouth = 0;
            this.uvRotateNorth = 0;
            this.uvRotateTop = 0;
            this.uvRotateBottom = 0;
            block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else {
            switch (i1) {
                case 0: {
                    this.uvRotateEast = 3;
                    this.uvRotateWest = 3;
                    this.uvRotateSouth = 3;
                    this.uvRotateNorth = 3;
                    break;
                }
                case 2: {
                    this.uvRotateSouth = 1;
                    this.uvRotateNorth = 2;
                    break;
                }
                case 3: {
                    this.uvRotateSouth = 2;
                    this.uvRotateNorth = 1;
                    this.uvRotateTop = 3;
                    this.uvRotateBottom = 3;
                    break;
                }
                case 4: {
                    this.uvRotateEast = 1;
                    this.uvRotateWest = 2;
                    this.uvRotateTop = 2;
                    this.uvRotateBottom = 1;
                    break;
                }
                case 5: {
                    this.uvRotateEast = 2;
                    this.uvRotateWest = 1;
                    this.uvRotateTop = 1;
                    this.uvRotateBottom = 2;
                }
            }
            this.renderStandardBlock(block, i2, j2, k2);
            this.uvRotateEast = 0;
            this.uvRotateWest = 0;
            this.uvRotateSouth = 0;
            this.uvRotateNorth = 0;
            this.uvRotateTop = 0;
            this.uvRotateBottom = 0;
        }
        return true;
    }

    private void func_31076_a(double d2, double d1, double d22, double d3, double d4, double d5, float f2, double d6) {
        int i2 = Block.texCoordToIndex(12, 6);
        if (this.overrideBlockTexture >= 0) {
            i2 = this.overrideBlockTexture;
        }
        int j2 = i2 % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int k2 = i2 / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        Tessellator tessellator = Tessellator.instance;
        double d7 = (float)(j2 + 0) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d8 = (float)(k2 + 0) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d9 = ((double)j2 + d6 - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d10 = ((double)((float)k2 + 4.0f) - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        tessellator.setColorOpaque_F(f2, f2, f2);
        tessellator.addVertexWithUV(d2, d3, d4, d9, d8);
        tessellator.addVertexWithUV(d2, d22, d4, d7, d8);
        tessellator.addVertexWithUV(d1, d22, d5, d7, d10);
        tessellator.addVertexWithUV(d1, d3, d5, d9, d10);
    }

    private void func_31081_b(double d2, double d1, double d22, double d3, double d4, double d5, float f2, double d6) {
        int i2 = Block.texCoordToIndex(12, 6);
        if (this.overrideBlockTexture >= 0) {
            i2 = this.overrideBlockTexture;
        }
        int j2 = i2 % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int k2 = i2 / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        Tessellator tessellator = Tessellator.instance;
        double d7 = (float)(j2 + 0) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d8 = (float)(k2 + 0) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d9 = ((double)j2 + d6 - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d10 = ((double)((float)k2 + 4.0f) - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        tessellator.setColorOpaque_F(f2, f2, f2);
        tessellator.addVertexWithUV(d2, d22, d5, d9, d8);
        tessellator.addVertexWithUV(d2, d22, d4, d7, d8);
        tessellator.addVertexWithUV(d1, d3, d4, d7, d10);
        tessellator.addVertexWithUV(d1, d3, d5, d9, d10);
    }

    private void func_31077_c(double d2, double d1, double d22, double d3, double d4, double d5, float f2, double d6) {
        int i2 = Block.texCoordToIndex(12, 6);
        if (this.overrideBlockTexture >= 0) {
            i2 = this.overrideBlockTexture;
        }
        int j2 = i2 % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int k2 = i2 / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        Tessellator tessellator = Tessellator.instance;
        double d7 = (float)(j2 + 0) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d8 = (float)(k2 + 0) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d9 = ((double)j2 + d6 - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d10 = ((double)((float)k2 + 4.0f) - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        tessellator.setColorOpaque_F(f2, f2, f2);
        tessellator.addVertexWithUV(d1, d22, d4, d9, d8);
        tessellator.addVertexWithUV(d2, d22, d4, d7, d8);
        tessellator.addVertexWithUV(d2, d3, d5, d7, d10);
        tessellator.addVertexWithUV(d1, d3, d5, d9, d10);
    }

    public void func_31079_a(Block block, int i2, int j2, int k2, boolean flag) {
        this.renderAllFaces = true;
        this.func_31080_c(block, i2, j2, k2, flag);
        this.renderAllFaces = false;
    }

    private boolean func_31080_c(Block block, int i2, int j2, int k2, boolean flag) {
        int l2 = this.blockAccess.getBlockMetadata(i2, j2, k2);
        int i1 = BlockPistonHead.func_31050_c(l2);
        float f2 = block.getBlockBrightness(this.blockAccess, i2, j2, k2);
        float f1 = flag ? 1.0f : 0.5f;
        double d2 = flag ? 16.0 : 8.0;
        switch (i1) {
            case 0: {
                this.uvRotateEast = 3;
                this.uvRotateWest = 3;
                this.uvRotateSouth = 3;
                this.uvRotateNorth = 3;
                block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.25f, 1.0f);
                this.renderStandardBlock(block, i2, j2, k2);
                this.func_31076_a((float)i2 + 0.375f, (float)i2 + 0.625f, (float)j2 + 0.25f, (float)j2 + 0.25f + f1, (float)k2 + 0.625f, (float)k2 + 0.625f, f2 * 0.8f, d2);
                this.func_31076_a((float)i2 + 0.625f, (float)i2 + 0.375f, (float)j2 + 0.25f, (float)j2 + 0.25f + f1, (float)k2 + 0.375f, (float)k2 + 0.375f, f2 * 0.8f, d2);
                this.func_31076_a((float)i2 + 0.375f, (float)i2 + 0.375f, (float)j2 + 0.25f, (float)j2 + 0.25f + f1, (float)k2 + 0.375f, (float)k2 + 0.625f, f2 * 0.6f, d2);
                this.func_31076_a((float)i2 + 0.625f, (float)i2 + 0.625f, (float)j2 + 0.25f, (float)j2 + 0.25f + f1, (float)k2 + 0.625f, (float)k2 + 0.375f, f2 * 0.6f, d2);
                break;
            }
            case 1: {
                block.setBlockBounds(0.0f, 0.75f, 0.0f, 1.0f, 1.0f, 1.0f);
                this.renderStandardBlock(block, i2, j2, k2);
                this.func_31076_a((float)i2 + 0.375f, (float)i2 + 0.625f, (float)j2 - 0.25f + 1.0f - f1, (float)j2 - 0.25f + 1.0f, (float)k2 + 0.625f, (float)k2 + 0.625f, f2 * 0.8f, d2);
                this.func_31076_a((float)i2 + 0.625f, (float)i2 + 0.375f, (float)j2 - 0.25f + 1.0f - f1, (float)j2 - 0.25f + 1.0f, (float)k2 + 0.375f, (float)k2 + 0.375f, f2 * 0.8f, d2);
                this.func_31076_a((float)i2 + 0.375f, (float)i2 + 0.375f, (float)j2 - 0.25f + 1.0f - f1, (float)j2 - 0.25f + 1.0f, (float)k2 + 0.375f, (float)k2 + 0.625f, f2 * 0.6f, d2);
                this.func_31076_a((float)i2 + 0.625f, (float)i2 + 0.625f, (float)j2 - 0.25f + 1.0f - f1, (float)j2 - 0.25f + 1.0f, (float)k2 + 0.625f, (float)k2 + 0.375f, f2 * 0.6f, d2);
                break;
            }
            case 2: {
                this.uvRotateSouth = 1;
                this.uvRotateNorth = 2;
                block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.25f);
                this.renderStandardBlock(block, i2, j2, k2);
                this.func_31081_b((float)i2 + 0.375f, (float)i2 + 0.375f, (float)j2 + 0.625f, (float)j2 + 0.375f, (float)k2 + 0.25f, (float)k2 + 0.25f + f1, f2 * 0.6f, d2);
                this.func_31081_b((float)i2 + 0.625f, (float)i2 + 0.625f, (float)j2 + 0.375f, (float)j2 + 0.625f, (float)k2 + 0.25f, (float)k2 + 0.25f + f1, f2 * 0.6f, d2);
                this.func_31081_b((float)i2 + 0.375f, (float)i2 + 0.625f, (float)j2 + 0.375f, (float)j2 + 0.375f, (float)k2 + 0.25f, (float)k2 + 0.25f + f1, f2 * 0.5f, d2);
                this.func_31081_b((float)i2 + 0.625f, (float)i2 + 0.375f, (float)j2 + 0.625f, (float)j2 + 0.625f, (float)k2 + 0.25f, (float)k2 + 0.25f + f1, f2, d2);
                break;
            }
            case 3: {
                this.uvRotateSouth = 2;
                this.uvRotateNorth = 1;
                this.uvRotateTop = 3;
                this.uvRotateBottom = 3;
                block.setBlockBounds(0.0f, 0.0f, 0.75f, 1.0f, 1.0f, 1.0f);
                this.renderStandardBlock(block, i2, j2, k2);
                this.func_31081_b((float)i2 + 0.375f, (float)i2 + 0.375f, (float)j2 + 0.625f, (float)j2 + 0.375f, (float)k2 - 0.25f + 1.0f - f1, (float)k2 - 0.25f + 1.0f, f2 * 0.6f, d2);
                this.func_31081_b((float)i2 + 0.625f, (float)i2 + 0.625f, (float)j2 + 0.375f, (float)j2 + 0.625f, (float)k2 - 0.25f + 1.0f - f1, (float)k2 - 0.25f + 1.0f, f2 * 0.6f, d2);
                this.func_31081_b((float)i2 + 0.375f, (float)i2 + 0.625f, (float)j2 + 0.375f, (float)j2 + 0.375f, (float)k2 - 0.25f + 1.0f - f1, (float)k2 - 0.25f + 1.0f, f2 * 0.5f, d2);
                this.func_31081_b((float)i2 + 0.625f, (float)i2 + 0.375f, (float)j2 + 0.625f, (float)j2 + 0.625f, (float)k2 - 0.25f + 1.0f - f1, (float)k2 - 0.25f + 1.0f, f2, d2);
                break;
            }
            case 4: {
                this.uvRotateEast = 1;
                this.uvRotateWest = 2;
                this.uvRotateTop = 2;
                this.uvRotateBottom = 1;
                block.setBlockBounds(0.0f, 0.0f, 0.0f, 0.25f, 1.0f, 1.0f);
                this.renderStandardBlock(block, i2, j2, k2);
                this.func_31077_c((float)i2 + 0.25f, (float)i2 + 0.25f + f1, (float)j2 + 0.375f, (float)j2 + 0.375f, (float)k2 + 0.625f, (float)k2 + 0.375f, f2 * 0.5f, d2);
                this.func_31077_c((float)i2 + 0.25f, (float)i2 + 0.25f + f1, (float)j2 + 0.625f, (float)j2 + 0.625f, (float)k2 + 0.375f, (float)k2 + 0.625f, f2, d2);
                this.func_31077_c((float)i2 + 0.25f, (float)i2 + 0.25f + f1, (float)j2 + 0.375f, (float)j2 + 0.625f, (float)k2 + 0.375f, (float)k2 + 0.375f, f2 * 0.6f, d2);
                this.func_31077_c((float)i2 + 0.25f, (float)i2 + 0.25f + f1, (float)j2 + 0.625f, (float)j2 + 0.375f, (float)k2 + 0.625f, (float)k2 + 0.625f, f2 * 0.6f, d2);
                break;
            }
            case 5: {
                this.uvRotateEast = 2;
                this.uvRotateWest = 1;
                this.uvRotateTop = 1;
                this.uvRotateBottom = 2;
                block.setBlockBounds(0.75f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                this.renderStandardBlock(block, i2, j2, k2);
                this.func_31077_c((float)i2 - 0.25f + 1.0f - f1, (float)i2 - 0.25f + 1.0f, (float)j2 + 0.375f, (float)j2 + 0.375f, (float)k2 + 0.625f, (float)k2 + 0.375f, f2 * 0.5f, d2);
                this.func_31077_c((float)i2 - 0.25f + 1.0f - f1, (float)i2 - 0.25f + 1.0f, (float)j2 + 0.625f, (float)j2 + 0.625f, (float)k2 + 0.375f, (float)k2 + 0.625f, f2, d2);
                this.func_31077_c((float)i2 - 0.25f + 1.0f - f1, (float)i2 - 0.25f + 1.0f, (float)j2 + 0.375f, (float)j2 + 0.625f, (float)k2 + 0.375f, (float)k2 + 0.375f, f2 * 0.6f, d2);
                this.func_31077_c((float)i2 - 0.25f + 1.0f - f1, (float)i2 - 0.25f + 1.0f, (float)j2 + 0.625f, (float)j2 + 0.375f, (float)k2 + 0.625f, (float)k2 + 0.625f, f2 * 0.6f, d2);
            }
        }
        this.uvRotateEast = 0;
        this.uvRotateWest = 0;
        this.uvRotateSouth = 0;
        this.uvRotateNorth = 0;
        this.uvRotateTop = 0;
        this.uvRotateBottom = 0;
        block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return true;
    }

    public boolean renderBlockLever(Block block, int i2, int j2, int k2) {
        boolean flag1;
        int l2 = this.blockAccess.getBlockMetadata(i2, j2, k2);
        int i1 = l2 & 7;
        boolean flag = (l2 & 8) > 0;
        Tessellator tessellator = Tessellator.instance;
        boolean bl2 = flag1 = this.overrideBlockTexture >= 0;
        if (!flag1) {
            this.overrideBlockTexture = Block.cobbleStone.getBlockTextureFromSide(0);
        }
        float f2 = 0.25f;
        float f1 = 0.1875f;
        float f22 = 0.1875f;
        if (i1 == 5) {
            block.setBlockBounds(0.5f - f1, 0.0f, 0.5f - f2, 0.5f + f1, f22, 0.5f + f2);
        } else if (i1 == 6) {
            block.setBlockBounds(0.5f - f2, 0.0f, 0.5f - f1, 0.5f + f2, f22, 0.5f + f1);
        } else if (i1 == 4) {
            block.setBlockBounds(0.5f - f1, 0.5f - f2, 1.0f - f22, 0.5f + f1, 0.5f + f2, 1.0f);
        } else if (i1 == 3) {
            block.setBlockBounds(0.5f - f1, 0.5f - f2, 0.0f, 0.5f + f1, 0.5f + f2, f22);
        } else if (i1 == 2) {
            block.setBlockBounds(1.0f - f22, 0.5f - f2, 0.5f - f1, 1.0f, 0.5f + f2, 0.5f + f1);
        } else if (i1 == 1) {
            block.setBlockBounds(0.0f, 0.5f - f2, 0.5f - f1, f22, 0.5f + f2, 0.5f + f1);
        }
        this.renderStandardBlock(block, i2, j2, k2);
        if (!flag1) {
            this.overrideBlockTexture = -1;
        }
        float f3 = block.getBlockBrightness(this.blockAccess, i2, j2, k2);
        if (Block.lightValue[block.blockID] > 0) {
            f3 = 1.0f;
        }
        tessellator.setColorOpaque_F(f3, f3, f3);
        int j1 = block.getBlockTextureFromSide(0);
        if (this.overrideBlockTexture >= 0) {
            j1 = this.overrideBlockTexture;
        }
        int k1 = j1 % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int l1 = j1 / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        float f4 = (float)k1 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        float f5 = ((float)k1 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        float f6 = (float)l1 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        float f7 = ((float)l1 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        Vec3D[] avec3d = new Vec3D[8];
        float f8 = 0.0625f;
        float f9 = 0.0625f;
        float f10 = 0.625f;
        avec3d[0] = Vec3D.createVector(-f8, 0.0, -f9);
        avec3d[1] = Vec3D.createVector(f8, 0.0, -f9);
        avec3d[2] = Vec3D.createVector(f8, 0.0, f9);
        avec3d[3] = Vec3D.createVector(-f8, 0.0, f9);
        avec3d[4] = Vec3D.createVector(-f8, f10, -f9);
        avec3d[5] = Vec3D.createVector(f8, f10, -f9);
        avec3d[6] = Vec3D.createVector(f8, f10, f9);
        avec3d[7] = Vec3D.createVector(-f8, f10, f9);
        for (int i22 = 0; i22 < 8; ++i22) {
            if (flag) {
                avec3d[i22].zCoord -= 0.0625;
                avec3d[i22].rotateAroundX(0.6981317f);
            } else {
                avec3d[i22].zCoord += 0.0625;
                avec3d[i22].rotateAroundX(-0.6981317f);
            }
            if (i1 == 6) {
                avec3d[i22].rotateAroundY(1.570796f);
            }
            if (i1 < 5) {
                avec3d[i22].yCoord -= 0.375;
                avec3d[i22].rotateAroundX(1.570796f);
                if (i1 == 4) {
                    avec3d[i22].rotateAroundY(0.0f);
                }
                if (i1 == 3) {
                    avec3d[i22].rotateAroundY(3.141593f);
                }
                if (i1 == 2) {
                    avec3d[i22].rotateAroundY(1.570796f);
                }
                if (i1 == 1) {
                    avec3d[i22].rotateAroundY(-1.570796f);
                }
                avec3d[i22].xCoord += (double)i2 + 0.5;
                avec3d[i22].yCoord += (double)((float)j2 + 0.5f);
                avec3d[i22].zCoord += (double)k2 + 0.5;
                continue;
            }
            avec3d[i22].xCoord += (double)i2 + 0.5;
            avec3d[i22].yCoord += (double)((float)j2 + 0.125f);
            avec3d[i22].zCoord += (double)k2 + 0.5;
        }
        Vec3D vec3d = null;
        Vec3D vec3d1 = null;
        Vec3D vec3d2 = null;
        Vec3D vec3d3 = null;
        for (int j22 = 0; j22 < 6; ++j22) {
            if (j22 == 0) {
                f4 = (float)((double)k1 + (double)TextureFX.tileWidthTerrain * 0.4375) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                f5 = ((float)((double)k1 + (double)TextureFX.tileWidthTerrain * 0.5625) - 0.01f) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                f6 = (float)((double)l1 + (double)TextureFX.tileWidthTerrain * 0.375) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                f7 = ((float)((double)l1 + (double)TextureFX.tileWidthTerrain * 0.5) - 0.01f) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            } else if (j22 == 2) {
                f4 = (float)((double)k1 + (double)TextureFX.tileWidthTerrain * 0.4375) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                f5 = ((float)((double)k1 + (double)TextureFX.tileWidthTerrain * 0.5625) - 0.01f) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                f6 = (float)((double)l1 + (double)TextureFX.tileWidthTerrain * 0.375) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                f7 = ((float)(l1 + TextureFX.tileWidthTerrain) - 0.01f) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            }
            if (j22 == 0) {
                vec3d = avec3d[0];
                vec3d1 = avec3d[1];
                vec3d2 = avec3d[2];
                vec3d3 = avec3d[3];
            } else if (j22 == 1) {
                vec3d = avec3d[7];
                vec3d1 = avec3d[6];
                vec3d2 = avec3d[5];
                vec3d3 = avec3d[4];
            } else if (j22 == 2) {
                vec3d = avec3d[1];
                vec3d1 = avec3d[0];
                vec3d2 = avec3d[4];
                vec3d3 = avec3d[5];
            } else if (j22 == 3) {
                vec3d = avec3d[2];
                vec3d1 = avec3d[1];
                vec3d2 = avec3d[5];
                vec3d3 = avec3d[6];
            } else if (j22 == 4) {
                vec3d = avec3d[3];
                vec3d1 = avec3d[2];
                vec3d2 = avec3d[6];
                vec3d3 = avec3d[7];
            } else if (j22 == 5) {
                vec3d = avec3d[0];
                vec3d1 = avec3d[3];
                vec3d2 = avec3d[7];
                vec3d3 = avec3d[4];
            }
            tessellator.addVertexWithUV(vec3d.xCoord, vec3d.yCoord, vec3d.zCoord, f4, f7);
            tessellator.addVertexWithUV(vec3d1.xCoord, vec3d1.yCoord, vec3d1.zCoord, f5, f7);
            tessellator.addVertexWithUV(vec3d2.xCoord, vec3d2.yCoord, vec3d2.zCoord, f5, f6);
            tessellator.addVertexWithUV(vec3d3.xCoord, vec3d3.yCoord, vec3d3.zCoord, f4, f6);
        }
        return true;
    }

    public boolean renderBlockFire(Block block, int i2, int j2, int k2) {
        Tessellator tessellator = Tessellator.instance;
        int l2 = block.getBlockTextureFromSide(0);
        if (this.overrideBlockTexture >= 0) {
            l2 = this.overrideBlockTexture;
        }
        float f2 = block.getBlockBrightness(this.blockAccess, i2, j2, k2);
        tessellator.setColorOpaque_F(f2, f2, f2);
        int i1 = l2 % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int j1 = l2 / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        double d2 = (float)i1 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d22 = ((float)i1 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d4 = (float)j1 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d6 = ((float)j1 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        float f1 = 1.4f;
        if (this.blockAccess.isBlockNormalCube(i2, j2 - 1, k2) || ((BlockFire)Block.fire).canBlockCatchFire(this.blockAccess, i2, j2 - 1, k2)) {
            double d8 = (double)i2 + 0.5 + 0.2;
            double d9 = (double)i2 + 0.5 - 0.2;
            double d12 = (double)k2 + 0.5 + 0.2;
            double d14 = (double)k2 + 0.5 - 0.2;
            double d16 = (double)i2 + 0.5 - 0.3;
            double d18 = (double)i2 + 0.5 + 0.3;
            double d20 = (double)k2 + 0.5 - 0.3;
            double d222 = (double)k2 + 0.5 + 0.3;
            tessellator.addVertexWithUV(d16, (float)j2 + f1, k2 + 1, d22, d4);
            tessellator.addVertexWithUV(d8, j2 + 0, k2 + 1, d22, d6);
            tessellator.addVertexWithUV(d8, j2 + 0, k2 + 0, d2, d6);
            tessellator.addVertexWithUV(d16, (float)j2 + f1, k2 + 0, d2, d4);
            tessellator.addVertexWithUV(d18, (float)j2 + f1, k2 + 0, d22, d4);
            tessellator.addVertexWithUV(d9, j2 + 0, k2 + 0, d22, d6);
            tessellator.addVertexWithUV(d9, j2 + 0, k2 + 1, d2, d6);
            tessellator.addVertexWithUV(d18, (float)j2 + f1, k2 + 1, d2, d4);
            d2 = (float)i1 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d22 = ((float)i1 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = (float)(j1 + TextureFX.tileWidthTerrain) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((float)j1 + ((float)TextureFX.tileWidthTerrain - 0.01f) + (float)TextureFX.tileWidthTerrain) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            tessellator.addVertexWithUV(i2 + 1, (float)j2 + f1, d222, d22, d4);
            tessellator.addVertexWithUV(i2 + 1, j2 + 0, d14, d22, d6);
            tessellator.addVertexWithUV(i2 + 0, j2 + 0, d14, d2, d6);
            tessellator.addVertexWithUV(i2 + 0, (float)j2 + f1, d222, d2, d4);
            tessellator.addVertexWithUV(i2 + 0, (float)j2 + f1, d20, d22, d4);
            tessellator.addVertexWithUV(i2 + 0, j2 + 0, d12, d22, d6);
            tessellator.addVertexWithUV(i2 + 1, j2 + 0, d12, d2, d6);
            tessellator.addVertexWithUV(i2 + 1, (float)j2 + f1, d20, d2, d4);
            d8 = (double)i2 + 0.5 - 0.5;
            d9 = (double)i2 + 0.5 + 0.5;
            d12 = (double)k2 + 0.5 - 0.5;
            d14 = (double)k2 + 0.5 + 0.5;
            d16 = (double)i2 + 0.5 - 0.4;
            d18 = (double)i2 + 0.5 + 0.4;
            d20 = (double)k2 + 0.5 - 0.4;
            d222 = (double)k2 + 0.5 + 0.4;
            tessellator.addVertexWithUV(d16, (float)j2 + f1, k2 + 0, d2, d4);
            tessellator.addVertexWithUV(d8, j2 + 0, k2 + 0, d2, d6);
            tessellator.addVertexWithUV(d8, j2 + 0, k2 + 1, d22, d6);
            tessellator.addVertexWithUV(d16, (float)j2 + f1, k2 + 1, d22, d4);
            tessellator.addVertexWithUV(d18, (float)j2 + f1, k2 + 1, d2, d4);
            tessellator.addVertexWithUV(d9, j2 + 0, k2 + 1, d2, d6);
            tessellator.addVertexWithUV(d9, j2 + 0, k2 + 0, d22, d6);
            tessellator.addVertexWithUV(d18, (float)j2 + f1, k2 + 0, d22, d4);
            d2 = (float)i1 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d22 = ((float)i1 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = (float)j1 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((float)j1 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            tessellator.addVertexWithUV(i2 + 0, (float)j2 + f1, d222, d2, d4);
            tessellator.addVertexWithUV(i2 + 0, j2 + 0, d14, d2, d6);
            tessellator.addVertexWithUV(i2 + 1, j2 + 0, d14, d22, d6);
            tessellator.addVertexWithUV(i2 + 1, (float)j2 + f1, d222, d22, d4);
            tessellator.addVertexWithUV(i2 + 1, (float)j2 + f1, d20, d2, d4);
            tessellator.addVertexWithUV(i2 + 1, j2 + 0, d12, d2, d6);
            tessellator.addVertexWithUV(i2 + 0, j2 + 0, d12, d22, d6);
            tessellator.addVertexWithUV(i2 + 0, (float)j2 + f1, d20, d22, d4);
        } else {
            float f3 = 0.2f;
            float f4 = 0.0625f;
            if ((i2 + j2 + k2 & 1) == 1) {
                d2 = (float)i1 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                d22 = ((float)i1 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                d4 = (float)(j1 + TextureFX.tileWidthTerrain) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                d6 = ((float)j1 + ((float)TextureFX.tileWidthTerrain - 0.01f) + (float)TextureFX.tileWidthTerrain) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            }
            if ((i2 / 2 + j2 / 2 + k2 / 2 & 1) == 1) {
                double d10 = d22;
                d22 = d2;
                d2 = d10;
            }
            if (((BlockFire)Block.fire).canBlockCatchFire(this.blockAccess, i2 - 1, j2, k2)) {
                tessellator.addVertexWithUV((float)i2 + f3, (float)j2 + f1 + f4, k2 + 1, d22, d4);
                tessellator.addVertexWithUV(i2 + 0, (float)(j2 + 0) + f4, k2 + 1, d22, d6);
                tessellator.addVertexWithUV(i2 + 0, (float)(j2 + 0) + f4, k2 + 0, d2, d6);
                tessellator.addVertexWithUV((float)i2 + f3, (float)j2 + f1 + f4, k2 + 0, d2, d4);
                tessellator.addVertexWithUV((float)i2 + f3, (float)j2 + f1 + f4, k2 + 0, d2, d4);
                tessellator.addVertexWithUV(i2 + 0, (float)(j2 + 0) + f4, k2 + 0, d2, d6);
                tessellator.addVertexWithUV(i2 + 0, (float)(j2 + 0) + f4, k2 + 1, d22, d6);
                tessellator.addVertexWithUV((float)i2 + f3, (float)j2 + f1 + f4, k2 + 1, d22, d4);
            }
            if (((BlockFire)Block.fire).canBlockCatchFire(this.blockAccess, i2 + 1, j2, k2)) {
                tessellator.addVertexWithUV((float)(i2 + 1) - f3, (float)j2 + f1 + f4, k2 + 0, d2, d4);
                tessellator.addVertexWithUV(i2 + 1 - 0, (float)(j2 + 0) + f4, k2 + 0, d2, d6);
                tessellator.addVertexWithUV(i2 + 1 - 0, (float)(j2 + 0) + f4, k2 + 1, d22, d6);
                tessellator.addVertexWithUV((float)(i2 + 1) - f3, (float)j2 + f1 + f4, k2 + 1, d22, d4);
                tessellator.addVertexWithUV((float)(i2 + 1) - f3, (float)j2 + f1 + f4, k2 + 1, d22, d4);
                tessellator.addVertexWithUV(i2 + 1 - 0, (float)(j2 + 0) + f4, k2 + 1, d22, d6);
                tessellator.addVertexWithUV(i2 + 1 - 0, (float)(j2 + 0) + f4, k2 + 0, d2, d6);
                tessellator.addVertexWithUV((float)(i2 + 1) - f3, (float)j2 + f1 + f4, k2 + 0, d2, d4);
            }
            if (((BlockFire)Block.fire).canBlockCatchFire(this.blockAccess, i2, j2, k2 - 1)) {
                tessellator.addVertexWithUV(i2 + 0, (float)j2 + f1 + f4, (float)k2 + f3, d22, d4);
                tessellator.addVertexWithUV(i2 + 0, (float)(j2 + 0) + f4, k2 + 0, d22, d6);
                tessellator.addVertexWithUV(i2 + 1, (float)(j2 + 0) + f4, k2 + 0, d2, d6);
                tessellator.addVertexWithUV(i2 + 1, (float)j2 + f1 + f4, (float)k2 + f3, d2, d4);
                tessellator.addVertexWithUV(i2 + 1, (float)j2 + f1 + f4, (float)k2 + f3, d2, d4);
                tessellator.addVertexWithUV(i2 + 1, (float)(j2 + 0) + f4, k2 + 0, d2, d6);
                tessellator.addVertexWithUV(i2 + 0, (float)(j2 + 0) + f4, k2 + 0, d22, d6);
                tessellator.addVertexWithUV(i2 + 0, (float)j2 + f1 + f4, (float)k2 + f3, d22, d4);
            }
            if (((BlockFire)Block.fire).canBlockCatchFire(this.blockAccess, i2, j2, k2 + 1)) {
                tessellator.addVertexWithUV(i2 + 1, (float)j2 + f1 + f4, (float)(k2 + 1) - f3, d2, d4);
                tessellator.addVertexWithUV(i2 + 1, (float)(j2 + 0) + f4, k2 + 1 - 0, d2, d6);
                tessellator.addVertexWithUV(i2 + 0, (float)(j2 + 0) + f4, k2 + 1 - 0, d22, d6);
                tessellator.addVertexWithUV(i2 + 0, (float)j2 + f1 + f4, (float)(k2 + 1) - f3, d22, d4);
                tessellator.addVertexWithUV(i2 + 0, (float)j2 + f1 + f4, (float)(k2 + 1) - f3, d22, d4);
                tessellator.addVertexWithUV(i2 + 0, (float)(j2 + 0) + f4, k2 + 1 - 0, d22, d6);
                tessellator.addVertexWithUV(i2 + 1, (float)(j2 + 0) + f4, k2 + 1 - 0, d2, d6);
                tessellator.addVertexWithUV(i2 + 1, (float)j2 + f1 + f4, (float)(k2 + 1) - f3, d2, d4);
            }
            if (((BlockFire)Block.fire).canBlockCatchFire(this.blockAccess, i2, j2 + 1, k2)) {
                double d11 = (double)i2 + 0.5 + 0.5;
                double d13 = (double)i2 + 0.5 - 0.5;
                double d15 = (double)k2 + 0.5 + 0.5;
                double d17 = (double)k2 + 0.5 - 0.5;
                double d19 = (double)i2 + 0.5 - 0.5;
                double d21 = (double)i2 + 0.5 + 0.5;
                double d23 = (double)k2 + 0.5 - 0.5;
                double d24 = (double)k2 + 0.5 + 0.5;
                double d1 = (float)i1 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                double d3 = ((float)i1 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                double d5 = (float)j1 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                double d7 = ((float)j1 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                float f22 = -0.2f;
                if ((i2 + ++j2 + k2 & 1) == 0) {
                    tessellator.addVertexWithUV(d19, (float)j2 + f22, k2 + 0, d3, d5);
                    tessellator.addVertexWithUV(d11, j2 + 0, k2 + 0, d3, d7);
                    tessellator.addVertexWithUV(d11, j2 + 0, k2 + 1, d1, d7);
                    tessellator.addVertexWithUV(d19, (float)j2 + f22, k2 + 1, d1, d5);
                    d1 = (float)i1 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                    d3 = ((float)i1 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                    d5 = (float)(j1 + TextureFX.tileWidthTerrain) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                    d7 = ((float)j1 + ((float)TextureFX.tileWidthTerrain - 0.01f) + (float)TextureFX.tileWidthTerrain) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                    tessellator.addVertexWithUV(d21, (float)j2 + f22, k2 + 1, d3, d5);
                    tessellator.addVertexWithUV(d13, j2 + 0, k2 + 1, d3, d7);
                    tessellator.addVertexWithUV(d13, j2 + 0, k2 + 0, d1, d7);
                    tessellator.addVertexWithUV(d21, (float)j2 + f22, k2 + 0, d1, d5);
                } else {
                    tessellator.addVertexWithUV(i2 + 0, (float)j2 + f22, d24, d3, d5);
                    tessellator.addVertexWithUV(i2 + 0, j2 + 0, d17, d3, d7);
                    tessellator.addVertexWithUV(i2 + 1, j2 + 0, d17, d1, d7);
                    tessellator.addVertexWithUV(i2 + 1, (float)j2 + f22, d24, d1, d5);
                    d1 = (float)i1 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                    d3 = ((float)i1 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                    d5 = (float)(j1 + TextureFX.tileWidthTerrain) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                    d7 = ((float)j1 + ((float)TextureFX.tileWidthTerrain - 0.01f) + (float)TextureFX.tileWidthTerrain) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                    tessellator.addVertexWithUV(i2 + 1, (float)j2 + f22, d23, d3, d5);
                    tessellator.addVertexWithUV(i2 + 1, j2 + 0, d15, d3, d7);
                    tessellator.addVertexWithUV(i2 + 0, j2 + 0, d15, d1, d7);
                    tessellator.addVertexWithUV(i2 + 0, (float)j2 + f22, d23, d1, d5);
                }
            }
        }
        return true;
    }

    public boolean renderBlockRedstoneWire(Block block, int i2, int j2, int k2) {
        boolean flag3;
        Tessellator tessellator = Tessellator.instance;
        int l2 = this.blockAccess.getBlockMetadata(i2, j2, k2);
        int i1 = block.getBlockTextureFromSideAndMetadata(1, l2);
        if (this.overrideBlockTexture >= 0) {
            i1 = this.overrideBlockTexture;
        }
        float f2 = block.getBlockBrightness(this.blockAccess, i2, j2, k2);
        float f1 = (float)l2 / 15.0f;
        float f22 = f1 * 0.6f + 0.4f;
        if (l2 == 0) {
            f22 = 0.3f;
        }
        float f3 = f1 * f1 * 0.7f - 0.5f;
        float f4 = f1 * f1 * 0.6f - 0.7f;
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f4 < 0.0f) {
            f4 = 0.0f;
        }
        tessellator.setColorOpaque_F(f2 * f22, f2 * f3, f2 * f4);
        int j1 = i1 % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int k1 = i1 / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        double d2 = (float)j1 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d22 = ((float)j1 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d4 = (float)k1 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d6 = ((float)k1 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        boolean flag = BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, i2 - 1, j2, k2, 1) || !this.blockAccess.isBlockNormalCube(i2 - 1, j2, k2) && BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, i2 - 1, j2 - 1, k2, -1);
        boolean flag1 = BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, i2 + 1, j2, k2, 3) || !this.blockAccess.isBlockNormalCube(i2 + 1, j2, k2) && BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, i2 + 1, j2 - 1, k2, -1);
        boolean flag2 = BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, i2, j2, k2 - 1, 2) || !this.blockAccess.isBlockNormalCube(i2, j2, k2 - 1) && BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, i2, j2 - 1, k2 - 1, -1);
        boolean bl2 = flag3 = BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, i2, j2, k2 + 1, 0) || !this.blockAccess.isBlockNormalCube(i2, j2, k2 + 1) && BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, i2, j2 - 1, k2 + 1, -1);
        if (!this.blockAccess.isBlockNormalCube(i2, j2 + 1, k2)) {
            if (this.blockAccess.isBlockNormalCube(i2 - 1, j2, k2) && BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, i2 - 1, j2 + 1, k2, -1)) {
                flag = true;
            }
            if (this.blockAccess.isBlockNormalCube(i2 + 1, j2, k2) && BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, i2 + 1, j2 + 1, k2, -1)) {
                flag1 = true;
            }
            if (this.blockAccess.isBlockNormalCube(i2, j2, k2 - 1) && BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, i2, j2 + 1, k2 - 1, -1)) {
                flag2 = true;
            }
            if (this.blockAccess.isBlockNormalCube(i2, j2, k2 + 1) && BlockRedstoneWire.isPowerProviderOrWire(this.blockAccess, i2, j2 + 1, k2 + 1, -1)) {
                flag3 = true;
            }
        }
        float f5 = i2 + 0;
        float f6 = i2 + 1;
        float f7 = k2 + 0;
        float f8 = k2 + 1;
        int byte0 = 0;
        if ((flag || flag1) && !flag2 && !flag3) {
            byte0 = 1;
        }
        if ((flag2 || flag3) && !flag1 && !flag) {
            byte0 = 2;
        }
        if (byte0 != 0) {
            d2 = (float)(j1 + TextureFX.tileWidthTerrain) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d22 = ((float)(j1 + TextureFX.tileWidthTerrain) + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = (float)k1 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((float)k1 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        }
        if (byte0 == 0) {
            if (flag1 || flag2 || flag3 || flag) {
                if (!flag) {
                    f5 += 0.3125f;
                }
                if (!flag) {
                    d2 += 0.3125 / (double)net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES;
                }
                if (!flag1) {
                    f6 -= 0.3125f;
                }
                if (!flag1) {
                    d22 -= 0.3125 / (double)net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES;
                }
                if (!flag2) {
                    f7 += 0.3125f;
                }
                if (!flag2) {
                    d4 += 0.3125 / (double)net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES;
                }
                if (!flag3) {
                    f8 -= 0.3125f;
                }
                if (!flag3) {
                    d6 -= 0.3125 / (double)net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES;
                }
            }
            tessellator.addVertexWithUV(f6, (float)j2 + 0.015625f, f8, d22, d6);
            tessellator.addVertexWithUV(f6, (float)j2 + 0.015625f, f7, d22, d4);
            tessellator.addVertexWithUV(f5, (float)j2 + 0.015625f, f7, d2, d4);
            tessellator.addVertexWithUV(f5, (float)j2 + 0.015625f, f8, d2, d6);
            tessellator.addVertexWithUV(f6, (float)j2 + 0.015625f, f8, d22, d6 + (double)(TextureFX.tileWidthTerrain / (net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
            tessellator.addVertexWithUV(f6, (float)j2 + 0.015625f, f7, d22, d4 + (double)(TextureFX.tileWidthTerrain / (net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
            tessellator.addVertexWithUV(f5, (float)j2 + 0.015625f, f7, d2, d4 + (double)(TextureFX.tileWidthTerrain / (net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
            tessellator.addVertexWithUV(f5, (float)j2 + 0.015625f, f8, d2, d6 + (double)(TextureFX.tileWidthTerrain / (net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
        } else if (byte0 == 1) {
            tessellator.addVertexWithUV(f6, (float)j2 + 0.015625f, f8, d22, d6);
            tessellator.addVertexWithUV(f6, (float)j2 + 0.015625f, f7, d22, d4);
            tessellator.addVertexWithUV(f5, (float)j2 + 0.015625f, f7, d2, d4);
            tessellator.addVertexWithUV(f5, (float)j2 + 0.015625f, f8, d2, d6);
            tessellator.addVertexWithUV(f6, (float)j2 + 0.015625f, f8, d22, d6 + (double)(TextureFX.tileWidthTerrain / (net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
            tessellator.addVertexWithUV(f6, (float)j2 + 0.015625f, f7, d22, d4 + (double)(TextureFX.tileWidthTerrain / (net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
            tessellator.addVertexWithUV(f5, (float)j2 + 0.015625f, f7, d2, d4 + (double)(TextureFX.tileWidthTerrain / (net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
            tessellator.addVertexWithUV(f5, (float)j2 + 0.015625f, f8, d2, d6 + (double)(TextureFX.tileWidthTerrain / (net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
        } else if (byte0 == 2) {
            tessellator.addVertexWithUV(f6, (float)j2 + 0.015625f, f8, d22, d6);
            tessellator.addVertexWithUV(f6, (float)j2 + 0.015625f, f7, d2, d6);
            tessellator.addVertexWithUV(f5, (float)j2 + 0.015625f, f7, d2, d4);
            tessellator.addVertexWithUV(f5, (float)j2 + 0.015625f, f8, d22, d4);
            tessellator.addVertexWithUV(f6, (float)j2 + 0.015625f, f8, d22, d6 + (double)(TextureFX.tileWidthTerrain / (net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
            tessellator.addVertexWithUV(f6, (float)j2 + 0.015625f, f7, d2, d6 + (double)(TextureFX.tileWidthTerrain / (net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
            tessellator.addVertexWithUV(f5, (float)j2 + 0.015625f, f7, d2, d4 + (double)(TextureFX.tileWidthTerrain / (net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
            tessellator.addVertexWithUV(f5, (float)j2 + 0.015625f, f8, d22, d4 + (double)(TextureFX.tileWidthTerrain / (net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
        }
        if (!this.blockAccess.isBlockNormalCube(i2, j2 + 1, k2)) {
            double d1 = (float)(j1 + TextureFX.tileWidthTerrain) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            double d3 = ((float)(j1 + TextureFX.tileWidthTerrain) + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            double d5 = (float)k1 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            double d7 = ((float)k1 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            if (this.blockAccess.isBlockNormalCube(i2 - 1, j2, k2) && this.blockAccess.getBlockId(i2 - 1, j2 + 1, k2) == Block.wireRedstone.blockID) {
                tessellator.setColorOpaque_F(f2 * f22, f2 * f3, f2 * f4);
                tessellator.addVertexWithUV((float)i2 + 0.015625f, (float)(j2 + 1) + 0.021875f, k2 + 1, d3, d5);
                tessellator.addVertexWithUV((float)i2 + 0.015625f, j2 + 0, k2 + 1, d1, d5);
                tessellator.addVertexWithUV((float)i2 + 0.015625f, j2 + 0, k2 + 0, d1, d7);
                tessellator.addVertexWithUV((float)i2 + 0.015625f, (float)(j2 + 1) + 0.021875f, k2 + 0, d3, d7);
                tessellator.addVertexWithUV((float)i2 + 0.015625f, (float)(j2 + 1) + 0.021875f, k2 + 1, d3, d5 + (double)(TextureFX.tileWidthTerrain / (net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
                tessellator.addVertexWithUV((float)i2 + 0.015625f, j2 + 0, k2 + 1, d1, d5 + (double)(TextureFX.tileWidthTerrain / (net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
                tessellator.addVertexWithUV((float)i2 + 0.015625f, j2 + 0, k2 + 0, d1, d7 + (double)(TextureFX.tileWidthTerrain / (net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
                tessellator.addVertexWithUV((float)i2 + 0.015625f, (float)(j2 + 1) + 0.021875f, k2 + 0, d3, d7 + (double)(TextureFX.tileWidthTerrain / (net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
            }
            if (this.blockAccess.isBlockNormalCube(i2 + 1, j2, k2) && this.blockAccess.getBlockId(i2 + 1, j2 + 1, k2) == Block.wireRedstone.blockID) {
                tessellator.setColorOpaque_F(f2 * f22, f2 * f3, f2 * f4);
                tessellator.addVertexWithUV((float)(i2 + 1) - 0.015625f, j2 + 0, k2 + 1, d1, d7);
                tessellator.addVertexWithUV((float)(i2 + 1) - 0.015625f, (float)(j2 + 1) + 0.021875f, k2 + 1, d3, d7);
                tessellator.addVertexWithUV((float)(i2 + 1) - 0.015625f, (float)(j2 + 1) + 0.021875f, k2 + 0, d3, d5);
                tessellator.addVertexWithUV((float)(i2 + 1) - 0.015625f, j2 + 0, k2 + 0, d1, d5);
                tessellator.addVertexWithUV((float)(i2 + 1) - 0.015625f, j2 + 0, k2 + 1, d1, d7 + (double)(TextureFX.tileWidthTerrain / (net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
                tessellator.addVertexWithUV((float)(i2 + 1) - 0.015625f, (float)(j2 + 1) + 0.021875f, k2 + 1, d3, d7 + (double)(TextureFX.tileWidthTerrain / (net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
                tessellator.addVertexWithUV((float)(i2 + 1) - 0.015625f, (float)(j2 + 1) + 0.021875f, k2 + 0, d3, d5 + (double)(TextureFX.tileWidthTerrain / (net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
                tessellator.addVertexWithUV((float)(i2 + 1) - 0.015625f, j2 + 0, k2 + 0, d1, d5 + (double)(TextureFX.tileWidthTerrain / (net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
            }
            if (this.blockAccess.isBlockNormalCube(i2, j2, k2 - 1) && this.blockAccess.getBlockId(i2, j2 + 1, k2 - 1) == Block.wireRedstone.blockID) {
                tessellator.setColorOpaque_F(f2 * f22, f2 * f3, f2 * f4);
                tessellator.addVertexWithUV(i2 + 1, j2 + 0, (float)k2 + 0.015625f, d1, d7);
                tessellator.addVertexWithUV(i2 + 1, (float)(j2 + 1) + 0.021875f, (float)k2 + 0.015625f, d3, d7);
                tessellator.addVertexWithUV(i2 + 0, (float)(j2 + 1) + 0.021875f, (float)k2 + 0.015625f, d3, d5);
                tessellator.addVertexWithUV(i2 + 0, j2 + 0, (float)k2 + 0.015625f, d1, d5);
                tessellator.addVertexWithUV(i2 + 1, j2 + 0, (float)k2 + 0.015625f, d1, d7 + (double)(TextureFX.tileWidthTerrain / (net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
                tessellator.addVertexWithUV(i2 + 1, (float)(j2 + 1) + 0.021875f, (float)k2 + 0.015625f, d3, d7 + (double)(TextureFX.tileWidthTerrain / (net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
                tessellator.addVertexWithUV(i2 + 0, (float)(j2 + 1) + 0.021875f, (float)k2 + 0.015625f, d3, d5 + (double)(TextureFX.tileWidthTerrain / (net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
                tessellator.addVertexWithUV(i2 + 0, j2 + 0, (float)k2 + 0.015625f, d1, d5 + (double)(TextureFX.tileWidthTerrain / (net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
            }
            if (this.blockAccess.isBlockNormalCube(i2, j2, k2 + 1) && this.blockAccess.getBlockId(i2, j2 + 1, k2 + 1) == Block.wireRedstone.blockID) {
                tessellator.setColorOpaque_F(f2 * f22, f2 * f3, f2 * f4);
                tessellator.addVertexWithUV(i2 + 1, (float)(j2 + 1) + 0.021875f, (float)(k2 + 1) - 0.015625f, d3, d5);
                tessellator.addVertexWithUV(i2 + 1, j2 + 0, (float)(k2 + 1) - 0.015625f, d1, d5);
                tessellator.addVertexWithUV(i2 + 0, j2 + 0, (float)(k2 + 1) - 0.015625f, d1, d7);
                tessellator.addVertexWithUV(i2 + 0, (float)(j2 + 1) + 0.021875f, (float)(k2 + 1) - 0.015625f, d3, d7);
                tessellator.addVertexWithUV(i2 + 1, (float)(j2 + 1) + 0.021875f, (float)(k2 + 1) - 0.015625f, d3, d5 + (double)(TextureFX.tileWidthTerrain / (net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
                tessellator.addVertexWithUV(i2 + 1, j2 + 0, (float)(k2 + 1) - 0.015625f, d1, d5 + (double)(TextureFX.tileWidthTerrain / (net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
                tessellator.addVertexWithUV(i2 + 0, j2 + 0, (float)(k2 + 1) - 0.015625f, d1, d7 + (double)(TextureFX.tileWidthTerrain / (net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
                tessellator.addVertexWithUV(i2 + 0, (float)(j2 + 1) + 0.021875f, (float)(k2 + 1) - 0.015625f, d3, d7 + (double)(TextureFX.tileWidthTerrain / (net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
            }
        }
        return true;
    }

    public boolean renderBlockMinecartTrack(BlockRail blockrail, int i2, int j2, int k2) {
        Tessellator tessellator = Tessellator.instance;
        int l2 = this.blockAccess.getBlockMetadata(i2, j2, k2);
        int i1 = blockrail.getBlockTextureFromSideAndMetadata(0, l2);
        if (this.overrideBlockTexture >= 0) {
            i1 = this.overrideBlockTexture;
        }
        if (blockrail.getIsPowered()) {
            l2 &= 7;
        }
        float f2 = blockrail.getBlockBrightness(this.blockAccess, i2, j2, k2);
        if (this.overbright) {
            i1 = blockrail.getBlockOverbright(this.blockAccess, i2, j2, k2, 0);
            if (i1 == -1) {
                return false;
            }
            f2 = 1.0f;
        }
        tessellator.setColorOpaque_F(f2, f2, f2);
        int j1 = i1 % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int k1 = i1 / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        double d2 = (float)j1 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d1 = ((float)j1 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d22 = (float)k1 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d3 = ((float)k1 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        float f1 = 0.0625f;
        float f22 = i2 + 1;
        float f3 = i2 + 1;
        float f4 = i2 + 0;
        float f5 = i2 + 0;
        float f6 = k2 + 0;
        float f7 = k2 + 1;
        float f8 = k2 + 1;
        float f9 = k2 + 0;
        float f10 = (float)j2 + f1;
        float f11 = (float)j2 + f1;
        float f12 = (float)j2 + f1;
        float f13 = (float)j2 + f1;
        if (l2 == 1 || l2 == 2 || l2 == 3 || l2 == 7) {
            f22 = f5 = (float)(i2 + 1);
            f3 = f4 = (float)(i2 + 0);
            f6 = f7 = (float)(k2 + 1);
            f8 = f9 = (float)(k2 + 0);
        } else if (l2 == 8) {
            f22 = f3 = (float)(i2 + 0);
            f4 = f5 = (float)(i2 + 1);
            f6 = f9 = (float)(k2 + 1);
            f7 = f8 = (float)(k2 + 0);
        } else if (l2 == 9) {
            f22 = f5 = (float)(i2 + 0);
            f3 = f4 = (float)(i2 + 1);
            f6 = f7 = (float)(k2 + 0);
            f8 = f9 = (float)(k2 + 1);
        }
        if (l2 == 2 || l2 == 4) {
            f10 += 1.0f;
            f13 += 1.0f;
        } else if (l2 == 3 || l2 == 5) {
            f11 += 1.0f;
            f12 += 1.0f;
        }
        tessellator.addVertexWithUV(f22, f10, f6, d1, d22);
        tessellator.addVertexWithUV(f3, f11, f7, d1, d3);
        tessellator.addVertexWithUV(f4, f12, f8, d2, d3);
        tessellator.addVertexWithUV(f5, f13, f9, d2, d22);
        tessellator.addVertexWithUV(f5, f13, f9, d2, d22);
        tessellator.addVertexWithUV(f4, f12, f8, d2, d3);
        tessellator.addVertexWithUV(f3, f11, f7, d1, d3);
        tessellator.addVertexWithUV(f22, f10, f6, d1, d22);
        return true;
    }

    public boolean renderBlockLadder(Block block, int i2, int j2, int k2) {
        Tessellator tessellator = Tessellator.instance;
        int l2 = block.getBlockTextureFromSide(0);
        if (this.overrideBlockTexture >= 0) {
            l2 = this.overrideBlockTexture;
        }
        float f2 = block.getBlockBrightness(this.blockAccess, i2, j2, k2);
        tessellator.setColorOpaque_F(f2, f2, f2);
        int i1 = l2 % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int j1 = l2 / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        double d2 = (float)i1 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d1 = ((float)i1 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d22 = (float)j1 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d3 = ((float)j1 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        int k1 = this.blockAccess.getBlockMetadata(i2, j2, k2);
        float f1 = 0.0f;
        float f22 = 0.05f;
        if (k1 == 5) {
            tessellator.addVertexWithUV((float)i2 + f22, (float)(j2 + 1) + f1, (float)(k2 + 1) + f1, d2, d22);
            tessellator.addVertexWithUV((float)i2 + f22, (float)(j2 + 0) - f1, (float)(k2 + 1) + f1, d2, d3);
            tessellator.addVertexWithUV((float)i2 + f22, (float)(j2 + 0) - f1, (float)(k2 + 0) - f1, d1, d3);
            tessellator.addVertexWithUV((float)i2 + f22, (float)(j2 + 1) + f1, (float)(k2 + 0) - f1, d1, d22);
        }
        if (k1 == 4) {
            tessellator.addVertexWithUV((float)(i2 + 1) - f22, (float)(j2 + 0) - f1, (float)(k2 + 1) + f1, d1, d3);
            tessellator.addVertexWithUV((float)(i2 + 1) - f22, (float)(j2 + 1) + f1, (float)(k2 + 1) + f1, d1, d22);
            tessellator.addVertexWithUV((float)(i2 + 1) - f22, (float)(j2 + 1) + f1, (float)(k2 + 0) - f1, d2, d22);
            tessellator.addVertexWithUV((float)(i2 + 1) - f22, (float)(j2 + 0) - f1, (float)(k2 + 0) - f1, d2, d3);
        }
        if (k1 == 3) {
            tessellator.addVertexWithUV((float)(i2 + 1) + f1, (float)(j2 + 0) - f1, (float)k2 + f22, d1, d3);
            tessellator.addVertexWithUV((float)(i2 + 1) + f1, (float)(j2 + 1) + f1, (float)k2 + f22, d1, d22);
            tessellator.addVertexWithUV((float)(i2 + 0) - f1, (float)(j2 + 1) + f1, (float)k2 + f22, d2, d22);
            tessellator.addVertexWithUV((float)(i2 + 0) - f1, (float)(j2 + 0) - f1, (float)k2 + f22, d2, d3);
        }
        if (k1 == 2) {
            tessellator.addVertexWithUV((float)(i2 + 1) + f1, (float)(j2 + 1) + f1, (float)(k2 + 1) - f22, d2, d22);
            tessellator.addVertexWithUV((float)(i2 + 1) + f1, (float)(j2 + 0) - f1, (float)(k2 + 1) - f22, d2, d3);
            tessellator.addVertexWithUV((float)(i2 + 0) - f1, (float)(j2 + 0) - f1, (float)(k2 + 1) - f22, d1, d3);
            tessellator.addVertexWithUV((float)(i2 + 0) - f1, (float)(j2 + 1) + f1, (float)(k2 + 1) - f22, d1, d22);
        }
        return true;
    }

    public boolean renderBlockReed(Block block, int i2, int j2, int k2) {
        Tessellator tessellator = Tessellator.instance;
        float f2 = block.getBlockBrightness(this.blockAccess, i2, j2, k2);
        int l2 = block.colorMultiplier(this.world, this.blockAccess, i2, j2, k2);
        float f1 = (float)(l2 >> 16 & 0xFF) / 255.0f;
        float f22 = (float)(l2 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(l2 & 0xFF) / 255.0f;
        if (EntityRenderer.field_28135_a) {
            float f4 = (f1 * 30.0f + f22 * 59.0f + f3 * 11.0f) / 100.0f;
            float f5 = (f1 * 30.0f + f22 * 70.0f) / 100.0f;
            float f6 = (f1 * 30.0f + f3 * 70.0f) / 100.0f;
            f1 = f4;
            f22 = f5;
            f3 = f6;
        }
        tessellator.setColorOpaque_F(f2 * f1, f2 * f22, f2 * f3);
        double d2 = i2;
        double d1 = j2;
        double d22 = k2;
        if (block == Block.tallgrass || block == Block.tallgrassFern) {
            long l1 = (long)(i2 * 3129871) ^ (long)k2 * 116129781L ^ (long)j2;
            l1 = l1 * l1 * 42317861L + l1 * 11L;
            d2 += ((double)((float)(l1 >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
            d1 += ((double)((float)(l1 >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
            d22 += ((double)((float)(l1 >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
        }
        this.renderCrossedSquares(block, this.blockAccess.getBlockMetadata(i2, j2, k2), d2, d1, d22);
        return true;
    }

    public boolean renderBlockCrops(Block block, int i2, int j2, int k2) {
        Tessellator tessellator = Tessellator.instance;
        float f2 = block.getBlockBrightness(this.blockAccess, i2, j2, k2);
        tessellator.setColorOpaque_F(f2, f2, f2);
        this.func_1245_b(block, this.blockAccess.getBlockMetadata(i2, j2, k2), i2, (float)j2 - 0.0625f, k2);
        return true;
    }

    public void renderTorchAtAngle(Block block, double x2, double y2, double z2, double topOffsetX, double topOffsetZ) {
        Tessellator tessellator = Tessellator.instance;
        int textureIndex = block.getBlockTextureFromSide(0);
        if (this.overrideBlockTexture >= 0) {
            textureIndex = this.overrideBlockTexture;
        }
        int texCoordX = textureIndex % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int texCoordY = textureIndex / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        float minU = (float)texCoordX / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        float maxU = ((float)texCoordX + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        float minV = (float)texCoordY / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        float maxV = ((float)texCoordY + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double topMinU = (double)minU + (double)TextureFX.tileWidthTerrain * 0.4375 / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double topMinV = (double)minV + (double)TextureFX.tileWidthTerrain * 0.375 / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double topMaxU = (double)minU + (double)TextureFX.tileWidthTerrain * 0.5625 / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double topMaxV = (double)minV + (double)TextureFX.tileWidthTerrain * 0.5 / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double bottomMinU = (double)minU + (double)TextureFX.tileWidthTerrain * 0.4375 / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double bottomMinV = (double)minV + (double)TextureFX.tileWidthTerrain * 0.875 / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double bottomMaxU = (double)minU + (double)TextureFX.tileWidthTerrain * 0.5625 / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double bottomMaxV = (double)minV + (double)TextureFX.tileWidthTerrain * 1.0 / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d9 = (x2 += 0.5) - 0.5;
        double d10 = x2 + 0.5;
        double d11 = (z2 += 0.5) - 0.5;
        double d12 = z2 + 0.5;
        double d13 = 0.0625;
        double d14 = 0.625;
        tessellator.addVertexWithUV(x2 - d13 + topOffsetX, y2 + 0.0, z2 + d13 + topOffsetZ, bottomMinU, bottomMaxV);
        tessellator.addVertexWithUV(x2 - d13 + topOffsetX, y2 + 0.0, z2 - d13 + topOffsetZ, bottomMinU, bottomMinV);
        tessellator.addVertexWithUV(x2 + topOffsetX + d13, y2 + 0.0, z2 - d13 + topOffsetZ, bottomMaxU, bottomMinV);
        tessellator.addVertexWithUV(x2 + topOffsetX + d13, y2 + 0.0, z2 + d13 + topOffsetZ, bottomMaxU, bottomMaxV);
        tessellator.addVertexWithUV(x2 + topOffsetX * (1.0 - d14) - d13, y2 + d14, z2 + topOffsetZ * (1.0 - d14) - d13, topMinU, topMinV);
        tessellator.addVertexWithUV(x2 + topOffsetX * (1.0 - d14) - d13, y2 + d14, z2 + topOffsetZ * (1.0 - d14) + d13, topMinU, topMaxV);
        tessellator.addVertexWithUV(x2 + topOffsetX * (1.0 - d14) + d13, y2 + d14, z2 + topOffsetZ * (1.0 - d14) + d13, topMaxU, topMaxV);
        tessellator.addVertexWithUV(x2 + topOffsetX * (1.0 - d14) + d13, y2 + d14, z2 + topOffsetZ * (1.0 - d14) - d13, topMaxU, topMinV);
        tessellator.addVertexWithUV(x2 - d13, y2 + 1.0, d11, minU, minV);
        tessellator.addVertexWithUV(x2 - d13 + topOffsetX, y2 + 0.0, d11 + topOffsetZ, minU, maxV);
        tessellator.addVertexWithUV(x2 - d13 + topOffsetX, y2 + 0.0, d12 + topOffsetZ, maxU, maxV);
        tessellator.addVertexWithUV(x2 - d13, y2 + 1.0, d12, maxU, minV);
        tessellator.addVertexWithUV(x2 + d13, y2 + 1.0, d12, minU, minV);
        tessellator.addVertexWithUV(x2 + topOffsetX + d13, y2 + 0.0, d12 + topOffsetZ, minU, maxV);
        tessellator.addVertexWithUV(x2 + topOffsetX + d13, y2 + 0.0, d11 + topOffsetZ, maxU, maxV);
        tessellator.addVertexWithUV(x2 + d13, y2 + 1.0, d11, maxU, minV);
        tessellator.addVertexWithUV(d9, y2 + 1.0, z2 + d13, minU, minV);
        tessellator.addVertexWithUV(d9 + topOffsetX, y2 + 0.0, z2 + d13 + topOffsetZ, minU, maxV);
        tessellator.addVertexWithUV(d10 + topOffsetX, y2 + 0.0, z2 + d13 + topOffsetZ, maxU, maxV);
        tessellator.addVertexWithUV(d10, y2 + 1.0, z2 + d13, maxU, minV);
        tessellator.addVertexWithUV(d10, y2 + 1.0, z2 - d13, minU, minV);
        tessellator.addVertexWithUV(d10 + topOffsetX, y2 + 0.0, z2 - d13 + topOffsetZ, minU, maxV);
        tessellator.addVertexWithUV(d9 + topOffsetX, y2 + 0.0, z2 - d13 + topOffsetZ, maxU, maxV);
        tessellator.addVertexWithUV(d9, y2 + 1.0, z2 - d13, maxU, minV);
    }

    public void renderCrossedSquares(Block block, int i2, double d2, double d1, double d22) {
        Tessellator tessellator = Tessellator.instance;
        int j2 = block.getBlockTextureFromSideAndMetadata(0, i2);
        if (this.overrideBlockTexture >= 0) {
            j2 = this.overrideBlockTexture;
        }
        int k2 = j2 % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int l2 = j2 / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        double d3 = (float)k2 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d4 = ((float)k2 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d5 = (float)l2 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d6 = ((float)l2 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d7 = d2 + 0.5 - (double)0.45f;
        double d8 = d2 + 0.5 + (double)0.45f;
        double d9 = d22 + 0.5 - (double)0.45f;
        double d10 = d22 + 0.5 + (double)0.45f;
        tessellator.addVertexWithUV(d7, d1 + 1.0, d9, d3, d5);
        tessellator.addVertexWithUV(d7, d1 + 0.0, d9, d3, d6);
        tessellator.addVertexWithUV(d8, d1 + 0.0, d10, d4, d6);
        tessellator.addVertexWithUV(d8, d1 + 1.0, d10, d4, d5);
        tessellator.addVertexWithUV(d8, d1 + 1.0, d10, d3, d5);
        tessellator.addVertexWithUV(d8, d1 + 0.0, d10, d3, d6);
        tessellator.addVertexWithUV(d7, d1 + 0.0, d9, d4, d6);
        tessellator.addVertexWithUV(d7, d1 + 1.0, d9, d4, d5);
        tessellator.addVertexWithUV(d7, d1 + 1.0, d10, d3, d5);
        tessellator.addVertexWithUV(d7, d1 + 0.0, d10, d3, d6);
        tessellator.addVertexWithUV(d8, d1 + 0.0, d9, d4, d6);
        tessellator.addVertexWithUV(d8, d1 + 1.0, d9, d4, d5);
        tessellator.addVertexWithUV(d8, d1 + 1.0, d9, d3, d5);
        tessellator.addVertexWithUV(d8, d1 + 0.0, d9, d3, d6);
        tessellator.addVertexWithUV(d7, d1 + 0.0, d10, d4, d6);
        tessellator.addVertexWithUV(d7, d1 + 1.0, d10, d4, d5);
    }

    public void func_1245_b(Block block, int i2, double d2, double d1, double d22) {
        Tessellator tessellator = Tessellator.instance;
        int j2 = block.getBlockTextureFromSideAndMetadata(0, i2);
        if (this.overrideBlockTexture >= 0) {
            j2 = this.overrideBlockTexture;
        }
        int k2 = j2 % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int l2 = j2 / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        double d3 = (float)k2 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d4 = ((float)k2 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d5 = (float)l2 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d6 = ((float)l2 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d7 = d2 + 0.5 - 0.25;
        double d8 = d2 + 0.5 + 0.25;
        double d9 = d22 + 0.5 - 0.5;
        double d10 = d22 + 0.5 + 0.5;
        tessellator.addVertexWithUV(d7, d1 + 1.0, d9, d3, d5);
        tessellator.addVertexWithUV(d7, d1 + 0.0, d9, d3, d6);
        tessellator.addVertexWithUV(d7, d1 + 0.0, d10, d4, d6);
        tessellator.addVertexWithUV(d7, d1 + 1.0, d10, d4, d5);
        tessellator.addVertexWithUV(d7, d1 + 1.0, d10, d3, d5);
        tessellator.addVertexWithUV(d7, d1 + 0.0, d10, d3, d6);
        tessellator.addVertexWithUV(d7, d1 + 0.0, d9, d4, d6);
        tessellator.addVertexWithUV(d7, d1 + 1.0, d9, d4, d5);
        tessellator.addVertexWithUV(d8, d1 + 1.0, d10, d3, d5);
        tessellator.addVertexWithUV(d8, d1 + 0.0, d10, d3, d6);
        tessellator.addVertexWithUV(d8, d1 + 0.0, d9, d4, d6);
        tessellator.addVertexWithUV(d8, d1 + 1.0, d9, d4, d5);
        tessellator.addVertexWithUV(d8, d1 + 1.0, d9, d3, d5);
        tessellator.addVertexWithUV(d8, d1 + 0.0, d9, d3, d6);
        tessellator.addVertexWithUV(d8, d1 + 0.0, d10, d4, d6);
        tessellator.addVertexWithUV(d8, d1 + 1.0, d10, d4, d5);
        d7 = d2 + 0.5 - 0.5;
        d8 = d2 + 0.5 + 0.5;
        d9 = d22 + 0.5 - 0.25;
        d10 = d22 + 0.5 + 0.25;
        tessellator.addVertexWithUV(d7, d1 + 1.0, d9, d3, d5);
        tessellator.addVertexWithUV(d7, d1 + 0.0, d9, d3, d6);
        tessellator.addVertexWithUV(d8, d1 + 0.0, d9, d4, d6);
        tessellator.addVertexWithUV(d8, d1 + 1.0, d9, d4, d5);
        tessellator.addVertexWithUV(d8, d1 + 1.0, d9, d3, d5);
        tessellator.addVertexWithUV(d8, d1 + 0.0, d9, d3, d6);
        tessellator.addVertexWithUV(d7, d1 + 0.0, d9, d4, d6);
        tessellator.addVertexWithUV(d7, d1 + 1.0, d9, d4, d5);
        tessellator.addVertexWithUV(d8, d1 + 1.0, d10, d3, d5);
        tessellator.addVertexWithUV(d8, d1 + 0.0, d10, d3, d6);
        tessellator.addVertexWithUV(d7, d1 + 0.0, d10, d4, d6);
        tessellator.addVertexWithUV(d7, d1 + 1.0, d10, d4, d5);
        tessellator.addVertexWithUV(d7, d1 + 1.0, d10, d3, d5);
        tessellator.addVertexWithUV(d7, d1 + 0.0, d10, d3, d6);
        tessellator.addVertexWithUV(d8, d1 + 0.0, d10, d4, d6);
        tessellator.addVertexWithUV(d8, d1 + 1.0, d10, d4, d5);
    }

    public boolean renderBlockSpikes(BlockSpikes block, int x2, int y2, int z2) {
        Tessellator tessellator = Tessellator.instance;
        int metaData = this.blockAccess.getBlockMetadata(x2, y2, z2);
        int j2 = block.getBlockTextureFromSide(2);
        if (this.overrideBlockTexture >= 0) {
            j2 = this.overrideBlockTexture;
        }
        block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.1875f, 1.0f);
        this.renderStandardBlock(block, x2, y2, z2);
        if (BlockSpikes.isSpikesUp(metaData)) {
            float f2 = block.getBlockBrightness(this.blockAccess, x2, y2, z2);
            tessellator.setColorOpaque_F(f2, f2, f2);
            int k2 = j2 % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
            int l2 = j2 / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
            double d3 = (float)k2 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            double d4 = ((float)k2 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            double d5 = (float)l2 / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            double d6 = ((float)l2 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            double d7 = (double)x2 + 0.5 - 0.25;
            double d8 = (double)x2 + 0.5 + 0.25;
            double d9 = (double)z2 + 0.5 - 0.5;
            double d10 = (double)z2 + 0.5 + 0.5;
            double mid = 0.25;
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y2 + 1.0, d9, d3, d5);
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y2 + 0.0, d9, d3, d6);
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y2 + 0.0, d10, d4, d6);
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y2 + 1.0, d10, d4, d5);
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y2 + 1.0, d10, d3, d5);
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y2 + 0.0, d10, d3, d6);
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y2 + 0.0, d9, d4, d6);
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y2 + 1.0, d9, d4, d5);
            tessellator.addVertexWithUV(d7 + mid, (double)y2 + 1.0, d9, d3, d5);
            tessellator.addVertexWithUV(d7 + mid, (double)y2 + 0.0, d9, d3, d6);
            tessellator.addVertexWithUV(d7 + mid, (double)y2 + 0.0, d10, d4, d6);
            tessellator.addVertexWithUV(d7 + mid, (double)y2 + 1.0, d10, d4, d5);
            tessellator.addVertexWithUV(d7 + mid, (double)y2 + 1.0, d10, d3, d5);
            tessellator.addVertexWithUV(d7 + mid, (double)y2 + 0.0, d10, d3, d6);
            tessellator.addVertexWithUV(d7 + mid, (double)y2 + 0.0, d9, d4, d6);
            tessellator.addVertexWithUV(d7 + mid, (double)y2 + 1.0, d9, d4, d5);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y2 + 1.0, d10, d3, d5);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y2 + 0.0, d10, d3, d6);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y2 + 0.0, d9, d4, d6);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y2 + 1.0, d9, d4, d5);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y2 + 1.0, d9, d3, d5);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y2 + 0.0, d9, d3, d6);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y2 + 0.0, d10, d4, d6);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y2 + 1.0, d10, d4, d5);
            d7 = (double)x2 + 0.5 - 0.5;
            d8 = (double)x2 + 0.5 + 0.5;
            d9 = (double)z2 + 0.5 - 0.25;
            d10 = (double)z2 + 0.5 + 0.25;
            tessellator.addVertexWithUV(d7, (double)y2 + 1.0, d9 - 0.0625, d3, d5);
            tessellator.addVertexWithUV(d7, (double)y2 + 0.0, d9 - 0.0625, d3, d6);
            tessellator.addVertexWithUV(d8, (double)y2 + 0.0, d9 - 0.0625, d4, d6);
            tessellator.addVertexWithUV(d8, (double)y2 + 1.0, d9 - 0.0625, d4, d5);
            tessellator.addVertexWithUV(d8, (double)y2 + 1.0, d9 - 0.0625, d3, d5);
            tessellator.addVertexWithUV(d8, (double)y2 + 0.0, d9 - 0.0625, d3, d6);
            tessellator.addVertexWithUV(d7, (double)y2 + 0.0, d9 - 0.0625, d4, d6);
            tessellator.addVertexWithUV(d7, (double)y2 + 1.0, d9 - 0.0625, d4, d5);
            tessellator.addVertexWithUV(d7, (double)y2 + 1.0, d9 + mid, d3, d5);
            tessellator.addVertexWithUV(d7, (double)y2 + 0.0, d9 + mid, d3, d6);
            tessellator.addVertexWithUV(d8, (double)y2 + 0.0, d9 + mid, d4, d6);
            tessellator.addVertexWithUV(d8, (double)y2 + 1.0, d9 + mid, d4, d5);
            tessellator.addVertexWithUV(d8, (double)y2 + 1.0, d9 + mid, d3, d5);
            tessellator.addVertexWithUV(d8, (double)y2 + 0.0, d9 + mid, d3, d6);
            tessellator.addVertexWithUV(d7, (double)y2 + 0.0, d9 + mid, d4, d6);
            tessellator.addVertexWithUV(d7, (double)y2 + 1.0, d9 + mid, d4, d5);
            tessellator.addVertexWithUV(d8, (double)y2 + 1.0, d10 + 0.0625, d3, d5);
            tessellator.addVertexWithUV(d8, (double)y2 + 0.0, d10 + 0.0625, d3, d6);
            tessellator.addVertexWithUV(d7, (double)y2 + 0.0, d10 + 0.0625, d4, d6);
            tessellator.addVertexWithUV(d7, (double)y2 + 1.0, d10 + 0.0625, d4, d5);
            tessellator.addVertexWithUV(d7, (double)y2 + 1.0, d10 + 0.0625, d3, d5);
            tessellator.addVertexWithUV(d7, (double)y2 + 0.0, d10 + 0.0625, d3, d6);
            tessellator.addVertexWithUV(d8, (double)y2 + 0.0, d10 + 0.0625, d4, d6);
            tessellator.addVertexWithUV(d8, (double)y2 + 1.0, d10 + 0.0625, d4, d5);
        }
        return true;
    }

    public boolean renderBlockFluids(Block block, int x2, int y2, int z2) {
        Tessellator tessellator = Tessellator.instance;
        int color = block.colorMultiplier(this.world, this.blockAccess, x2, y2, z2);
        float colorRed = (float)(color >> 16 & 0xFF) / 255.0f;
        float colorGreen = (float)(color >> 8 & 0xFF) / 255.0f;
        float colorBlue = (float)(color & 0xFF) / 255.0f;
        boolean renderTop = block.shouldSideBeRendered(this.blockAccess, x2, y2 + 1, z2, 1);
        boolean flag1 = block.shouldSideBeRendered(this.blockAccess, x2, y2 - 1, z2, 0);
        boolean[] aflag = new boolean[]{block.shouldSideBeRendered(this.blockAccess, x2, y2, z2 - 1, 2), block.shouldSideBeRendered(this.blockAccess, x2, y2, z2 + 1, 3), block.shouldSideBeRendered(this.blockAccess, x2 - 1, y2, z2, 4), block.shouldSideBeRendered(this.blockAccess, x2 + 1, y2, z2, 5)};
        if (!(renderTop || flag1 || aflag[0] || aflag[1] || aflag[2] || aflag[3])) {
            return false;
        }
        boolean flag2 = false;
        float f3 = 0.5f;
        float f4 = 1.0f;
        float f5 = 0.8f;
        float f6 = 0.6f;
        double d2 = 0.0;
        double d1 = 1.0;
        Material material = block.blockMaterial;
        int i1 = this.blockAccess.getBlockMetadata(x2, y2, z2);
        float f7 = this.func_1224_a(x2, y2, z2, material);
        float f8 = this.func_1224_a(x2, y2, z2 + 1, material);
        float f9 = this.func_1224_a(x2 + 1, y2, z2 + 1, material);
        float f10 = this.func_1224_a(x2 + 1, y2, z2, material);
        if (this.renderAllFaces || renderTop) {
            flag2 = true;
            int j1 = block.getBlockTextureFromSideAndMetadata(1, i1);
            float f12 = (float)BlockFluid.func_293_a(this.blockAccess, x2, y2, z2, material);
            if (f12 > -999.0f) {
                j1 = block.getBlockTextureFromSideAndMetadata(2, i1);
            }
            int i2 = j1 % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
            int k2 = j1 / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
            double d22 = ((double)i2 + (double)(TextureFX.tileWidthTerrain / 2)) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            double d3 = ((double)k2 + (double)(TextureFX.tileWidthTerrain / 2)) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            if (f12 < -999.0f) {
                f12 = 0.0f;
            } else {
                d22 = (float)(i2 + TextureFX.tileWidthTerrain) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                d3 = (float)(k2 + TextureFX.tileWidthTerrain) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            }
            float f14 = MathHelper.sin(f12) * (float)(TextureFX.tileWidthTerrain / 2) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            float f16 = MathHelper.cos(f12) * (float)(TextureFX.tileWidthTerrain / 2) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            float f18 = block.getBlockBrightness(this.blockAccess, x2, y2, z2);
            tessellator.setColorOpaque_F(f4 * f18 * colorRed, f4 * f18 * colorGreen, f4 * f18 * colorBlue);
            tessellator.addVertexWithUV(x2 + 0, (float)y2 + f7, z2 + 0, d22 - (double)f16 - (double)f14, d3 - (double)f16 + (double)f14);
            tessellator.addVertexWithUV(x2 + 0, (float)y2 + f8, z2 + 1, d22 - (double)f16 + (double)f14, d3 + (double)f16 + (double)f14);
            tessellator.addVertexWithUV(x2 + 1, (float)y2 + f9, z2 + 1, d22 + (double)f16 + (double)f14, d3 + (double)f16 - (double)f14);
            tessellator.addVertexWithUV(x2 + 1, (float)y2 + f10, z2 + 0, d22 + (double)f16 - (double)f14, d3 - (double)f16 - (double)f14);
        }
        if (this.renderAllFaces || flag1) {
            float f11 = block.getBlockBrightness(this.blockAccess, x2, y2 - 1, z2);
            tessellator.setColorOpaque_F(f3 * f11 * colorRed, f3 * f11 * colorGreen, f3 * f11 * colorBlue);
            this.renderBottomFace(block, x2, (float)y2 + 1.0E-4f, z2, block.getBlockTextureFromSide(0));
            flag2 = true;
        }
        for (int k1 = 0; k1 < 4; ++k1) {
            float f21;
            float f19;
            float f20;
            float f17;
            float f15;
            float f13;
            int l1 = x2;
            int j2 = y2;
            int l2 = z2;
            if (k1 == 0) {
                --l2;
            }
            if (k1 == 1) {
                ++l2;
            }
            if (k1 == 2) {
                --l1;
            }
            if (k1 == 3) {
                ++l1;
            }
            int i3 = block.getBlockTextureFromSideAndMetadata(k1 + 2, i1);
            int j3 = i3 % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
            int k3 = i3 / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
            if (!this.renderAllFaces && !aflag[k1]) continue;
            if (k1 == 0) {
                f13 = f7;
                f15 = f10;
                f17 = (float)x2 + 1.0E-4f;
                f20 = (float)(x2 + 1) - 1.0E-4f;
                f19 = (float)z2 + 1.0E-4f;
                f21 = (float)z2 + 1.0E-4f;
            } else if (k1 == 1) {
                f13 = f9;
                f15 = f8;
                f17 = (float)(x2 + 1) - 1.0E-4f;
                f20 = (float)x2 + 1.0E-4f;
                f19 = (float)(z2 + 1) - 1.0E-4f;
                f21 = (float)(z2 + 1) - 0.001f;
            } else if (k1 == 2) {
                f13 = f8;
                f15 = f7;
                f17 = (float)x2 + 1.0E-4f;
                f20 = (float)x2 + 1.0E-4f;
                f19 = (float)(z2 + 1) - 1.0E-4f;
                f21 = (float)z2 + 1.0E-4f;
            } else {
                f13 = f10;
                f15 = f9;
                f17 = (float)(x2 + 1) - 1.0E-4f;
                f20 = (float)(x2 + 1) - 1.0E-4f;
                f19 = (float)z2 + 1.0E-4f;
                f21 = (float)(z2 + 1) - 1.0E-4f;
            }
            flag2 = true;
            double d4 = (float)(j3 + 0) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            double d5 = ((double)(j3 + TextureFX.tileWidthTerrain) - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            double d6 = ((float)k3 + (1.0f - f13) * (float)TextureFX.tileWidthTerrain) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            double d7 = ((float)k3 + (1.0f - f15) * (float)TextureFX.tileWidthTerrain) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            double d8 = ((double)(k3 + TextureFX.tileWidthTerrain) - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            float f22 = block.getBlockBrightness(this.blockAccess, l1, j2, l2);
            f22 = k1 < 2 ? (f22 *= f5) : (f22 *= f6);
            tessellator.setColorOpaque_F(f4 * f22 * colorRed, f4 * f22 * colorGreen, f4 * f22 * colorBlue);
            tessellator.addVertexWithUV(f17, (float)y2 + f13, f19, d4, d6);
            tessellator.addVertexWithUV(f20, (float)y2 + f15, f21, d5, d7);
            tessellator.addVertexWithUV(f20, y2 + 0, f21, d5, d8);
            tessellator.addVertexWithUV(f17, y2 + 0, f19, d4, d8);
        }
        block.minY = d2;
        block.maxY = d1;
        return flag2;
    }

    private float func_1224_a(int i2, int j2, int k2, Material material) {
        int l2 = 0;
        float f2 = 0.0f;
        for (int i1 = 0; i1 < 4; ++i1) {
            int j1 = i2 - (i1 & 1);
            int k1 = j2;
            int l1 = k2 - (i1 >> 1 & 1);
            if (this.blockAccess.getBlockMaterial(j1, k1 + 1, l1) == material) {
                return 1.0f;
            }
            Material material1 = this.blockAccess.getBlockMaterial(j1, k1, l1);
            if (material1 == material) {
                int i22 = this.blockAccess.getBlockMetadata(j1, k1, l1);
                if (i22 >= 8 || i22 == 0) {
                    f2 += BlockFluid.getPercentAir(i22) * 10.0f;
                    l2 += 10;
                }
                f2 += BlockFluid.getPercentAir(i22);
                ++l2;
                continue;
            }
            if (material1.isSolid()) continue;
            f2 += 1.0f;
            ++l2;
        }
        return 1.0f - f2 / (float)l2;
    }

    public void renderBlockFallingSand(Block block, World world, int i2, int j2, int k2) {
        float f2 = 0.5f;
        float f1 = 1.0f;
        float f22 = 0.8f;
        float f3 = 0.6f;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        float f4 = block.getBlockBrightness(world, i2, j2, k2);
        float f5 = block.getBlockBrightness(world, i2, j2 - 1, k2);
        if (f5 < f4) {
            f5 = f4;
        }
        tessellator.setColorOpaque_F(f2 * f5, f2 * f5, f2 * f5);
        this.renderBottomFace(block, -0.5, -0.5, -0.5, block.getBlockTextureFromSide(0));
        f5 = block.getBlockBrightness(world, i2, j2 + 1, k2);
        if (f5 < f4) {
            f5 = f4;
        }
        tessellator.setColorOpaque_F(f1 * f5, f1 * f5, f1 * f5);
        this.renderTopFace(block, -0.5, -0.5, -0.5, block.getBlockTextureFromSide(1));
        f5 = block.getBlockBrightness(world, i2, j2, k2 - 1);
        if (f5 < f4) {
            f5 = f4;
        }
        tessellator.setColorOpaque_F(f22 * f5, f22 * f5, f22 * f5);
        this.renderEastFace(block, -0.5, -0.5, -0.5, block.getBlockTextureFromSide(2));
        f5 = block.getBlockBrightness(world, i2, j2, k2 + 1);
        if (f5 < f4) {
            f5 = f4;
        }
        tessellator.setColorOpaque_F(f22 * f5, f22 * f5, f22 * f5);
        this.renderWestFace(block, -0.5, -0.5, -0.5, block.getBlockTextureFromSide(3));
        f5 = block.getBlockBrightness(world, i2 - 1, j2, k2);
        if (f5 < f4) {
            f5 = f4;
        }
        tessellator.setColorOpaque_F(f3 * f5, f3 * f5, f3 * f5);
        this.renderNorthFace(block, -0.5, -0.5, -0.5, block.getBlockTextureFromSide(4));
        f5 = block.getBlockBrightness(world, i2 + 1, j2, k2);
        if (f5 < f4) {
            f5 = f4;
        }
        tessellator.setColorOpaque_F(f3 * f5, f3 * f5, f3 * f5);
        this.renderSouthFace(block, -0.5, -0.5, -0.5, block.getBlockTextureFromSide(5));
        tessellator.draw();
    }

    public boolean renderStandardBlock(Block block, int i2, int j2, int k2) {
        int l2 = block.colorMultiplier(this.world, this.blockAccess, i2, j2, k2);
        float f2 = (float)(l2 >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(l2 >> 8 & 0xFF) / 255.0f;
        float f22 = (float)(l2 & 0xFF) / 255.0f;
        if (EntityRenderer.field_28135_a) {
            float f3 = (f2 * 30.0f + f1 * 59.0f + f22 * 11.0f) / 100.0f;
            float f4 = (f2 * 30.0f + f1 * 70.0f) / 100.0f;
            float f5 = (f2 * 30.0f + f22 * 70.0f) / 100.0f;
            f2 = f3;
            f1 = f4;
            f22 = f5;
        }
        if (Minecraft.isAmbientOcclusionEnabled()) {
            return this.renderStandardBlockWithAmbientOcclusion(block, i2, j2, k2, f2, f1, f22);
        }
        return this.renderStandardBlockWithColorMultiplier(block, i2, j2, k2, f2, f1, f22);
    }

    public boolean renderStandardBlockWithAmbientOcclusion(Block block, int x2, int y2, int z2, float x1, float y1, float z1) {
        int textureIndex;
        this.enableAO = true;
        boolean flag = false;
        float f3 = this.lightValueOwn;
        float f10 = this.lightValueOwn;
        float f17 = this.lightValueOwn;
        float f24 = this.lightValueOwn;
        boolean flag1 = true;
        boolean flag2 = true;
        boolean flag3 = true;
        boolean flag4 = true;
        boolean flag5 = true;
        boolean flag6 = true;
        this.lightValueOwn = block.getBlockBrightness(this.blockAccess, x2, y2, z2);
        this.aoLightValueXNeg = block.getBlockBrightness(this.blockAccess, x2 - 1, y2, z2);
        this.aoLightValueYNeg = block.getBlockBrightness(this.blockAccess, x2, y2 - 1, z2);
        this.aoLightValueZNeg = block.getBlockBrightness(this.blockAccess, x2, y2, z2 - 1);
        this.aoLightValueXPos = block.getBlockBrightness(this.blockAccess, x2 + 1, y2, z2);
        this.aoLightValueYPos = block.getBlockBrightness(this.blockAccess, x2, y2 + 1, z2);
        this.aoLightValueZPos = block.getBlockBrightness(this.blockAccess, x2, y2, z2 + 1);
        this.ao0 = !Block.opaqueCubeLookup[this.blockAccess.getBlockId(x2 + 1, y2 + 1, z2)];
        this.ao1 = !Block.opaqueCubeLookup[this.blockAccess.getBlockId(x2 + 1, y2 - 1, z2)];
        this.ao2 = !Block.opaqueCubeLookup[this.blockAccess.getBlockId(x2 + 1, y2, z2 + 1)];
        this.ao3 = !Block.opaqueCubeLookup[this.blockAccess.getBlockId(x2 + 1, y2, z2 - 1)];
        this.ao4 = !Block.opaqueCubeLookup[this.blockAccess.getBlockId(x2 - 1, y2 + 1, z2)];
        this.ao5 = !Block.opaqueCubeLookup[this.blockAccess.getBlockId(x2 - 1, y2 - 1, z2)];
        this.ao6 = !Block.opaqueCubeLookup[this.blockAccess.getBlockId(x2 - 1, y2, z2 - 1)];
        this.ao7 = !Block.opaqueCubeLookup[this.blockAccess.getBlockId(x2 - 1, y2, z2 + 1)];
        this.ao8 = !Block.opaqueCubeLookup[this.blockAccess.getBlockId(x2, y2 + 1, z2 + 1)];
        this.ao9 = !Block.opaqueCubeLookup[this.blockAccess.getBlockId(x2, y2 + 1, z2 - 1)];
        this.ao10 = !Block.opaqueCubeLookup[this.blockAccess.getBlockId(x2, y2 - 1, z2 + 1)];
        boolean bl2 = this.ao11 = !Block.opaqueCubeLookup[this.blockAccess.getBlockId(x2, y2 - 1, z2 - 1)];
        if (block == Block.grass) {
            flag6 = false;
            flag5 = false;
            flag4 = false;
            flag3 = false;
            flag1 = false;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, x2, y2 - 1, z2, 0)) {
            float f4;
            float f11;
            float f18;
            float f25;
            if (this.overbright) {
                f25 = 1.0f;
                f18 = 1.0f;
                f11 = 1.0f;
                f4 = 1.0f;
            } else if (this.field_22352_G > 0) {
                this.field_22376_n = block.getBlockBrightness(this.blockAccess, x2 - 1, --y2, z2);
                this.field_22374_p = block.getBlockBrightness(this.blockAccess, x2, y2, z2 - 1);
                this.field_22373_q = block.getBlockBrightness(this.blockAccess, x2, y2, z2 + 1);
                this.field_22371_s = block.getBlockBrightness(this.blockAccess, x2 + 1, y2, z2);
                this.field_22377_m = this.ao11 || this.ao5 ? block.getBlockBrightness(this.blockAccess, x2 - 1, y2, z2 - 1) : this.field_22376_n;
                this.field_22375_o = this.ao10 || this.ao5 ? block.getBlockBrightness(this.blockAccess, x2 - 1, y2, z2 + 1) : this.field_22376_n;
                this.field_22372_r = this.ao11 || this.ao1 ? block.getBlockBrightness(this.blockAccess, x2 + 1, y2, z2 - 1) : this.field_22371_s;
                this.field_22370_t = this.ao10 || this.ao1 ? block.getBlockBrightness(this.blockAccess, x2 + 1, y2, z2 + 1) : this.field_22371_s;
                ++y2;
                f4 = (this.field_22375_o + this.field_22376_n + this.field_22373_q + this.aoLightValueYNeg) / 4.0f;
                f25 = (this.field_22373_q + this.aoLightValueYNeg + this.field_22370_t + this.field_22371_s) / 4.0f;
                f18 = (this.aoLightValueYNeg + this.field_22374_p + this.field_22371_s + this.field_22372_r) / 4.0f;
                f11 = (this.field_22376_n + this.field_22377_m + this.aoLightValueYNeg + this.field_22374_p) / 4.0f;
            } else {
                f18 = f25 = this.aoLightValueYNeg;
                f11 = f25;
                f4 = f25;
            }
            this.colorRedBottomRight = this.colorRedTopRight = (flag1 ? x1 : 1.0f) * 0.5f;
            this.colorRedBottomLeft = this.colorRedTopRight;
            this.colorRedTopLeft = this.colorRedTopRight;
            this.colorGreenBottomRight = this.colorGreenTopRight = (flag1 ? y1 : 1.0f) * 0.5f;
            this.colorGreenBottomLeft = this.colorGreenTopRight;
            this.colorGreenTopLeft = this.colorGreenTopRight;
            this.colorBlueBottomRight = this.colorBlueTopRight = (flag1 ? z1 : 1.0f) * 0.5f;
            this.colorBlueBottomLeft = this.colorBlueTopRight;
            this.colorBlueTopLeft = this.colorBlueTopRight;
            this.colorRedTopLeft *= f4;
            this.colorGreenTopLeft *= f4;
            this.colorBlueTopLeft *= f4;
            this.colorRedBottomLeft *= f11;
            this.colorGreenBottomLeft *= f11;
            this.colorBlueBottomLeft *= f11;
            this.colorRedBottomRight *= f18;
            this.colorGreenBottomRight *= f18;
            this.colorBlueBottomRight *= f18;
            this.colorRedTopRight *= f25;
            this.colorGreenTopRight *= f25;
            this.colorBlueTopRight *= f25;
            textureIndex = this.overbright ? block.getBlockOverbright(this.blockAccess, x2, y2, z2, 0) : block.getBlockTexture(this.blockAccess, x2, y2, z2, 0);
            if (textureIndex >= 0) {
                this.renderBottomFace(block, x2, y2, z2, textureIndex);
                flag = true;
            }
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, x2, y2 + 1, z2, 1)) {
            float f5;
            float f12;
            float f19;
            float f26;
            if (this.overbright) {
                f26 = 1.0f;
                f19 = 1.0f;
                f12 = 1.0f;
                f5 = 1.0f;
            } else if (this.field_22352_G > 0) {
                this.field_22368_v = block.getBlockBrightness(this.blockAccess, x2 - 1, ++y2, z2);
                this.field_22364_z = block.getBlockBrightness(this.blockAccess, x2 + 1, y2, z2);
                this.field_22366_x = block.getBlockBrightness(this.blockAccess, x2, y2, z2 - 1);
                this.field_22362_A = block.getBlockBrightness(this.blockAccess, x2, y2, z2 + 1);
                this.field_22369_u = this.ao9 || this.ao4 ? block.getBlockBrightness(this.blockAccess, x2 - 1, y2, z2 - 1) : this.field_22368_v;
                this.field_22365_y = this.ao9 || this.ao0 ? block.getBlockBrightness(this.blockAccess, x2 + 1, y2, z2 - 1) : this.field_22364_z;
                this.field_22367_w = this.ao8 || this.ao4 ? block.getBlockBrightness(this.blockAccess, x2 - 1, y2, z2 + 1) : this.field_22368_v;
                this.field_22360_B = this.ao8 || this.ao0 ? block.getBlockBrightness(this.blockAccess, x2 + 1, y2, z2 + 1) : this.field_22364_z;
                --y2;
                f26 = (this.field_22367_w + this.field_22368_v + this.field_22362_A + this.aoLightValueYPos) / 4.0f;
                f5 = (this.field_22362_A + this.aoLightValueYPos + this.field_22360_B + this.field_22364_z) / 4.0f;
                f12 = (this.aoLightValueYPos + this.field_22366_x + this.field_22364_z + this.field_22365_y) / 4.0f;
                f19 = (this.field_22368_v + this.field_22369_u + this.aoLightValueYPos + this.field_22366_x) / 4.0f;
            } else {
                f19 = f26 = this.aoLightValueYPos;
                f12 = f26;
                f5 = f26;
            }
            this.colorRedTopRight = flag2 ? x1 : 1.0f;
            this.colorRedBottomRight = this.colorRedTopRight;
            this.colorRedBottomLeft = this.colorRedTopRight;
            this.colorRedTopLeft = this.colorRedTopRight;
            this.colorGreenTopRight = flag2 ? y1 : 1.0f;
            this.colorGreenBottomRight = this.colorGreenTopRight;
            this.colorGreenBottomLeft = this.colorGreenTopRight;
            this.colorGreenTopLeft = this.colorGreenTopRight;
            this.colorBlueTopRight = flag2 ? z1 : 1.0f;
            this.colorBlueBottomRight = this.colorBlueTopRight;
            this.colorBlueBottomLeft = this.colorBlueTopRight;
            this.colorBlueTopLeft = this.colorBlueTopRight;
            this.colorRedTopLeft *= f5;
            this.colorGreenTopLeft *= f5;
            this.colorBlueTopLeft *= f5;
            this.colorRedBottomLeft *= f12;
            this.colorGreenBottomLeft *= f12;
            this.colorBlueBottomLeft *= f12;
            this.colorRedBottomRight *= f19;
            this.colorGreenBottomRight *= f19;
            this.colorBlueBottomRight *= f19;
            this.colorRedTopRight *= f26;
            this.colorGreenTopRight *= f26;
            this.colorBlueTopRight *= f26;
            textureIndex = this.overbright ? block.getBlockOverbright(this.blockAccess, x2, y2, z2, 1) : block.getBlockTexture(this.blockAccess, x2, y2, z2, 1);
            if (textureIndex >= 0) {
                this.renderTopFace(block, x2, y2, z2, textureIndex);
                flag = true;
            }
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, x2, y2, z2 - 1, 2)) {
            float f6;
            float f13;
            float f20;
            float f27;
            if (this.overbright) {
                f27 = 1.0f;
                f20 = 1.0f;
                f13 = 1.0f;
                f6 = 1.0f;
            } else if (this.field_22352_G > 0) {
                this.field_22358_C = block.getBlockBrightness(this.blockAccess, x2 - 1, y2, --z2);
                this.field_22374_p = block.getBlockBrightness(this.blockAccess, x2, y2 - 1, z2);
                this.field_22366_x = block.getBlockBrightness(this.blockAccess, x2, y2 + 1, z2);
                this.field_22356_D = block.getBlockBrightness(this.blockAccess, x2 + 1, y2, z2);
                this.field_22377_m = this.ao6 || this.ao11 ? block.getBlockBrightness(this.blockAccess, x2 - 1, y2 - 1, z2) : this.field_22358_C;
                this.field_22369_u = this.ao6 || this.ao9 ? block.getBlockBrightness(this.blockAccess, x2 - 1, y2 + 1, z2) : this.field_22358_C;
                this.field_22372_r = this.ao3 || this.ao11 ? block.getBlockBrightness(this.blockAccess, x2 + 1, y2 - 1, z2) : this.field_22356_D;
                this.field_22365_y = this.ao3 || this.ao9 ? block.getBlockBrightness(this.blockAccess, x2 + 1, y2 + 1, z2) : this.field_22356_D;
                ++z2;
                f6 = (this.field_22358_C + this.field_22369_u + this.aoLightValueZNeg + this.field_22366_x) / 4.0f;
                f13 = (this.aoLightValueZNeg + this.field_22366_x + this.field_22356_D + this.field_22365_y) / 4.0f;
                f20 = (this.field_22374_p + this.aoLightValueZNeg + this.field_22372_r + this.field_22356_D) / 4.0f;
                f27 = (this.field_22377_m + this.field_22358_C + this.field_22374_p + this.aoLightValueZNeg) / 4.0f;
            } else {
                f20 = f27 = this.aoLightValueZNeg;
                f13 = f27;
                f6 = f27;
            }
            this.colorRedBottomRight = this.colorRedTopRight = (flag3 ? x1 : 1.0f) * 0.8f;
            this.colorRedBottomLeft = this.colorRedTopRight;
            this.colorRedTopLeft = this.colorRedTopRight;
            this.colorGreenBottomRight = this.colorGreenTopRight = (flag3 ? y1 : 1.0f) * 0.8f;
            this.colorGreenBottomLeft = this.colorGreenTopRight;
            this.colorGreenTopLeft = this.colorGreenTopRight;
            this.colorBlueBottomRight = this.colorBlueTopRight = (flag3 ? z1 : 1.0f) * 0.8f;
            this.colorBlueBottomLeft = this.colorBlueTopRight;
            this.colorBlueTopLeft = this.colorBlueTopRight;
            this.colorRedTopLeft *= f6;
            this.colorGreenTopLeft *= f6;
            this.colorBlueTopLeft *= f6;
            this.colorRedBottomLeft *= f13;
            this.colorGreenBottomLeft *= f13;
            this.colorBlueBottomLeft *= f13;
            this.colorRedBottomRight *= f20;
            this.colorGreenBottomRight *= f20;
            this.colorBlueBottomRight *= f20;
            this.colorRedTopRight *= f27;
            this.colorGreenTopRight *= f27;
            this.colorBlueTopRight *= f27;
            textureIndex = this.overbright ? block.getBlockOverbright(this.blockAccess, x2, y2, z2, 2) : block.getBlockTexture(this.blockAccess, x2, y2, z2, 2);
            if (textureIndex >= 0) {
                this.renderEastFace(block, x2, y2, z2, textureIndex);
                flag = true;
            }
            if (fancyGrass && textureIndex == 3 && this.overrideBlockTexture < 0) {
                this.colorRedTopLeft *= x1;
                this.colorRedBottomLeft *= x1;
                this.colorRedBottomRight *= x1;
                this.colorRedTopRight *= x1;
                this.colorGreenTopLeft *= y1;
                this.colorGreenBottomLeft *= y1;
                this.colorGreenBottomRight *= y1;
                this.colorGreenTopRight *= y1;
                this.colorBlueTopLeft *= z1;
                this.colorBlueBottomLeft *= z1;
                this.colorBlueBottomRight *= z1;
                this.colorBlueTopRight *= z1;
                this.renderEastFace(block, x2, y2, z2, Block.texCoordToIndex(6, 2));
                flag = true;
            }
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, x2, y2, z2 + 1, 3)) {
            float f7;
            float f14;
            float f21;
            float f28;
            if (this.overbright) {
                f28 = 1.0f;
                f21 = 1.0f;
                f14 = 1.0f;
                f7 = 1.0f;
            } else if (this.field_22352_G > 0) {
                this.field_22354_E = block.getBlockBrightness(this.blockAccess, x2 - 1, y2, ++z2);
                this.field_22353_F = block.getBlockBrightness(this.blockAccess, x2 + 1, y2, z2);
                this.field_22373_q = block.getBlockBrightness(this.blockAccess, x2, y2 - 1, z2);
                this.field_22362_A = block.getBlockBrightness(this.blockAccess, x2, y2 + 1, z2);
                this.field_22375_o = this.ao7 || this.ao10 ? block.getBlockBrightness(this.blockAccess, x2 - 1, y2 - 1, z2) : this.field_22354_E;
                this.field_22367_w = this.ao7 || this.ao8 ? block.getBlockBrightness(this.blockAccess, x2 - 1, y2 + 1, z2) : this.field_22354_E;
                this.field_22370_t = this.ao2 || this.ao10 ? block.getBlockBrightness(this.blockAccess, x2 + 1, y2 - 1, z2) : this.field_22353_F;
                this.field_22360_B = this.ao2 || this.ao8 ? block.getBlockBrightness(this.blockAccess, x2 + 1, y2 + 1, z2) : this.field_22353_F;
                --z2;
                f7 = (this.field_22354_E + this.field_22367_w + this.aoLightValueZPos + this.field_22362_A) / 4.0f;
                f28 = (this.aoLightValueZPos + this.field_22362_A + this.field_22353_F + this.field_22360_B) / 4.0f;
                f21 = (this.field_22373_q + this.aoLightValueZPos + this.field_22370_t + this.field_22353_F) / 4.0f;
                f14 = (this.field_22375_o + this.field_22354_E + this.field_22373_q + this.aoLightValueZPos) / 4.0f;
            } else {
                f21 = f28 = this.aoLightValueZPos;
                f14 = f28;
                f7 = f28;
            }
            this.colorRedBottomRight = this.colorRedTopRight = (flag4 ? x1 : 1.0f) * 0.8f;
            this.colorRedBottomLeft = this.colorRedTopRight;
            this.colorRedTopLeft = this.colorRedTopRight;
            this.colorGreenBottomRight = this.colorGreenTopRight = (flag4 ? y1 : 1.0f) * 0.8f;
            this.colorGreenBottomLeft = this.colorGreenTopRight;
            this.colorGreenTopLeft = this.colorGreenTopRight;
            this.colorBlueBottomRight = this.colorBlueTopRight = (flag4 ? z1 : 1.0f) * 0.8f;
            this.colorBlueBottomLeft = this.colorBlueTopRight;
            this.colorBlueTopLeft = this.colorBlueTopRight;
            this.colorRedTopLeft *= f7;
            this.colorGreenTopLeft *= f7;
            this.colorBlueTopLeft *= f7;
            this.colorRedBottomLeft *= f14;
            this.colorGreenBottomLeft *= f14;
            this.colorBlueBottomLeft *= f14;
            this.colorRedBottomRight *= f21;
            this.colorGreenBottomRight *= f21;
            this.colorBlueBottomRight *= f21;
            this.colorRedTopRight *= f28;
            this.colorGreenTopRight *= f28;
            this.colorBlueTopRight *= f28;
            textureIndex = this.overbright ? block.getBlockOverbright(this.blockAccess, x2, y2, z2, 3) : block.getBlockTexture(this.blockAccess, x2, y2, z2, 3);
            if (textureIndex >= 0) {
                this.renderWestFace(block, x2, y2, z2, textureIndex);
                flag = true;
            }
            if (fancyGrass && textureIndex == 3 && this.overrideBlockTexture < 0) {
                this.colorRedTopLeft *= x1;
                this.colorRedBottomLeft *= x1;
                this.colorRedBottomRight *= x1;
                this.colorRedTopRight *= x1;
                this.colorGreenTopLeft *= y1;
                this.colorGreenBottomLeft *= y1;
                this.colorGreenBottomRight *= y1;
                this.colorGreenTopRight *= y1;
                this.colorBlueTopLeft *= z1;
                this.colorBlueBottomLeft *= z1;
                this.colorBlueBottomRight *= z1;
                this.colorBlueTopRight *= z1;
                this.renderWestFace(block, x2, y2, z2, Block.texCoordToIndex(6, 2));
                flag = true;
            }
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, x2 - 1, y2, z2, 4)) {
            float f8;
            float f15;
            float f22;
            float f29;
            if (this.overbright) {
                f29 = 1.0f;
                f22 = 1.0f;
                f15 = 1.0f;
                f8 = 1.0f;
            } else if (this.field_22352_G > 0) {
                this.field_22376_n = block.getBlockBrightness(this.blockAccess, --x2, y2 - 1, z2);
                this.field_22358_C = block.getBlockBrightness(this.blockAccess, x2, y2, z2 - 1);
                this.field_22354_E = block.getBlockBrightness(this.blockAccess, x2, y2, z2 + 1);
                this.field_22368_v = block.getBlockBrightness(this.blockAccess, x2, y2 + 1, z2);
                this.field_22377_m = this.ao6 || this.ao5 ? block.getBlockBrightness(this.blockAccess, x2, y2 - 1, z2 - 1) : this.field_22358_C;
                this.field_22375_o = this.ao7 || this.ao5 ? block.getBlockBrightness(this.blockAccess, x2, y2 - 1, z2 + 1) : this.field_22354_E;
                this.field_22369_u = this.ao6 || this.ao4 ? block.getBlockBrightness(this.blockAccess, x2, y2 + 1, z2 - 1) : this.field_22358_C;
                this.field_22367_w = this.ao7 || this.ao4 ? block.getBlockBrightness(this.blockAccess, x2, y2 + 1, z2 + 1) : this.field_22354_E;
                ++x2;
                f29 = (this.field_22376_n + this.field_22375_o + this.aoLightValueXNeg + this.field_22354_E) / 4.0f;
                f8 = (this.aoLightValueXNeg + this.field_22354_E + this.field_22368_v + this.field_22367_w) / 4.0f;
                f15 = (this.field_22358_C + this.aoLightValueXNeg + this.field_22369_u + this.field_22368_v) / 4.0f;
                f22 = (this.field_22377_m + this.field_22376_n + this.field_22358_C + this.aoLightValueXNeg) / 4.0f;
            } else {
                f22 = f29 = this.aoLightValueXNeg;
                f15 = f29;
                f8 = f29;
            }
            this.colorRedBottomRight = this.colorRedTopRight = (flag5 ? x1 : 1.0f) * 0.6f;
            this.colorRedBottomLeft = this.colorRedTopRight;
            this.colorRedTopLeft = this.colorRedTopRight;
            this.colorGreenBottomRight = this.colorGreenTopRight = (flag5 ? y1 : 1.0f) * 0.6f;
            this.colorGreenBottomLeft = this.colorGreenTopRight;
            this.colorGreenTopLeft = this.colorGreenTopRight;
            this.colorBlueBottomRight = this.colorBlueTopRight = (flag5 ? z1 : 1.0f) * 0.6f;
            this.colorBlueBottomLeft = this.colorBlueTopRight;
            this.colorBlueTopLeft = this.colorBlueTopRight;
            this.colorRedTopLeft *= f8;
            this.colorGreenTopLeft *= f8;
            this.colorBlueTopLeft *= f8;
            this.colorRedBottomLeft *= f15;
            this.colorGreenBottomLeft *= f15;
            this.colorBlueBottomLeft *= f15;
            this.colorRedBottomRight *= f22;
            this.colorGreenBottomRight *= f22;
            this.colorBlueBottomRight *= f22;
            this.colorRedTopRight *= f29;
            this.colorGreenTopRight *= f29;
            this.colorBlueTopRight *= f29;
            textureIndex = this.overbright ? block.getBlockOverbright(this.blockAccess, x2, y2, z2, 4) : block.getBlockTexture(this.blockAccess, x2, y2, z2, 4);
            if (textureIndex >= 0) {
                this.renderNorthFace(block, x2, y2, z2, textureIndex);
                flag = true;
            }
            if (fancyGrass && textureIndex == 3 && this.overrideBlockTexture < 0) {
                this.colorRedTopLeft *= x1;
                this.colorRedBottomLeft *= x1;
                this.colorRedBottomRight *= x1;
                this.colorRedTopRight *= x1;
                this.colorGreenTopLeft *= y1;
                this.colorGreenBottomLeft *= y1;
                this.colorGreenBottomRight *= y1;
                this.colorGreenTopRight *= y1;
                this.colorBlueTopLeft *= z1;
                this.colorBlueBottomLeft *= z1;
                this.colorBlueBottomRight *= z1;
                this.colorBlueTopRight *= z1;
                this.renderNorthFace(block, x2, y2, z2, Block.texCoordToIndex(6, 2));
                flag = true;
            }
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, x2 + 1, y2, z2, 5)) {
            float f9;
            float f16;
            float f23;
            float f30;
            if (this.overbright) {
                f30 = 1.0f;
                f23 = 1.0f;
                f16 = 1.0f;
                f9 = 1.0f;
            } else if (this.field_22352_G > 0) {
                this.field_22371_s = block.getBlockBrightness(this.blockAccess, ++x2, y2 - 1, z2);
                this.field_22356_D = block.getBlockBrightness(this.blockAccess, x2, y2, z2 - 1);
                this.field_22353_F = block.getBlockBrightness(this.blockAccess, x2, y2, z2 + 1);
                this.field_22364_z = block.getBlockBrightness(this.blockAccess, x2, y2 + 1, z2);
                this.field_22372_r = this.ao1 || this.ao3 ? block.getBlockBrightness(this.blockAccess, x2, y2 - 1, z2 - 1) : this.field_22356_D;
                this.field_22370_t = this.ao1 || this.ao2 ? block.getBlockBrightness(this.blockAccess, x2, y2 - 1, z2 + 1) : this.field_22353_F;
                this.field_22365_y = this.ao0 || this.ao3 ? block.getBlockBrightness(this.blockAccess, x2, y2 + 1, z2 - 1) : this.field_22356_D;
                this.field_22360_B = this.ao0 || this.ao2 ? block.getBlockBrightness(this.blockAccess, x2, y2 + 1, z2 + 1) : this.field_22353_F;
                --x2;
                f9 = (this.field_22371_s + this.field_22370_t + this.aoLightValueXPos + this.field_22353_F) / 4.0f;
                f30 = (this.aoLightValueXPos + this.field_22353_F + this.field_22364_z + this.field_22360_B) / 4.0f;
                f23 = (this.field_22356_D + this.aoLightValueXPos + this.field_22365_y + this.field_22364_z) / 4.0f;
                f16 = (this.field_22372_r + this.field_22371_s + this.field_22356_D + this.aoLightValueXPos) / 4.0f;
            } else {
                f23 = f30 = this.aoLightValueXPos;
                f16 = f30;
                f9 = f30;
            }
            this.colorRedBottomRight = this.colorRedTopRight = (flag6 ? x1 : 1.0f) * 0.6f;
            this.colorRedBottomLeft = this.colorRedTopRight;
            this.colorRedTopLeft = this.colorRedTopRight;
            this.colorGreenBottomRight = this.colorGreenTopRight = (flag6 ? y1 : 1.0f) * 0.6f;
            this.colorGreenBottomLeft = this.colorGreenTopRight;
            this.colorGreenTopLeft = this.colorGreenTopRight;
            this.colorBlueBottomRight = this.colorBlueTopRight = (flag6 ? z1 : 1.0f) * 0.6f;
            this.colorBlueBottomLeft = this.colorBlueTopRight;
            this.colorBlueTopLeft = this.colorBlueTopRight;
            this.colorRedTopLeft *= f9;
            this.colorGreenTopLeft *= f9;
            this.colorBlueTopLeft *= f9;
            this.colorRedBottomLeft *= f16;
            this.colorGreenBottomLeft *= f16;
            this.colorBlueBottomLeft *= f16;
            this.colorRedBottomRight *= f23;
            this.colorGreenBottomRight *= f23;
            this.colorBlueBottomRight *= f23;
            this.colorRedTopRight *= f30;
            this.colorGreenTopRight *= f30;
            this.colorBlueTopRight *= f30;
            textureIndex = this.overbright ? block.getBlockOverbright(this.blockAccess, x2, y2, z2, 5) : block.getBlockTexture(this.blockAccess, x2, y2, z2, 5);
            if (textureIndex >= 0) {
                this.renderSouthFace(block, x2, y2, z2, textureIndex);
                flag = true;
            }
            if (fancyGrass && textureIndex == 3 && this.overrideBlockTexture < 0) {
                this.colorRedTopLeft *= x1;
                this.colorRedBottomLeft *= x1;
                this.colorRedBottomRight *= x1;
                this.colorRedTopRight *= x1;
                this.colorGreenTopLeft *= y1;
                this.colorGreenBottomLeft *= y1;
                this.colorGreenBottomRight *= y1;
                this.colorGreenTopRight *= y1;
                this.colorBlueTopLeft *= z1;
                this.colorBlueBottomLeft *= z1;
                this.colorBlueBottomRight *= z1;
                this.colorBlueTopRight *= z1;
                this.renderSouthFace(block, x2, y2, z2, Block.texCoordToIndex(6, 2));
                flag = true;
            }
        }
        this.enableAO = false;
        return flag;
    }

    public boolean renderStandardBlockWithColorMultiplier(Block block, int i2, int j2, int k2, float f2, float f1, float f22) {
        this.enableAO = false;
        Tessellator tessellator = Tessellator.instance;
        boolean flag = false;
        float f3 = 0.5f;
        float f4 = 1.0f;
        float f5 = 0.8f;
        float f6 = 0.6f;
        float f7 = f4 * f2;
        float f8 = f4 * f1;
        float f9 = f4 * f22;
        float f10 = f3;
        float f11 = f5;
        float f12 = f6;
        float f13 = f3;
        float f14 = f5;
        float f15 = f6;
        float f16 = f3;
        float f17 = f5;
        float f18 = f6;
        if (block != Block.grass) {
            f10 *= f2;
            f11 *= f2;
            f12 *= f2;
            f13 *= f1;
            f14 *= f1;
            f15 *= f1;
            f16 *= f22;
            f17 *= f22;
            f18 *= f22;
        }
        float f19 = block.getBlockBrightness(this.blockAccess, i2, j2, k2);
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, i2, j2 - 1, k2, 0)) {
            float f20 = block.getBlockBrightness(this.blockAccess, i2, j2 - 1, k2);
            tessellator.setColorOpaque_F(f10 * f20, f13 * f20, f16 * f20);
            this.renderBottomFace(block, i2, j2, k2, block.getBlockTexture(this.blockAccess, i2, j2, k2, 0));
            flag = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, i2, j2 + 1, k2, 1)) {
            float f21 = block.getBlockBrightness(this.blockAccess, i2, j2 + 1, k2);
            if (block.maxY != 1.0 && !block.blockMaterial.getIsLiquid()) {
                f21 = f19;
            }
            tessellator.setColorOpaque_F(f7 * f21, f8 * f21, f9 * f21);
            this.renderTopFace(block, i2, j2, k2, block.getBlockTexture(this.blockAccess, i2, j2, k2, 1));
            flag = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, i2, j2, k2 - 1, 2)) {
            float f222 = block.getBlockBrightness(this.blockAccess, i2, j2, k2 - 1);
            if (block.minZ > 0.0) {
                f222 = f19;
            }
            tessellator.setColorOpaque_F(f11 * f222, f14 * f222, f17 * f222);
            int l2 = block.getBlockTexture(this.blockAccess, i2, j2, k2, 2);
            this.renderEastFace(block, i2, j2, k2, l2);
            if (fancyGrass && l2 == 3 && this.overrideBlockTexture < 0) {
                tessellator.setColorOpaque_F(f11 * f222 * f2, f14 * f222 * f1, f17 * f222 * f22);
                this.renderEastFace(block, i2, j2, k2, Block.texCoordToIndex(6, 2));
            }
            flag = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, i2, j2, k2 + 1, 3)) {
            float f23 = block.getBlockBrightness(this.blockAccess, i2, j2, k2 + 1);
            if (block.maxZ < 1.0) {
                f23 = f19;
            }
            tessellator.setColorOpaque_F(f11 * f23, f14 * f23, f17 * f23);
            int i1 = block.getBlockTexture(this.blockAccess, i2, j2, k2, 3);
            this.renderWestFace(block, i2, j2, k2, i1);
            if (fancyGrass && i1 == 3 && this.overrideBlockTexture < 0) {
                tessellator.setColorOpaque_F(f11 * f23 * f2, f14 * f23 * f1, f17 * f23 * f22);
                this.renderWestFace(block, i2, j2, k2, Block.texCoordToIndex(6, 2));
            }
            flag = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, i2 - 1, j2, k2, 4)) {
            float f24 = block.getBlockBrightness(this.blockAccess, i2 - 1, j2, k2);
            if (block.minX > 0.0) {
                f24 = f19;
            }
            tessellator.setColorOpaque_F(f12 * f24, f15 * f24, f18 * f24);
            int j1 = block.getBlockTexture(this.blockAccess, i2, j2, k2, 4);
            this.renderNorthFace(block, i2, j2, k2, j1);
            if (fancyGrass && j1 == 3 && this.overrideBlockTexture < 0) {
                tessellator.setColorOpaque_F(f12 * f24 * f2, f15 * f24 * f1, f18 * f24 * f22);
                this.renderNorthFace(block, i2, j2, k2, Block.texCoordToIndex(6, 2));
            }
            flag = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, i2 + 1, j2, k2, 5)) {
            float f25 = block.getBlockBrightness(this.blockAccess, i2 + 1, j2, k2);
            if (block.maxX < 1.0) {
                f25 = f19;
            }
            tessellator.setColorOpaque_F(f12 * f25, f15 * f25, f18 * f25);
            int k1 = block.getBlockTexture(this.blockAccess, i2, j2, k2, 5);
            this.renderSouthFace(block, i2, j2, k2, k1);
            if (fancyGrass && k1 == 3 && this.overrideBlockTexture < 0) {
                tessellator.setColorOpaque_F(f12 * f25 * f2, f15 * f25 * f1, f18 * f25 * f22);
                this.renderSouthFace(block, i2, j2, k2, Block.texCoordToIndex(6, 2));
            }
            flag = true;
        }
        return flag;
    }

    public boolean renderBlockCactus(Block block, int i2, int j2, int k2) {
        int l2 = block.colorMultiplier(this.world, this.blockAccess, i2, j2, k2);
        float f2 = (float)(l2 >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(l2 >> 8 & 0xFF) / 255.0f;
        float f22 = (float)(l2 & 0xFF) / 255.0f;
        if (EntityRenderer.field_28135_a) {
            float f3 = (f2 * 30.0f + f1 * 59.0f + f22 * 11.0f) / 100.0f;
            float f4 = (f2 * 30.0f + f1 * 70.0f) / 100.0f;
            float f5 = (f2 * 30.0f + f22 * 70.0f) / 100.0f;
            f2 = f3;
            f1 = f4;
            f22 = f5;
        }
        return this.func_1230_b(block, i2, j2, k2, f2, f1, f22);
    }

    public boolean func_1230_b(Block block, int i2, int j2, int k2, float f2, float f1, float f22) {
        Tessellator tessellator = Tessellator.instance;
        boolean flag = false;
        float f3 = 0.5f;
        float f4 = 1.0f;
        float f5 = 0.8f;
        float f6 = 0.6f;
        float f7 = f3 * f2;
        float f8 = f4 * f2;
        float f9 = f5 * f2;
        float f10 = f6 * f2;
        float f11 = f3 * f1;
        float f12 = f4 * f1;
        float f13 = f5 * f1;
        float f14 = f6 * f1;
        float f15 = f3 * f22;
        float f16 = f4 * f22;
        float f17 = f5 * f22;
        float f18 = f6 * f22;
        float f19 = 0.0625f;
        float f20 = block.getBlockBrightness(this.blockAccess, i2, j2, k2);
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, i2, j2 - 1, k2, 0)) {
            float f21 = block.getBlockBrightness(this.blockAccess, i2, j2 - 1, k2);
            tessellator.setColorOpaque_F(f7 * f21, f11 * f21, f15 * f21);
            this.renderBottomFace(block, i2, j2, k2, block.getBlockTexture(this.blockAccess, i2, j2, k2, 0));
            flag = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, i2, j2 + 1, k2, 1)) {
            float f222 = block.getBlockBrightness(this.blockAccess, i2, j2 + 1, k2);
            if (block.maxY != 1.0 && !block.blockMaterial.getIsLiquid()) {
                f222 = f20;
            }
            tessellator.setColorOpaque_F(f8 * f222, f12 * f222, f16 * f222);
            this.renderTopFace(block, i2, j2, k2, block.getBlockTexture(this.blockAccess, i2, j2, k2, 1));
            flag = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, i2, j2, k2 - 1, 2)) {
            float f23 = block.getBlockBrightness(this.blockAccess, i2, j2, k2 - 1);
            if (block.minZ > 0.0) {
                f23 = f20;
            }
            tessellator.setColorOpaque_F(f9 * f23, f13 * f23, f17 * f23);
            tessellator.setTranslationF(0.0f, 0.0f, f19);
            this.renderEastFace(block, i2, j2, k2, block.getBlockTexture(this.blockAccess, i2, j2, k2, 2));
            tessellator.setTranslationF(0.0f, 0.0f, -f19);
            flag = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, i2, j2, k2 + 1, 3)) {
            float f24 = block.getBlockBrightness(this.blockAccess, i2, j2, k2 + 1);
            if (block.maxZ < 1.0) {
                f24 = f20;
            }
            tessellator.setColorOpaque_F(f9 * f24, f13 * f24, f17 * f24);
            tessellator.setTranslationF(0.0f, 0.0f, -f19);
            this.renderWestFace(block, i2, j2, k2, block.getBlockTexture(this.blockAccess, i2, j2, k2, 3));
            tessellator.setTranslationF(0.0f, 0.0f, f19);
            flag = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, i2 - 1, j2, k2, 4)) {
            float f25 = block.getBlockBrightness(this.blockAccess, i2 - 1, j2, k2);
            if (block.minX > 0.0) {
                f25 = f20;
            }
            tessellator.setColorOpaque_F(f10 * f25, f14 * f25, f18 * f25);
            tessellator.setTranslationF(f19, 0.0f, 0.0f);
            this.renderNorthFace(block, i2, j2, k2, block.getBlockTexture(this.blockAccess, i2, j2, k2, 4));
            tessellator.setTranslationF(-f19, 0.0f, 0.0f);
            flag = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.blockAccess, i2 + 1, j2, k2, 5)) {
            float f26 = block.getBlockBrightness(this.blockAccess, i2 + 1, j2, k2);
            if (block.maxX < 1.0) {
                f26 = f20;
            }
            tessellator.setColorOpaque_F(f10 * f26, f14 * f26, f18 * f26);
            tessellator.setTranslationF(-f19, 0.0f, 0.0f);
            this.renderSouthFace(block, i2, j2, k2, block.getBlockTexture(this.blockAccess, i2, j2, k2, 5));
            tessellator.setTranslationF(f19, 0.0f, 0.0f);
            flag = true;
        }
        return flag;
    }

    public boolean renderBlockFence(BlockFence blockfence, int i2, int j2, int k2) {
        float f7;
        boolean flag = false;
        float f2 = 0.375f;
        float f1 = 0.625f;
        blockfence.setBlockBounds(f2, 0.0f, f2, f1, 1.0f, f1);
        blockfence.setBlockBounds(f2, 0.0f, f2, f1, 1.0f, f1);
        this.renderStandardBlock(blockfence, i2, j2, k2);
        flag = true;
        boolean flag1 = false;
        boolean flag2 = false;
        if (blockfence.canConnectTo(this.blockAccess, i2 - 1, j2, k2) || blockfence.canConnectTo(this.blockAccess, i2 + 1, j2, k2)) {
            flag1 = true;
        }
        if (blockfence.canConnectTo(this.blockAccess, i2, j2, k2 - 1) || blockfence.canConnectTo(this.blockAccess, i2, j2, k2 + 1)) {
            flag2 = true;
        }
        boolean flag3 = blockfence.canConnectTo(this.blockAccess, i2 - 1, j2, k2);
        boolean flag4 = blockfence.canConnectTo(this.blockAccess, i2 + 1, j2, k2);
        boolean flag5 = blockfence.canConnectTo(this.blockAccess, i2, j2, k2 - 1);
        boolean flag6 = blockfence.canConnectTo(this.blockAccess, i2, j2, k2 + 1);
        if (!flag1 && !flag2) {
            flag1 = true;
        }
        f2 = 0.4375f;
        f1 = 0.5625f;
        float f22 = 0.75f;
        float f3 = 0.9375f;
        float f4 = flag3 ? 0.0f : f2;
        float f5 = flag4 ? 1.0f : f1;
        float f6 = flag5 ? 0.0f : f2;
        float f8 = f7 = flag6 ? 1.0f : f1;
        if (flag1) {
            blockfence.setBlockBounds(f4, f22, f2, f5, f3, f1);
            this.renderStandardBlock(blockfence, i2, j2, k2);
            flag = true;
        }
        if (flag2) {
            blockfence.setBlockBounds(f2, f22, f6, f1, f3, f7);
            this.renderStandardBlock(blockfence, i2, j2, k2);
            flag = true;
        }
        f22 = 0.375f;
        f3 = 0.5625f;
        if (flag1) {
            blockfence.setBlockBounds(f4, f22, f2, f5, f3, f1);
            this.renderStandardBlock(blockfence, i2, j2, k2);
            flag = true;
        }
        if (flag2) {
            blockfence.setBlockBounds(f2, f22, f6, f1, f3, f7);
            this.renderStandardBlock(blockfence, i2, j2, k2);
            flag = true;
        }
        blockfence.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return flag;
    }

    public boolean renderBlockFenceGate(BlockFenceGate blockfencegate, int i2, int j2, int k2) {
        boolean flag = true;
        int l2 = this.blockAccess.getBlockMetadata(i2, j2, k2);
        boolean flag1 = BlockFenceGate.func_35291_d(l2);
        int i1 = BlockFenceGate.func_35290_f(l2);
        if (i1 == 3 || i1 == 1) {
            float f2 = 0.4375f;
            float f4 = 0.5625f;
            float f8 = 0.0f;
            float f12 = 0.125f;
            blockfencegate.setBlockBounds(f2, 0.3125f, f8, f4, 1.0f, f12);
            this.renderStandardBlock(blockfencegate, i2, j2, k2);
            f8 = 0.875f;
            f12 = 1.0f;
            blockfencegate.setBlockBounds(f2, 0.3125f, f8, f4, 1.0f, f12);
            this.renderStandardBlock(blockfencegate, i2, j2, k2);
        } else {
            float f1 = 0.0f;
            float f5 = 0.125f;
            float f9 = 0.4375f;
            float f13 = 0.5625f;
            blockfencegate.setBlockBounds(f1, 0.3125f, f9, f5, 1.0f, f13);
            this.renderStandardBlock(blockfencegate, i2, j2, k2);
            f1 = 0.875f;
            f5 = 1.0f;
            blockfencegate.setBlockBounds(f1, 0.3125f, f9, f5, 1.0f, f13);
            this.renderStandardBlock(blockfencegate, i2, j2, k2);
        }
        if (!flag1) {
            if (i1 == 3 || i1 == 1) {
                float f2 = 0.4375f;
                float f6 = 0.5625f;
                float f10 = 0.375f;
                float f14 = 0.5f;
                blockfencegate.setBlockBounds(f2, 0.375f, f10, f6, 0.9375f, f14);
                this.renderStandardBlock(blockfencegate, i2, j2, k2);
                f10 = 0.5f;
                f14 = 0.625f;
                blockfencegate.setBlockBounds(f2, 0.375f, f10, f6, 0.9375f, f14);
                this.renderStandardBlock(blockfencegate, i2, j2, k2);
                f10 = 0.625f;
                f14 = 0.875f;
                blockfencegate.setBlockBounds(f2, 0.375f, f10, f6, 0.5625f, f14);
                this.renderStandardBlock(blockfencegate, i2, j2, k2);
                blockfencegate.setBlockBounds(f2, 0.75f, f10, f6, 0.9375f, f14);
                this.renderStandardBlock(blockfencegate, i2, j2, k2);
                f10 = 0.125f;
                f14 = 0.375f;
                blockfencegate.setBlockBounds(f2, 0.375f, f10, f6, 0.5625f, f14);
                this.renderStandardBlock(blockfencegate, i2, j2, k2);
                blockfencegate.setBlockBounds(f2, 0.75f, f10, f6, 0.9375f, f14);
                this.renderStandardBlock(blockfencegate, i2, j2, k2);
            } else {
                float f3 = 0.375f;
                float f7 = 0.5f;
                float f11 = 0.4375f;
                float f15 = 0.5625f;
                blockfencegate.setBlockBounds(f3, 0.375f, f11, f7, 0.9375f, f15);
                this.renderStandardBlock(blockfencegate, i2, j2, k2);
                f3 = 0.5f;
                f7 = 0.625f;
                blockfencegate.setBlockBounds(f3, 0.375f, f11, f7, 0.9375f, f15);
                this.renderStandardBlock(blockfencegate, i2, j2, k2);
                f3 = 0.625f;
                f7 = 0.875f;
                blockfencegate.setBlockBounds(f3, 0.375f, f11, f7, 0.5625f, f15);
                this.renderStandardBlock(blockfencegate, i2, j2, k2);
                blockfencegate.setBlockBounds(f3, 0.75f, f11, f7, 0.9375f, f15);
                this.renderStandardBlock(blockfencegate, i2, j2, k2);
                f3 = 0.125f;
                f7 = 0.375f;
                blockfencegate.setBlockBounds(f3, 0.375f, f11, f7, 0.5625f, f15);
                this.renderStandardBlock(blockfencegate, i2, j2, k2);
                blockfencegate.setBlockBounds(f3, 0.75f, f11, f7, 0.9375f, f15);
                this.renderStandardBlock(blockfencegate, i2, j2, k2);
            }
        } else if (i1 == 3) {
            blockfencegate.setBlockBounds(0.8125f, 0.375f, 0.0f, 0.9375f, 0.9375f, 0.125f);
            this.renderStandardBlock(blockfencegate, i2, j2, k2);
            blockfencegate.setBlockBounds(0.8125f, 0.375f, 0.875f, 0.9375f, 0.9375f, 1.0f);
            this.renderStandardBlock(blockfencegate, i2, j2, k2);
            blockfencegate.setBlockBounds(0.5625f, 0.375f, 0.0f, 0.8125f, 0.5625f, 0.125f);
            this.renderStandardBlock(blockfencegate, i2, j2, k2);
            blockfencegate.setBlockBounds(0.5625f, 0.375f, 0.875f, 0.8125f, 0.5625f, 1.0f);
            this.renderStandardBlock(blockfencegate, i2, j2, k2);
            blockfencegate.setBlockBounds(0.5625f, 0.75f, 0.0f, 0.8125f, 0.9375f, 0.125f);
            this.renderStandardBlock(blockfencegate, i2, j2, k2);
            blockfencegate.setBlockBounds(0.5625f, 0.75f, 0.875f, 0.8125f, 0.9375f, 1.0f);
            this.renderStandardBlock(blockfencegate, i2, j2, k2);
        } else if (i1 == 1) {
            blockfencegate.setBlockBounds(0.0625f, 0.375f, 0.0f, 0.1875f, 0.9375f, 0.125f);
            this.renderStandardBlock(blockfencegate, i2, j2, k2);
            blockfencegate.setBlockBounds(0.0625f, 0.375f, 0.875f, 0.1875f, 0.9375f, 1.0f);
            this.renderStandardBlock(blockfencegate, i2, j2, k2);
            blockfencegate.setBlockBounds(0.1875f, 0.375f, 0.0f, 0.4375f, 0.5625f, 0.125f);
            this.renderStandardBlock(blockfencegate, i2, j2, k2);
            blockfencegate.setBlockBounds(0.1875f, 0.375f, 0.875f, 0.4375f, 0.5625f, 1.0f);
            this.renderStandardBlock(blockfencegate, i2, j2, k2);
            blockfencegate.setBlockBounds(0.1875f, 0.75f, 0.0f, 0.4375f, 0.9375f, 0.125f);
            this.renderStandardBlock(blockfencegate, i2, j2, k2);
            blockfencegate.setBlockBounds(0.1875f, 0.75f, 0.875f, 0.4375f, 0.9375f, 1.0f);
            this.renderStandardBlock(blockfencegate, i2, j2, k2);
        } else if (i1 == 0) {
            blockfencegate.setBlockBounds(0.0f, 0.375f, 0.8125f, 0.125f, 0.9375f, 0.9375f);
            this.renderStandardBlock(blockfencegate, i2, j2, k2);
            blockfencegate.setBlockBounds(0.875f, 0.375f, 0.8125f, 1.0f, 0.9375f, 0.9375f);
            this.renderStandardBlock(blockfencegate, i2, j2, k2);
            blockfencegate.setBlockBounds(0.0f, 0.375f, 0.5625f, 0.125f, 0.5625f, 0.8125f);
            this.renderStandardBlock(blockfencegate, i2, j2, k2);
            blockfencegate.setBlockBounds(0.875f, 0.375f, 0.5625f, 1.0f, 0.5625f, 0.8125f);
            this.renderStandardBlock(blockfencegate, i2, j2, k2);
            blockfencegate.setBlockBounds(0.0f, 0.75f, 0.5625f, 0.125f, 0.9375f, 0.8125f);
            this.renderStandardBlock(blockfencegate, i2, j2, k2);
            blockfencegate.setBlockBounds(0.875f, 0.75f, 0.5625f, 1.0f, 0.9375f, 0.8125f);
            this.renderStandardBlock(blockfencegate, i2, j2, k2);
        } else if (i1 == 2) {
            blockfencegate.setBlockBounds(0.0f, 0.375f, 0.0625f, 0.125f, 0.9375f, 0.1875f);
            this.renderStandardBlock(blockfencegate, i2, j2, k2);
            blockfencegate.setBlockBounds(0.875f, 0.375f, 0.0625f, 1.0f, 0.9375f, 0.1875f);
            this.renderStandardBlock(blockfencegate, i2, j2, k2);
            blockfencegate.setBlockBounds(0.0f, 0.375f, 0.1875f, 0.125f, 0.5625f, 0.4375f);
            this.renderStandardBlock(blockfencegate, i2, j2, k2);
            blockfencegate.setBlockBounds(0.875f, 0.375f, 0.1875f, 1.0f, 0.5625f, 0.4375f);
            this.renderStandardBlock(blockfencegate, i2, j2, k2);
            blockfencegate.setBlockBounds(0.0f, 0.75f, 0.1875f, 0.125f, 0.9375f, 0.4375f);
            this.renderStandardBlock(blockfencegate, i2, j2, k2);
            blockfencegate.setBlockBounds(0.875f, 0.75f, 0.1875f, 1.0f, 0.9375f, 0.4375f);
            this.renderStandardBlock(blockfencegate, i2, j2, k2);
        }
        blockfencegate.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return flag;
    }

    public boolean renderBlockStairs(Block block, int i2, int j2, int k2) {
        boolean flag = false;
        int l2 = this.blockAccess.getBlockMetadata(i2, j2, k2) & 3;
        if (l2 == 0) {
            block.setBlockBounds(0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 1.0f);
            this.renderStandardBlock(block, i2, j2, k2);
            block.setBlockBounds(0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            this.renderStandardBlock(block, i2, j2, k2);
            flag = true;
        } else if (l2 == 1) {
            block.setBlockBounds(0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f);
            this.renderStandardBlock(block, i2, j2, k2);
            block.setBlockBounds(0.5f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
            this.renderStandardBlock(block, i2, j2, k2);
            flag = true;
        } else if (l2 == 2) {
            block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 0.5f);
            this.renderStandardBlock(block, i2, j2, k2);
            block.setBlockBounds(0.0f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f);
            this.renderStandardBlock(block, i2, j2, k2);
            flag = true;
        } else if (l2 == 3) {
            block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f);
            this.renderStandardBlock(block, i2, j2, k2);
            block.setBlockBounds(0.0f, 0.0f, 0.5f, 1.0f, 0.5f, 1.0f);
            this.renderStandardBlock(block, i2, j2, k2);
            flag = true;
        }
        block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return flag;
    }

    public boolean renderBlockDoor(Block block, int i2, int j2, int k2) {
        Tessellator tessellator = Tessellator.instance;
        BlockDoor blockdoor = (BlockDoor)block;
        boolean flag = false;
        float f2 = 0.5f;
        float f1 = 1.0f;
        float f22 = 0.8f;
        float f3 = 0.6f;
        float f4 = block.getBlockBrightness(this.blockAccess, i2, j2, k2);
        float f5 = block.getBlockBrightness(this.blockAccess, i2, j2 - 1, k2);
        if (blockdoor.minY > 0.0) {
            f5 = f4;
        }
        if (Block.lightValue[block.blockID] > 0) {
            f5 = 1.0f;
        }
        tessellator.setColorOpaque_F(f2 * f5, f2 * f5, f2 * f5);
        this.renderBottomFace(block, i2, j2, k2, block.getBlockTexture(this.blockAccess, i2, j2, k2, 0));
        flag = true;
        f5 = block.getBlockBrightness(this.blockAccess, i2, j2 + 1, k2);
        if (blockdoor.maxY < 1.0) {
            f5 = f4;
        }
        if (Block.lightValue[block.blockID] > 0) {
            f5 = 1.0f;
        }
        tessellator.setColorOpaque_F(f1 * f5, f1 * f5, f1 * f5);
        this.renderTopFace(block, i2, j2, k2, block.getBlockTexture(this.blockAccess, i2, j2, k2, 1));
        flag = true;
        f5 = block.getBlockBrightness(this.blockAccess, i2, j2, k2 - 1);
        if (blockdoor.minZ > 0.0) {
            f5 = f4;
        }
        if (Block.lightValue[block.blockID] > 0) {
            f5 = 1.0f;
        }
        tessellator.setColorOpaque_F(f22 * f5, f22 * f5, f22 * f5);
        int l2 = block.getBlockTexture(this.blockAccess, i2, j2, k2, 2);
        if (l2 < 0) {
            this.flipTexture = true;
            l2 = -l2;
        }
        this.renderEastFace(block, i2, j2, k2, l2);
        flag = true;
        this.flipTexture = false;
        f5 = block.getBlockBrightness(this.blockAccess, i2, j2, k2 + 1);
        if (blockdoor.maxZ < 1.0) {
            f5 = f4;
        }
        if (Block.lightValue[block.blockID] > 0) {
            f5 = 1.0f;
        }
        tessellator.setColorOpaque_F(f22 * f5, f22 * f5, f22 * f5);
        l2 = block.getBlockTexture(this.blockAccess, i2, j2, k2, 3);
        if (l2 < 0) {
            this.flipTexture = true;
            l2 = -l2;
        }
        this.renderWestFace(block, i2, j2, k2, l2);
        flag = true;
        this.flipTexture = false;
        f5 = block.getBlockBrightness(this.blockAccess, i2 - 1, j2, k2);
        if (blockdoor.minX > 0.0) {
            f5 = f4;
        }
        if (Block.lightValue[block.blockID] > 0) {
            f5 = 1.0f;
        }
        tessellator.setColorOpaque_F(f3 * f5, f3 * f5, f3 * f5);
        l2 = block.getBlockTexture(this.blockAccess, i2, j2, k2, 4);
        if (l2 < 0) {
            this.flipTexture = true;
            l2 = -l2;
        }
        this.renderNorthFace(block, i2, j2, k2, l2);
        flag = true;
        this.flipTexture = false;
        f5 = block.getBlockBrightness(this.blockAccess, i2 + 1, j2, k2);
        if (blockdoor.maxX < 1.0) {
            f5 = f4;
        }
        if (Block.lightValue[block.blockID] > 0) {
            f5 = 1.0f;
        }
        tessellator.setColorOpaque_F(f3 * f5, f3 * f5, f3 * f5);
        l2 = block.getBlockTexture(this.blockAccess, i2, j2, k2, 5);
        if (l2 < 0) {
            this.flipTexture = true;
            l2 = -l2;
        }
        this.renderSouthFace(block, i2, j2, k2, l2);
        flag = true;
        this.flipTexture = false;
        return flag;
    }

    public void renderBottomFace(Block block, double d2, double d1, double d22, int i2) {
        Tessellator tessellator = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            i2 = this.overrideBlockTexture;
        }
        int j2 = i2 % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int k2 = i2 / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        double d3 = ((double)j2 + block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d4 = ((double)j2 + block.maxX * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d5 = ((double)k2 + block.minZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d6 = ((double)k2 + block.maxZ * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        if (block.minX < 0.0 || block.maxX > 1.0) {
            d3 = ((float)j2 + 0.0f) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((float)j2 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        }
        if (block.minZ < 0.0 || block.maxZ > 1.0) {
            d5 = ((float)k2 + 0.0f) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((float)k2 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        }
        double d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (this.uvRotateBottom == 2) {
            d3 = ((double)j2 + block.minZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)(k2 + TextureFX.tileWidthTerrain) - block.maxX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)j2 + block.maxZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)(k2 + TextureFX.tileWidthTerrain) - block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (this.uvRotateBottom == 1) {
            d3 = ((double)(j2 + TextureFX.tileWidthTerrain) - block.maxZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)k2 + block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)(j2 + TextureFX.tileWidthTerrain) - block.minZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)k2 + block.maxX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
            d3 = d7;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (this.uvRotateBottom == 3) {
            d3 = ((double)(j2 + TextureFX.tileWidthTerrain) - block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)(j2 + TextureFX.tileWidthTerrain) - block.maxX * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)(k2 + TextureFX.tileWidthTerrain) - block.minZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)(k2 + TextureFX.tileWidthTerrain) - block.maxZ * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = d2 + block.minX;
        double d12 = d2 + block.maxX;
        double d13 = d1 + block.minY;
        double d14 = d22 + block.minZ;
        double d15 = d22 + block.maxZ;
        if (this.enableAO) {
            tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            tessellator.addVertexWithUV(d11, d13, d15, d8, d10);
            tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            tessellator.addVertexWithUV(d11, d13, d14, d3, d5);
            tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            tessellator.addVertexWithUV(d12, d13, d14, d7, d9);
            tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            tessellator.addVertexWithUV(d12, d13, d15, d4, d6);
        } else {
            tessellator.addVertexWithUV(d11, d13, d15, d8, d10);
            tessellator.addVertexWithUV(d11, d13, d14, d3, d5);
            tessellator.addVertexWithUV(d12, d13, d14, d7, d9);
            tessellator.addVertexWithUV(d12, d13, d15, d4, d6);
        }
    }

    public void renderTopFace(Block block, double d2, double d1, double d22, int i2) {
        Tessellator tessellator = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            i2 = this.overrideBlockTexture;
        }
        int j2 = i2 % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int k2 = i2 / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        double d3 = ((double)j2 + block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d4 = ((double)j2 + block.maxX * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d5 = ((double)k2 + block.minZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d6 = ((double)k2 + block.maxZ * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        if (block.minX < 0.0 || block.maxX > 1.0) {
            d3 = ((float)j2 + 0.0f) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((float)j2 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        }
        if (block.minZ < 0.0 || block.maxZ > 1.0) {
            d5 = ((float)k2 + 0.0f) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((float)k2 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        }
        double d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (this.uvRotateTop == 1) {
            d3 = ((double)j2 + block.minZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)(k2 + TextureFX.tileWidthTerrain) - block.maxX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)j2 + block.maxZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)(k2 + TextureFX.tileWidthTerrain) - block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (this.uvRotateTop == 2) {
            d3 = ((double)(j2 + TextureFX.tileWidthTerrain) - block.maxZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)k2 + block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)(j2 + TextureFX.tileWidthTerrain) - block.minZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)k2 + block.maxX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
            d3 = d7;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (this.uvRotateTop == 3) {
            d3 = ((double)(j2 + TextureFX.tileWidthTerrain) - block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)(j2 + TextureFX.tileWidthTerrain) - block.maxX * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)(k2 + TextureFX.tileWidthTerrain) - block.minZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)(k2 + TextureFX.tileWidthTerrain) - block.maxZ * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = d2 + block.minX;
        double d12 = d2 + block.maxX;
        double d13 = d1 + block.maxY;
        double d14 = d22 + block.minZ;
        double d15 = d22 + block.maxZ;
        if (this.enableAO) {
            tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            tessellator.addVertexWithUV(d12, d13, d15, d4, d6);
            tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            tessellator.addVertexWithUV(d12, d13, d14, d7, d9);
            tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            tessellator.addVertexWithUV(d11, d13, d14, d3, d5);
            tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            tessellator.addVertexWithUV(d11, d13, d15, d8, d10);
        } else {
            tessellator.addVertexWithUV(d12, d13, d15, d4, d6);
            tessellator.addVertexWithUV(d12, d13, d14, d7, d9);
            tessellator.addVertexWithUV(d11, d13, d14, d3, d5);
            tessellator.addVertexWithUV(d11, d13, d15, d8, d10);
        }
    }

    public void renderEastFace(Block block, double d2, double d1, double d22, int i2) {
        Tessellator tessellator = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            i2 = this.overrideBlockTexture;
        }
        int j2 = i2 % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int k2 = i2 / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        double d3 = ((double)j2 + block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d4 = ((double)j2 + block.maxX * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d5 = ((double)(k2 + TextureFX.tileWidthTerrain) - block.maxY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d6 = ((double)(k2 + TextureFX.tileWidthTerrain) - block.minY * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        if (this.flipTexture) {
            double d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (block.minX < 0.0 || block.maxX > 1.0) {
            d3 = ((float)j2 + 0.0f) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((float)j2 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        }
        if (block.minY < 0.0 || block.maxY > 1.0) {
            d5 = ((float)k2 + 0.0f) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((float)k2 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        }
        double d8 = d4;
        double d9 = d3;
        double d10 = d5;
        double d11 = d6;
        if (this.uvRotateEast == 2) {
            d3 = ((double)j2 + block.minY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)(k2 + TextureFX.tileWidthTerrain) - block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)j2 + block.maxY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)(k2 + TextureFX.tileWidthTerrain) - block.maxX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d8 = d4;
            d9 = d3;
            d10 = d5;
            d11 = d6;
            d8 = d3;
            d9 = d4;
            d5 = d6;
            d6 = d10;
        } else if (this.uvRotateEast == 1) {
            d3 = ((double)(j2 + TextureFX.tileWidthTerrain) - block.maxY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)k2 + block.maxX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)(j2 + TextureFX.tileWidthTerrain) - block.minY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)k2 + block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d8 = d4;
            d9 = d3;
            d10 = d5;
            d11 = d6;
            d3 = d8;
            d4 = d9;
            d10 = d6;
            d11 = d5;
        } else if (this.uvRotateEast == 3) {
            d3 = ((double)(j2 + TextureFX.tileWidthTerrain) - block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)(j2 + TextureFX.tileWidthTerrain) - block.maxX * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)k2 + block.maxY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)k2 + block.minY * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d8 = d4;
            d9 = d3;
            d10 = d5;
            d11 = d6;
        }
        double d12 = d2 + block.minX;
        double d13 = d2 + block.maxX;
        double d14 = d1 + block.minY;
        double d15 = d1 + block.maxY;
        double d16 = d22 + block.minZ;
        if (this.enableAO) {
            tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            tessellator.addVertexWithUV(d12, d15, d16, d8, d10);
            tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            tessellator.addVertexWithUV(d13, d15, d16, d3, d5);
            tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            tessellator.addVertexWithUV(d13, d14, d16, d9, d11);
            tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            tessellator.addVertexWithUV(d12, d14, d16, d4, d6);
        } else {
            tessellator.addVertexWithUV(d12, d15, d16, d8, d10);
            tessellator.addVertexWithUV(d13, d15, d16, d3, d5);
            tessellator.addVertexWithUV(d13, d14, d16, d9, d11);
            tessellator.addVertexWithUV(d12, d14, d16, d4, d6);
        }
    }

    public void renderWestFace(Block block, double d2, double d1, double d22, int i2) {
        Tessellator tessellator = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            i2 = this.overrideBlockTexture;
        }
        int j2 = i2 % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int k2 = i2 / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        double d3 = ((double)j2 + block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d4 = ((double)j2 + block.maxX * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d5 = ((double)(k2 + TextureFX.tileWidthTerrain) - block.maxY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d6 = ((double)(k2 + TextureFX.tileWidthTerrain) - block.minY * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        if (this.flipTexture) {
            double d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (block.minX < 0.0 || block.maxX > 1.0) {
            d3 = ((float)j2 + 0.0f) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((float)j2 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        }
        if (block.minY < 0.0 || block.maxY > 1.0) {
            d5 = ((float)k2 + 0.0f) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((float)k2 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        }
        double d8 = d4;
        double d9 = d3;
        double d10 = d5;
        double d11 = d6;
        if (this.uvRotateWest == 1) {
            d3 = ((double)j2 + block.minY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)(k2 + TextureFX.tileWidthTerrain) - block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)j2 + block.maxY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)(k2 + TextureFX.tileWidthTerrain) - block.maxX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d8 = d4;
            d9 = d3;
            d10 = d5;
            d11 = d6;
            d8 = d3;
            d9 = d4;
            d5 = d6;
            d6 = d10;
        } else if (this.uvRotateWest == 2) {
            d3 = ((double)(j2 + TextureFX.tileWidthTerrain) - block.maxY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)k2 + block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)(j2 + TextureFX.tileWidthTerrain) - block.minY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)k2 + block.maxX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d8 = d4;
            d9 = d3;
            d10 = d5;
            d11 = d6;
            d3 = d8;
            d4 = d9;
            d10 = d6;
            d11 = d5;
        } else if (this.uvRotateWest == 3) {
            d3 = ((double)(j2 + TextureFX.tileWidthTerrain) - block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)(j2 + TextureFX.tileWidthTerrain) - block.maxX * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)k2 + block.maxY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)k2 + block.minY * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d8 = d4;
            d9 = d3;
            d10 = d5;
            d11 = d6;
        }
        double d12 = d2 + block.minX;
        double d13 = d2 + block.maxX;
        double d14 = d1 + block.minY;
        double d15 = d1 + block.maxY;
        double d16 = d22 + block.maxZ;
        if (this.enableAO) {
            tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            tessellator.addVertexWithUV(d12, d15, d16, d3, d5);
            tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            tessellator.addVertexWithUV(d12, d14, d16, d9, d11);
            tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            tessellator.addVertexWithUV(d13, d14, d16, d4, d6);
            tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            tessellator.addVertexWithUV(d13, d15, d16, d8, d10);
        } else {
            tessellator.addVertexWithUV(d12, d15, d16, d3, d5);
            tessellator.addVertexWithUV(d12, d14, d16, d9, d11);
            tessellator.addVertexWithUV(d13, d14, d16, d4, d6);
            tessellator.addVertexWithUV(d13, d15, d16, d8, d10);
        }
    }

    public void renderNorthFace(Block block, double d2, double d1, double d22, int i2) {
        Tessellator tessellator = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            i2 = this.overrideBlockTexture;
        }
        int j2 = i2 % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int k2 = i2 / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        double d3 = ((double)j2 + block.minZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d4 = ((double)j2 + block.maxZ * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d5 = ((double)(k2 + TextureFX.tileWidthTerrain) - block.maxY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d6 = ((double)(k2 + TextureFX.tileWidthTerrain) - block.minY * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        if (this.flipTexture) {
            double d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (block.minZ < 0.0 || block.maxZ > 1.0) {
            d3 = ((float)j2 + 0.0f) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((float)j2 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        }
        if (block.minY < 0.0 || block.maxY > 1.0) {
            d5 = ((float)k2 + 0.0f) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((float)k2 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        }
        double d8 = d4;
        double d9 = d3;
        double d10 = d5;
        double d11 = d6;
        if (this.uvRotateNorth == 1) {
            d3 = ((double)j2 + block.minY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)(k2 + TextureFX.tileWidthTerrain) - block.maxZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)j2 + block.maxY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)(k2 + TextureFX.tileWidthTerrain) - block.minZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d8 = d4;
            d9 = d3;
            d10 = d5;
            d11 = d6;
            d8 = d3;
            d9 = d4;
            d5 = d6;
            d6 = d10;
        } else if (this.uvRotateNorth == 2) {
            d3 = ((double)(j2 + TextureFX.tileWidthTerrain) - block.maxY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)k2 + block.minZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)(j2 + TextureFX.tileWidthTerrain) - block.minY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)k2 + block.maxZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d8 = d4;
            d9 = d3;
            d10 = d5;
            d11 = d6;
            d3 = d8;
            d4 = d9;
            d10 = d6;
            d11 = d5;
        } else if (this.uvRotateNorth == 3) {
            d3 = ((double)(j2 + TextureFX.tileWidthTerrain) - block.minZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)(j2 + TextureFX.tileWidthTerrain) - block.maxZ * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)k2 + block.maxY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)k2 + block.minY * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d8 = d4;
            d9 = d3;
            d10 = d5;
            d11 = d6;
        }
        double d12 = d2 + block.minX;
        double d13 = d1 + block.minY;
        double d14 = d1 + block.maxY;
        double d15 = d22 + block.minZ;
        double d16 = d22 + block.maxZ;
        if (this.enableAO) {
            tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            tessellator.addVertexWithUV(d12, d14, d16, d8, d10);
            tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            tessellator.addVertexWithUV(d12, d14, d15, d3, d5);
            tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            tessellator.addVertexWithUV(d12, d13, d15, d9, d11);
            tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            tessellator.addVertexWithUV(d12, d13, d16, d4, d6);
        } else {
            tessellator.addVertexWithUV(d12, d14, d16, d8, d10);
            tessellator.addVertexWithUV(d12, d14, d15, d3, d5);
            tessellator.addVertexWithUV(d12, d13, d15, d9, d11);
            tessellator.addVertexWithUV(d12, d13, d16, d4, d6);
        }
    }

    public void renderSouthFace(Block block, double d2, double d1, double d22, int i2) {
        Tessellator tessellator = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            i2 = this.overrideBlockTexture;
        }
        int j2 = i2 % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int k2 = i2 / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        double d3 = ((double)j2 + block.minZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d4 = ((double)j2 + block.maxZ * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d5 = ((double)(k2 + TextureFX.tileWidthTerrain) - block.maxY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        double d6 = ((double)(k2 + TextureFX.tileWidthTerrain) - block.minY * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        if (this.flipTexture) {
            double d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (block.minZ < 0.0 || block.maxZ > 1.0) {
            d3 = ((float)j2 + 0.0f) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((float)j2 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        }
        if (block.minY < 0.0 || block.maxY > 1.0) {
            d5 = ((float)k2 + 0.0f) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((float)k2 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        }
        double d8 = d4;
        double d9 = d3;
        double d10 = d5;
        double d11 = d6;
        if (this.uvRotateSouth == 2) {
            d3 = ((double)j2 + block.minY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)(k2 + TextureFX.tileWidthTerrain) - block.minZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)j2 + block.maxY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)(k2 + TextureFX.tileWidthTerrain) - block.maxZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d8 = d4;
            d9 = d3;
            d10 = d5;
            d11 = d6;
            d8 = d3;
            d9 = d4;
            d5 = d6;
            d6 = d10;
        } else if (this.uvRotateSouth == 1) {
            d3 = ((double)(j2 + TextureFX.tileWidthTerrain) - block.maxY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)k2 + block.maxZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)(j2 + TextureFX.tileWidthTerrain) - block.minY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)k2 + block.minZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d8 = d4;
            d9 = d3;
            d10 = d5;
            d11 = d6;
            d3 = d8;
            d4 = d9;
            d10 = d6;
            d11 = d5;
        } else if (this.uvRotateSouth == 3) {
            d3 = ((double)(j2 + TextureFX.tileWidthTerrain) - block.minZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)(j2 + TextureFX.tileWidthTerrain) - block.maxZ * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)k2 + block.maxY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)k2 + block.minY * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            d8 = d4;
            d9 = d3;
            d10 = d5;
            d11 = d6;
        }
        double d12 = d2 + block.maxX;
        double d13 = d1 + block.minY;
        double d14 = d1 + block.maxY;
        double d15 = d22 + block.minZ;
        double d16 = d22 + block.maxZ;
        if (this.enableAO) {
            tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            tessellator.addVertexWithUV(d12, d13, d16, d9, d11);
            tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            tessellator.addVertexWithUV(d12, d13, d15, d4, d6);
            tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            tessellator.addVertexWithUV(d12, d14, d15, d8, d10);
            tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            tessellator.addVertexWithUV(d12, d14, d16, d3, d5);
        } else {
            tessellator.addVertexWithUV(d12, d13, d16, d9, d11);
            tessellator.addVertexWithUV(d12, d13, d15, d4, d6);
            tessellator.addVertexWithUV(d12, d14, d15, d8, d10);
            tessellator.addVertexWithUV(d12, d14, d16, d3, d5);
        }
    }

    public void renderBlockAsItem(Block var1, float var2) {
        int var3 = var1.getRenderType();
        Tessellator var4 = Tessellator.instance;
        if (var3 == 0) {
            var1.setBlockBoundsForItemRender();
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            float var5 = 0.5f;
            float var6 = 1.0f;
            float var7 = 0.8f;
            float var8 = 0.6f;
            var4.startDrawingQuads();
            var4.setColorRGBA_F(var6, var6, var6, var2);
            this.renderBottomFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(0));
            var4.setColorRGBA_F(var5, var5, var5, var2);
            this.renderTopFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(1));
            var4.setColorRGBA_F(var7, var7, var7, var2);
            this.renderEastFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(2));
            this.renderWestFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(3));
            var4.setColorRGBA_F(var8, var8, var8, var2);
            this.renderNorthFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(4));
            this.renderSouthFace(var1, 0.0, 0.0, 0.0, var1.getBlockTextureFromSide(5));
            var4.draw();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        }
    }

    public void renderBlockOnInventory(Block block, int i2, float f2) {
        float f9;
        float f8;
        float f4;
        float f92;
        float f82;
        float f42;
        int renderType;
        boolean isGrass;
        Tessellator tessellator = Tessellator.instance;
        boolean bl2 = isGrass = block.blockID == Block.grass.blockID;
        if (this.useInventoryTint) {
            int j2 = block.getRenderColor(i2);
            if (isGrass) {
                j2 = 0xFFFFFF;
            }
            float f1 = (float)(j2 >> 16 & 0xFF) / 255.0f;
            float f3 = (float)(j2 >> 8 & 0xFF) / 255.0f;
            float f5 = (float)(j2 & 0xFF) / 255.0f;
            GL11.glColor4f((float)(f1 * f2), (float)(f3 * f2), (float)(f5 * f2), (float)1.0f);
        }
        if ((renderType = block.getRenderType()) == 0 || renderType == 16) {
            if (renderType == 16) {
                i2 = 1;
            }
            block.setBlockBoundsForItemRender();
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            this.renderBottomFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(0, i2));
            tessellator.draw();
            if (isGrass && this.useInventoryTint) {
                int l2 = block.getRenderColor(i2);
                f42 = (float)(l2 >> 16 & 0xFF) / 255.0f;
                f82 = (float)(l2 >> 8 & 0xFF) / 255.0f;
                f92 = (float)(l2 & 0xFF) / 255.0f;
                GL11.glColor4f((float)(f42 * f2), (float)(f82 * f2), (float)(f92 * f2), (float)1.0f);
            }
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            this.renderTopFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(1, i2));
            tessellator.draw();
            if (isGrass && this.useInventoryTint) {
                GL11.glColor4f((float)f2, (float)f2, (float)f2, (float)1.0f);
            }
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            this.renderEastFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(5, i2));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            this.renderWestFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(4, i2));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            this.renderNorthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(3, i2));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            this.renderSouthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(2, i2));
            tessellator.draw();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        } else if (renderType == 21) {
            int mossCoord = Block.texCoordToIndex(0, 2);
            GL11.glColor4f((float)f2, (float)f2, (float)f2, (float)1.0f);
            block.setBlockBoundsForItemRender();
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            this.renderBottomFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(0, i2));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            this.renderTopFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(1, i2));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            this.renderEastFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(2, i2));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            this.renderWestFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(3, i2));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            this.renderNorthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(4, i2));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            this.renderSouthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(5, i2));
            tessellator.draw();
            int l3 = block.getRenderColor(i2);
            f4 = (float)(l3 >> 16 & 0xFF) / 255.0f;
            f8 = (float)(l3 >> 8 & 0xFF) / 255.0f;
            f9 = (float)(l3 & 0xFF) / 255.0f;
            GL11.glColor4f((float)(f4 * f2), (float)(f8 * f2), (float)(f9 * f2), (float)1.0f);
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            this.renderBottomFace(block, 0.0, 0.0, 0.0, mossCoord);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            this.renderTopFace(block, 0.0, 0.0, 0.0, mossCoord);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            this.renderEastFace(block, 0.0, 0.0, 0.0, mossCoord);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            this.renderWestFace(block, 0.0, 0.0, 0.0, mossCoord);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            this.renderNorthFace(block, 0.0, 0.0, 0.0, mossCoord);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            this.renderSouthFace(block, 0.0, 0.0, 0.0, mossCoord);
            tessellator.draw();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        } else if (renderType == 22) {
            GL11.glColor4f((float)f2, (float)f2, (float)f2, (float)1.0f);
            block.setBlockBoundsForItemRender();
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            this.renderBottomFace(block, 0.0, 0.0, 0.0, Block.chestPlanksOak.getBlockTextureFromSideAndMetadata(0, 0));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            this.renderTopFace(block, 0.0, 0.0, 0.0, Block.chestPlanksOak.getBlockTextureFromSideAndMetadata(1, 0));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            this.renderEastFace(block, 0.0, 0.0, 0.0, Block.chestPlanksOak.getBlockTextureFromSideAndMetadata(5, 0));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            this.renderWestFace(block, 0.0, 0.0, 0.0, Block.chestPlanksOak.getBlockTextureFromSideAndMetadata(4, 0));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            this.renderNorthFace(block, 0.0, 0.0, 0.0, Block.chestPlanksOak.getBlockTextureFromSideAndMetadata(3, 0));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            this.renderSouthFace(block, 0.0, 0.0, 0.0, Block.chestPlanksOak.getBlockTextureFromSideAndMetadata(2, 0));
            tessellator.draw();
            int l4 = block.getRenderColor(i2);
            f42 = (float)(l4 >> 16 & 0xFF) / 255.0f;
            f82 = (float)(l4 >> 8 & 0xFF) / 255.0f;
            f92 = (float)(l4 & 0xFF) / 255.0f;
            GL11.glColor4f((float)(f42 * f2), (float)(f82 * f2), (float)(f92 * f2), (float)1.0f);
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            this.renderBottomFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(0, 0));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            this.renderTopFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(1, 0));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            this.renderEastFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(2, 0));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            this.renderWestFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(3, 0));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            this.renderNorthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(4, 0));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            this.renderSouthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(5, 0));
            tessellator.draw();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        } else if (renderType == 23) {
            int cherryCoord = Block.texCoordToIndex(3, 17);
            int l5 = block.getRenderColor(i2);
            f4 = (float)(l5 >> 16 & 0xFF) / 255.0f;
            f8 = (float)(l5 >> 8 & 0xFF) / 255.0f;
            f9 = (float)(l5 & 0xFF) / 255.0f;
            GL11.glColor4f((float)(f4 * f2), (float)(f8 * f2), (float)(f9 * f2), (float)1.0f);
            block.setBlockBoundsForItemRender();
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            this.renderBottomFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(0, i2));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            this.renderTopFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(1, i2));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            this.renderEastFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(2, i2));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            this.renderWestFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(3, i2));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            this.renderNorthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(4, i2));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            this.renderSouthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(5, i2));
            tessellator.draw();
            GL11.glColor4f((float)f2, (float)f2, (float)f2, (float)1.0f);
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            this.renderBottomFace(block, 0.0, 0.0, 0.0, cherryCoord);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            this.renderTopFace(block, 0.0, 0.0, 0.0, cherryCoord);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            this.renderEastFace(block, 0.0, 0.0, 0.0, cherryCoord);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            this.renderWestFace(block, 0.0, 0.0, 0.0, cherryCoord);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            this.renderNorthFace(block, 0.0, 0.0, 0.0, cherryCoord);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            this.renderSouthFace(block, 0.0, 0.0, 0.0, cherryCoord);
            tessellator.draw();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        } else if (renderType == 1) {
            boolean isTallGrass;
            boolean bl3 = isTallGrass = block.blockID == Block.tallgrass.blockID;
            if (isTallGrass && this.useInventoryTint) {
                int l6 = block.getRenderColor(i2);
                f4 = (float)(l6 >> 16 & 0xFF) / 255.0f;
                f8 = (float)(l6 >> 8 & 0xFF) / 255.0f;
                f9 = (float)(l6 & 0xFF) / 255.0f;
                GL11.glColor4f((float)(f4 * f2), (float)(f8 * f2), (float)(f9 * f2), (float)1.0f);
            }
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            this.renderCrossedSquares(block, i2, -0.5, -0.5, -0.5);
            tessellator.draw();
        } else if (renderType == 13) {
            block.setBlockBoundsForItemRender();
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            float f22 = 0.0625f;
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            this.renderBottomFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(0));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            this.renderTopFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(1));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            tessellator.setTranslationF(0.0f, 0.0f, f22);
            this.renderEastFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(2));
            tessellator.setTranslationF(0.0f, 0.0f, -f22);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            tessellator.setTranslationF(0.0f, 0.0f, -f22);
            this.renderWestFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(3));
            tessellator.setTranslationF(0.0f, 0.0f, f22);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            tessellator.setTranslationF(f22, 0.0f, 0.0f);
            this.renderNorthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(4));
            tessellator.setTranslationF(-f22, 0.0f, 0.0f);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            tessellator.setTranslationF(-f22, 0.0f, 0.0f);
            this.renderSouthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(5));
            tessellator.setTranslationF(f22, 0.0f, 0.0f);
            tessellator.draw();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        } else if (renderType == 6) {
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            this.func_1245_b(block, i2, -0.5, -0.5, -0.5);
            tessellator.draw();
        } else if (renderType == 2) {
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            this.renderTorchAtAngle(block, -0.5, -0.5, -0.5, 0.0, 0.0);
            tessellator.draw();
        } else if (renderType == 10) {
            for (int l7 = 0; l7 < 2; ++l7) {
                if (l7 == 0) {
                    block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f);
                }
                if (l7 == 1) {
                    block.setBlockBounds(0.0f, 0.0f, 0.5f, 1.0f, 0.5f, 1.0f);
                }
                GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, -1.0f, 0.0f);
                this.renderBottomFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(0));
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, 1.0f, 0.0f);
                this.renderTopFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(1));
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, 0.0f, -1.0f);
                this.renderEastFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(2));
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, 0.0f, 1.0f);
                this.renderWestFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(3));
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(-1.0f, 0.0f, 0.0f);
                this.renderNorthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(4));
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(1.0f, 0.0f, 0.0f);
                this.renderSouthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(5));
                tessellator.draw();
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            }
        } else if (renderType == 11) {
            for (int i1 = 0; i1 < 4; ++i1) {
                f42 = 0.125f;
                if (i1 == 0) {
                    block.setBlockBounds(0.5f - f42, 0.0f, 0.0f, 0.5f + f42, 1.0f, f42 * 2.0f);
                }
                if (i1 == 1) {
                    block.setBlockBounds(0.5f - f42, 0.0f, 1.0f - f42 * 2.0f, 0.5f + f42, 1.0f, 1.0f);
                }
                f42 = 0.0625f;
                if (i1 == 2) {
                    block.setBlockBounds(0.5f - f42, 1.0f - f42 * 3.0f, -f42 * 2.0f, 0.5f + f42, 1.0f - f42, 1.0f + f42 * 2.0f);
                }
                if (i1 == 3) {
                    block.setBlockBounds(0.5f - f42, 0.5f - f42 * 3.0f, -f42 * 2.0f, 0.5f + f42, 0.5f - f42, 1.0f + f42 * 2.0f);
                }
                GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, -1.0f, 0.0f);
                this.renderBottomFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(0));
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, 1.0f, 0.0f);
                this.renderTopFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(1));
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, 0.0f, -1.0f);
                this.renderEastFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(2));
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, 0.0f, 1.0f);
                this.renderWestFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(3));
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(-1.0f, 0.0f, 0.0f);
                this.renderNorthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(4));
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(1.0f, 0.0f, 0.0f);
                this.renderSouthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(5));
                tessellator.draw();
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            }
            block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        if (renderType == 20) {
            block.setBlockBoundsForItemRender();
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            this.renderBottomFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(0, i2));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            this.renderTopFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(1, i2));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            this.renderEastFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(2, i2));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            this.renderWestFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(3, i2));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            this.renderNorthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(4, i2));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            this.renderSouthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(5, i2));
            tessellator.draw();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        } else if (renderType == 18) {
            for (int k1 = 0; k1 < 3; ++k1) {
                float f6 = 0.0625f;
                if (k1 == 0) {
                    block.setBlockBounds(0.5f - f6, 0.3f, 0.0f, 0.5f + f6, 1.0f, f6 * 2.0f);
                }
                if (k1 == 1) {
                    block.setBlockBounds(0.5f - f6, 0.3f, 1.0f - f6 * 2.0f, 0.5f + f6, 1.0f, 1.0f);
                }
                f6 = 0.0625f;
                if (k1 == 2) {
                    block.setBlockBounds(0.5f - f6, 0.5f, 0.0f, 0.5f + f6, 1.0f - f6, 1.0f);
                }
                GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, -1.0f, 0.0f);
                this.renderBottomFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(0));
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, 1.0f, 0.0f);
                this.renderTopFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(1));
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, 0.0f, -1.0f);
                this.renderEastFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(2));
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, 0.0f, 1.0f);
                this.renderWestFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(3));
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(-1.0f, 0.0f, 0.0f);
                this.renderNorthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(4));
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(1.0f, 0.0f, 0.0f);
                this.renderSouthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSide(5));
                tessellator.draw();
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            }
            block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static boolean renderItemIn3d(int i2) {
        if (i2 == 0 || i2 == 20) {
            return true;
        }
        if (i2 == 13) {
            return true;
        }
        if (i2 == 10) {
            return true;
        }
        if (i2 == 11) {
            return true;
        }
        if (i2 == 18) {
            return true;
        }
        if (i2 == 21) {
            return true;
        }
        if (i2 == 22) {
            return true;
        }
        if (i2 == 23) {
            return true;
        }
        return i2 == 16;
    }
}

