/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.minecraft.client.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.ColorProperties;
import net.minecraft.src.DownloadedTexture;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.GLAllocation;
import net.minecraft.src.GameSettings;
import net.minecraft.src.ImageParser;
import net.minecraft.src.TextureFX;
import net.minecraft.src.TexturePackBase;
import net.minecraft.src.TexturePackList;
import net.minecraft.src.dynamictexture.DynamicTexture;
import net.minecraft.src.dynamictexture.DynamicTextureCalendar;
import net.minecraft.src.dynamictexture.DynamicTextureClock;
import net.minecraft.src.dynamictexture.DynamicTextureCompass;
import net.minecraft.src.dynamictexture.DynamicTextureCustom;
import net.minecraft.src.dynamictexture.DynamicTextureFire;
import net.minecraft.src.dynamictexture.DynamicTextureLavaFlowing;
import net.minecraft.src.dynamictexture.DynamicTextureLavaStill;
import net.minecraft.src.dynamictexture.DynamicTexturePortal;
import net.minecraft.src.dynamictexture.DynamicTextureTrommel;
import net.minecraft.src.dynamictexture.DynamicTextureWaterFlow;
import net.minecraft.src.dynamictexture.DynamicTextureWaterStill;
import net.minecraft.src.helper.Buffer;
import net.minecraft.src.helper.Color;
import net.minecraft.src.helper.Colors;
import net.minecraft.src.helper.Textures;
import org.lwjgl.opengl.GL11;

public class RenderEngine {
    public final Minecraft minecraft;
    private Map<String, Integer> textureMap = new HashMap<String, Integer>();
    private Map<String, int[]> intArrayTextureData = new HashMap<String, int[]>();
    private Map<Integer, BufferedImage> textureNameToImageMap = new HashMap<Integer, BufferedImage>();
    private Map<String, DownloadedTexture> downloadedTextures = new HashMap<String, DownloadedTexture>();
    private List<DynamicTexture> dynamicTextures = new ArrayList<DynamicTexture>();
    private GameSettings gameSettings;
    public TexturePackList texturePacks;
    private boolean clampTexture;
    private boolean blurTexture;

    public RenderEngine(Minecraft minecraft, TexturePackList texturePacks, GameSettings gameSettings) {
        this.minecraft = minecraft;
        this.clampTexture = false;
        this.blurTexture = false;
        this.texturePacks = texturePacks;
        this.gameSettings = gameSettings;
    }

    public void initDynamicTextures() {
        System.out.println("Initializing Dynamic Textures...");
        this.dynamicTextures.clear();
        GL11.glBindTexture((int)3553, (int)this.getTexture("/terrain.png"));
        int terrainResolution = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096) / RenderEngine.atlasWidth();
        GL11.glBindTexture((int)3553, (int)this.getTexture("/gui/items.png"));
        int itemsResolution = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096) / RenderEngine.atlasWidth();
        System.out.println("Resolution: Terrain: " + terrainResolution + " Items: " + itemsResolution);
        TextureFX.tileWidthTerrain = terrainResolution;
        TextureFX.tileWidthItems = itemsResolution;
        if ((Integer)this.minecraft.gameSettings.animations.value != 0) {
            boolean useCustomAnimations;
            boolean bl2 = useCustomAnimations = (Integer)this.minecraft.gameSettings.animations.value == 2;
            if (useCustomAnimations && this.texturePacks.selectedTexturePack.hasFile("/custom_water_still.png")) {
                System.out.println("Using Custom Still Water Animation");
                this.dynamicTextures.add(new DynamicTextureCustom(this.minecraft, "/terrain.png", "/custom_water_still.png", Block.texCoordToIndex(13, 12), terrainResolution, 1));
            } else {
                System.out.println("Using Generated Still Water Animation");
                this.dynamicTextures.add(new DynamicTextureWaterStill(terrainResolution));
            }
            if (useCustomAnimations && this.texturePacks.selectedTexturePack.hasFile("/custom_water_flowing.png")) {
                System.out.println("Using Custom Flowing Water Animation");
                this.dynamicTextures.add(new DynamicTextureCustom(this.minecraft, "/terrain.png", "/custom_water_flowing.png", Block.texCoordToIndex(14, 12), terrainResolution, 2));
            } else {
                System.out.println("Using Generated Flowing Water Animation");
                this.dynamicTextures.add(new DynamicTextureWaterFlow(terrainResolution));
            }
            if (useCustomAnimations && this.texturePacks.selectedTexturePack.hasFile("/custom_lava_still.png")) {
                System.out.println("Using Custom Still Lava Animation");
                this.dynamicTextures.add(new DynamicTextureCustom(this.minecraft, "/terrain.png", "/custom_lava_still.png", Block.texCoordToIndex(13, 14), terrainResolution, 1));
            } else {
                System.out.println("Using Generated Still Lava Animation");
                this.dynamicTextures.add(new DynamicTextureLavaStill(terrainResolution));
            }
            if (useCustomAnimations && this.texturePacks.selectedTexturePack.hasFile("/custom_lava_flowing.png")) {
                System.out.println("Using Custom Flowing Lava Animation");
                this.dynamicTextures.add(new DynamicTextureCustom(this.minecraft, "/terrain.png", "/custom_lava_flowing.png", Block.texCoordToIndex(14, 14), terrainResolution, 2));
            } else {
                System.out.println("Using Generated Flowing Lava Animation");
                this.dynamicTextures.add(new DynamicTextureLavaFlowing(terrainResolution));
            }
            if (useCustomAnimations && this.texturePacks.selectedTexturePack.hasFile("/custom_portal.png")) {
                System.out.println("Using Custom Portal Animation");
                this.dynamicTextures.add(new DynamicTextureCustom(this.minecraft, "/terrain.png", "/custom_portal.png", Block.texCoordToIndex(14, 0), terrainResolution, 1));
            } else {
                System.out.println("Using Generated Portal Animation");
                this.dynamicTextures.add(new DynamicTexturePortal(terrainResolution, false));
            }
            this.dynamicTextures.add(new DynamicTextureTrommel(this.minecraft, Block.texCoordToIndex(1, 7), terrainResolution, false));
            this.dynamicTextures.add(new DynamicTextureTrommel(this.minecraft, Block.texCoordToIndex(2, 7), terrainResolution, true));
            this.dynamicTextures.add(new DynamicTextureFire(terrainResolution));
        } else {
            this.updateDynamicTexture(new DynamicTextureTrommel(this.minecraft, Block.texCoordToIndex(1, 7), terrainResolution, false));
            this.updateDynamicTexture(new DynamicTextureTrommel(this.minecraft, Block.texCoordToIndex(2, 7), terrainResolution, true));
        }
        this.dynamicTextures.add(new DynamicTextureClock(this.minecraft, itemsResolution));
        this.dynamicTextures.add(new DynamicTextureCalendar(this.minecraft, itemsResolution));
        this.dynamicTextures.add(new DynamicTextureCompass(this.minecraft, itemsResolution));
    }

    public int[] getTextureImageData(String name) {
        int[] imageData = this.intArrayTextureData.get(name);
        if (imageData != null) {
            return imageData;
        }
        imageData = Textures.getImageData(Textures.readImage(this.texturePacks.selectedTexturePack.getResourceAsStream(name)));
        if (imageData == null) {
            imageData = Textures.getImageData(Textures.missingTexture);
        }
        this.intArrayTextureData.put(name, imageData);
        return imageData;
    }

    public boolean enableMipmapForTexture(String name) {
        return name.equals("/terrain.png") || name.equals("/gui/items.png");
    }

    public int getTexture(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        TexturePackBase texturePack = this.texturePacks.selectedTexturePack;
        Integer id2 = this.textureMap.get(name);
        if (id2 != null) {
            return id2;
        }
        try {
            id2 = GLAllocation.generateTexture();
            if (name.startsWith("##")) {
                this.setupTexture(Textures.unwrapImageByColumns(Textures.readImage(texturePack.getResourceAsStream(name.substring(2)))), (int)id2);
            } else if (name.startsWith("%clamp%")) {
                this.clampTexture = true;
                this.setupTexture(Textures.readImage(texturePack.getResourceAsStream(name.substring(7))), (int)id2);
                this.clampTexture = false;
            } else if (name.startsWith("%blur%")) {
                this.blurTexture = true;
                this.setupTexture(Textures.readImage(texturePack.getResourceAsStream(name.substring(6))), (int)id2);
                this.blurTexture = false;
            } else {
                InputStream inputstream = texturePack.getResourceAsStream(name);
                if (inputstream == null) {
                    this.setupTexture(Textures.missingTexture, (int)id2);
                } else {
                    this.setupTexture(Textures.readImage(inputstream), id2, this.enableMipmapForTexture(name));
                }
            }
            this.textureMap.put(name, id2);
            return id2;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            int j2 = GLAllocation.generateTexture();
            this.setupTexture(Textures.missingTexture, j2);
            this.textureMap.put(name, j2);
            return j2;
        }
    }

    public int allocateAndSetupTexture(BufferedImage bufferedimage) {
        int i2 = GLAllocation.generateTexture();
        this.setupTexture(bufferedimage, i2);
        this.textureNameToImageMap.put(i2, bufferedimage);
        return i2;
    }

    public void setupTexture(BufferedImage img, int id2) {
        this.setupTexture(img, id2, false);
    }

    public int[] getAverageTileColors(ByteBuffer buffer, int atlasSize, int res) {
        int[] tileColors = new int[atlasSize * atlasSize];
        int w2 = atlasSize * res;
        for (int tileX = 0; tileX < atlasSize; ++tileX) {
            for (int tileY = 0; tileY < atlasSize; ++tileY) {
                int r1 = 0;
                int g1 = 0;
                int b1 = 0;
                int a1 = 0;
                int co2 = 0;
                for (int i2 = 0; i2 < res; ++i2) {
                    for (int j2 = 0; j2 < res; ++j2) {
                        int k2 = (tileY * res + j2) * w2 + (tileX * res + i2);
                        int r2 = buffer.get(k2 * 4 + 0) & 0xFF;
                        int g2 = buffer.get(k2 * 4 + 1) & 0xFF;
                        int b2 = buffer.get(k2 * 4 + 2) & 0xFF;
                        int a2 = buffer.get(k2 * 4 + 3) & 0xFF;
                        if (a2 <= 0) continue;
                        r1 += r2;
                        g1 += g2;
                        b1 += b2;
                        a1 += a2;
                        ++co2;
                    }
                }
                tileColors[tileY * atlasSize + tileX] = co2 > 0 ? Color.intToIntARGB(a1 /= co2, r1 /= co2, g1 /= co2, b1 /= co2) : 0;
            }
        }
        return tileColors;
    }

    public void setupTexture(BufferedImage img, int id2, boolean mipmap) {
        GL11.glBindTexture((int)3553, (int)id2);
        if (this.blurTexture) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
        if (this.clampTexture) {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        } else {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        }
        int w2 = img.getWidth();
        int h2 = img.getHeight();
        Buffer.put(img);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)w2, (int)h2, (int)0, (int)6408, (int)5121, (ByteBuffer)Buffer.buffer);
        int atlasSize = net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES;
        int res = w2 / atlasSize;
        if ((Integer)this.minecraft.gameSettings.mipmapLevels.value > 0 && mipmap && w2 == h2) {
            Color color = new Color();
            Color tileColor = new Color();
            int levels = (Integer)this.minecraft.gameSettings.mipmapLevels.value;
            int[] tileColors = this.getAverageTileColors(Buffer.buffer, atlasSize, res);
            for (int level = 0; level <= levels; ++level) {
                int j2;
                int i2;
                Buffer.reset();
                int lod = (int)Math.pow(2.0, level);
                int res2 = res / lod;
                int w22 = w2 / lod;
                if (((Boolean)this.minecraft.gameSettings.mipmapSmooth.value).booleanValue()) {
                    for (i2 = 0; i2 < w22; ++i2) {
                        for (j2 = 0; j2 < w22; ++j2) {
                            int r1 = 0;
                            int g1 = 0;
                            int b1 = 0;
                            int a1 = 0;
                            int co2 = 0;
                            for (int i1 = 0; i1 < lod; ++i1) {
                                for (int j1 = 0; j1 < lod; ++j1) {
                                    color.setARGB(img.getRGB(i2 * lod + i1, j2 * lod + j1));
                                    int a2 = color.getAlpha();
                                    if (a2 <= 0) continue;
                                    r1 += color.getRed();
                                    g1 += color.getGreen();
                                    b1 += color.getBlue();
                                    a1 += a2;
                                    ++co2;
                                }
                            }
                            if (co2 > 0) {
                                color.setRGBA(r1 /= co2, g1 /= co2, b1 /= co2, a1 /= co2);
                            } else {
                                color.setRGBA(0, 0, 0, 0);
                            }
                            Buffer.putColor(j2 * w22 + i2, color);
                        }
                    }
                } else {
                    for (i2 = 0; i2 < w22; ++i2) {
                        for (j2 = 0; j2 < w22; ++j2) {
                            Buffer.putARGB(j2 * w22 + i2, img.getRGB(i2 * lod, j2 * lod));
                        }
                    }
                }
                for (int tileX = 0; tileX < atlasSize; ++tileX) {
                    for (int tileY = 0; tileY < atlasSize; ++tileY) {
                        tileColor.setARGB(tileColors[tileY * atlasSize + tileX]);
                        for (int i3 = 0; i3 < res2; ++i3) {
                            for (int j3 = 0; j3 < res2; ++j3) {
                                int k2 = (tileY * res2 + j3) * w22 + (tileX * res2 + i3);
                                color.setARGB(Buffer.getARGB(k2));
                                if (color.getAlpha() != 0) continue;
                                color.setRGB(tileColor);
                                Buffer.putColor(k2, color);
                            }
                        }
                    }
                }
                Buffer.buffer.position(0);
                Buffer.buffer.limit(w22 * w22 * 4);
                GL11.glTexImage2D((int)3553, (int)level, (int)6408, (int)w22, (int)w22, (int)0, (int)6408, (int)5121, (ByteBuffer)Buffer.buffer);
            }
            GL11.glTexParameteri((int)3553, (int)10241, (int)9986);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)33085, (int)levels);
        }
    }

    public void updateDynamicTexture(DynamicTexture texture) {
        texture.update();
        Buffer.checkBufferSize(texture.imageData.length);
        Buffer.reset();
        Buffer.buffer.put(texture.imageData);
        Buffer.buffer.position(0).limit(texture.imageData.length);
        GL11.glBindTexture((int)3553, (int)this.getTexture(texture.getTextureName()));
        int res = texture.resolution;
        int tileX = texture.textureIndex % RenderEngine.atlasWidth();
        int tileY = texture.textureIndex / RenderEngine.atlasWidth();
        for (int i2 = 0; i2 < texture.tileWidth; ++i2) {
            for (int j2 = 0; j2 < texture.tileHeight; ++j2) {
                int x1 = (tileX + i2) * res;
                int y1 = (tileY + j2) * res;
                GL11.glTexSubImage2D((int)3553, (int)0, (int)x1, (int)y1, (int)res, (int)res, (int)6408, (int)5121, (ByteBuffer)Buffer.buffer);
            }
        }
        if ((Integer)this.minecraft.gameSettings.mipmapLevels.value > 0) {
            int levels = GL11.glGetTexParameteri((int)3553, (int)33085);
            for (int level = 1; level <= levels; ++level) {
                int j3;
                int i3;
                int lod = (int)Math.pow(2.0, level);
                int res2 = res / lod;
                Buffer.reset();
                for (i3 = 0; i3 < res2; ++i3) {
                    for (j3 = 0; j3 < res2; ++j3) {
                        int k2 = j3 * lod * res + i3 * lod;
                        int l2 = j3 * res2 + i3;
                        Buffer.buffer.put(l2 * 4 + 0, texture.imageData[k2 * 4 + 0]);
                        Buffer.buffer.put(l2 * 4 + 1, texture.imageData[k2 * 4 + 1]);
                        Buffer.buffer.put(l2 * 4 + 2, texture.imageData[k2 * 4 + 2]);
                        Buffer.buffer.put(l2 * 4 + 3, texture.imageData[k2 * 4 + 3]);
                    }
                }
                Buffer.buffer.position(0).limit(res2 * res2 * 4);
                for (i3 = 0; i3 < texture.tileWidth; ++i3) {
                    for (j3 = 0; j3 < texture.tileHeight; ++j3) {
                        int x1 = (tileX + i3) * res;
                        int y1 = (tileY + j3) * res;
                        GL11.glTexSubImage2D((int)3553, (int)level, (int)(x1 / lod), (int)(y1 / lod), (int)res2, (int)res2, (int)6408, (int)5121, (ByteBuffer)Buffer.buffer);
                    }
                }
            }
        }
    }

    public void func_28150_a(int[] imageData, int w2, int h2, int textureId) {
        GL11.glBindTexture((int)3553, (int)textureId);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        if (this.blurTexture) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        }
        if (this.clampTexture) {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        } else {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        }
        byte[] bytes = new byte[w2 * h2 * 4];
        for (int l2 = 0; l2 < imageData.length; ++l2) {
            int i1 = imageData[l2] >> 24 & 0xFF;
            int j1 = imageData[l2] >> 16 & 0xFF;
            int k1 = imageData[l2] >> 8 & 0xFF;
            int l1 = imageData[l2] & 0xFF;
            if (this.gameSettings != null && ((Boolean)this.gameSettings.anaglyph.value).booleanValue()) {
                int i2 = (j1 * 30 + k1 * 59 + l1 * 11) / 100;
                int j2 = (j1 * 30 + k1 * 70) / 100;
                int k2 = (j1 * 30 + l1 * 70) / 100;
                j1 = i2;
                k1 = j2;
                l1 = k2;
            }
            bytes[l2 * 4 + 0] = (byte)j1;
            bytes[l2 * 4 + 1] = (byte)k1;
            bytes[l2 * 4 + 2] = (byte)l1;
            bytes[l2 * 4 + 3] = (byte)i1;
        }
        Buffer.buffer.clear();
        Buffer.buffer.put(bytes);
        Buffer.buffer.position(0).limit(bytes.length);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)w2, (int)h2, (int)6408, (int)5121, (ByteBuffer)Buffer.buffer);
    }

    public void deleteTexture(int i2) {
        this.textureNameToImageMap.remove(i2);
        GL11.glDeleteTextures((int)i2);
    }

    public static int atlasWidth() {
        return net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES;
    }

    public void updateDynamicTextures() {
        for (DynamicTexture dynamicTexture : this.dynamicTextures) {
            this.updateDynamicTexture(dynamicTexture);
        }
    }

    private int weightedAverageColor(int i2, int j2) {
        int k2 = (i2 & 0xFF000000) >> 24 & 0xFF;
        int l2 = (j2 & 0xFF000000) >> 24 & 0xFF;
        int c2 = 255;
        if (k2 + l2 == 0) {
            k2 = 1;
            l2 = 1;
            c2 = 0;
        }
        int i1 = (i2 >> 16 & 0xFF) * k2;
        int j1 = (i2 >> 8 & 0xFF) * k2;
        int k1 = (i2 & 0xFF) * k2;
        int l1 = (j2 >> 16 & 0xFF) * l2;
        int i22 = (j2 >> 8 & 0xFF) * l2;
        int j22 = (j2 & 0xFF) * l2;
        int k22 = (i1 + l1) / (k2 + l2);
        int l22 = (j1 + i22) / (k2 + l2);
        int i3 = (k1 + j22) / (k2 + l2);
        return c2 << 24 | k22 << 16 | l22 << 8 | i3;
    }

    public BufferedImage getImage(String name) {
        TexturePackBase pack = this.texturePacks.selectedTexturePack;
        try {
            BufferedImage img;
            if (name.startsWith("##")) {
                img = Textures.unwrapImageByColumns(Textures.readImage(pack.getResourceAsStream(name.substring(2))));
            } else if (name.startsWith("%clamp%")) {
                this.clampTexture = true;
                img = Textures.readImage(pack.getResourceAsStream(name.substring(7)));
            } else if (name.startsWith("%blur%")) {
                this.blurTexture = true;
                img = Textures.readImage(pack.getResourceAsStream(name.substring(6)));
            } else {
                img = Textures.readImage(pack.getResourceAsStream(name));
            }
            return img;
        }
        catch (Exception e2) {
            return Textures.missingTexture;
        }
    }

    public void setupTexture(String name, int id2) {
        try {
            BufferedImage img = this.getImage(name);
            int j2 = this.textureMap.get(name);
            this.setupTexture(img, j2, this.enableMipmapForTexture(name));
            this.blurTexture = false;
            this.clampTexture = false;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void refreshTextures() {
        TexturePackBase texturePack = this.texturePacks.selectedTexturePack;
        this.textureNameToImageMap.forEach((i2, img) -> this.setupTexture((BufferedImage)img, (int)i2));
        this.textureMap.forEach((name, id2) -> this.setupTexture((String)name, (int)id2));
        for (String s2 : this.intArrayTextureData.keySet()) {
            try {
                BufferedImage img2;
                if (s2.startsWith("##")) {
                    img2 = Textures.unwrapImageByColumns(Textures.readImage(texturePack.getResourceAsStream(s2.substring(2))));
                } else if (s2.startsWith("%clamp%")) {
                    this.clampTexture = true;
                    img2 = Textures.readImage(texturePack.getResourceAsStream(s2.substring(7)));
                } else if (s2.startsWith("%blur%")) {
                    this.blurTexture = true;
                    img2 = Textures.readImage(texturePack.getResourceAsStream(s2.substring(6)));
                } else {
                    img2 = Textures.readImage(texturePack.getResourceAsStream(s2));
                }
                Textures.getImageData(img2, this.intArrayTextureData.get(s2));
                this.blurTexture = false;
                this.clampTexture = false;
            }
            catch (Exception ioexception1) {
                ioexception1.printStackTrace();
            }
        }
        this.initDynamicTextures();
        Colors.loadColors(texturePack);
        this.texturePacks.mc.fontRenderer = new FontRenderer(this.texturePacks.mc.gameSettings, "/font/default.png", this);
        Properties colors = new Properties();
        try {
            colors.load(texturePack.getResourceAsStream("/misc/colors.properties"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ColorProperties.loadColors(colors);
    }

    public void bindTexture(int i2) {
        if (i2 < 0) {
            return;
        }
        GL11.glBindTexture((int)3553, (int)i2);
    }

    public Map<String, Integer> getTextureMap() {
        return this.textureMap;
    }

    public boolean loadDownloadableTexture(String url, String localTexture, ImageParser imageParser) {
        if (url == null) {
            if (localTexture != null) {
                this.bindTexture(this.getTexture(localTexture));
                return true;
            }
            return false;
        }
        DownloadedTexture texture = this.downloadedTextures.get(url);
        if (texture == null) {
            texture = new DownloadedTexture(url, imageParser);
            this.downloadedTextures.put(url, texture);
        }
        if (texture.textureId < 0 && texture.image != null) {
            texture.textureId = this.allocateAndSetupTexture(texture.image);
        }
        if (texture.textureId > 0) {
            this.bindTexture(texture.textureId);
            return true;
        }
        if (localTexture != null) {
            this.bindTexture(this.getTexture(localTexture));
            return true;
        }
        return false;
    }
}

