/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockLeavesBase;
import net.minecraft.src.Dimension;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityArrowGoldenFX;
import net.minecraft.src.EntityBubbleFX;
import net.minecraft.src.EntityDiggingFX;
import net.minecraft.src.EntityExplodeFX;
import net.minecraft.src.EntityFlameFX;
import net.minecraft.src.EntityFootStepFX;
import net.minecraft.src.EntityHeartFX;
import net.minecraft.src.EntityLavaFX;
import net.minecraft.src.EntityLeafFX;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityNoteFX;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityPortalFX;
import net.minecraft.src.EntityReddustFX;
import net.minecraft.src.EntityRenderer;
import net.minecraft.src.EntitySlimeChunkFX;
import net.minecraft.src.EntitySlimeFX;
import net.minecraft.src.EntitySmokeFX;
import net.minecraft.src.EntitySnowShovelFX;
import net.minecraft.src.EntitySorter;
import net.minecraft.src.EntitySplashFX;
import net.minecraft.src.EnumMovingObjectType;
import net.minecraft.src.GLAllocation;
import net.minecraft.src.ICamera;
import net.minecraft.src.IWorldAccess;
import net.minecraft.src.Item;
import net.minecraft.src.ItemRecord;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.RenderEngine;
import net.minecraft.src.RenderHelper;
import net.minecraft.src.RenderList;
import net.minecraft.src.RenderManager;
import net.minecraft.src.RenderSorter;
import net.minecraft.src.Tessellator;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityRenderer;
import net.minecraft.src.Vec3D;
import net.minecraft.src.Weather;
import net.minecraft.src.World;
import net.minecraft.src.WorldRenderer;
import org.lwjgl.opengl.ARBOcclusionQuery;
import org.lwjgl.opengl.GL11;

public class RenderGlobal
implements IWorldAccess {
    public List tileEntities;
    private World worldObj;
    private RenderEngine renderEngine;
    private List worldRenderersToUpdate;
    private WorldRenderer[] sortedWorldRenderers;
    private WorldRenderer[] worldRenderers;
    private int renderChunksWide;
    private int renderChunksTall;
    private int renderChunksDeep;
    private int glRenderListBase;
    private Minecraft mc;
    private RenderBlocks globalRenderBlocks;
    private IntBuffer glOcclusionQueryBase;
    private boolean occlusionEnabled = false;
    private int cloudOffsetX = 0;
    private int starGLCallList;
    private int glSkyList;
    private int glSkyList2;
    private int minBlockX;
    private int minBlockY;
    private int minBlockZ;
    private int maxBlockX;
    private int maxBlockY;
    private int maxBlockZ;
    private int renderDistance = -1;
    private int renderEntitiesStartupCounter = 2;
    private int countEntitiesTotal;
    private int countEntitiesRendered;
    private int countEntitiesHidden;
    int[] dummyBuf50k;
    IntBuffer occlusionResult;
    private int renderersLoaded;
    private int renderersBeingClipped;
    private int renderersBeingOccluded;
    private int renderersBeingRendered;
    private int renderersSkippingRenderPass;
    private int worldRenderersCheckIndex;
    private List glRenderLists;
    private RenderList[] allRenderLists = new RenderList[]{new RenderList(), new RenderList(), new RenderList(), new RenderList()};
    int dummyInt0 = 0;
    int glDummyList;
    double prevSortX = -9999.0;
    double prevSortY = -9999.0;
    double prevSortZ = -9999.0;
    public float damagePartialTime;
    int frustrumCheckOffset = 0;

    public RenderGlobal(Minecraft minecraft, RenderEngine renderengine) {
        this.tileEntities = new ArrayList();
        this.worldRenderersToUpdate = new ArrayList();
        this.dummyBuf50k = new int[50000];
        this.occlusionResult = GLAllocation.createDirectIntBuffer(64);
        this.glRenderLists = new ArrayList();
        this.glDummyList = GLAllocation.generateDisplayLists(1);
        this.mc = minecraft;
        this.renderEngine = renderengine;
        int byte0 = 64;
        this.glRenderListBase = GLAllocation.generateDisplayLists(byte0 * byte0 * byte0 * 3);
        this.occlusionEnabled = minecraft.getOpenGlCapsChecker().checkARBOcclusion();
        if (this.occlusionEnabled) {
            this.occlusionResult.clear();
            this.glOcclusionQueryBase = GLAllocation.createDirectIntBuffer(byte0 * byte0 * byte0);
            this.glOcclusionQueryBase.clear();
            this.glOcclusionQueryBase.position(0);
            this.glOcclusionQueryBase.limit(byte0 * byte0 * byte0);
            ARBOcclusionQuery.glGenQueriesARB((IntBuffer)this.glOcclusionQueryBase);
        }
        this.starGLCallList = GLAllocation.generateDisplayLists(3);
        GL11.glPushMatrix();
        GL11.glNewList((int)this.starGLCallList, (int)4864);
        this.renderStars();
        GL11.glEndList();
        GL11.glPopMatrix();
        Tessellator tessellator = Tessellator.instance;
        this.glSkyList = this.starGLCallList + 1;
        GL11.glNewList((int)this.glSkyList, (int)4864);
        int byte1 = 64;
        int i2 = 256 / byte1 + 2;
        float f2 = 16.0f;
        for (int j2 = -byte1 * i2; j2 <= byte1 * i2; j2 += byte1) {
            for (int l2 = -byte1 * i2; l2 <= byte1 * i2; l2 += byte1) {
                tessellator.startDrawingQuads();
                tessellator.addVertex(j2 + 0, f2, l2 + 0);
                tessellator.addVertex(j2 + byte1, f2, l2 + 0);
                tessellator.addVertex(j2 + byte1, f2, l2 + byte1);
                tessellator.addVertex(j2 + 0, f2, l2 + byte1);
                tessellator.draw();
            }
        }
        GL11.glEndList();
        this.glSkyList2 = this.starGLCallList + 2;
        GL11.glNewList((int)this.glSkyList2, (int)4864);
        f2 = -16.0f;
        tessellator.startDrawingQuads();
        for (int k2 = -byte1 * i2; k2 <= byte1 * i2; k2 += byte1) {
            for (int i1 = -byte1 * i2; i1 <= byte1 * i2; i1 += byte1) {
                tessellator.addVertex(k2 + byte1, f2, i1 + 0);
                tessellator.addVertex(k2 + 0, f2, i1 + 0);
                tessellator.addVertex(k2 + 0, f2, i1 + byte1);
                tessellator.addVertex(k2 + byte1, f2, i1 + byte1);
            }
        }
        tessellator.draw();
        GL11.glEndList();
    }

    private void renderStars() {
        Random random = new Random(10842L);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        for (int i2 = 0; i2 < 1500; ++i2) {
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d22 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.25f + random.nextFloat() * 0.25f;
            double d4 = d2 * d2 + d1 * d1 + d22 * d22;
            if (d4 >= 1.0 || d4 <= 0.01) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d2 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d22 *= d4) * 100.0;
            double d8 = Math.atan2(d2, d22);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d2 * d2 + d22 * d22), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j2 = 0; j2 < 4; ++j2) {
                double d222;
                double d17 = 0.0;
                double d18 = (double)((j2 & 2) - 1) * d3;
                double d19 = (double)((j2 + 1 & 2) - 1) * d3;
                double d20 = d17;
                double d21 = d18 * d16 - d19 * d15;
                double d23 = d222 = d19 * d16 + d18 * d15;
                double d24 = d21 * d12 + d20 * d13;
                double d25 = d20 * d12 - d21 * d13;
                double d26 = d25 * d9 - d23 * d10;
                double d27 = d24;
                double d28 = d23 * d9 + d25 * d10;
                tessellator.addVertex(d5 + d26, d6 + d27, d7 + d28);
            }
        }
        tessellator.draw();
    }

    public void changeWorld(World world) {
        if (this.worldObj != null) {
            this.worldObj.removeWorldAccess(this);
        }
        this.prevSortX = -9999.0;
        this.prevSortY = -9999.0;
        this.prevSortZ = -9999.0;
        RenderManager.instance.func_852_a(world);
        this.worldObj = world;
        this.globalRenderBlocks = new RenderBlocks(world, world);
        if (world != null) {
            world.addWorldAccess(this);
            this.loadRenderers();
        }
    }

    public void loadRenderers() {
        EntityLiving entityliving;
        int j2;
        BlockLeavesBase.setGraphicsLevel((Boolean)this.mc.gameSettings.fancyGraphics.value);
        this.renderDistance = (Integer)this.mc.gameSettings.renderDistance.value;
        if (this.worldRenderers != null) {
            for (int i2 = 0; i2 < this.worldRenderers.length; ++i2) {
                this.worldRenderers[i2].func_1204_c();
            }
        }
        if ((j2 = 64 << 4 - this.renderDistance) > 400) {
            j2 = 400;
        }
        this.renderChunksWide = j2 / 16 + 1;
        this.renderChunksTall = net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS / 16;
        this.renderChunksDeep = j2 / 16 + 1;
        this.worldRenderers = new WorldRenderer[this.renderChunksWide * this.renderChunksTall * this.renderChunksDeep];
        this.sortedWorldRenderers = new WorldRenderer[this.renderChunksWide * this.renderChunksTall * this.renderChunksDeep];
        int k2 = 0;
        int l2 = 0;
        this.minBlockX = 0;
        this.minBlockY = 0;
        this.minBlockZ = 0;
        this.maxBlockX = this.renderChunksWide;
        this.maxBlockY = this.renderChunksTall;
        this.maxBlockZ = this.renderChunksDeep;
        for (int i1 = 0; i1 < this.worldRenderersToUpdate.size(); ++i1) {
            ((WorldRenderer)this.worldRenderersToUpdate.get((int)i1)).needsUpdate = false;
        }
        this.worldRenderersToUpdate.clear();
        this.tileEntities.clear();
        for (int j1 = 0; j1 < this.renderChunksWide; ++j1) {
            for (int k1 = 0; k1 < this.renderChunksTall; ++k1) {
                for (int l1 = 0; l1 < this.renderChunksDeep; ++l1) {
                    this.worldRenderers[(l1 * this.renderChunksTall + k1) * this.renderChunksWide + j1] = new WorldRenderer(this.renderEngine, this.worldObj, this.tileEntities, j1 * 16, k1 * 16, l1 * 16, 16, this.glRenderListBase + k2);
                    if (this.occlusionEnabled) {
                        this.worldRenderers[(l1 * this.renderChunksTall + k1) * this.renderChunksWide + j1].glOcclusionQuery = this.glOcclusionQueryBase.get(l2);
                    }
                    this.worldRenderers[(l1 * this.renderChunksTall + k1) * this.renderChunksWide + j1].isWaitingOnOcclusionQuery = false;
                    this.worldRenderers[(l1 * this.renderChunksTall + k1) * this.renderChunksWide + j1].isVisible = true;
                    this.worldRenderers[(l1 * this.renderChunksTall + k1) * this.renderChunksWide + j1].isInFrustum = true;
                    this.worldRenderers[(l1 * this.renderChunksTall + k1) * this.renderChunksWide + j1].chunkIndex = l2++;
                    this.worldRenderers[(l1 * this.renderChunksTall + k1) * this.renderChunksWide + j1].markDirty();
                    this.sortedWorldRenderers[(l1 * this.renderChunksTall + k1) * this.renderChunksWide + j1] = this.worldRenderers[(l1 * this.renderChunksTall + k1) * this.renderChunksWide + j1];
                    this.worldRenderersToUpdate.add(this.worldRenderers[(l1 * this.renderChunksTall + k1) * this.renderChunksWide + j1]);
                    k2 += 3;
                }
            }
        }
        if (this.worldObj != null && (entityliving = this.mc.renderViewEntity) != null) {
            this.markRenderersForNewPosition(MathHelper.floor_double(entityliving.posX), MathHelper.floor_double(entityliving.posY), MathHelper.floor_double(entityliving.posZ));
            Arrays.sort(this.sortedWorldRenderers, new EntitySorter(entityliving));
        }
        this.renderEntitiesStartupCounter = 2;
    }

    public void renderEntities(Vec3D vec3d, ICamera icamera, float f2) {
        if (this.renderEntitiesStartupCounter > 0) {
            --this.renderEntitiesStartupCounter;
            return;
        }
        TileEntityRenderer.instance.cacheActiveRenderInfo(this.worldObj, this.renderEngine, this.mc.fontRenderer, this.mc.renderViewEntity, f2);
        RenderManager.instance.cacheActiveRenderInfo(this.worldObj, this.renderEngine, this.mc.fontRenderer, this.mc.renderViewEntity, this.mc.gameSettings, f2);
        this.countEntitiesTotal = 0;
        this.countEntitiesRendered = 0;
        this.countEntitiesHidden = 0;
        EntityLiving entityliving = this.mc.renderViewEntity;
        RenderManager.renderPosX = entityliving.lastTickPosX + (entityliving.posX - entityliving.lastTickPosX) * (double)f2;
        RenderManager.renderPosY = entityliving.lastTickPosY + (entityliving.posY - entityliving.lastTickPosY) * (double)f2;
        RenderManager.renderPosZ = entityliving.lastTickPosZ + (entityliving.posZ - entityliving.lastTickPosZ) * (double)f2;
        TileEntityRenderer.staticPlayerX = entityliving.lastTickPosX + (entityliving.posX - entityliving.lastTickPosX) * (double)f2;
        TileEntityRenderer.staticPlayerY = entityliving.lastTickPosY + (entityliving.posY - entityliving.lastTickPosY) * (double)f2;
        TileEntityRenderer.staticPlayerZ = entityliving.lastTickPosZ + (entityliving.posZ - entityliving.lastTickPosZ) * (double)f2;
        List<Entity> list = this.worldObj.getLoadedEntityList();
        this.countEntitiesTotal = list.size();
        for (int i2 = 0; i2 < this.worldObj.weatherEffects.size(); ++i2) {
            Entity entity = this.worldObj.weatherEffects.get(i2);
            ++this.countEntitiesRendered;
            if (!entity.isInRangeToRenderVec3D(vec3d)) continue;
            RenderManager.instance.renderEntity(entity, f2);
        }
        for (int j2 = 0; j2 < list.size(); ++j2) {
            Entity entity1 = list.get(j2);
            if (!entity1.isInRangeToRenderVec3D(vec3d) || !entity1.ignoreFrustumCheck && !icamera.isBoundingBoxInFrustum(entity1.boundingBox) || entity1 == this.mc.renderViewEntity && (Integer)this.mc.gameSettings.thirdPersonView.value == 0 && !this.mc.isometricMode && !this.mc.renderViewEntity.isPlayerSleeping()) continue;
            int l2 = MathHelper.floor_double(entity1.posY);
            if (l2 < 0) {
                l2 = 0;
            }
            if (l2 >= net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS) {
                l2 = net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS - 1;
            }
            if (!this.worldObj.blockExists(MathHelper.floor_double(entity1.posX), l2, MathHelper.floor_double(entity1.posZ))) continue;
            ++this.countEntitiesRendered;
            RenderManager.instance.renderEntity(entity1, f2);
        }
        for (int k2 = 0; k2 < this.tileEntities.size(); ++k2) {
            TileEntityRenderer.instance.renderTileEntity((TileEntity)this.tileEntities.get(k2), f2);
        }
    }

    public String getDebugInfoRenders() {
        return "C: " + this.renderersBeingRendered + "/" + this.renderersLoaded + ". F: " + this.renderersBeingClipped + ", O: " + this.renderersBeingOccluded + ", E: " + this.renderersSkippingRenderPass;
    }

    public String getDebugInfoEntities() {
        return "E: " + this.countEntitiesRendered + "/" + this.countEntitiesTotal + ". B: " + this.countEntitiesHidden + ", I: " + (this.countEntitiesTotal - this.countEntitiesHidden - this.countEntitiesRendered);
    }

    private void markRenderersForNewPosition(int i2, int j2, int k2) {
        i2 -= 8;
        j2 -= 8;
        k2 -= 8;
        this.minBlockX = Integer.MAX_VALUE;
        this.minBlockY = Integer.MAX_VALUE;
        this.minBlockZ = Integer.MAX_VALUE;
        this.maxBlockX = Integer.MIN_VALUE;
        this.maxBlockY = Integer.MIN_VALUE;
        this.maxBlockZ = Integer.MIN_VALUE;
        int l2 = this.renderChunksWide * 16;
        int i1 = l2 / 2;
        for (int j1 = 0; j1 < this.renderChunksWide; ++j1) {
            int k1 = j1 * 16;
            int l1 = k1 + i1 - i2;
            if (l1 < 0) {
                l1 -= l2 - 1;
            }
            if ((k1 -= (l1 /= l2) * l2) < this.minBlockX) {
                this.minBlockX = k1;
            }
            if (k1 > this.maxBlockX) {
                this.maxBlockX = k1;
            }
            for (int i22 = 0; i22 < this.renderChunksDeep; ++i22) {
                int j22 = i22 * 16;
                int k22 = j22 + i1 - k2;
                if (k22 < 0) {
                    k22 -= l2 - 1;
                }
                if ((j22 -= (k22 /= l2) * l2) < this.minBlockZ) {
                    this.minBlockZ = j22;
                }
                if (j22 > this.maxBlockZ) {
                    this.maxBlockZ = j22;
                }
                for (int l22 = 0; l22 < this.renderChunksTall; ++l22) {
                    int i3 = l22 * 16;
                    if (i3 < this.minBlockY) {
                        this.minBlockY = i3;
                    }
                    if (i3 > this.maxBlockY) {
                        this.maxBlockY = i3;
                    }
                    WorldRenderer worldrenderer = this.worldRenderers[(i22 * this.renderChunksTall + l22) * this.renderChunksWide + j1];
                    boolean flag = worldrenderer.needsUpdate;
                    worldrenderer.setPosition(k1, i3, j22);
                    if (flag || !worldrenderer.needsUpdate) continue;
                    this.worldRenderersToUpdate.add(worldrenderer);
                }
            }
        }
    }

    public int sortAndRender(EntityLiving entityliving, int i2, double d2) {
        for (int j2 = 0; j2 < 10; ++j2) {
            this.worldRenderersCheckIndex = (this.worldRenderersCheckIndex + 1) % this.worldRenderers.length;
            WorldRenderer worldrenderer = this.worldRenderers[this.worldRenderersCheckIndex];
            if (!worldrenderer.needsUpdate || this.worldRenderersToUpdate.contains(worldrenderer)) continue;
            this.worldRenderersToUpdate.add(worldrenderer);
        }
        if ((Integer)this.mc.gameSettings.renderDistance.value != this.renderDistance) {
            this.loadRenderers();
        }
        if (i2 == 0) {
            this.renderersLoaded = 0;
            this.renderersBeingClipped = 0;
            this.renderersBeingOccluded = 0;
            this.renderersBeingRendered = 0;
            this.renderersSkippingRenderPass = 0;
        }
        double d1 = entityliving.lastTickPosX + (entityliving.posX - entityliving.lastTickPosX) * d2;
        double d22 = entityliving.lastTickPosY + (entityliving.posY - entityliving.lastTickPosY) * d2;
        double d3 = entityliving.lastTickPosZ + (entityliving.posZ - entityliving.lastTickPosZ) * d2;
        double d4 = entityliving.posX - this.prevSortX;
        double d5 = entityliving.posY - this.prevSortY;
        double d6 = entityliving.posZ - this.prevSortZ;
        if (d4 * d4 + d5 * d5 + d6 * d6 > 16.0) {
            this.prevSortX = entityliving.posX;
            this.prevSortY = entityliving.posY;
            this.prevSortZ = entityliving.posZ;
            this.markRenderersForNewPosition(MathHelper.floor_double(entityliving.posX), MathHelper.floor_double(entityliving.posY), MathHelper.floor_double(entityliving.posZ));
            Arrays.sort(this.sortedWorldRenderers, new EntitySorter(entityliving));
        }
        RenderHelper.disableStandardItemLighting();
        int k2 = 0;
        if (this.occlusionEnabled && ((Boolean)this.mc.gameSettings.advancedOpenGL.value).booleanValue() && !((Boolean)this.mc.gameSettings.anaglyph.value).booleanValue() && i2 == 0) {
            int l2 = 0;
            int i1 = 16;
            this.checkOcclusionQueryResult(l2, i1);
            for (int j1 = l2; j1 < i1; ++j1) {
                this.sortedWorldRenderers[j1].isVisible = true;
            }
            k2 += this.renderSortedRenderers(l2, i1, i2, d2);
            do {
                int byte0 = i1;
                if ((i1 *= 2) > this.sortedWorldRenderers.length) {
                    i1 = this.sortedWorldRenderers.length;
                }
                GL11.glDisable((int)3553);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)3008);
                GL11.glDisable((int)2912);
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                GL11.glDepthMask((boolean)false);
                this.checkOcclusionQueryResult(byte0, i1);
                GL11.glPushMatrix();
                float f2 = 0.0f;
                float f1 = 0.0f;
                float f22 = 0.0f;
                for (int k1 = byte0; k1 < i1; ++k1) {
                    float f3;
                    int l1;
                    if (this.sortedWorldRenderers[k1].skipAllRenderPasses()) {
                        this.sortedWorldRenderers[k1].isInFrustum = false;
                        continue;
                    }
                    if (!this.sortedWorldRenderers[k1].isInFrustum) {
                        this.sortedWorldRenderers[k1].isVisible = true;
                    }
                    if (!this.sortedWorldRenderers[k1].isInFrustum || this.sortedWorldRenderers[k1].isWaitingOnOcclusionQuery || this.cloudOffsetX % (l1 = (int)(1.0f + (f3 = MathHelper.sqrt_float(this.sortedWorldRenderers[k1].distanceToEntitySquared(entityliving))) / 128.0f)) != k1 % l1) continue;
                    WorldRenderer worldrenderer1 = this.sortedWorldRenderers[k1];
                    float f4 = (float)((double)worldrenderer1.posXMinus - d1);
                    float f5 = (float)((double)worldrenderer1.posYMinus - d22);
                    float f6 = (float)((double)worldrenderer1.posZMinus - d3);
                    float f7 = f4 - f2;
                    float f8 = f5 - f1;
                    float f9 = f6 - f22;
                    if (f7 != 0.0f || f8 != 0.0f || f9 != 0.0f) {
                        GL11.glTranslatef((float)f7, (float)f8, (float)f9);
                        f2 += f7;
                        f1 += f8;
                        f22 += f9;
                    }
                    ARBOcclusionQuery.glBeginQueryARB((int)35092, (int)this.sortedWorldRenderers[k1].glOcclusionQuery);
                    this.sortedWorldRenderers[k1].callOcclusionQueryList();
                    ARBOcclusionQuery.glEndQueryARB((int)35092);
                    this.sortedWorldRenderers[k1].isWaitingOnOcclusionQuery = true;
                }
                GL11.glPopMatrix();
                if (((Boolean)this.mc.gameSettings.anaglyph.value).booleanValue()) {
                    if (EntityRenderer.anaglyphField == 0) {
                        GL11.glColorMask((boolean)false, (boolean)true, (boolean)true, (boolean)true);
                    } else {
                        GL11.glColorMask((boolean)true, (boolean)false, (boolean)false, (boolean)true);
                    }
                } else {
                    GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                }
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)3553);
                GL11.glEnable((int)3008);
                GL11.glEnable((int)2912);
                k2 += this.renderSortedRenderers(byte0, i1, i2, d2);
            } while (i1 < this.sortedWorldRenderers.length);
        } else {
            k2 += this.renderSortedRenderers(0, this.sortedWorldRenderers.length, i2, d2);
        }
        return k2;
    }

    private void checkOcclusionQueryResult(int i2, int j2) {
        for (int k2 = i2; k2 < j2; ++k2) {
            if (!this.sortedWorldRenderers[k2].isWaitingOnOcclusionQuery) continue;
            this.occlusionResult.clear();
            ARBOcclusionQuery.glGetQueryObjectuARB((int)this.sortedWorldRenderers[k2].glOcclusionQuery, (int)34919, (IntBuffer)this.occlusionResult);
            if (this.occlusionResult.get(0) == 0) continue;
            this.sortedWorldRenderers[k2].isWaitingOnOcclusionQuery = false;
            this.occlusionResult.clear();
            ARBOcclusionQuery.glGetQueryObjectuARB((int)this.sortedWorldRenderers[k2].glOcclusionQuery, (int)34918, (IntBuffer)this.occlusionResult);
            this.sortedWorldRenderers[k2].isVisible = this.occlusionResult.get(0) != 0;
        }
    }

    private int renderSortedRenderers(int i2, int j2, int k2, double d2) {
        this.glRenderLists.clear();
        int l2 = 0;
        for (int i1 = i2; i1 < j2; ++i1) {
            int j1;
            if (k2 == 0) {
                ++this.renderersLoaded;
                if (this.sortedWorldRenderers[i1].skipRenderPass[k2]) {
                    ++this.renderersSkippingRenderPass;
                } else if (!this.sortedWorldRenderers[i1].isInFrustum) {
                    ++this.renderersBeingClipped;
                } else if (this.occlusionEnabled && !this.sortedWorldRenderers[i1].isVisible) {
                    ++this.renderersBeingOccluded;
                } else {
                    ++this.renderersBeingRendered;
                }
            }
            if (this.sortedWorldRenderers[i1].skipRenderPass[k2] || !this.sortedWorldRenderers[i1].isInFrustum || this.occlusionEnabled && !this.sortedWorldRenderers[i1].isVisible || (j1 = this.sortedWorldRenderers[i1].getGLCallListForPass(k2)) < 0) continue;
            this.glRenderLists.add(this.sortedWorldRenderers[i1]);
            ++l2;
        }
        EntityLiving entityliving = this.mc.renderViewEntity;
        double d1 = entityliving.lastTickPosX + (entityliving.posX - entityliving.lastTickPosX) * d2;
        double d22 = entityliving.lastTickPosY + (entityliving.posY - entityliving.lastTickPosY) * d2;
        double d3 = entityliving.lastTickPosZ + (entityliving.posZ - entityliving.lastTickPosZ) * d2;
        int k1 = 0;
        for (int l1 = 0; l1 < this.allRenderLists.length; ++l1) {
            this.allRenderLists[l1].func_859_b();
        }
        for (int i22 = 0; i22 < this.glRenderLists.size(); ++i22) {
            WorldRenderer worldrenderer = (WorldRenderer)this.glRenderLists.get(i22);
            int j22 = -1;
            for (int k22 = 0; k22 < k1; ++k22) {
                if (!this.allRenderLists[k22].func_862_a(worldrenderer.posXMinus, worldrenderer.posYMinus, worldrenderer.posZMinus)) continue;
                j22 = k22;
            }
            if (j22 < 0) {
                j22 = k1++;
                this.allRenderLists[j22].func_861_a(worldrenderer.posXMinus, worldrenderer.posYMinus, worldrenderer.posZMinus, d1, d22, d3);
            }
            this.allRenderLists[j22].func_858_a(worldrenderer.getGLCallListForPass(k2));
        }
        this.renderAllRenderLists(k2, d2);
        return l2;
    }

    public void renderAllRenderLists(int i2, double d2) {
        for (int j2 = 0; j2 < this.allRenderLists.length; ++j2) {
            this.allRenderLists[j2].func_860_a();
        }
    }

    public void updateClouds() {
        ++this.cloudOffsetX;
    }

    public void renderSky(float partialTicks) {
        if (this.mc.theWorld.dimension == Dimension.nether) {
            return;
        }
        float celestialAngle = this.worldObj.getCelestialAngle(partialTicks);
        GL11.glDisable((int)3553);
        Vec3D vec3d = this.worldObj.getSkyColor(this.mc.renderViewEntity, partialTicks);
        float f1 = (float)vec3d.xCoord;
        float f2 = (float)vec3d.yCoord;
        float f3 = (float)vec3d.zCoord;
        if (((Boolean)this.mc.gameSettings.anaglyph.value).booleanValue()) {
            float f4 = (f1 * 30.0f + f2 * 59.0f + f3 * 11.0f) / 100.0f;
            float f5 = (f1 * 30.0f + f2 * 70.0f) / 100.0f;
            float f7 = (f1 * 30.0f + f3 * 70.0f) / 100.0f;
            f1 = f4;
            f2 = f5;
            f3 = f7;
        }
        GL11.glColor3f((float)f1, (float)f2, (float)f3);
        Tessellator tessellator = Tessellator.instance;
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)2912);
        GL11.glColor3f((float)f1, (float)f2, (float)f3);
        GL11.glCallList((int)this.glSkyList);
        GL11.glDisable((int)2912);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderHelper.disableStandardItemLighting();
        float[] af2 = this.worldObj.dimension.worldType.worldProvider.calcSunriseSunsetColors(celestialAngle, partialTicks);
        if (af2 != null) {
            GL11.glDisable((int)3553);
            GL11.glShadeModel((int)7425);
            GL11.glPushMatrix();
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(celestialAngle <= 0.5f ? 0.0f : 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            float f10 = af2[0];
            float f12 = af2[1];
            float f14 = af2[2];
            if (((Boolean)this.mc.gameSettings.anaglyph.value).booleanValue()) {
                float f16 = (f10 * 30.0f + f12 * 59.0f + f14 * 11.0f) / 100.0f;
                float f18 = (f10 * 30.0f + f12 * 70.0f) / 100.0f;
                float f19 = (f10 * 30.0f + f14 * 70.0f) / 100.0f;
                f10 = f16;
                f12 = f18;
                f14 = f19;
            }
            tessellator.startDrawing(6);
            tessellator.setColorRGBA_F(f10, f12, f14, af2[3]);
            tessellator.addVertex(0.0, 100.0, 0.0);
            int i2 = 16;
            tessellator.setColorRGBA_F(af2[0], af2[1], af2[2], 0.0f);
            for (int j2 = 0; j2 <= i2; ++j2) {
                float f20 = (float)j2 * 3.141593f * 2.0f / (float)i2;
                float f21 = MathHelper.sin(f20);
                float f22 = MathHelper.cos(f20);
                tessellator.addVertex(f21 * 120.0f, f22 * 120.0f, -f22 * 40.0f * af2[3]);
            }
            tessellator.draw();
            GL11.glPopMatrix();
            GL11.glShadeModel((int)7424);
        }
        GL11.glEnable((int)3553);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glPushMatrix();
        float f6 = 1.0f - (this.worldObj.currentWeather != null && this.worldObj.currentWeather != Weather.weatherClear ? this.worldObj.weatherIntensity * this.worldObj.weatherPower * 1.5f : 0.0f);
        float f9 = 0.0f;
        float f11 = 0.0f;
        float f13 = 0.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f6);
        GL11.glTranslatef((float)f9, (float)f11, (float)f13);
        GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(celestialAngle * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        float f15 = 30.0f;
        GL11.glBindTexture((int)3553, (int)this.renderEngine.getTexture("/terrain/sun.png"));
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(-f15, 100.0, -f15, 0.0, 0.0);
        tessellator.addVertexWithUV(f15, 100.0, -f15, 1.0, 0.0);
        tessellator.addVertexWithUV(f15, 100.0, f15, 1.0, 1.0);
        tessellator.addVertexWithUV(-f15, 100.0, f15, 0.0, 1.0);
        tessellator.draw();
        f15 = 20.0f;
        GL11.glBindTexture((int)3553, (int)this.renderEngine.getTexture("/terrain/moon.png"));
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(-f15, -100.0, f15, 1.0, 1.0);
        tessellator.addVertexWithUV(f15, -100.0, f15, 0.0, 1.0);
        tessellator.addVertexWithUV(f15, -100.0, -f15, 0.0, 0.0);
        tessellator.addVertexWithUV(-f15, -100.0, -f15, 1.0, 0.0);
        tessellator.draw();
        GL11.glDisable((int)3553);
        float f17 = this.worldObj.getStarBrightness(partialTicks) * f6;
        if (f17 > 0.0f) {
            GL11.glColor4f((float)f17, (float)f17, (float)f17, (float)f17);
            GL11.glCallList((int)this.starGLCallList);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2912);
        GL11.glPopMatrix();
        if (this.worldObj.dimension.worldType.worldProvider.func_28112_c()) {
            GL11.glColor3f((float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.2f + 0.04f), (float)(f3 * 0.6f + 0.1f));
        } else {
            GL11.glColor3f((float)f1, (float)f2, (float)f3);
        }
        GL11.glDisable((int)3553);
        GL11.glCallList((int)this.glSkyList2);
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
    }

    public void renderClouds(float f2) {
        if (this.mc.theWorld.dimension == Dimension.nether) {
            return;
        }
        if (this.mc.isometricMode) {
            return;
        }
        if (((Boolean)this.mc.gameSettings.fancyGraphics.value).booleanValue()) {
            this.renderCloudsFancy(f2);
            return;
        }
        GL11.glDisable((int)2884);
        float f1 = (float)(this.mc.renderViewEntity.lastTickPosY + (this.mc.renderViewEntity.posY - this.mc.renderViewEntity.lastTickPosY) * (double)f2);
        int byte0 = 32;
        int i2 = 256 / byte0;
        Tessellator tessellator = Tessellator.instance;
        GL11.glBindTexture((int)3553, (int)this.renderEngine.getTexture("/environment/clouds.png"));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Vec3D vec3d = this.worldObj.getDimensionColor(f2);
        float f22 = (float)vec3d.xCoord;
        float f3 = (float)vec3d.yCoord;
        float f4 = (float)vec3d.zCoord;
        if (((Boolean)this.mc.gameSettings.anaglyph.value).booleanValue()) {
            float f5 = (f22 * 30.0f + f3 * 59.0f + f4 * 11.0f) / 100.0f;
            float f7 = (f22 * 30.0f + f3 * 70.0f) / 100.0f;
            float f8 = (f22 * 30.0f + f4 * 70.0f) / 100.0f;
            f22 = f5;
            f3 = f7;
            f4 = f8;
        }
        float f6 = 4.882813E-4f;
        double d2 = this.mc.renderViewEntity.prevPosX + (this.mc.renderViewEntity.posX - this.mc.renderViewEntity.prevPosX) * (double)f2 + (double)(((float)this.cloudOffsetX + f2) * 0.03f);
        double d1 = this.mc.renderViewEntity.prevPosZ + (this.mc.renderViewEntity.posZ - this.mc.renderViewEntity.prevPosZ) * (double)f2;
        int j2 = MathHelper.floor_double(d2 / 2048.0);
        int k2 = MathHelper.floor_double(d1 / 2048.0);
        float f9 = this.worldObj.dimension.worldType.worldProvider.getCloudHeight() - f1 + 0.33f;
        float f10 = (float)((d2 -= (double)(j2 * 2048)) * (double)f6);
        float f11 = (float)((d1 -= (double)(k2 * 2048)) * (double)f6);
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_F(f22, f3, f4, 0.8f);
        for (int l2 = -byte0 * i2; l2 < byte0 * i2; l2 += byte0) {
            for (int i1 = -byte0 * i2; i1 < byte0 * i2; i1 += byte0) {
                tessellator.addVertexWithUV(l2 + 0, f9, i1 + byte0, (float)(l2 + 0) * f6 + f10, (float)(i1 + byte0) * f6 + f11);
                tessellator.addVertexWithUV(l2 + byte0, f9, i1 + byte0, (float)(l2 + byte0) * f6 + f10, (float)(i1 + byte0) * f6 + f11);
                tessellator.addVertexWithUV(l2 + byte0, f9, i1 + 0, (float)(l2 + byte0) * f6 + f10, (float)(i1 + 0) * f6 + f11);
                tessellator.addVertexWithUV(l2 + 0, f9, i1 + 0, (float)(l2 + 0) * f6 + f10, (float)(i1 + 0) * f6 + f11);
            }
        }
        tessellator.draw();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
    }

    public boolean func_27307_a(double d2, double d1, double d22, float f2) {
        return false;
    }

    public void renderCloudsFancy(float f2) {
        GL11.glDisable((int)2884);
        float f1 = (float)(this.mc.renderViewEntity.lastTickPosY + (this.mc.renderViewEntity.posY - this.mc.renderViewEntity.lastTickPosY) * (double)f2);
        Tessellator tessellator = Tessellator.instance;
        float cloudWidth = 12.0f;
        float cloudThickness = 4.0f;
        double d2 = (this.mc.renderViewEntity.prevPosX + (this.mc.renderViewEntity.posX - this.mc.renderViewEntity.prevPosX) * (double)f2 + (double)(((float)this.cloudOffsetX + f2) * 0.03f)) / (double)cloudWidth;
        double d1 = (this.mc.renderViewEntity.prevPosZ + (this.mc.renderViewEntity.posZ - this.mc.renderViewEntity.prevPosZ) * (double)f2) / (double)cloudWidth + (double)0.33f;
        float f4 = this.worldObj.dimension.worldType.worldProvider.getCloudHeight() - f1 + 0.33f;
        int i2 = MathHelper.floor_double(d2 / 2048.0);
        int j2 = MathHelper.floor_double(d1 / 2048.0);
        d2 -= (double)(i2 * 2048);
        d1 -= (double)(j2 * 2048);
        GL11.glBindTexture((int)3553, (int)this.renderEngine.getTexture("/environment/clouds.png"));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Vec3D vec3d = this.worldObj.getDimensionColor(f2);
        float f5 = (float)vec3d.xCoord;
        float f6 = (float)vec3d.yCoord;
        float f7 = (float)vec3d.zCoord;
        if (((Boolean)this.mc.gameSettings.anaglyph.value).booleanValue()) {
            float f8 = (f5 * 30.0f + f6 * 59.0f + f7 * 11.0f) / 100.0f;
            float f10 = (f5 * 30.0f + f6 * 70.0f) / 100.0f;
            float f12 = (f5 * 30.0f + f7 * 70.0f) / 100.0f;
            f5 = f8;
            f6 = f10;
            f7 = f12;
        }
        float f9 = (float)(d2 * 0.0);
        float f11 = (float)(d1 * 0.0);
        float f13 = 0.00390625f;
        f9 = (float)MathHelper.floor_double(d2) * f13;
        f11 = (float)MathHelper.floor_double(d1) * f13;
        float f14 = (float)(d2 - (double)MathHelper.floor_double(d2));
        float f15 = (float)(d1 - (double)MathHelper.floor_double(d1));
        int k2 = 8;
        int byte0 = 3;
        float f16 = 9.765625E-4f;
        GL11.glScalef((float)cloudWidth, (float)1.0f, (float)cloudWidth);
        for (int l2 = 0; l2 < 2; ++l2) {
            if (l2 == 0) {
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            } else if (((Boolean)this.mc.gameSettings.anaglyph.value).booleanValue()) {
                if (EntityRenderer.anaglyphField == 0) {
                    GL11.glColorMask((boolean)false, (boolean)true, (boolean)true, (boolean)true);
                } else {
                    GL11.glColorMask((boolean)true, (boolean)false, (boolean)false, (boolean)true);
                }
            } else {
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }
            for (int i1 = -byte0 + 1; i1 <= byte0; ++i1) {
                for (int j1 = -byte0 + 1; j1 <= byte0; ++j1) {
                    tessellator.startDrawingQuads();
                    float f17 = i1 * k2;
                    float f18 = j1 * k2;
                    float f19 = f17 - f14;
                    float f20 = f18 - f15;
                    if (f4 > -cloudThickness - 1.0f) {
                        tessellator.setColorRGBA_F(f5 * 0.7f, f6 * 0.7f, f7 * 0.7f, 0.8f);
                        tessellator.setNormal(0.0f, -1.0f, 0.0f);
                        tessellator.addVertexWithUV(f19 + 0.0f, f4 + 0.0f, f20 + (float)k2, (f17 + 0.0f) * f13 + f9, (f18 + (float)k2) * f13 + f11);
                        tessellator.addVertexWithUV(f19 + (float)k2, f4 + 0.0f, f20 + (float)k2, (f17 + (float)k2) * f13 + f9, (f18 + (float)k2) * f13 + f11);
                        tessellator.addVertexWithUV(f19 + (float)k2, f4 + 0.0f, f20 + 0.0f, (f17 + (float)k2) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                        tessellator.addVertexWithUV(f19 + 0.0f, f4 + 0.0f, f20 + 0.0f, (f17 + 0.0f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                    }
                    if (f4 <= cloudThickness + 1.0f) {
                        tessellator.setColorRGBA_F(f5, f6, f7, 0.8f);
                        tessellator.setNormal(0.0f, 1.0f, 0.0f);
                        tessellator.addVertexWithUV(f19 + 0.0f, f4 + cloudThickness - f16, f20 + (float)k2, (f17 + 0.0f) * f13 + f9, (f18 + (float)k2) * f13 + f11);
                        tessellator.addVertexWithUV(f19 + (float)k2, f4 + cloudThickness - f16, f20 + (float)k2, (f17 + (float)k2) * f13 + f9, (f18 + (float)k2) * f13 + f11);
                        tessellator.addVertexWithUV(f19 + (float)k2, f4 + cloudThickness - f16, f20 + 0.0f, (f17 + (float)k2) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                        tessellator.addVertexWithUV(f19 + 0.0f, f4 + cloudThickness - f16, f20 + 0.0f, (f17 + 0.0f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                    }
                    tessellator.setColorRGBA_F(f5 * 0.9f, f6 * 0.9f, f7 * 0.9f, 0.8f);
                    if (i1 > -1) {
                        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
                        for (int k1 = 0; k1 < k2; ++k1) {
                            tessellator.addVertexWithUV(f19 + (float)k1 + 0.0f, f4 + 0.0f, f20 + (float)k2, (f17 + (float)k1 + 0.5f) * f13 + f9, (f18 + (float)k2) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + (float)k1 + 0.0f, f4 + cloudThickness, f20 + (float)k2, (f17 + (float)k1 + 0.5f) * f13 + f9, (f18 + (float)k2) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + (float)k1 + 0.0f, f4 + cloudThickness, f20 + 0.0f, (f17 + (float)k1 + 0.5f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + (float)k1 + 0.0f, f4 + 0.0f, f20 + 0.0f, (f17 + (float)k1 + 0.5f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                        }
                    }
                    if (i1 <= 1) {
                        tessellator.setNormal(1.0f, 0.0f, 0.0f);
                        for (int l1 = 0; l1 < k2; ++l1) {
                            tessellator.addVertexWithUV(f19 + (float)l1 + 1.0f - f16, f4 + 0.0f, f20 + (float)k2, (f17 + (float)l1 + 0.5f) * f13 + f9, (f18 + (float)k2) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + (float)l1 + 1.0f - f16, f4 + cloudThickness, f20 + (float)k2, (f17 + (float)l1 + 0.5f) * f13 + f9, (f18 + (float)k2) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + (float)l1 + 1.0f - f16, f4 + cloudThickness, f20 + 0.0f, (f17 + (float)l1 + 0.5f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + (float)l1 + 1.0f - f16, f4 + 0.0f, f20 + 0.0f, (f17 + (float)l1 + 0.5f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                        }
                    }
                    tessellator.setColorRGBA_F(f5 * 0.8f, f6 * 0.8f, f7 * 0.8f, 0.8f);
                    if (j1 > -1) {
                        tessellator.setNormal(0.0f, 0.0f, -1.0f);
                        for (int i22 = 0; i22 < k2; ++i22) {
                            tessellator.addVertexWithUV(f19 + 0.0f, f4 + cloudThickness, f20 + (float)i22 + 0.0f, (f17 + 0.0f) * f13 + f9, (f18 + (float)i22 + 0.5f) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + (float)k2, f4 + cloudThickness, f20 + (float)i22 + 0.0f, (f17 + (float)k2) * f13 + f9, (f18 + (float)i22 + 0.5f) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + (float)k2, f4 + 0.0f, f20 + (float)i22 + 0.0f, (f17 + (float)k2) * f13 + f9, (f18 + (float)i22 + 0.5f) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + 0.0f, f4 + 0.0f, f20 + (float)i22 + 0.0f, (f17 + 0.0f) * f13 + f9, (f18 + (float)i22 + 0.5f) * f13 + f11);
                        }
                    }
                    if (j1 <= 1) {
                        tessellator.setNormal(0.0f, 0.0f, 1.0f);
                        for (int j22 = 0; j22 < k2; ++j22) {
                            tessellator.addVertexWithUV(f19 + 0.0f, f4 + cloudThickness, f20 + (float)j22 + 1.0f - f16, (f17 + 0.0f) * f13 + f9, (f18 + (float)j22 + 0.5f) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + (float)k2, f4 + cloudThickness, f20 + (float)j22 + 1.0f - f16, (f17 + (float)k2) * f13 + f9, (f18 + (float)j22 + 0.5f) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + (float)k2, f4 + 0.0f, f20 + (float)j22 + 1.0f - f16, (f17 + (float)k2) * f13 + f9, (f18 + (float)j22 + 0.5f) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + 0.0f, f4 + 0.0f, f20 + (float)j22 + 1.0f - f16, (f17 + 0.0f) * f13 + f9, (f18 + (float)j22 + 0.5f) * f13 + f11);
                        }
                    }
                    tessellator.draw();
                }
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
    }

    public boolean updateRenderers(EntityLiving entityliving, boolean flag) {
        int j2;
        boolean flag1 = false;
        if (flag1) {
            Collections.sort(this.worldRenderersToUpdate, new RenderSorter(entityliving));
            int i2 = this.worldRenderersToUpdate.size() - 1;
            int j3 = this.worldRenderersToUpdate.size();
            for (int k2 = 0; k2 < j3; ++k2) {
                WorldRenderer worldrenderer = (WorldRenderer)this.worldRenderersToUpdate.get(i2 - k2);
                if (!flag) {
                    if (worldrenderer.distanceToEntitySquared(entityliving) > 256.0f && (worldrenderer.isInFrustum ? k2 >= 3 : k2 >= 1)) {
                        return false;
                    }
                } else if (!worldrenderer.isInFrustum) continue;
                worldrenderer.updateRenderer();
                this.worldRenderersToUpdate.remove(worldrenderer);
                worldrenderer.needsUpdate = false;
            }
            return this.worldRenderersToUpdate.size() == 0;
        }
        int byte0 = 2;
        RenderSorter rendersorter = new RenderSorter(entityliving);
        WorldRenderer[] aworldrenderer = new WorldRenderer[byte0];
        ArrayList<WorldRenderer> arraylist = null;
        int l2 = this.worldRenderersToUpdate.size();
        int i1 = 0;
        for (int j1 = 0; j1 < l2; ++j1) {
            WorldRenderer worldrenderer1 = (WorldRenderer)this.worldRenderersToUpdate.get(j1);
            if (!flag) {
                if (worldrenderer1.distanceToEntitySquared(entityliving) > 256.0f) {
                    int k2;
                    for (k2 = 0; k2 < byte0 && (aworldrenderer[k2] == null || rendersorter.doCompare(aworldrenderer[k2], worldrenderer1) <= 0); ++k2) {
                    }
                    if (--k2 <= 0) continue;
                    int i3 = k2;
                    while (--i3 != 0) {
                        aworldrenderer[i3 - 1] = aworldrenderer[i3];
                    }
                    aworldrenderer[k2] = worldrenderer1;
                    continue;
                }
            } else if (!worldrenderer1.isInFrustum) continue;
            if (arraylist == null) {
                arraylist = new ArrayList<WorldRenderer>();
            }
            ++i1;
            arraylist.add(worldrenderer1);
            this.worldRenderersToUpdate.set(j1, null);
        }
        if (arraylist != null) {
            if (arraylist.size() > 1) {
                Collections.sort(arraylist, rendersorter);
            }
            for (int k1 = arraylist.size() - 1; k1 >= 0; --k1) {
                WorldRenderer worldrenderer2 = (WorldRenderer)arraylist.get(k1);
                worldrenderer2.updateRenderer();
                worldrenderer2.needsUpdate = false;
            }
        }
        int l1 = 0;
        for (int i2 = byte0 - 1; i2 >= 0; --i2) {
            WorldRenderer worldrenderer3 = aworldrenderer[i2];
            if (worldrenderer3 == null) continue;
            if (!worldrenderer3.isInFrustum && i2 != byte0 - 1) {
                aworldrenderer[i2] = null;
                aworldrenderer[0] = null;
                break;
            }
            aworldrenderer[i2].updateRenderer();
            aworldrenderer[i2].needsUpdate = false;
            ++l1;
        }
        int l22 = 0;
        int j3 = this.worldRenderersToUpdate.size();
        for (j2 = 0; j2 != j3; ++j2) {
            WorldRenderer worldrenderer4 = (WorldRenderer)this.worldRenderersToUpdate.get(j2);
            if (worldrenderer4 == null) continue;
            boolean flag2 = false;
            for (int k3 = 0; k3 < byte0 && !flag2; ++k3) {
                if (worldrenderer4 != aworldrenderer[k3]) continue;
                flag2 = true;
            }
            if (flag2) continue;
            if (l22 != j2) {
                this.worldRenderersToUpdate.set(l22, worldrenderer4);
            }
            ++l22;
        }
        while (--j2 >= l22) {
            this.worldRenderersToUpdate.remove(j2);
        }
        return l2 == i1 + l1;
    }

    public void drawBlockBreaking(EntityPlayer entityplayer, MovingObjectPosition movingobjectposition, int i2, ItemStack itemstack, float f2) {
        Tessellator tessellator = Tessellator.instance;
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((MathHelper.sin((float)System.currentTimeMillis() / 100.0f) * 0.2f + 0.4f) * 0.5f));
        if (i2 == 0) {
            if (this.damagePartialTime > 0.0f) {
                GL11.glBlendFunc((int)774, (int)768);
                int j2 = this.renderEngine.getTexture("/terrain.png");
                GL11.glBindTexture((int)3553, (int)j2);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                GL11.glPushMatrix();
                int k2 = this.worldObj.getBlockId(movingobjectposition.blockX, movingobjectposition.blockY, movingobjectposition.blockZ);
                Block block = k2 <= 0 ? null : Block.blocksList[k2];
                GL11.glDisable((int)3008);
                GL11.glPolygonOffset((float)-3.0f, (float)-3.0f);
                GL11.glEnable((int)32823);
                double d2 = entityplayer.lastTickPosX + (entityplayer.posX - entityplayer.lastTickPosX) * (double)f2;
                double d1 = entityplayer.lastTickPosY + (entityplayer.posY - entityplayer.lastTickPosY) * (double)f2;
                double d22 = entityplayer.lastTickPosZ + (entityplayer.posZ - entityplayer.lastTickPosZ) * (double)f2;
                if (block == null) {
                    block = Block.stone;
                }
                GL11.glEnable((int)3008);
                tessellator.startDrawingQuads();
                tessellator.setTranslationD(-d2, -d1, -d22);
                tessellator.disableColor();
                this.globalRenderBlocks.renderBlockUsingTexture(block, movingobjectposition.blockX, movingobjectposition.blockY, movingobjectposition.blockZ, Block.texCoordToIndex(0, 15) + (int)(this.damagePartialTime * 10.0f));
                tessellator.draw();
                tessellator.setTranslationD(0.0, 0.0, 0.0);
                GL11.glDisable((int)3008);
                GL11.glPolygonOffset((float)0.0f, (float)0.0f);
                GL11.glDisable((int)32823);
                GL11.glEnable((int)3008);
                GL11.glDepthMask((boolean)true);
                GL11.glPopMatrix();
            }
        } else if (itemstack != null) {
            GL11.glBlendFunc((int)770, (int)771);
            float f1 = MathHelper.sin((float)System.currentTimeMillis() / 100.0f) * 0.2f + 0.8f;
            GL11.glColor4f((float)f1, (float)f1, (float)f1, (float)(MathHelper.sin((float)System.currentTimeMillis() / 200.0f) * 0.2f + 0.5f));
            int l2 = this.renderEngine.getTexture("/terrain.png");
            GL11.glBindTexture((int)3553, (int)l2);
            int i1 = movingobjectposition.blockX;
            int j1 = movingobjectposition.blockY;
            int k1 = movingobjectposition.blockZ;
            if (movingobjectposition.sideHit == 0) {
                --j1;
            }
            if (movingobjectposition.sideHit == 1) {
                ++j1;
            }
            if (movingobjectposition.sideHit == 2) {
                --k1;
            }
            if (movingobjectposition.sideHit == 3) {
                ++k1;
            }
            if (movingobjectposition.sideHit == 4) {
                --i1;
            }
            if (movingobjectposition.sideHit == 5) {
                ++i1;
            }
        }
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3008);
    }

    public void drawSelectionBox(EntityPlayer entityplayer, MovingObjectPosition movingobjectposition, int i2, ItemStack itemstack, float f2) {
        if (i2 == 0 && movingobjectposition.typeOfHit == EnumMovingObjectType.TILE && this.mc.gameSettings.immersiveMode.drawOutline()) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            GL11.glLineWidth((float)2.0f);
            GL11.glDisable((int)3553);
            GL11.glDepthMask((boolean)false);
            float f1 = 0.002f;
            int j2 = this.worldObj.getBlockId(movingobjectposition.blockX, movingobjectposition.blockY, movingobjectposition.blockZ);
            if (j2 > 0) {
                Block.blocksList[j2].setBlockBoundsBasedOnState(this.worldObj, movingobjectposition.blockX, movingobjectposition.blockY, movingobjectposition.blockZ);
                double d2 = entityplayer.lastTickPosX + (entityplayer.posX - entityplayer.lastTickPosX) * (double)f2;
                double d1 = entityplayer.lastTickPosY + (entityplayer.posY - entityplayer.lastTickPosY) * (double)f2;
                double d22 = entityplayer.lastTickPosZ + (entityplayer.posZ - entityplayer.lastTickPosZ) * (double)f2;
                this.drawOutlinedBoundingBox(Block.blocksList[j2].getSelectedBoundingBoxFromPool(this.worldObj, movingobjectposition.blockX, movingobjectposition.blockY, movingobjectposition.blockZ).expand(f1, f1, f1).getOffsetBoundingBox(-d2, -d1, -d22));
            }
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)3553);
            GL11.glDisable((int)3042);
        }
    }

    private void drawOutlinedBoundingBox(AxisAlignedBB axisalignedbb) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawing(3);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.draw();
        tessellator.startDrawing(3);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.draw();
        tessellator.startDrawing(1);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.draw();
    }

    public void func_949_a(int i2, int j2, int k2, int l2, int i1, int j1) {
        int k1 = MathHelper.bucketInt(i2, 16);
        int l1 = MathHelper.bucketInt(j2, 16);
        int i22 = MathHelper.bucketInt(k2, 16);
        int j22 = MathHelper.bucketInt(l2, 16);
        int k22 = MathHelper.bucketInt(i1, 16);
        int l22 = MathHelper.bucketInt(j1, 16);
        for (int i3 = k1; i3 <= j22; ++i3) {
            int j3 = i3 % this.renderChunksWide;
            if (j3 < 0) {
                j3 += this.renderChunksWide;
            }
            for (int k3 = l1; k3 <= k22; ++k3) {
                int l3 = k3 % this.renderChunksTall;
                if (l3 < 0) {
                    l3 += this.renderChunksTall;
                }
                for (int i4 = i22; i4 <= l22; ++i4) {
                    int j4 = i4 % this.renderChunksDeep;
                    if (j4 < 0) {
                        j4 += this.renderChunksDeep;
                    }
                    int k4 = (j4 * this.renderChunksTall + l3) * this.renderChunksWide + j3;
                    WorldRenderer worldrenderer = this.worldRenderers[k4];
                    if (worldrenderer.needsUpdate) continue;
                    this.worldRenderersToUpdate.add(worldrenderer);
                    worldrenderer.markDirty();
                }
            }
        }
    }

    @Override
    public void markBlockAndNeighborsNeedsUpdate(int i2, int j2, int k2) {
        this.func_949_a(i2 - 1, j2 - 1, k2 - 1, i2 + 1, j2 + 1, k2 + 1);
    }

    @Override
    public void markBlockRangeNeedsUpdate(int i2, int j2, int k2, int l2, int i1, int j1) {
        this.func_949_a(i2 - 1, j2 - 1, k2 - 1, l2 + 1, i1 + 1, j1 + 1);
    }

    public void clipRenderersByFrustrum(ICamera icamera, float f2) {
        for (int i2 = 0; i2 < this.worldRenderers.length; ++i2) {
            if (this.worldRenderers[i2].skipAllRenderPasses() || this.worldRenderers[i2].isInFrustum && (i2 + this.frustrumCheckOffset & 0xF) != 0) continue;
            this.worldRenderers[i2].updateInFrustrum(icamera);
        }
        ++this.frustrumCheckOffset;
    }

    @Override
    public void playRecord(String s2, int i2, int j2, int k2) {
        if (s2 != null) {
            this.mc.ingameGUI.setRecordPlayingMessage("C418 - " + s2);
        }
        this.mc.sndManager.playStreaming(s2, i2, j2, k2, 1.0f, 1.0f);
    }

    @Override
    public void playSound(String s2, double d2, double d1, double d22, float f2, float f1) {
        float f22 = 16.0f;
        if (f2 > 1.0f) {
            f22 *= f2;
        }
        if (this.mc.renderViewEntity.getDistanceSq(d2, d1, d22) < (double)(f22 * f22)) {
            this.mc.sndManager.playSound(s2, (float)d2, (float)d1, (float)d22, f2, f1);
        }
    }

    @Override
    public void spawnParticle(String s2, double x2, double y2, double z2, double motionX, double motionY, double motionZ) {
        if (this.mc == null || this.mc.renderViewEntity == null || this.mc.effectRenderer == null) {
            return;
        }
        double d6 = this.mc.renderViewEntity.posX - x2;
        double d7 = this.mc.renderViewEntity.posY - y2;
        double d8 = this.mc.renderViewEntity.posZ - z2;
        double d9 = 16.0;
        if (d6 * d6 + d7 * d7 + d8 * d8 > d9 * d9) {
            return;
        }
        if (s2.equals("bubble")) {
            this.mc.effectRenderer.addEffect(new EntityBubbleFX(this.worldObj, x2, y2, z2, motionX, motionY, motionZ));
        } else if (s2.equals("smoke")) {
            this.mc.effectRenderer.addEffect(new EntitySmokeFX(this.worldObj, x2, y2, z2, motionX, motionY, motionZ));
        } else if (s2.equals("note")) {
            this.mc.effectRenderer.addEffect(new EntityNoteFX(this.worldObj, x2, y2, z2, motionX, motionY, motionZ));
        } else if (s2.equals("portal")) {
            this.mc.effectRenderer.addEffect(new EntityPortalFX(this.worldObj, x2, y2, z2, motionX, motionY, motionZ));
        } else if (s2.equals("explode")) {
            this.mc.effectRenderer.addEffect(new EntityExplodeFX(this.worldObj, x2, y2, z2, motionX, motionY, motionZ));
        } else if (s2.equals("flame")) {
            this.mc.effectRenderer.addEffect(new EntityFlameFX(this.worldObj, x2, y2, z2, motionX, motionY, motionZ));
        } else if (s2.equals("lava")) {
            this.mc.effectRenderer.addEffect(new EntityLavaFX(this.worldObj, x2, y2, z2));
        } else if (s2.equals("footstep")) {
            this.mc.effectRenderer.addEffect(new EntityFootStepFX(this.renderEngine, this.worldObj, x2, y2, z2));
        } else if (s2.equals("splash")) {
            this.mc.effectRenderer.addEffect(new EntitySplashFX(this.worldObj, x2, y2, z2, motionX, motionY, motionZ));
        } else if (s2.equals("largesmoke")) {
            this.mc.effectRenderer.addEffect(new EntitySmokeFX(this.worldObj, x2, y2, z2, motionX, motionY, motionZ, 2.5f));
        } else if (s2.equals("reddust")) {
            this.mc.effectRenderer.addEffect(new EntityReddustFX(this.worldObj, x2, y2, z2, (float)motionX, (float)motionY, (float)motionZ));
        } else if (s2.equals("snowballpoof")) {
            this.mc.effectRenderer.addEffect(new EntitySlimeFX(this.worldObj, x2, y2, z2, Item.ammoSnowball));
        } else if (s2.equals("snowshovel")) {
            this.mc.effectRenderer.addEffect(new EntitySnowShovelFX(this.worldObj, x2, y2, z2, motionX, motionY, motionZ));
        } else if (s2.equals("slime")) {
            this.mc.effectRenderer.addEffect(new EntitySlimeFX(this.worldObj, x2, y2, z2, Item.slimeball));
        } else if (s2.equals("heart")) {
            this.mc.effectRenderer.addEffect(new EntityHeartFX(this.worldObj, x2, y2, z2, motionX, motionY, motionZ));
        } else if (s2.equals("slimechunk")) {
            if (((Boolean)this.mc.gameSettings.slimeParticles.value).booleanValue()) {
                this.mc.effectRenderer.addEffect(new EntitySlimeChunkFX(this.worldObj, x2, y2, z2, Item.slimeball));
            }
        } else if (s2.equals("arrowtrail")) {
            this.mc.effectRenderer.addEffect(new EntityArrowGoldenFX(this.worldObj, x2, y2, z2, motionX, motionY, motionZ));
        } else if (s2.equals("arrowbreak")) {
            this.mc.effectRenderer.addEffect(new EntitySlimeFX(this.worldObj, x2, y2, z2, Item.ammoArrowPurple));
        } else if (s2.equals("fallingleaf")) {
            int id2 = this.worldObj.getBlockId((int)x2, (int)y2, (int)z2);
            if (id2 != 0) {
                this.mc.effectRenderer.addEffect(new EntityLeafFX(this.worldObj, x2, y2, z2, motionX, motionY, motionZ).func_4041_a((int)x2, (int)y2, (int)z2));
            }
        } else if (s2.equals("boatbreak")) {
            this.mc.effectRenderer.addEffect(new EntityDiggingFX(this.worldObj, x2, y2, z2, motionX, motionY, motionZ, Block.planksOak, 0, 0));
        }
    }

    @Override
    public void updateAllRenderers() {
        for (int i2 = 0; i2 < this.worldRenderers.length; ++i2) {
            if (!this.worldRenderers[i2].isChunkLit || this.worldRenderers[i2].needsUpdate) continue;
            this.worldRenderersToUpdate.add(this.worldRenderers[i2]);
            this.worldRenderers[i2].markDirty();
        }
    }

    @Override
    public void sendTileEntityToPlayer(int i2, int j2, int k2, TileEntity tileentity) {
    }

    public void func_28137_f() {
        GLAllocation.func_28194_b(this.glRenderListBase);
    }

    @Override
    public void playSoundEffectForPlayer(EntityPlayer entityplayer, int id2, int x2, int y2, int z2, int data) {
        Random random = this.worldObj.rand;
        switch (id2) {
            default: {
                break;
            }
            case 1001: {
                this.worldObj.playSoundEffect(x2, y2, z2, "random.click", 1.0f, 1.2f);
                break;
            }
            case 1000: {
                this.worldObj.playSoundEffect(x2, y2, z2, "random.click", 1.0f, 1.0f);
                break;
            }
            case 1002: {
                this.worldObj.playSoundEffect(x2, y2, z2, "random.bow", 1.0f, 1.2f);
                break;
            }
            case 2000: {
                int j1 = data % 3 - 1;
                int k1 = data / 3 % 3 - 1;
                double d2 = (double)x2 + (double)j1 * 0.6 + 0.5;
                double d1 = (double)y2 + 0.5;
                double d22 = (double)z2 + (double)k1 * 0.6 + 0.5;
                for (int l1 = 0; l1 < 10; ++l1) {
                    double d3 = random.nextDouble() * 0.2 + 0.01;
                    double d4 = d2 + (double)j1 * 0.01 + (random.nextDouble() - 0.5) * (double)k1 * 0.5;
                    double d5 = d1 + (random.nextDouble() - 0.5) * 0.5;
                    double d6 = d22 + (double)k1 * 0.01 + (random.nextDouble() - 0.5) * (double)j1 * 0.5;
                    double d7 = (double)j1 * d3 + random.nextGaussian() * 0.01;
                    double d8 = -0.03 + random.nextGaussian() * 0.01;
                    double d9 = (double)k1 * d3 + random.nextGaussian() * 0.01;
                    this.spawnParticle("smoke", d4, d5, d6, d7, d8, d9);
                }
                break;
            }
            case 2001: {
                int i2 = data;
                if (i2 > 0) {
                    Block block = Block.blocksList[i2];
                    this.mc.sndManager.playSound(block.stepSound.stepSoundDir(), (float)x2 + 0.5f, (float)y2 + 0.5f, (float)z2 + 0.5f, (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
                }
                this.mc.effectRenderer.addBlockDestroyEffects(x2, y2, z2, data, this.worldObj.getBlockMetadata(x2, y2, z2));
                break;
            }
            case 1003: {
                if (Math.random() < 0.5) {
                    this.worldObj.playSoundEffect((double)x2 + 0.5, (double)y2 + 0.5, (double)z2 + 0.5, "random.door_open", 1.0f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
                    break;
                }
                this.worldObj.playSoundEffect((double)x2 + 0.5, (double)y2 + 0.5, (double)z2 + 0.5, "random.door_close", 1.0f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case 1004: {
                this.worldObj.playSoundEffect((float)x2 + 0.5f, (float)y2 + 0.5f, (float)z2 + 0.5f, "random.fizz", 0.5f, 2.6f + (random.nextFloat() - random.nextFloat()) * 0.8f);
                break;
            }
            case 1005: {
                if (Item.itemsList[data] instanceof ItemRecord) {
                    this.worldObj.playRecord(((ItemRecord)Item.itemsList[data]).recordName, x2, y2, z2);
                    break;
                }
                this.worldObj.playRecord(null, x2, y2, z2);
                break;
            }
            case 1006: {
                this.worldObj.playSoundEffect((double)x2 + 0.5, (double)y2 + 0.5, (double)z2 + 0.5, "tile.piston.out", 0.5f, this.worldObj.rand.nextFloat() * 0.25f + 0.6f);
                break;
            }
            case 1007: {
                this.worldObj.playSoundEffect((double)x2 + 0.5, (double)y2 + 0.5, (double)z2 + 0.5, "tile.piston.in", 0.5f, this.worldObj.rand.nextFloat() * 0.25f + 0.6f);
                break;
            }
            case 1008: {
                this.worldObj.playSoundEffect((double)x2 + 0.5, (double)y2 + 0.5, (double)z2 + 0.5, "random.breath", 0.5f, this.worldObj.rand.nextFloat());
            }
        }
    }

    @Override
    public void trackEntity(Entity entity) {
    }

    @Override
    public void untrackEntity(Entity entity) {
    }
}

