/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityItem;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.Render;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.RenderEngine;
import net.minecraft.src.RenderManager;
import net.minecraft.src.Tessellator;
import net.minecraft.src.TextureFX;
import org.lwjgl.opengl.GL11;

public class RenderItem
extends Render {
    private final RenderBlocks renderBlocks = new RenderBlocks();
    private final Random random = new Random();
    public boolean field_27004_a = true;

    public RenderItem() {
        this.shadowSize = 0.15f;
        this.field_194_c = 0.75f;
    }

    @Override
    public void doRender(Entity entity, double d2, double d1, double d22, float f2, float f1) {
        this.doRenderItem((EntityItem)entity, d2, d1, d22, f2, f1);
    }

    public void doRenderItem(EntityItem entityitem, double d2, double d1, double d22, float f2, float f1) {
        this.random.setSeed(187L);
        ItemStack itemstack = entityitem.item;
        GL11.glPushMatrix();
        float f22 = MathHelper.sin(((float)entityitem.age + f1) / 10.0f + entityitem.field_804_d) * 0.1f + 0.1f;
        float f3 = (((float)entityitem.age + f1) / 20.0f + entityitem.field_804_d) * 57.29578f;
        int renderCount = 1;
        if (entityitem.item.stackSize > 1) {
            renderCount = 2;
        }
        if (entityitem.item.stackSize > 5) {
            renderCount = 3;
        }
        if (entityitem.item.stackSize > 20) {
            renderCount = 4;
        }
        GL11.glTranslatef((float)((float)d2), (float)((float)d1 + f22), (float)((float)d22));
        GL11.glEnable((int)32826);
        if (itemstack.itemID < Block.blocksList.length && RenderBlocks.renderItemIn3d(Block.blocksList[itemstack.itemID].getRenderType())) {
            GL11.glRotatef((float)f3, (float)0.0f, (float)1.0f, (float)0.0f);
            this.loadTexture("/terrain.png");
            float itemSize = 0.25f;
            int renderType = Block.blocksList[itemstack.itemID].getRenderType();
            if (renderType == 1 || renderType == 19 || renderType == 12 || renderType == 2) {
                itemSize = 0.5f;
            }
            GL11.glScalef((float)itemSize, (float)itemSize, (float)itemSize);
            for (int j2 = 0; j2 < renderCount; ++j2) {
                GL11.glPushMatrix();
                if (j2 > 0) {
                    float f5 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.2f / itemSize;
                    float f7 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.2f / itemSize;
                    float f9 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.2f / itemSize;
                    GL11.glTranslatef((float)f5, (float)f7, (float)f9);
                }
                float f4 = entityitem.getEntityBrightness(f1);
                if (Minecraft.getMinecraft().fullbright) {
                    f4 = 1.0f;
                }
                this.renderBlocks.renderBlockOnInventory(Block.blocksList[itemstack.itemID], itemstack.getMetadata(), f4);
                GL11.glPopMatrix();
            }
        } else {
            int tileWidth;
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            int i2 = itemstack.getIconIndex();
            if (itemstack.itemID < Block.blocksList.length) {
                this.loadTexture("/terrain.png");
                tileWidth = TextureFX.tileWidthTerrain;
            } else {
                this.loadTexture("/gui/items.png");
                tileWidth = TextureFX.tileWidthItems;
            }
            Tessellator tessellator = Tessellator.instance;
            float f6 = (float)(i2 % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * tileWidth + 0) / (float)(net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * tileWidth);
            float f8 = (float)(i2 % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * tileWidth + tileWidth) / (float)(net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * tileWidth);
            float f10 = (float)(i2 / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * tileWidth + 0) / (float)(net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * tileWidth);
            float f11 = (float)(i2 / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * tileWidth + tileWidth) / (float)(net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * tileWidth);
            float f12 = 1.0f;
            float f13 = 0.5f;
            float f14 = 0.25f;
            if (this.field_27004_a) {
                int k2 = Item.itemsList[itemstack.itemID].getColorFromDamage(itemstack.getMetadata());
                float f15 = (float)(k2 >> 16 & 0xFF) / 255.0f;
                float f17 = (float)(k2 >> 8 & 0xFF) / 255.0f;
                float f19 = (float)(k2 & 0xFF) / 255.0f;
                float f21 = entityitem.getEntityBrightness(f1);
                if (Minecraft.getMinecraft().fullbright) {
                    f21 = 1.0f;
                }
                GL11.glColor4f((float)(f15 * f21), (float)(f17 * f21), (float)(f19 * f21), (float)1.0f);
            }
            if (((Boolean)Minecraft.getMinecraft().gameSettings.items3D.value).booleanValue()) {
                GL11.glPushMatrix();
                GL11.glScaled((double)1.0, (double)1.0, (double)1.0);
                GL11.glRotated((double)f3, (double)0.0, (double)1.0, (double)0.0);
                GL11.glTranslated((double)-0.5, (double)0.0, (double)(-0.05 * (double)(renderCount - 1)));
                for (int j3 = 0; j3 < renderCount; ++j3) {
                    GL11.glPushMatrix();
                    GL11.glTranslated((double)0.0, (double)0.0, (double)(0.1 * (double)j3));
                    RenderManager.instance.itemRenderer.renderItem(entityitem, itemstack, false);
                    GL11.glPopMatrix();
                }
                GL11.glPopMatrix();
            } else {
                for (int l2 = 0; l2 < renderCount; ++l2) {
                    GL11.glPushMatrix();
                    if (l2 > 0) {
                        float f16 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                        float f18 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                        float f20 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                        GL11.glTranslatef((float)f16, (float)f18, (float)f20);
                    }
                    GL11.glRotatef((float)(180.0f - this.renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
                    tessellator.startDrawingQuads();
                    tessellator.setNormal(0.0f, 1.0f, 0.0f);
                    tessellator.addVertexWithUV(-0.5, -0.25, 0.0, f6, f11);
                    tessellator.addVertexWithUV(0.5, -0.25, 0.0, f8, f11);
                    tessellator.addVertexWithUV(0.5, 0.75, 0.0, f8, f10);
                    tessellator.addVertexWithUV(-0.5, 0.75, 0.0, f6, f10);
                    tessellator.draw();
                    GL11.glPopMatrix();
                }
            }
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    public void drawItemIntoGui(FontRenderer fontrenderer, RenderEngine renderengine, int i2, int j2, int k2, int l2, int i1) {
        this.drawItemIntoGui(fontrenderer, renderengine, i2, j2, k2, l2, i1, 1.0f, 1.0f);
    }

    public void drawItemIntoGui(FontRenderer fontrenderer, RenderEngine renderengine, int i2, int j2, int k2, int l2, int i1, float brightness, float alpha) {
        if (i2 < Block.blocksList.length && RenderBlocks.renderItemIn3d(Block.blocksList[i2].getRenderType())) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            int j1 = i2;
            renderengine.bindTexture(renderengine.getTexture("/terrain.png"));
            Block block = Block.blocksList[j1];
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(l2 - 2), (float)(i1 + 3), (float)-3.0f);
            GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
            GL11.glTranslatef((float)1.0f, (float)0.5f, (float)1.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
            GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            int l1 = Item.itemsList[i2].getColorFromDamage(j2);
            float f2 = (float)(l1 >> 16 & 0xFF) / 255.0f;
            float f4 = (float)(l1 >> 8 & 0xFF) / 255.0f;
            float f5 = (float)(l1 & 0xFF) / 255.0f;
            if (this.field_27004_a) {
                GL11.glColor4f((float)(f2 * brightness), (float)(f4 * brightness), (float)(f5 * brightness), (float)alpha);
            } else {
                GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
            }
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.renderBlocks.useInventoryTint = this.field_27004_a;
            this.renderBlocks.renderBlockOnInventory(block, j2, brightness);
            this.renderBlocks.useInventoryTint = true;
            GL11.glPopMatrix();
            GL11.glDisable((int)3042);
        } else if (k2 >= 0) {
            int tileWidth;
            GL11.glDisable((int)2896);
            if (i2 < Block.blocksList.length) {
                renderengine.bindTexture(renderengine.getTexture("/terrain.png"));
                tileWidth = TextureFX.tileWidthTerrain;
            } else {
                renderengine.bindTexture(renderengine.getTexture("/gui/items.png"));
                tileWidth = TextureFX.tileWidthItems;
            }
            int k1 = Item.itemsList[i2].getColorFromDamage(j2);
            float f2 = (float)(k1 >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(k1 >> 8 & 0xFF) / 255.0f;
            float f3 = (float)(k1 & 0xFF) / 255.0f;
            if (this.field_27004_a) {
                GL11.glColor4f((float)(f2 * brightness), (float)(f1 * brightness), (float)(f3 * brightness), (float)alpha);
            } else {
                GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
            }
            this.renderTexturedQuad(l2, i1, k2 % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * tileWidth, k2 / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * tileWidth, tileWidth, tileWidth);
            GL11.glEnable((int)2896);
        }
        GL11.glEnable((int)2884);
    }

    public void renderItemIntoGUI(FontRenderer fontrenderer, RenderEngine renderengine, ItemStack itemstack, int i2, int j2, float alpha) {
        if (itemstack == null) {
            return;
        }
        this.drawItemIntoGui(fontrenderer, renderengine, itemstack.itemID, itemstack.getMetadata(), itemstack.getIconIndex(), i2, j2, 1.0f, alpha);
    }

    public void renderItemIntoGUI(FontRenderer fontrenderer, RenderEngine renderengine, ItemStack itemstack, int i2, int j2, float brightness, float alpha) {
        if (itemstack == null) {
            return;
        }
        this.drawItemIntoGui(fontrenderer, renderengine, itemstack.itemID, itemstack.getMetadata(), itemstack.getIconIndex(), i2, j2, brightness, alpha);
    }

    public void renderItemOverlayIntoGUI(FontRenderer fontrenderer, RenderEngine renderengine, ItemStack itemstack, int i2, int j2, float alpha) {
        if (itemstack == null) {
            return;
        }
        if (itemstack.stackSize != 1) {
            String s2 = "" + itemstack.stackSize;
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            fontrenderer.drawStringWithShadow(s2, i2 + 19 - 2 - fontrenderer.getStringWidth(s2), j2 + 6 + 3, 0xFFFFFF);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        }
        if (itemstack.isItemDamaged()) {
            int k2 = (int)Math.round(13.0 - (double)itemstack.getItemDamageForDisplay() * 13.0 / (double)itemstack.getMaxDamage());
            int l2 = (int)Math.round(255.0 - (double)itemstack.getItemDamageForDisplay() * 255.0 / (double)itemstack.getMaxDamage());
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3553);
            Tessellator tessellator = Tessellator.instance;
            int i1 = 255 - l2 << 16 | l2 << 8;
            int j1 = (255 - l2) / 4 << 16 | 0x3F00;
            this.renderQuad(tessellator, i2 + 2, j2 + 13, 13, 2, 0);
            this.renderQuad(tessellator, i2 + 2, j2 + 13, 12, 1, j1);
            this.renderQuad(tessellator, i2 + 2, j2 + 13, k2, 1, i1);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void renderItemOverlayIntoGUI(FontRenderer fontrenderer, RenderEngine renderengine, ItemStack itemstack, int i2, int j2, boolean discovered) {
        if (itemstack == null) {
            return;
        }
        if (itemstack.stackSize != 1 || !discovered) {
            String s2 = "" + itemstack.stackSize;
            if (!discovered) {
                s2 = "?";
            }
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            fontrenderer.drawStringWithShadow(s2, i2 + 19 - 2 - fontrenderer.getStringWidth(s2), j2 + 6 + 3, 0xFFFFFF);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        }
        if (itemstack.isItemDamaged() && discovered) {
            int k2 = (int)Math.round(13.0 - (double)itemstack.getItemDamageForDisplay() * 13.0 / (double)itemstack.getMaxDamage());
            int l2 = (int)Math.round(255.0 - (double)itemstack.getItemDamageForDisplay() * 255.0 / (double)itemstack.getMaxDamage());
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3553);
            Tessellator tessellator = Tessellator.instance;
            int i1 = 255 - l2 << 16 | l2 << 8;
            int j1 = (255 - l2) / 4 << 16 | 0x3F00;
            this.renderQuad(tessellator, i2 + 2, j2 + 13, 13, 2, 0);
            this.renderQuad(tessellator, i2 + 2, j2 + 13, 12, 1, j1);
            this.renderQuad(tessellator, i2 + 2, j2 + 13, k2, 1, i1);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void renderQuad(Tessellator tessellator, int i2, int j2, int k2, int l2, int i1) {
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(i1);
        tessellator.addVertex(i2 + 0, j2 + 0, 0.0);
        tessellator.addVertex(i2 + 0, j2 + l2, 0.0);
        tessellator.addVertex(i2 + k2, j2 + l2, 0.0);
        tessellator.addVertex(i2 + k2, j2 + 0, 0.0);
        tessellator.draw();
    }

    public void renderTexturedQuad(int x2, int y2, int tileX, int tileY, int tileWidth, int tileHeight) {
        float f2 = 0.0f;
        float f1 = 1.0f / (float)(net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * tileWidth);
        float f22 = 1.0f / (float)(net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * tileHeight);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(x2 + 0, y2 + 16, 0.0, (float)(tileX + 0) * f1, (float)(tileY + tileHeight) * f22);
        tessellator.addVertexWithUV(x2 + 16, y2 + 16, 0.0, (float)(tileX + tileWidth) * f1, (float)(tileY + tileHeight) * f22);
        tessellator.addVertexWithUV(x2 + 16, y2 + 0, 0.0, (float)(tileX + tileWidth) * f1, (float)(tileY + 0) * f22);
        tessellator.addVertexWithUV(x2 + 0, y2 + 0, 0.0, (float)(tileX + 0) * f1, (float)(tileY + 0) * f22);
        tessellator.draw();
    }
}

