/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.client.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityPlayerSP;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemArmor;
import net.minecraft.src.ItemQuiver;
import net.minecraft.src.ItemQuiverEndless;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.ModelBiped;
import net.minecraft.src.PlayerSkinParser;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.RenderLiving;
import net.minecraft.src.Tessellator;
import org.lwjgl.opengl.GL11;

public class RenderPlayer
extends RenderLiving {
    private ModelBiped modelBipedMain;
    private ModelBiped modelArmorChestplate;
    private ModelBiped modelArmor;
    private static final String[] armorFilenamePrefix = new String[]{"cloth", "chain", "iron", "diamond", "gold", "steel"};

    public RenderPlayer() {
        super(new ModelBiped(0.0f), 0.5f);
        this.modelBipedMain = (ModelBiped)this.mainModel;
        this.modelArmorChestplate = new ModelBiped(1.0f);
        this.modelArmor = new ModelBiped(0.5f);
    }

    protected boolean setArmorModel(EntityPlayer entityplayer, int i2, float f2) {
        ItemStack itemstack = entityplayer.inventory.armorItemInSlot(3 - i2);
        if (itemstack != null) {
            Item item = itemstack.getItem();
            if (item instanceof ItemArmor) {
                ItemArmor itemarmor = (ItemArmor)item;
                this.loadTexture("/armor/" + armorFilenamePrefix[itemarmor.material.renderIndex] + "_" + (i2 != 2 ? 1 : 2) + ".png");
                ModelBiped modelbiped = i2 != 2 ? this.modelArmorChestplate : this.modelArmor;
                modelbiped.bipedHead.showModel = i2 == 0;
                modelbiped.bipedHeadwear.showModel = i2 == 0;
                modelbiped.bipedBody.showModel = i2 == 1 || i2 == 2;
                modelbiped.bipedRightArm.showModel = i2 == 1;
                modelbiped.bipedLeftArm.showModel = i2 == 1;
                modelbiped.bipedRightLeg.showModel = i2 == 2 || i2 == 3;
                modelbiped.bipedLeftLeg.showModel = i2 == 2 || i2 == 3;
                this.setRenderPassModel(modelbiped);
                return true;
            }
            if (item instanceof ItemQuiver) {
                this.loadTexture("/armor/quiver" + ".png");
                ModelBiped modelbiped = this.modelArmorChestplate;
                modelbiped.bipedBody.showModel = i2 == 1 || i2 == 2;
                this.setRenderPassModel(modelbiped);
                return true;
            }
            if (item instanceof ItemQuiverEndless) {
                this.loadTexture("/armor/quiver_golden" + ".png");
                ModelBiped modelbiped = this.modelArmorChestplate;
                modelbiped.bipedBody.showModel = i2 == 1 || i2 == 2;
                this.setRenderPassModel(modelbiped);
                return true;
            }
        }
        return false;
    }

    public void renderPlayer(EntityPlayer entityplayer, double d2, double d1, double d22, float f2, float f1) {
        ItemStack itemstack = entityplayer.inventory.getCurrentItem();
        this.modelBipedMain.field_1278_i = itemstack != null;
        this.modelArmor.field_1278_i = this.modelBipedMain.field_1278_i;
        this.modelArmorChestplate.field_1278_i = this.modelBipedMain.field_1278_i;
        this.modelArmor.isSneak = this.modelBipedMain.isSneak = entityplayer.isSneaking();
        this.modelArmorChestplate.isSneak = this.modelBipedMain.isSneak;
        double d3 = d1 - (double)entityplayer.yOffset;
        if (entityplayer.isSneaking() && !(entityplayer instanceof EntityPlayerSP)) {
            d3 -= 0.125;
        }
        super.doRenderLiving(entityplayer, d2, d3, d22, f2, f1);
        this.modelBipedMain.isSneak = false;
        this.modelArmor.isSneak = false;
        this.modelArmorChestplate.isSneak = false;
        this.modelBipedMain.field_1278_i = false;
        this.modelArmor.field_1278_i = false;
        this.modelArmorChestplate.field_1278_i = false;
    }

    protected void renderName(EntityPlayer entityplayer, double d2, double d1, double d22) {
        if (Minecraft.getMinecraft().gameSettings.immersiveMode.drawNames() && this.renderManager.livingPlayer != null && entityplayer != this.renderManager.livingPlayer) {
            float f3;
            float f2 = 1.6f;
            float f1 = 0.01666667f * f2;
            float f22 = entityplayer.getDistanceToEntity(this.renderManager.livingPlayer);
            float f4 = f3 = entityplayer.isSneaking() ? 32.0f : 64.0f;
            if (f22 < f3) {
                String s2 = entityplayer.getDisplayName();
                if (!entityplayer.isSneaking()) {
                    if (entityplayer.isPlayerSleeping()) {
                        this.renderLivingLabel(entityplayer, s2, d2, d1 - 1.5, d22, 64);
                    } else {
                        this.renderLivingLabel(entityplayer, s2, d2, d1, d22, 64);
                    }
                } else {
                    FontRenderer fontrenderer = this.getFontRendererFromRenderManager();
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)((float)d2 + 0.0f), (float)((float)d1 + 2.3f), (float)((float)d22));
                    GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)(-this.renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)this.renderManager.playerViewX, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glScalef((float)(-f1), (float)(-f1), (float)f1);
                    GL11.glDisable((int)2896);
                    GL11.glTranslatef((float)0.0f, (float)(0.25f / f1), (float)0.0f);
                    GL11.glDepthMask((boolean)false);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    Tessellator tessellator = Tessellator.instance;
                    GL11.glDisable((int)3553);
                    tessellator.startDrawingQuads();
                    int i2 = fontrenderer.getStringWidth(s2) / 2;
                    tessellator.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.25f);
                    tessellator.addVertex(-i2 - 1, -1.0, 0.0);
                    tessellator.addVertex(-i2 - 1, 8.0, 0.0);
                    tessellator.addVertex(i2 + 1, 8.0, 0.0);
                    tessellator.addVertex(i2 + 1, -1.0, 0.0);
                    tessellator.draw();
                    GL11.glEnable((int)3553);
                    GL11.glDepthMask((boolean)true);
                    fontrenderer.drawString(s2, -fontrenderer.getStringWidth(s2) / 2, 0, 0x20FFFFFF);
                    GL11.glEnable((int)2896);
                    GL11.glDisable((int)3042);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glPopMatrix();
                }
            }
        }
    }

    protected void renderSpecials(EntityPlayer entityplayer, float f2) {
        ItemStack itemstack1;
        ItemStack itemstack = entityplayer.inventory.armorItemInSlot(3);
        if (itemstack != null && itemstack.getItem().itemID < Block.blocksList.length) {
            GL11.glPushMatrix();
            this.modelBipedMain.bipedHead.postRender(0.0625f);
            if (RenderBlocks.renderItemIn3d(Block.blocksList[itemstack.itemID].getRenderType())) {
                float f1 = 0.625f;
                GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)f1, (float)(-f1), (float)f1);
            }
            this.renderManager.itemRenderer.renderItem(entityplayer, itemstack);
            GL11.glPopMatrix();
        }
        boolean renderCape = false;
        if (entityplayer.username.equals("MaggAndGeez") || entityplayer.username.equals("jonkadelic") || entityplayer.username.equals("Bestsoft100")) {
            renderCape = true;
            this.loadTexture("/armor/bta_cloak.png");
        } else {
            renderCape = this.loadDownloadableTexture(entityplayer.capeURL, null, null);
        }
        if (renderCape) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.125f);
            double d2 = entityplayer.field_20066_r + (entityplayer.field_20063_u - entityplayer.field_20066_r) * (double)f2 - (entityplayer.prevPosX + (entityplayer.posX - entityplayer.prevPosX) * (double)f2);
            double d1 = entityplayer.field_20065_s + (entityplayer.field_20062_v - entityplayer.field_20065_s) * (double)f2 - (entityplayer.prevPosY + (entityplayer.posY - entityplayer.prevPosY) * (double)f2);
            double d22 = entityplayer.field_20064_t + (entityplayer.field_20061_w - entityplayer.field_20064_t) * (double)f2 - (entityplayer.prevPosZ + (entityplayer.posZ - entityplayer.prevPosZ) * (double)f2);
            float f8 = entityplayer.prevRenderYawOffset + (entityplayer.renderYawOffset - entityplayer.prevRenderYawOffset) * f2;
            double d3 = MathHelper.sin(f8 * 3.141593f / 180.0f);
            double d4 = -MathHelper.cos(f8 * 3.141593f / 180.0f);
            float f9 = (float)d1 * 10.0f;
            if (f9 < -6.0f) {
                f9 = -6.0f;
            }
            if (f9 > 32.0f) {
                f9 = 32.0f;
            }
            float f10 = (float)(d2 * d3 + d22 * d4) * 100.0f;
            float f11 = (float)(d2 * d4 - d22 * d3) * 100.0f;
            if (f10 < 0.0f) {
                f10 = 0.0f;
            }
            float f12 = entityplayer.field_775_e + (entityplayer.field_774_f - entityplayer.field_775_e) * f2;
            f9 += MathHelper.sin((entityplayer.prevDistanceWalkedModified + (entityplayer.distanceWalkedModified - entityplayer.prevDistanceWalkedModified) * f2) * 6.0f) * 32.0f * f12;
            if (entityplayer.isSneaking()) {
                f9 += 25.0f;
            }
            GL11.glRotatef((float)(6.0f + f10 / 2.0f + f9), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(f11 / 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(-f11 / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.modelBipedMain.renderCloak(0.0625f);
            GL11.glPopMatrix();
        }
        if ((itemstack1 = entityplayer.inventory.getCurrentItem()) != null) {
            GL11.glPushMatrix();
            this.modelBipedMain.bipedRightArm.postRender(0.0625f);
            GL11.glTranslatef((float)-0.0625f, (float)0.4375f, (float)0.0625f);
            if (entityplayer.fishEntity != null) {
                itemstack1 = new ItemStack(Item.stick);
            }
            if (itemstack1.itemID < Block.blocksList.length && RenderBlocks.renderItemIn3d(Block.blocksList[itemstack1.itemID].getRenderType())) {
                float f3 = 0.5f;
                GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)-0.3125f);
                GL11.glRotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)(f3 *= 0.75f), (float)(-f3), (float)f3);
            } else if (Item.itemsList[itemstack1.itemID].isFull3D()) {
                float f4 = 0.625f;
                if (Item.itemsList[itemstack1.itemID].shouldRotateAroundWhenRendering()) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)0.0f, (float)-0.125f, (float)0.0f);
                }
                if (Item.itemsList[itemstack1.itemID].shouldPointInFrontOfPlayer()) {
                    GL11.glRotatef((float)-20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)-0.125f, (float)0.0f);
                }
                GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)0.0f);
                GL11.glScalef((float)f4, (float)(-f4), (float)f4);
                GL11.glRotatef((float)-100.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                float f5 = 0.375f;
                GL11.glTranslatef((float)0.25f, (float)0.1875f, (float)-0.1875f);
                GL11.glScalef((float)f5, (float)f5, (float)f5);
                GL11.glRotatef((float)60.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            this.renderManager.itemRenderer.renderItem(entityplayer, itemstack1);
            GL11.glPopMatrix();
        }
    }

    protected void func_186_b(EntityPlayer entityplayer, float f2) {
        float f1 = 0.9375f;
        GL11.glScalef((float)f1, (float)f1, (float)f1);
    }

    public void drawFirstPersonHand() {
        this.modelBipedMain.onGround = 0.0f;
        this.modelBipedMain.setRotationAngles(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        this.modelBipedMain.bipedRightArm.render(0.0625f);
    }

    protected void func_22016_b(EntityPlayer entityplayer, double d2, double d1, double d22) {
        if (entityplayer.isEntityAlive() && entityplayer.isPlayerSleeping()) {
            super.func_22012_b(entityplayer, d2 + (double)entityplayer.field_22063_x, d1 + (double)entityplayer.field_22062_y, d22 + (double)entityplayer.field_22061_z);
        } else {
            super.func_22012_b(entityplayer, d2, d1, d22);
        }
    }

    protected void func_22017_a(EntityPlayer entityplayer, float f2, float f1, float f22) {
        if (entityplayer.isEntityAlive() && entityplayer.isPlayerSleeping()) {
            GL11.glRotatef((float)entityplayer.getBedOrientationInDegrees(), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.getDeathMaxRotation(entityplayer), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            super.rotateCorpse(entityplayer, f2, f1, f22);
        }
    }

    @Override
    protected void passSpecialRender(EntityLiving entityliving, double d2, double d1, double d22) {
        this.renderName((EntityPlayer)entityliving, d2, d1, d22);
    }

    @Override
    protected void preRenderCallback(EntityLiving entityliving, float f2) {
        this.func_186_b((EntityPlayer)entityliving, f2);
    }

    @Override
    protected boolean shouldRenderPass(EntityLiving entityliving, int i2, float f2) {
        return this.setArmorModel((EntityPlayer)entityliving, i2, f2);
    }

    @Override
    protected void renderEquippedItems(EntityLiving entityliving, float f2) {
        this.renderSpecials((EntityPlayer)entityliving, f2);
    }

    @Override
    protected void rotateCorpse(EntityLiving entityliving, float f2, float f1, float f22) {
        this.func_22017_a((EntityPlayer)entityliving, f2, f1, f22);
    }

    @Override
    protected void func_22012_b(EntityLiving entityliving, double d2, double d1, double d22) {
        this.func_22016_b((EntityPlayer)entityliving, d2, d1, d22);
    }

    @Override
    public void doRenderLiving(EntityLiving entityliving, double d2, double d1, double d22, float f2, float f1) {
        this.renderPlayer((EntityPlayer)entityliving, d2, d1, d22, f2, f1);
    }

    @Override
    public void doRender(Entity entity, double d2, double d1, double d22, float f2, float f1) {
        this.renderPlayer((EntityPlayer)entity, d2, d1, d22, f2, f1);
    }

    @Override
    public void loadEntityTexture(EntityLiving entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            this.loadDownloadableTexture(((EntityPlayer)entityLiving).skinURL, entityLiving.getEntityTexture(), PlayerSkinParser.instance);
        } else {
            super.loadEntityTexture(entityLiving);
        }
    }
}

