/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.ChunkConverter;
import net.minecraft.src.ChunkFile;
import net.minecraft.src.CompressedStreamTools;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.ISaveHandler;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.RegionFile;
import net.minecraft.src.RegionFileCache;
import net.minecraft.src.SaveFormatComparator;
import net.minecraft.src.SaveFormatOld;
import net.minecraft.src.SaveOldDirClient;
import net.minecraft.src.WorldInfo;

public class SaveFormatMcRegionExtended
extends SaveFormatOld {
    public SaveFormatMcRegionExtended(File file) {
        super(file);
    }

    @Override
    public String getFormatName() {
        return "Extended McRegion";
    }

    @Override
    public List getSaveList() {
        File[] afile;
        ArrayList<SaveFormatComparator> arraylist = new ArrayList<SaveFormatComparator>();
        for (File file : afile = this.saveDir.listFiles()) {
            String s2;
            WorldInfo worldinfo;
            if (!file.isDirectory() || (worldinfo = this.getWorldInfo(s2 = file.getName())) == null) continue;
            boolean needsConversion = worldinfo.getSaveVersion() != 19133;
            String s1 = worldinfo.getWorldName();
            if (s1 == null || MathHelper.stringNullOrLengthZero(s1)) {
                s1 = s2;
            }
            arraylist.add(new SaveFormatComparator(s2, s1, worldinfo, worldinfo.getLastTimePlayed(), worldinfo.getSizeOnDisk(), needsConversion));
        }
        return arraylist;
    }

    @Override
    public void flushCache() {
        RegionFileCache.func_22192_a();
    }

    @Override
    public ISaveHandler getSaveLoader(String s2, boolean flag) {
        return new SaveOldDirClient(this.saveDir, s2, flag);
    }

    @Override
    public boolean isOldMapFormat(String s2) {
        WorldInfo worldinfo = this.getWorldInfo(s2);
        return worldinfo != null && worldinfo.getSaveVersion() == 19132;
    }

    @Override
    public boolean convertMapFormat(String s2, IProgressUpdate iprogressupdate) {
        iprogressupdate.setLoadingProgress(0);
        ArrayList arraylist = new ArrayList();
        ArrayList arraylist1 = new ArrayList();
        ArrayList arraylist2 = new ArrayList();
        ArrayList arraylist3 = new ArrayList();
        File file = new File(this.saveDir, s2);
        File file1 = new File(file, "DIM-1");
        System.out.println("Scanning folders...");
        this.getOldFormatFolders(file, arraylist, arraylist1);
        if (file1.exists()) {
            this.getOldFormatFolders(file1, arraylist2, arraylist3);
        }
        int i2 = arraylist.size() + arraylist2.size() + arraylist1.size() + arraylist3.size();
        System.out.println("Total conversion count is " + (i2 *= 1024));
        this.func_22181_a(file, arraylist, 0, i2, iprogressupdate);
        this.func_22181_a(file1, arraylist2, arraylist.size(), i2, iprogressupdate);
        WorldInfo worldinfo = this.getWorldInfo(s2);
        worldinfo.setSaveVersion(19133);
        ISaveHandler isavehandler = this.getSaveLoader(s2, false);
        isavehandler.saveWorldInfo(worldinfo);
        return true;
    }

    private void getOldFormatFolders(File file, ArrayList arraylist, ArrayList arraylist1) {
        File[] files = new File(file, "region").listFiles();
        for (int i2 = 0; i2 < files.length; ++i2) {
            arraylist.add(files[i2]);
            arraylist1.add(new ChunkFile(files[i2]));
        }
    }

    private void func_22181_a(File file, ArrayList arraylist, int i2, int j2, IProgressUpdate iprogressupdate) {
        Collections.sort(arraylist);
        byte[] abyte0 = new byte[4096];
        int i1 = 0;
        for (File region : arraylist) {
            RegionFile oldRegionFile = new RegionFile(region);
            for (int x2 = 0; x2 < 32; ++x2) {
                for (int z2 = 0; z2 < 32; ++z2) {
                    try {
                        int j1;
                        DataInputStream datainputstream = oldRegionFile.getChunkDataInputStream(x2, z2);
                        if (datainputstream == null) continue;
                        DataOutputStream dataoutputstream = oldRegionFile.getChunkDataOutputStream(x2, z2);
                        NBTTagCompound oldLevel = CompressedStreamTools.func_1141_a(datainputstream);
                        byte[] ids = oldLevel.getCompoundTag("Level").getByteArray("Blocks");
                        byte[] expandedIds = new byte[256 * Minecraft.WORLD_HEIGHT_BLOCKS];
                        short[] shortIds = new short[256 * Minecraft.WORLD_HEIGHT_BLOCKS];
                        for (j1 = 0; j1 < ids.length; j1 += 128) {
                            System.arraycopy(ids, j1, expandedIds, j1 * 2, 128);
                        }
                        for (j1 = 0; j1 < expandedIds.length; ++j1) {
                            shortIds[j1] = expandedIds[j1];
                        }
                        byte[] nibbleData = oldLevel.getCompoundTag("Level").getByteArray("Data");
                        byte[] byteData = new byte[nibbleData.length * 2];
                        for (int j12 = 0; j12 < byteData.length; ++j12) {
                            int nibbleIndex = j12 >> 1;
                            byteData[j12] = (j12 & 1) == 0 ? (byte)(nibbleData[nibbleIndex] & 0xF) : (byte)(nibbleData[nibbleIndex] >> 4 & 0xF);
                        }
                        byte[] expandedByteData = new byte[256 * Minecraft.WORLD_HEIGHT_BLOCKS];
                        for (int j13 = 0; j13 < byteData.length; j13 += 128) {
                            System.arraycopy(byteData, j13, expandedByteData, j13 * 2, 128);
                        }
                        ChunkConverter.converters[0].convertBlocksAndMetadata(shortIds, expandedByteData);
                        oldLevel.getCompoundTag("Level").setShortArray("Blocks", shortIds);
                        oldLevel.getCompoundTag("Level").setByteArray("Data", expandedByteData);
                        byte[] skylightMap = oldLevel.getCompoundTag("Level").getByteArray("SkyLight");
                        byte[] skylightMapExtended = new byte[256 * Minecraft.WORLD_HEIGHT_BLOCKS / 2];
                        for (int j14 = 0; j14 < skylightMap.length; j14 += 64) {
                            System.arraycopy(skylightMap, j14, skylightMapExtended, j14 * 2, 64);
                        }
                        oldLevel.getCompoundTag("Level").setByteArray("SkyLight", skylightMapExtended);
                        byte[] blocklightMap = oldLevel.getCompoundTag("Level").getByteArray("BlockLight");
                        byte[] blocklightMapExtended = new byte[256 * Minecraft.WORLD_HEIGHT_BLOCKS / 2];
                        for (int j15 = 0; j15 < blocklightMap.length; j15 += 64) {
                            System.arraycopy(blocklightMap, j15, blocklightMapExtended, j15 * 2, 64);
                        }
                        oldLevel.getCompoundTag("Level").setByteArray("BlockLight", blocklightMapExtended);
                        CompressedStreamTools.func_1139_a(oldLevel, dataoutputstream);
                        dataoutputstream.close();
                        datainputstream.close();
                    }
                    catch (IOException ioexception) {
                        ioexception.printStackTrace();
                    }
                    i1 = (int)Math.round(100.0 * (double)(++i2) / (double)j2);
                }
            }
            iprogressupdate.setLoadingProgress(i1);
        }
        RegionFileCache.func_22192_a();
    }

    private void func_22182_a(ArrayList arraylist, int i2, int j2, IProgressUpdate iprogressupdate) {
        for (File file : arraylist) {
            File[] afile = file.listFiles();
            SaveFormatMcRegionExtended.deleteFiles(afile);
            file.delete();
            int k2 = (int)Math.round(100.0 * (double)(++i2) / (double)j2);
            iprogressupdate.setLoadingProgress(k2);
        }
    }
}

