/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import net.minecraft.src.ChunkLoader;
import net.minecraft.src.CompressedStreamTools;
import net.minecraft.src.Dimension;
import net.minecraft.src.IChunkLoader;
import net.minecraft.src.IPlayerFileData;
import net.minecraft.src.ISaveHandler;
import net.minecraft.src.MinecraftException;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.WorldInfo;

public class SaveHandler
implements ISaveHandler {
    private final File saveDirectory;
    private final File playersDirectory;
    private final File dataDirectory;
    private final long now = System.currentTimeMillis();

    public SaveHandler(File savesFolder, String levelFolderName, boolean multiplayer) {
        this.saveDirectory = new File(savesFolder, levelFolderName);
        this.saveDirectory.mkdirs();
        this.playersDirectory = new File(this.saveDirectory, "players");
        this.dataDirectory = new File(this.saveDirectory, "data");
        this.dataDirectory.mkdirs();
        if (multiplayer) {
            this.playersDirectory.mkdirs();
        }
        this.lockSession();
    }

    private void lockSession() {
        try {
            File file = new File(this.saveDirectory, "session.lock");
            try (DataOutputStream stream = new DataOutputStream(new FileOutputStream(file));){
                stream.writeLong(this.now);
            }
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
            throw new RuntimeException("Failed to check session lock, aborting");
        }
    }

    protected File getSaveDirectory() {
        return this.saveDirectory;
    }

    @Override
    public void checkSessionLock() {
        try {
            File file = new File(this.saveDirectory, "session.lock");
            try (DataInputStream datainputstream = new DataInputStream(new FileInputStream(file));){
                if (datainputstream.readLong() != this.now) {
                    throw new MinecraftException("The save is being accessed from another location, aborting");
                }
            }
        }
        catch (IOException ioexception) {
            throw new MinecraftException("Failed to check session lock, aborting");
        }
    }

    @Override
    public IChunkLoader getChunkLoader(Dimension dimension) {
        if (dimension == Dimension.overworld) {
            return new ChunkLoader(this.saveDirectory, true);
        }
        File file = new File(this.saveDirectory, "DIM-" + dimension.dimId);
        file.mkdirs();
        return new ChunkLoader(file, true);
    }

    @Override
    public WorldInfo loadWorldInfo() {
        File file = new File(this.saveDirectory, "level.dat");
        if (file.exists()) {
            try {
                NBTTagCompound nbttagcompound = CompressedStreamTools.func_1138_a(new FileInputStream(file));
                NBTTagCompound nbttagcompound2 = nbttagcompound.getCompoundTag("Data");
                return new WorldInfo(nbttagcompound2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if ((file = new File(this.saveDirectory, "level.dat_old")).exists()) {
            try {
                NBTTagCompound nbttagcompound1 = CompressedStreamTools.func_1138_a(new FileInputStream(file));
                NBTTagCompound nbttagcompound3 = nbttagcompound1.getCompoundTag("Data");
                return new WorldInfo(nbttagcompound3);
            }
            catch (Exception exception1) {
                exception1.printStackTrace();
            }
        }
        return null;
    }

    public void saveWorldInfoAndPlayer(WorldInfo worldinfo, List list) {
        NBTTagCompound nbttagcompound = worldinfo.getNBTTagCompoundWithPlayer(list);
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        nbttagcompound1.setTag("Data", nbttagcompound);
        try {
            File file = new File(this.saveDirectory, "level.dat_new");
            File file1 = new File(this.saveDirectory, "level.dat_old");
            File file2 = new File(this.saveDirectory, "level.dat");
            CompressedStreamTools.writeGzippedCompoundToOutputStream(nbttagcompound1, new FileOutputStream(file));
            if (file1.exists()) {
                file1.delete();
            }
            file2.renameTo(file1);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void saveWorldInfo(WorldInfo worldinfo) {
        NBTTagCompound nbttagcompound = worldinfo.getNBTTagCompound();
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        nbttagcompound1.setTag("Data", nbttagcompound);
        try {
            File file = new File(this.saveDirectory, "level.dat_new");
            File file1 = new File(this.saveDirectory, "level.dat_old");
            File file2 = new File(this.saveDirectory, "level.dat");
            CompressedStreamTools.writeGzippedCompoundToOutputStream(nbttagcompound1, new FileOutputStream(file));
            if (file1.exists()) {
                file1.delete();
            }
            file2.renameTo(file1);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public File func_28113_a(String s2) {
        return new File(this.dataDirectory, s2 + ".dat");
    }

    @Override
    public IPlayerFileData func_22090_d() {
        return null;
    }
}

